/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterEvent;
import ipsk.beans.dyn.DynProperty;
import ipsk.beans.dyn.DynPropertyDescriptor;
import ipsk.db.speech.Mediaitem;
import ipsk.net.URLContext;
import java.awt.Font;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;

public abstract class BasicPromptPresenter
extends JPanel
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    protected URL contextURL;
    protected Mediaitem[] mediaitems;
    protected Vector<PromptPresenterListener> listeners = new Vector();
    protected Font promptFont = new Font("sans-serif", 1, 48);
    protected PromptPresenterListener listener;
    protected boolean emphasized = false;

    public BasicPromptPresenter() {
    }

    public BasicPromptPresenter(LayoutManager layoutManager) {
        super(layoutManager);
    }

    @Override
    public void setPromptFont(Font promptFont) {
        this.promptFont = promptFont;
    }

    @Override
    public boolean getEmphasized() {
        return this.emphasized;
    }

    @Override
    public void setEmphasized(boolean emphasized) {
        this.emphasized = emphasized;
    }

    @Override
    public void setContents(Mediaitem[] mediaitems) throws PromptPresenterException {
        if (mediaitems == null || mediaitems.length == 0) {
            throw new UnsupportedContentException("No media item to display!");
        }
        this.mediaitems = mediaitems;
    }

    protected static String[][] getSupportedMIMETypes(String[] supportedMimeTypes) {
        String[][] mtypes = new String[supportedMimeTypes.length][1];
        for (int i = 0; i < supportedMimeTypes.length; ++i) {
            mtypes[i][0] = supportedMimeTypes[i];
        }
        return mtypes;
    }

    @Override
    public String[] getSupportedLegacyMIMETypes() {
        return new String[0];
    }

    protected void updateListeners(PromptPresenterEvent event) {
        for (PromptPresenterListener ppl : this.listeners) {
            ppl.update(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPromptPresenterListener(PromptPresenterListener listener) {
        Vector<PromptPresenterListener> vector = this.listeners;
        synchronized (vector) {
            if (listener != null && !this.listeners.contains(listener)) {
                this.listeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePromptPresenterListener(PromptPresenterListener listener) {
        Vector<PromptPresenterListener> vector = this.listeners;
        synchronized (vector) {
            if (listener != null) {
                this.listeners.removeElement(listener);
            }
        }
    }

    protected URL applyContextToMediaitemURL(Mediaitem mi) throws PromptPresenterException {
        URI miUri = mi.getSrc();
        if (miUri == null) {
            return null;
        }
        try {
            return URLContext.getContextURL((URL)this.contextURL, (String)miUri.toString());
        }
        catch (MalformedURLException e) {
            throw new PromptPresenterException(e);
        }
    }

    public URL getContextURL() {
        return this.contextURL;
    }

    @Override
    public void setContextURL(URL contextURL) {
        this.contextURL = contextURL;
    }

    public List<DynPropertyDescriptor> getDynamicPropertyDescriptors() {
        return new ArrayList<DynPropertyDescriptor>();
    }

    public void setDynamicProperty(DynProperty dynProperty) {
    }

    public DynProperty getDynamicProperty(String name) {
        return null;
    }
}

