/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.SprCompatTextViewer;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.db.speech.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.Bidi;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

@Title(value="Plain text prompter")
@Description(value="Presents plain text. Automatically inserts line feeds.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class PromptPlainTextViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptPlainTextViewer.class.getName(), new LocalizableMessage("Plain text prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{1, 0, 0}), new LocalizableMessage("Presents plain text. Automatically inserts line feeds."), PromptPlainTextViewer.getSupportedMIMETypes());
    public static final int MINFONTSIZE = 12;
    public static final int MAXFONTSIZE = 48;
    public static final int FONTDOWNSTEP = 4;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int MIDDLE = 5;
    public static final String DEF_CHARSET = "UTF-8";
    private String promptText = "";
    private Color textColor = Color.black;
    private Color backgroundColor = Color.white;
    private HAlign hAlign;
    private int vAlign;
    private String fontFamily = "sans-serif";
    private String fontStyleName = "bold";
    private int fontStyle;
    private int fontSize = 48;

    public PromptPlainTextViewer() {
        this.setBackground(this.backgroundColor);
        this.promptFont = new Font("sans-serif", 1, 48);
        if (this.fontSize < 12) {
            this.fontSize = 12;
        } else if (this.fontSize > 48) {
            this.fontSize = 48;
        }
        this.fontStyle = this.fontStyleName.equals("bold") ? 1 : (this.fontStyleName.equals("italic") ? 2 : 0);
        this.promptFont = new Font(this.fontFamily, this.fontStyle, this.fontSize);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.hAlign = HAlign.CENTER;
        this.vAlign = 5;
    }

    public void setAlignment(HAlign h, int v) {
        this.hAlign = h;
        this.vAlign = v;
    }

    public void prepareGraphics(Graphics g) {
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        }
        int xMargin = 2;
        TextGraphicsItem[] itemList = null;
        int width = this.getSize().width;
        int height = this.getSize().height;
        Bidi bidi = new Bidi(this.promptText, -2);
        boolean wLtR = bidi.baseIsLeftToRight();
        String[] pW = this.promptText.split("\\s");
        int[] lineLengths = new int[pW.length];
        if (pW != null && pW.length > 0) {
            boolean textSizeOK = false;
            int newFontSize = this.fontSize;
            for (int fs = this.fontSize; fs >= 12 && !textSizeOK; fs -= 4) {
                int xMax = 0;
                int yMax = 0;
                int lineCount = 0;
                newFontSize = fs;
                this.promptFont = new Font(this.fontFamily, this.fontStyle, newFontSize);
                g.setFont(this.promptFont);
                FontMetrics fM = this.getFontMetrics(this.promptFont);
                int lineSpacing = fs / 10 + 1;
                int yStep = fs + lineSpacing;
                itemList = new TextGraphicsItem[pW.length];
                int dx = xMargin;
                int y = yStep;
                int lineLength = xMargin;
                for (int i = 0; i < pW.length; ++i) {
                    String w = pW[i];
                    String wordWithBlank = w + " ";
                    int wwbw = fM.stringWidth(wordWithBlank);
                    if (i > 0 && dx + wwbw > width - 4) {
                        lineLengths[lineCount] = lineLength;
                        ++lineCount;
                        y += yStep;
                        dx = xMargin;
                    }
                    int x = wLtR ? dx : width - dx - wwbw;
                    itemList[i] = new TextGraphicsItem(x, y, lineCount, pW[i], wLtR);
                    lineLength = dx + fM.stringWidth(pW[i]);
                    if ((dx += fM.stringWidth(pW[i] + " ")) > xMax) {
                        xMax = dx;
                    }
                    if (y <= yMax) continue;
                    yMax = y;
                }
                if (yMax > height) continue;
                textSizeOK = true;
                HAlign tmpHAlign = this.hAlign;
                if (newFontSize < this.fontSize) {
                    tmpHAlign = HAlign.START;
                }
                lineLengths[lineCount] = lineLength;
                for (int i = 0; i < itemList.length; ++i) {
                    boolean ltr = itemList[i].leftToRight;
                    if (HAlign.START.equals((Object)tmpHAlign)) {
                        itemList[i].xPos = itemList[i].xPos;
                    } else if (HAlign.CENTER.equals((Object)tmpHAlign)) {
                        int margin = (width - lineLengths[itemList[i].line]) / 2;
                        itemList[i].xPos = ltr ? margin + itemList[i].xPos : (itemList[i].xPos -= margin);
                    }
                    if (this.vAlign == 3) {
                        itemList[i].yPos = itemList[i].yPos;
                        continue;
                    }
                    if (this.vAlign == 4) {
                        itemList[i].yPos = height - lineSpacing - (yMax + lineSpacing) + itemList[i].yPos;
                        continue;
                    }
                    if (this.vAlign != 5) continue;
                    itemList[i].yPos = (height - yMax) / 2 + itemList[i].yPos;
                }
            }
            for (int i = 0; i < pW.length; ++i) {
                String t = itemList[i].getString();
                g.drawString(itemList[i].getString(), itemList[i].getX(), itemList[i].getY());
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.textColor);
        try {
            this.prepareGraphics(g);
        }
        catch (ArrayIndexOutOfBoundsException arrException) {
            arrException.printStackTrace();
        }
    }

    public void showContents() {
    }

    public void hideContents() {
    }

    public void setContents(String s) {
        this.promptText = s;
    }

    public void setContents(String s, String d) {
        this.promptText = s.replaceAll("\\s{2,}", " ");
    }

    public void setContents(String s, String d, String type) {
        this.setContents(s, d);
    }

    public void setContents(URL u) {
        this.setContents(u, null);
    }

    public void setContents(URL u, String d) {
        this.setContents(u, null, null);
    }

    public void setContents(URL u, String d, String type) {
        this.setContents(u, null, null, null);
    }

    public void setContents(URL u, String d, String type, String cs) {
        try {
            InputStreamReader r = null;
            r = cs != null ? new InputStreamReader(u.openStream(), cs) : new InputStreamReader(u.openStream());
            StringWriter sw = new StringWriter();
            char[] cbuf = new char[2048];
            int read = 0;
            while ((read = r.read(cbuf)) >= 0) {
                sw.write(cbuf, 0, read);
            }
            r.close();
            sw.close();
            this.setContents(sw.getBuffer().toString(), d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPromptFont(Font promptFont) {
        this.promptFont = promptFont;
        this.fontSize = promptFont.getSize();
        if (this.fontSize < 12) {
            this.fontSize = 12;
        }
        this.fontStyle = promptFont.getStyle();
        this.fontFamily = promptFont.getFamily();
    }

    @Override
    public boolean getEmphasized() {
        return this.emphasized;
    }

    @Override
    public void setEmphasized(boolean emphasized) {
        this.emphasized = emphasized;
        if (emphasized) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.lightGray);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return PromptPlainTextViewer.getSupportedMIMETypes(MIMETypes.PLAINTEXTMIMETYPES);
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems == null || this.mediaitems.length == 0) {
            throw new UnsupportedContentException("No media item to display!");
        }
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        String text = null;
        Mediaitem mi = this.mediaitems[0];
        URL u = this.applyContextToMediaitemURL(mi);
        if (u != null) {
            Charset cs = null;
            String miCharset = mi.getCharSet();
            if (miCharset != null) {
                cs = Charset.forName(miCharset.trim());
            }
            InputStreamReader r = null;
            try {
                r = cs != null ? new InputStreamReader(u.openStream(), cs) : new InputStreamReader(u.openStream());
                StringWriter sw = new StringWriter();
                char[] cbuf = new char[2048];
                int read = 0;
                while ((read = r.read(cbuf)) >= 0) {
                    sw.write(cbuf, 0, read);
                }
                sw.close();
                text = sw.getBuffer().toString();
            }
            catch (IOException e) {
                throw new PromptPresenterException(e);
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException e) {
                    throw new PromptPresenterException(e);
                }
            }
        }
        text = mi.getText();
        this.promptText = text.replaceAll("\\s{2,}", " ");
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SprCompatTextViewer vw = new SprCompatTextViewer();
                vw.setPreferredSize(new Dimension(600, 400));
                JFrame w = new JFrame();
                w.setDefaultCloseOperation(3);
                w.getContentPane().add(vw);
                w.pack();
                w.setVisible(true);
                vw.setContents("Welcome to the plain text prompt viewer!");
            }
        };
        SwingUtilities.invokeLater(r);
    }

    class TextGraphicsItem {
        protected int xPos;
        protected int yPos;
        protected int line;
        protected String textString;
        protected boolean leftToRight;

        protected TextGraphicsItem(int x, int y, int l, String s, boolean ltr) {
            this.xPos = x;
            this.yPos = y;
            this.line = l;
            this.textString = s;
            this.leftToRight = ltr;
        }

        public int getX() {
            return this.xPos;
        }

        public int getY() {
            return this.yPos;
        }

        public String getString() {
            return this.textString;
        }
    }

    public static enum HAlign {
        CENTER,
        START;

    }
}

