/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.DialogTargetProvider;
import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.MediaPromptPresenter;
import ipsk.apps.speechrecorder.prompting.MediaPromptPresenter2;
import ipsk.apps.speechrecorder.prompting.PromptPlainTextViewer;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptViewerException;
import ipsk.apps.speechrecorder.prompting.PromptViewerListener;
import ipsk.apps.speechrecorder.prompting.StartPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.StopPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerClosedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerOpenedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerStartedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerStoppedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterListener;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterPluginException;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterOpenedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStartEvent;
import ipsk.apps.speechrecorder.prompting.presenter.event.PromptPresenterStopEvent;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.Presenter;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Reccomment;
import ipsk.db.speech.Recinstructions;
import ipsk.db.speech.Recording;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.sound.sampled.Mixer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PromptViewer
extends JPanel
implements PropertyChangeListener,
PromptPresenterListener,
DialogTargetProvider {
    private static final long serialVersionUID = -6099442015723739386L;
    private static final boolean DEBUG = false;
    private List<PromptPresenterServiceDescriptor> promptPresenterServiceDescriptors;
    private List<PromptPresenter> plugins;
    private final String EMPTY_STRING = "";
    private Font promptFont;
    private Font instructionsFont = new Font("sans-serif", 1, 48);
    private Font descriptionFont = new Font("sans-serif", 0, 14);
    private JLabel promptInstructions;
    private PromptPresenter promptPresenter;
    private JLabel promptDescription;
    private URL context;
    private PromptItem promptItem = null;
    private Integer recIndex;
    private boolean isSilent = false;
    private boolean showComments = true;
    private boolean instructionNumbering = true;
    private Vector<PromptViewerListener> listeners;
    private boolean showPrompt;
    private StartPromptPlaybackAction startPromptPlaybackAction;
    private StopPromptPlaybackAction stopPromptPlaybackAction;
    private Mixer promptMixer;
    private Status status;
    private int audioChannelOffset = 0;
    private DialogTargetProvider dialogTargetProvider;

    public PromptViewer(List<PromptPresenterServiceDescriptor> promptPresenterServiceDescriptors, StartPromptPlaybackAction startPromptPlaybackAction, StopPromptPlaybackAction stopPromptPlaybackAction) {
        super(new BorderLayout());
        this.promptPresenterServiceDescriptors = promptPresenterServiceDescriptors;
        this.startPromptPlaybackAction = startPromptPlaybackAction;
        this.stopPromptPlaybackAction = stopPromptPlaybackAction;
        this.dialogTargetProvider = this;
        this.status = Status.CLOSED;
        this.promptInstructions = new JLabel("");
        this.promptInstructions.setForeground(Color.darkGray);
        this.promptInstructions.setBackground(Color.lightGray);
        this.promptInstructions.setFont(this.instructionsFont);
        this.promptDescription = new JLabel("");
        this.promptDescription.setFont(this.descriptionFont);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.listeners = new Vector();
        this.plugins = new ArrayList<PromptPresenter>();
    }

    public Set<List<String>> getSupportedMIMETypes() {
        HashSet<List<String>> s = new HashSet<List<String>>();
        String[][] ppMtcArrs = null;
        for (PromptPresenter pp : this.plugins) {
            PromptPresenterServiceDescriptor ppsd = pp.getServiceDescriptor();
            for (String[] ppMtcArr : ppMtcArrs = ppsd.getSupportedMIMETypes()) {
                List<String> ppMtc = Arrays.asList(ppMtcArr);
                s.add(ppMtc);
            }
        }
        return s;
    }

    public void setPromptMixer(Mixer mixer) throws PromptPresenterPluginException {
        this.promptMixer = mixer;
        for (PromptPresenter pp : this.plugins) {
            if (pp == null || !(pp instanceof MediaPromptPresenter)) continue;
            ((MediaPromptPresenter)pp).setAudioMixer(this.promptMixer);
        }
    }

    public void setPromptAudioChannelOffset(int audioChannelOffset) throws PromptPresenterPluginException {
        this.audioChannelOffset = audioChannelOffset;
        for (PromptPresenter pp : this.plugins) {
            if (pp == null || !(pp instanceof MediaPromptPresenter2)) continue;
            ((MediaPromptPresenter2)pp).setAudioChannelOffset(audioChannelOffset);
        }
    }

    public void setSilent(boolean silence) {
        this.isSilent = silence;
    }

    public boolean getSilent() {
        return this.isSilent;
    }

    public boolean getShowComments() {
        return this.showComments;
    }

    public void setShowComments(boolean comments) {
        this.showComments = comments;
    }

    public void displayInstructions(Recinstructions instructions) {
        this.remove(this.promptInstructions);
        Object instructionsText = null;
        if (instructions != null) {
            instructionsText = instructions.getRecinstructions();
            ((String)instructionsText).trim();
            if (this.instructionNumbering) {
                instructionsText = this.recIndex + ": " + (String)instructionsText;
            }
        }
        if (instructionsText != null && !((String)instructionsText).equals("")) {
            this.promptInstructions.setText((String)instructionsText);
            this.promptInstructions.setHorizontalAlignment(10);
            Bidi bidi = new Bidi((String)instructionsText, -2);
            if (bidi.baseIsLeftToRight()) {
                this.promptInstructions.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                this.promptInstructions.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            this.add((Component)this.promptInstructions, "North");
        }
    }

    public void displayComments(Reccomment comments) {
        this.remove(this.promptDescription);
        String commentsText = null;
        if (comments != null) {
            commentsText = comments.getReccomment();
            commentsText.trim();
        }
        if (this.getShowComments() && commentsText != null && !commentsText.equals("")) {
            this.promptDescription.setText(commentsText);
            this.add((Component)this.promptDescription, "South");
        }
    }

    public void init() {
        this.promptInstructions.setText("");
        this.displayInstructions(null);
        this.displayComments(null);
        this.setPromptPresenterEnabled(false);
        this.setShowPrompt(false);
    }

    private boolean supportsMIMEtypeCombination(PromptPresenterServiceDescriptor ppsd, String[] mimeTypeCombination) {
        String[][] suppMimes;
        String serviceImplClassname = ppsd.getServiceImplementationClassname();
        if (PromptPlainTextViewer.class.getName().equals(serviceImplClassname) && mimeTypeCombination != null && mimeTypeCombination.length == 1) {
            for (String falseMt : MIMETypes.FALSE_PLAINTEXTMIMETYPES) {
                if (!falseMt.equals(mimeTypeCombination[0])) continue;
                return true;
            }
        }
        if ((suppMimes = ppsd.getSupportedMIMETypes()) != null && mimeTypeCombination != null) {
            for (String[] suppMimeCombination : suppMimes) {
                boolean combinationMatch = true;
                if (suppMimeCombination.length != mimeTypeCombination.length) {
                    combinationMatch = false;
                } else {
                    Vector<String> suppMimeCombinationVector = new Vector<String>(Arrays.asList(suppMimeCombination));
                    for (String mimeType : mimeTypeCombination) {
                        boolean match = false;
                        int availsuppMimes = suppMimeCombinationVector.size();
                        for (int i = 0; i < availsuppMimes; ++i) {
                            String am = suppMimeCombinationVector.get(i);
                            if (!am.equals(mimeType)) continue;
                            match = true;
                            suppMimeCombinationVector.remove(i);
                            break;
                        }
                        if (match) continue;
                        combinationMatch = false;
                        break;
                    }
                }
                if (!combinationMatch) continue;
                return true;
            }
        }
        return false;
    }

    public void prepare() throws PromptPresenterException {
        block30: {
            String[] mimeTypes;
            Mediaitem[] mediaitemsArr;
            Recording recItem;
            block32: {
                block31: {
                    String presenterClassname;
                    recItem = null;
                    mediaitemsArr = null;
                    mimeTypes = null;
                    if (this.promptItem != null) {
                        List miList = this.promptItem.getMediaitems();
                        mediaitemsArr = miList.toArray(new Mediaitem[0]);
                        mimeTypes = new String[miList.size()];
                        for (int i = 0; i < mimeTypes.length; ++i) {
                            mimeTypes[i] = ((Mediaitem)miList.get(i)).getNNMimetype();
                        }
                        if (this.promptItem != null && !Arrays.asList(this.promptItem.getPropertyChangeListeners()).contains(this)) {
                            this.promptItem.addPropertyChangeListener((PropertyChangeListener)this);
                            for (Mediaitem mi : miList) {
                                mi.addPropertyChangeListener((PropertyChangeListener)this);
                            }
                        }
                        if (this.promptItem instanceof Recording) {
                            recItem = (Recording)this.promptItem;
                            this.promptInstructions.setForeground(Color.black);
                            Recinstructions instr = recItem.getRecinstructions();
                            this.displayInstructions(instr);
                            Reccomment rc = recItem.getReccomment();
                            this.displayComments(rc);
                        } else if (this.promptItem instanceof Nonrecording) {
                            this.displayInstructions(null);
                            this.displayComments(null);
                        }
                    }
                    this.setShowPrompt(false);
                    this.promptPresenter = null;
                    if (this.promptItem == null) break block30;
                    Presenter presenter = this.promptItem.getPresenter();
                    if (presenter == null) break block31;
                    String type = presenter.getType();
                    if (!"javaclass".equalsIgnoreCase(type) || (presenterClassname = presenter.getClassname()) == null) break block32;
                    boolean found = false;
                    for (PromptPresenter pp : this.plugins) {
                        Class<?> ppClass = pp.getClass();
                        if (!presenterClassname.equals(ppClass.getName())) continue;
                        this.promptPresenter = pp;
                        found = true;
                        break;
                    }
                    if (!found) {
                        Object pClass = null;
                        Object presenterObj = null;
                        try {
                            pClass = Class.forName(presenterClassname);
                            presenterObj = ((Class)pClass).newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        if (presenterObj != null && presenterObj instanceof PromptPresenter) {
                            this.promptPresenter = presenterObj;
                            this.plugins.add(this.promptPresenter);
                        }
                    }
                    break block32;
                }
                block12: for (PromptPresenterServiceDescriptor ppsd : this.promptPresenterServiceDescriptors) {
                    if (!this.supportsMIMEtypeCombination(ppsd, mimeTypes)) continue;
                    String ppcn = ppsd.getServiceImplementationClassname();
                    for (PromptPresenter pp : this.plugins) {
                        String lpcn = pp.getServiceDescriptor().getServiceImplementationClassname();
                        if (lpcn == null || !lpcn.equals(ppcn)) continue;
                        this.promptPresenter = pp;
                        break block12;
                    }
                }
            }
            if (this.promptPresenter == null && this.promptPresenterServiceDescriptors != null) {
                for (PromptPresenterServiceDescriptor ppsd : this.promptPresenterServiceDescriptors) {
                    if (!this.supportsMIMEtypeCombination(ppsd, mimeTypes)) continue;
                    String ppcn = ppsd.getServiceImplementationClassname();
                    Class<?> ppc = null;
                    Object ppObj = null;
                    try {
                        ppc = Class.forName(ppcn);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    try {
                        ppObj = ppc.newInstance();
                    }
                    catch (InstantiationException e) {
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        continue;
                    }
                    if (ppObj == null || !(ppObj instanceof PromptPresenter)) continue;
                    this.promptPresenter = ppObj;
                    this.plugins.add(this.promptPresenter);
                    break;
                }
            }
            if (this.promptPresenter == null) {
                if (mimeTypes.length == 1) {
                    throw new PromptPresenterException("Could not load presenter plugin for MIME type \"" + mimeTypes[0] + "\"");
                }
                StringBuffer mimetypeCombinationSb = new StringBuffer();
                int mimeTypesCount = mimeTypes.length;
                for (int i = 0; i < mimeTypesCount; ++i) {
                    mimetypeCombinationSb.append(mimeTypes[i]);
                    if (i + 1 >= mimeTypesCount) continue;
                    mimetypeCombinationSb.append(',');
                }
                throw new PromptPresenterException("Could not load presenter plugin for MIME type combination \"" + mimetypeCombinationSb + "\"");
            }
            this.setPromptEmphased(false);
            if (recItem != null) {
                // empty if block
            }
            if (this.promptPresenter instanceof MediaPromptPresenter) {
                MediaPromptPresenter mpp = (MediaPromptPresenter)this.promptPresenter;
                mpp.setStartControlAction(this.startPromptPlaybackAction);
                mpp.setStopControlAction(this.stopPromptPlaybackAction);
                mpp.setSilent(this.isSilent);
                mpp.setAudioMixer(this.promptMixer);
                if (this.promptPresenter instanceof MediaPromptPresenter2) {
                    MediaPromptPresenter2 mpp2 = (MediaPromptPresenter2)mpp;
                    mpp2.setAudioChannelOffset(this.audioChannelOffset);
                }
            }
            if (this.promptPresenter != null) {
                this.promptPresenter.setContextURL(this.context);
                this.promptPresenter.setPromptFont(this.promptFont);
                this.promptPresenter.setContents(mediaitemsArr);
                this.promptPresenter.loadContents();
            }
        }
    }

    public boolean isShowPrompt() {
        return this.showPrompt;
    }

    public void setShowPrompt(boolean showPrompt) {
        if (showPrompt) {
            if (!this.showPrompt) {
                if (this.promptItem instanceof Recording) {
                    Recording recItem = (Recording)this.promptItem;
                    this.displayInstructions(recItem.getRecinstructions());
                    this.displayComments(recItem.getReccomment());
                }
                if (this.promptPresenter != null && !this.isAncestorOf((Component)((Object)this.promptPresenter))) {
                    this.add((Component)((Object)this.promptPresenter), "Center");
                }
                this.setPromptPresenterEnabled(true);
            }
        } else if (this.promptPresenter != null) {
            this.remove((Component)((Object)this.promptPresenter));
        }
        this.showPrompt = showPrompt;
        this.revalidate();
        this.repaint();
    }

    public void open() throws PromptViewerException {
        if (Status.CLOSED.equals((Object)this.status) || Status.PRESENTER_CLOSED.equals((Object)this.status)) {
            if (this.promptPresenter instanceof MediaPromptPresenter) {
                MediaPromptPresenter mpp = (MediaPromptPresenter)this.promptPresenter;
                mpp.removePromptPresenterListener(this);
                mpp.addPromptPresenterListener(this);
                try {
                    mpp.open();
                }
                catch (PromptPresenterException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.dialogTargetProvider.getDialogTarget(), e.getLocalizedMessage(), "Prompt presenter error", 0);
                    throw new PromptViewerException(e);
                }
            } else {
                this.status = Status.OPEN;
                this.updateListeners(new PromptViewerOpenedEvent(this));
            }
        }
    }

    public void start() {
        if (!(Status.RUNNING.equals((Object)this.status) || Status.CLOSED.equals((Object)this.status) || Status.PRESENTER_CLOSED.equals((Object)this.status))) {
            if (this.promptPresenter instanceof MediaPromptPresenter) {
                MediaPromptPresenter mpp = (MediaPromptPresenter)this.promptPresenter;
                try {
                    mpp.start();
                }
                catch (PromptPresenterException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.dialogTargetProvider.getDialogTarget(), e.getLocalizedMessage(), "Prompt presenter error", 0);
                    return;
                }
            } else {
                this.status = Status.PRESENTER_CLOSED;
                this.updateListeners(new PromptViewerPresenterClosedEvent(this));
            }
        }
    }

    public void stop() {
        if (Status.RUNNING.equals((Object)this.status)) {
            this.promptInstructions.setForeground(Color.lightGray);
            if (this.promptItem instanceof Recording) {
                Recording recItem = (Recording)this.promptItem;
                this.displayInstructions(recItem.getRecinstructions());
                this.displayComments(recItem.getReccomment());
            }
            if (this.promptPresenter instanceof MediaPromptPresenter) {
                try {
                    ((MediaPromptPresenter)this.promptPresenter).stop();
                }
                catch (PromptPresenterException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.dialogTargetProvider.getDialogTarget(), e.getLocalizedMessage(), "Prompt presenter error", 0);
                }
            } else {
                this.status = Status.STOPPED;
            }
        }
    }

    private void _close() {
        this.status = Status.CLOSED;
        this.promptInstructions.setText("");
        this.displayComments(null);
        if (this.promptPresenter != null) {
            this.remove((Component)((Object)this.promptPresenter));
        }
        this.setShowPrompt(false);
        this.revalidate();
        this.repaint();
        this.updateListeners(new PromptViewerClosedEvent(this));
    }

    public void close() {
        if (!Status.CLOSED.equals((Object)this.status)) {
            if (this.promptPresenter instanceof MediaPromptPresenter && !this.status.equals((Object)Status.PRESENTER_CLOSED)) {
                try {
                    ((MediaPromptPresenter)this.promptPresenter).close();
                }
                catch (PromptPresenterException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.dialogTargetProvider.getDialogTarget(), e.getLocalizedMessage(), "Prompt presenter error", 0);
                }
            } else {
                this._close();
            }
        }
    }

    public void setInstructionsEmphased(boolean b) {
        if (b) {
            this.promptInstructions.setForeground(Color.black);
        } else {
            this.promptInstructions.setForeground(Color.lightGray);
        }
    }

    public void setPromptEmphased(boolean b) {
        if (this.promptPresenter != null) {
            this.promptPresenter.setEmphasized(b);
        }
    }

    public void setPromptPresenterEnabled(boolean b) {
        if (this.promptPresenter != null) {
            ((Component)((Object)this.promptPresenter)).setEnabled(b);
        }
    }

    public void setPromptFont(Font font) {
        this.promptFont = font;
        if (this.promptPresenter != null) {
            this.promptPresenter.setPromptFont(this.promptFont);
        }
    }

    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    public Font getInstructionsFont() {
        return this.instructionsFont;
    }

    public void setDescriptionFont(Font font) {
        this.descriptionFont = font;
        this.promptDescription.setFont(this.descriptionFont);
    }

    public void setInstructionsFont(Font font) {
        this.instructionsFont = font;
        this.promptInstructions.setFont(this.instructionsFont);
    }

    public boolean isInstructionNumbering() {
        return this.instructionNumbering;
    }

    public void setInstructionNumbering(boolean instructionNumbering) {
        this.instructionNumbering = instructionNumbering;
    }

    public URL getContext() {
        return this.context;
    }

    public void setContext(URL url) {
        this.context = url;
    }

    protected synchronized void updateListeners(PromptViewerEvent event) {
        for (PromptViewerListener ppl : this.listeners) {
            ppl.update(event);
        }
    }

    public void addPromptViewerListener(PromptViewerListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removePromptViewerListener(PromptViewerListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean showingBefore = this.isShowPrompt();
        if (evt.getPropertyName().startsWith("recording")) {
            // empty if block
        }
        try {
            this.prepare();
            if (showingBefore) {
                this.setShowPrompt(true);
            }
        }
        catch (PromptPresenterException promptPresenterException) {
            // empty catch block
        }
    }

    public PromptItem getPromptItem() {
        return this.promptItem;
    }

    public void setPromptItem(PromptItem promptItem) {
        PromptItem oldPromptItem = this.promptItem;
        if (oldPromptItem != null) {
            List miList = oldPromptItem.getMediaitems();
            for (Mediaitem mi : miList) {
                mi.removePropertyChangeListener((PropertyChangeListener)this);
            }
            oldPromptItem.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.promptItem = promptItem;
    }

    public int getRecIndex() {
        return this.recIndex;
    }

    public void setRecIndex(Integer recIndex) {
        this.recIndex = recIndex;
    }

    @Override
    public void update(PromptPresenterEvent promptPresenterEvent) {
        if (promptPresenterEvent instanceof PromptPresenterOpenedEvent) {
            if (Status.PRESENTER_CLOSED.equals((Object)this.status) || Status.CLOSED.equals((Object)this.status)) {
                this.status = Status.OPEN;
                this.updateListeners(new PromptViewerOpenedEvent(this));
            }
        } else if (promptPresenterEvent instanceof PromptPresenterStartEvent) {
            if (!Status.RUNNING.equals((Object)this.status)) {
                this.status = Status.RUNNING;
                this.updateListeners(new PromptViewerStartedEvent(this));
            }
        } else if (promptPresenterEvent instanceof PromptPresenterStopEvent) {
            if (Status.RUNNING.equals((Object)this.status)) {
                this.status = Status.STOPPED;
                this.updateListeners(new PromptViewerStoppedEvent(this));
            }
        } else if (promptPresenterEvent instanceof PromptPresenterClosedEvent && !Status.PRESENTER_CLOSED.equals((Object)this.status)) {
            this.status = Status.PRESENTER_CLOSED;
            this.updateListeners(new PromptViewerPresenterClosedEvent(this));
        }
    }

    public void closeMediaPresenter() {
        if (this.promptPresenter instanceof MediaPromptPresenter && !Status.PRESENTER_CLOSED.equals((Object)this.status)) {
            try {
                ((MediaPromptPresenter)this.promptPresenter).close();
            }
            catch (PromptPresenterException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.dialogTargetProvider.getDialogTarget(), e.getLocalizedMessage(), "Prompt presenter error", 0);
            }
        }
    }

    public boolean isClosed() {
        return Status.CLOSED.equals((Object)this.status);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setDialogTargetProvider(DialogTargetProvider dialogTargetProvider) {
        this.dialogTargetProvider = dialogTargetProvider;
    }

    @Override
    public Component getDialogTarget() {
        return this;
    }

    public static enum Status {
        CLOSED,
        OPEN,
        RUNNING,
        STOPPED,
        PRESENTER_CLOSED;

    }
}

