/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.DialogTargetProvider;
import ipsk.apps.speechrecorder.prompting.PromptViewer;
import ipsk.apps.speechrecorder.prompting.PromptViewerException;
import ipsk.apps.speechrecorder.prompting.PromptViewerListener;
import ipsk.apps.speechrecorder.prompting.PrompterException;
import ipsk.apps.speechrecorder.prompting.StartPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.StopPromptPlaybackAction;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerClosedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerOpenedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerPresenterClosedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerStartedEvent;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerStoppedEvent;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Reccomment;
import ipsk.db.speech.Recinstructions;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.Mixer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Prompter
implements PromptViewerListener {
    private PromptViewer experimenterViewer;
    private List<PromptViewer> subjectViewers = new ArrayList<PromptViewer>();
    private List<PromptViewer> allViewers = new ArrayList<PromptViewer>();
    private StartPromptPlaybackAction startPromptPlaybackAction;
    private StopPromptPlaybackAction stopPromptPlaybackAction;
    private Vector<PromptViewerListener> listeners = new Vector();
    private boolean startControlEnabled;
    private boolean stopControlEnabled = true;
    private boolean autoPlay = true;
    private boolean autoPlayStarted = true;
    private PromptItem promptItem;
    private Integer recIndex;
    private Mixer promptMixer = null;
    private int audioChannelOffset = 0;
    private DialogTargetProvider dialogTargetProvider = null;
    private PromptViewer.Status status = PromptViewer.Status.CLOSED;

    public DialogTargetProvider getDialogTargetProvider() {
        return this.dialogTargetProvider;
    }

    public void setDialogTargetProvider(DialogTargetProvider dialogTargetProvider) {
        this.dialogTargetProvider = dialogTargetProvider;
    }

    public int getAudioChannelOffset() {
        return this.audioChannelOffset;
    }

    public void setAudioChannelOffset(int audioChannelOffset) {
        this.audioChannelOffset = audioChannelOffset;
    }

    public Mixer getPromptMixer() {
        return this.promptMixer;
    }

    public void setPromptMixer(Mixer promptMixer) {
        this.promptMixer = promptMixer;
    }

    public Prompter() {
        ImageIcon audioImage = new ImageIcon(this.getClass().getResource("icons/playAudio.gif"));
        this.startPromptPlaybackAction = new StartPromptPlaybackAction(this, (Icon)audioImage);
        this.startPromptPlaybackAction.setEnabled(false);
        this.stopPromptPlaybackAction = new StopPromptPlaybackAction(this, (Icon)audioImage);
        this.stopPromptPlaybackAction.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAllViewersList() {
        List<PromptViewer> list = this.allViewers;
        synchronized (list) {
            this.allViewers.clear();
            this.allViewers.add(this.experimenterViewer);
            this.allViewers.addAll(this.subjectViewers);
        }
    }

    public PromptViewer getExperimenterViewer() {
        return this.experimenterViewer;
    }

    public void setExperimenterViewer(PromptViewer experimenterViewer) {
        if (this.experimenterViewer != null) {
            this.experimenterViewer.removePromptViewerListener(this);
        }
        this.experimenterViewer = experimenterViewer;
        if (this.experimenterViewer != null) {
            this.experimenterViewer.addPromptViewerListener(this);
        }
        this.createAllViewersList();
    }

    public void addSubjectViewer(PromptViewer sv) {
        this.subjectViewers.add(sv);
        sv.addPromptViewerListener(this);
        this.createAllViewersList();
    }

    public void removeSubjectViewer(PromptViewer sv) {
        sv.removePromptViewerListener(this);
        this.subjectViewers.remove(sv);
        this.createAllViewersList();
    }

    public void clearSubjectViewersList() {
        for (PromptViewer spv : this.subjectViewers) {
            spv.removePromptViewerListener(this);
        }
        this.subjectViewers.clear();
        this.createAllViewersList();
    }

    public List<PromptViewer> getSubjectViewers() {
        return Collections.unmodifiableList(this.subjectViewers);
    }

    public void setSubjectViewers(List<PromptViewer> subjectViewers) {
        this.subjectViewers = subjectViewers;
        this.createAllViewersList();
    }

    public void close() {
        for (PromptViewer pv : this.allViewers) {
            pv.close();
        }
    }

    public void displayComments(Reccomment comments) {
        for (PromptViewer pv : this.allViewers) {
            pv.displayComments(comments);
        }
    }

    public void displayInstructions(Recinstructions instructions) {
        for (PromptViewer pv : this.allViewers) {
            pv.displayInstructions(instructions);
        }
    }

    public Font getInstructionsFont() {
        return this.experimenterViewer.getInstructionsFont();
    }

    public PromptItem getPromptItem() {
        return this.promptItem;
    }

    public int getRecIndex() {
        return this.recIndex;
    }

    public void play() {
        try {
            this.open();
        }
        catch (PrompterException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.dialogTargetProvider.getDialogTarget(), e.getLocalizedMessage(), "Prompt open error", 0);
            return;
        }
        this.start();
    }

    public void open() throws PrompterException {
        for (PromptViewer pv : this.allViewers) {
            try {
                pv.open();
            }
            catch (PromptViewerException e) {
                this.close();
                throw new PrompterException("Prompter error: " + e.getLocalizedMessage(), e);
            }
        }
    }

    public void prepare() throws PromptPresenterException {
        this.startPromptPlaybackAction.resetIcon();
        this.stopPromptPlaybackAction.resetIcon();
        for (PromptViewer pv : this.allViewers) {
            pv.setPromptMixer(this.promptMixer);
            pv.setPromptAudioChannelOffset(this.audioChannelOffset);
            pv.prepare();
        }
    }

    public void setInstructionNumbering(boolean instructionNumbering) {
        for (PromptViewer pv : this.allViewers) {
            pv.setInstructionNumbering(instructionNumbering);
        }
    }

    public void setInstructionsEmphased(boolean b) {
        for (PromptViewer pv : this.allViewers) {
            pv.setInstructionsEmphased(b);
        }
    }

    public void setPromptEmphased(boolean b) {
        for (PromptViewer pv : this.allViewers) {
            pv.setPromptEmphased(b);
        }
    }

    public void setPromptFont(Font font) {
        for (PromptViewer pv : this.allViewers) {
            pv.setPromptFont(font);
        }
    }

    public void setInstructionsFont(Font font) {
        for (PromptViewer pv : this.allViewers) {
            pv.setInstructionsFont(font);
        }
    }

    public void setDescriptionFont(Font font) {
        for (PromptViewer pv : this.allViewers) {
            pv.setDescriptionFont(font);
        }
    }

    public void setPromptItem(PromptItem promptItem) {
        this.promptItem = promptItem;
        for (PromptViewer pv : this.allViewers) {
            pv.setPromptItem(promptItem);
        }
        this.autoPlayStarted = false;
    }

    public void setPromptPresenterEnabled(boolean b) {
        for (PromptViewer pv : this.allViewers) {
            pv.setPromptPresenterEnabled(b);
        }
    }

    public void setRecIndex(Integer recIndex) {
        this.recIndex = recIndex;
        for (PromptViewer pv : this.allViewers) {
            pv.setRecIndex(recIndex);
        }
    }

    public void setShowComments(boolean comments) {
        for (PromptViewer pv : this.allViewers) {
            pv.setShowComments(comments);
        }
    }

    public void setShowPrompt(boolean showPrompt) {
        for (PromptViewer pv : this.allViewers) {
            pv.setShowPrompt(showPrompt);
        }
    }

    public void autoPlay() throws PrompterException {
        boolean resAutoPlay = this.autoPlay;
        List mis = this.promptItem.getMediaitems();
        Boolean piAutoPlay = null;
        for (Mediaitem mi : mis) {
            Boolean miAp = mi.getAutoplay();
            if (miAp == null) continue;
            if (piAutoPlay == null) {
                piAutoPlay = miAp;
                continue;
            }
            piAutoPlay = piAutoPlay != false || miAp != false;
        }
        if (piAutoPlay != null) {
            resAutoPlay = piAutoPlay;
        }
        if (!this.autoPlayStarted && resAutoPlay) {
            this.open();
            this.autoPlayStarted = true;
            this.start();
        } else {
            this.startPromptPlaybackAction.setEnabled(true);
        }
    }

    public void init() {
        for (PromptViewer pv : this.allViewers) {
            pv.init();
        }
    }

    public void start() {
        if (PromptViewer.Status.OPEN.equals((Object)this.status) || PromptViewer.Status.STOPPED.equals((Object)this.status)) {
            for (PromptViewer pv : this.allViewers) {
                pv.start();
            }
        }
    }

    public void stop() {
        for (PromptViewer pv : this.allViewers) {
            pv.stop();
        }
    }

    protected synchronized void updateListeners(PromptViewerEvent event) {
        for (PromptViewerListener ppl : this.listeners) {
            ppl.update(event);
        }
    }

    public void addPromptViewerListener(PromptViewerListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removePromptViewerListener(PromptViewerListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }

    private boolean checkAllViewersStatus(PromptViewer.Status[] states) {
        PromptViewer.Status expStatus = this.experimenterViewer.getStatus();
        boolean ok = false;
        for (PromptViewer.Status status : states) {
            if (!status.equals((Object)expStatus)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            return false;
        }
        for (PromptViewer pv : this.subjectViewers) {
            PromptViewer.Status pvStatus = pv.getStatus();
            ok = false;
            for (PromptViewer.Status status : states) {
                if (!status.equals((Object)pvStatus)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    private boolean checkAllViewersStatus(PromptViewer.Status status) {
        PromptViewer.Status expStatus = this.experimenterViewer.getStatus();
        if (!status.equals((Object)expStatus)) {
            return false;
        }
        for (PromptViewer pv : this.subjectViewers) {
            PromptViewer.Status pvStatus = pv.getStatus();
            if (status.equals((Object)pvStatus)) continue;
            return false;
        }
        return true;
    }

    public boolean isPresenterClosed() {
        return PromptViewer.Status.PRESENTER_CLOSED.equals((Object)this.status) || PromptViewer.Status.CLOSED.equals((Object)this.status);
    }

    @Override
    public void update(PromptViewerEvent promptViewerEvent) {
        if (promptViewerEvent instanceof PromptViewerStartedEvent) {
            if (this.checkAllViewersStatus(new PromptViewer.Status[]{PromptViewer.Status.RUNNING, PromptViewer.Status.STOPPED})) {
                PromptItem pi = this.getPromptItem();
                boolean modal = false;
                List mis = pi.getMediaitems();
                for (Mediaitem mi : mis) {
                    boolean miModal = mi.getNNModal();
                    if (!miModal) continue;
                    modal = true;
                    break;
                }
                this.startPromptPlaybackAction.setEnabled(false);
                this.stopPromptPlaybackAction.setEnabled(this.stopControlEnabled && !modal);
                this.status = PromptViewer.Status.RUNNING;
                this.updateListeners(promptViewerEvent);
            }
        } else if (promptViewerEvent instanceof PromptViewerStoppedEvent) {
            if (!PromptViewer.Status.STOPPED.equals((Object)this.status) && this.checkAllViewersStatus(PromptViewer.Status.STOPPED)) {
                this.stopPromptPlaybackAction.setEnabled(false);
                this.status = PromptViewer.Status.STOPPED;
                this.updateListeners(promptViewerEvent);
                for (PromptViewer pv : this.allViewers) {
                    pv.closeMediaPresenter();
                }
            }
        } else if (promptViewerEvent instanceof PromptViewerOpenedEvent) {
            if (!PromptViewer.Status.OPEN.equals((Object)this.status) && this.checkAllViewersStatus(PromptViewer.Status.OPEN)) {
                this.status = PromptViewer.Status.OPEN;
                this.updateListeners(promptViewerEvent);
            }
        } else if (promptViewerEvent instanceof PromptViewerPresenterClosedEvent) {
            if (!PromptViewer.Status.PRESENTER_CLOSED.equals((Object)this.status) && this.checkAllViewersStatus(PromptViewer.Status.PRESENTER_CLOSED)) {
                this.startPromptPlaybackAction.setEnabled(this.startControlEnabled);
                this.status = PromptViewer.Status.PRESENTER_CLOSED;
                this.updateListeners(promptViewerEvent);
            }
        } else if (promptViewerEvent instanceof PromptViewerClosedEvent && !PromptViewer.Status.CLOSED.equals((Object)this.status) && this.checkAllViewersStatus(PromptViewer.Status.CLOSED)) {
            this.status = PromptViewer.Status.CLOSED;
            this.updateListeners(promptViewerEvent);
        }
    }

    public boolean isStartControlEnabled() {
        return this.startControlEnabled;
    }

    public void setStartControlEnabled(boolean startControlEnabled) {
        this.startControlEnabled = startControlEnabled;
    }

    public boolean isStopControlEnabled() {
        return this.stopControlEnabled;
    }

    public void setStopControlEnabled(boolean stopControlEnabled) {
        this.stopControlEnabled = stopControlEnabled;
    }

    public StartPromptPlaybackAction getStartPromptPlaybackAction() {
        return this.startPromptPlaybackAction;
    }

    public StopPromptPlaybackAction getStopPromptPlaybackAction() {
        return this.stopPromptPlaybackAction;
    }

    public void setAutomaticPromptPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }
}

