/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.awt.ColorUtils;
import ipsk.db.speech.Block;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.P;
import ipsk.db.speech.Text;
import ipsk.db.speech.TextFormatElement;
import ipsk.text.ParserException;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

@Title(value="Compatible formatted text prompter")
@Description(value="Presents Speechrecorder fromatted text. Automatically inserts line feeds. Compatible to existing plain text prompts.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class SprCompatTextViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(SprCompatTextViewer.class.getName(), new LocalizableMessage("Presents formatted or plain text prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{1, 0, 0}), new LocalizableMessage("Presents formatted or plain text prompter. Compatible to existing plain text prompts."), SprCompatTextViewer.getSupportedMIMETypes());
    public static final int VIRTUAL_HEIGHT = 400;
    public static final int MINFONTSIZE = 12;
    public static final int MAXFONTSIZE = 48;
    public static final int FONTDOWNSTEP = 4;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int MIDDLE = 5;
    public static final String DEF_CHARSET = "UTF-8";
    private PromptDoc promptText;
    private Color textColor = Color.BLACK;
    private Color backgroundColor = Color.WHITE;
    private int hAlign;
    private int vAlign;
    private static String DEFAULT_FONT_NAME = "sans-serif";
    private static int DEFAULT_FONT_STYLE = 1;
    private int fontStyle;
    private int DEFAULT_FONT_SIZE = 48;
    private int fontSize;

    public SprCompatTextViewer() {
        this.setBackground(this.backgroundColor);
        this.fontSize = this.DEFAULT_FONT_SIZE;
        if (this.fontSize < 12) {
            this.fontSize = 12;
        } else if (this.fontSize > 48) {
            this.fontSize = 48;
        }
        this.promptFont = new Font(DEFAULT_FONT_NAME, DEFAULT_FONT_STYLE, this.fontSize);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.hAlign = 2;
        this.vAlign = 5;
    }

    private PromptDoc promptDocFromString(String str) {
        String[] pWs = str.split("\\s");
        ArrayList<Word> ws = new ArrayList<Word>();
        for (String pW : pWs) {
            ArrayList<TextFragment> frgs = new ArrayList<TextFragment>();
            TextFragment tfr = new TextFragment(pW);
            frgs.add(tfr);
            Word w = new Word(frgs);
            ws.add(w);
        }
        Line l = new Line(ws);
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(l);
        return new PromptDoc(lines);
    }

    private Font fontByTextFragment(TextFragment textFragment) {
        Font f = this.promptFont;
        if (!textFragment.isDefaultFont()) {
            Float frSize;
            TextFragment.FontWeight frWeight;
            TextFragment.FontStyle frStyle;
            int defStyle = this.promptFont.getStyle();
            int defSize = this.promptFont.getSize();
            int style = defStyle;
            String frFamily = textFragment.getFontFamily();
            if (frFamily != null) {
                f = new Font(frFamily, defStyle, defSize);
            }
            if ((frStyle = textFragment.getFontStyle()) != null) {
                if (TextFragment.FontStyle.NORMAL.equals((Object)frStyle)) {
                    style &= 0xFFFFFFFD;
                } else if (TextFragment.FontStyle.ITALIC.equals((Object)frStyle)) {
                    style |= 2;
                }
            }
            if ((frWeight = textFragment.getFontWeight()) != null) {
                if (frWeight.isNormal()) {
                    style &= 0xFFFFFFFE;
                } else if (frWeight.isBold()) {
                    style |= 1;
                }
            }
            if (style != defStyle) {
                f = f.deriveFont(style);
            }
            if ((frSize = textFragment.getFontSize()) != null) {
                f = f.deriveFont(frSize.floatValue());
            }
        }
        return f;
    }

    private int fragmentWidth(TextFragment textFrag) {
        Font tFrFt = this.fontByTextFragment(textFrag);
        FontMetrics fM = this.getFontMetrics(tFrFt);
        return fM.stringWidth(textFrag.getText());
    }

    private int wordWidth(Word word) {
        List<TextFragment> textFrags = word.getTextFragments();
        int wordLen = 0;
        for (TextFragment textFrag : textFrags) {
            wordLen += this.fragmentWidth(textFrag);
        }
        return wordLen;
    }

    public void setAlignment(int h, int v) {
        this.hAlign = h;
        this.vAlign = v;
    }

    /*
     * WARNING - void declaration
     */
    public void prepareGraphics(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        }
        int xMargin = 2;
        TextGraphicsItem[] itemList = null;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.promptText != null) {
            List<Line> lines = this.promptText.getLines();
            int wordCount = this.promptText.wordCount();
            int[] lineLengths = new int[wordCount];
            int boxBaseY = height / 2;
            int yMax = 0;
            if (wordCount > 0) {
                int scaledFontSize;
                boolean textSizeOK = false;
                int newFontSize = scaledFontSize = (int)((float)this.fontSize * (float)this.getHeight() / 400.0f);
                int lineCount = 0;
                for (int fs = scaledFontSize; fs >= 12 && !textSizeOK; fs -= 4) {
                    int xMax = 0;
                    yMax = 0;
                    lineCount = 0;
                    newFontSize = fs;
                    this.promptFont = this.promptFont.deriveFont((float)newFontSize);
                    g.setFont(this.promptFont);
                    FontMetrics fM = this.getFontMetrics(this.promptFont);
                    int fontBaselineToBottom = fM.getDescent() + fM.getLeading();
                    int n = fs / 10 + 1;
                    int yStep = fM.getHeight();
                    itemList = new TextGraphicsItem[wordCount];
                    int x = xMargin;
                    int y = yStep;
                    int lineLength = xMargin;
                    int itemIdx = 0;
                    for (int docLine = 0; docLine < lines.size(); ++docLine) {
                        Line line = lines.get(docLine);
                        List<Word> pWList = line.getWords();
                        Word[] pW = pWList.toArray(new Word[pWList.size()]);
                        for (int i = 0; i < pW.length; ++i) {
                            pW[i].setFontSize(newFontSize);
                            int spacedWordLen = this.wordWidth(pW[i]) + fM.stringWidth(" ");
                            if (i > 0 && x + spacedWordLen > width - 4) {
                                lineLengths[lineCount] = lineLength;
                                ++lineCount;
                                y += yStep;
                                x = xMargin;
                            }
                            itemList[itemIdx++] = new TextGraphicsItem(x, y - fontBaselineToBottom, lineCount, pW[i]);
                            lineLength = x + this.wordWidth(pW[i]);
                            if ((x += spacedWordLen) > xMax) {
                                xMax = x;
                            }
                            if (y <= yMax) continue;
                            yMax = y;
                        }
                        if (docLine < lines.size() - 1) {
                            if ((y += yStep) > yMax) {
                                yMax = y;
                            }
                            x = xMargin;
                        }
                        lineLengths[lineCount] = lineLength;
                        ++lineCount;
                    }
                    if (yMax > height) continue;
                    textSizeOK = true;
                    int tmpHAlign = this.hAlign;
                    if (newFontSize < scaledFontSize) {
                        tmpHAlign = 0;
                    }
                    boxBaseY = (height - yMax) / 2;
                    for (int i = 0; i < itemList.length; ++i) {
                        if (tmpHAlign == 0) {
                            itemList[i].xPos = itemList[i].xPos;
                        } else if (tmpHAlign == 1) {
                            itemList[i].xPos = width - xMargin - lineLengths[itemList[i].line] + itemList[i].xPos;
                        } else if (tmpHAlign == 2) {
                            itemList[i].xPos = (width - lineLengths[itemList[i].line]) / 2 + itemList[i].xPos;
                        }
                        if (this.vAlign == 3) {
                            itemList[i].yPos = itemList[i].yPos;
                            continue;
                        }
                        if (this.vAlign == 4) {
                            itemList[i].yPos = height - n - (yMax + n) + itemList[i].yPos;
                            continue;
                        }
                        if (this.vAlign != 5) continue;
                        itemList[i].yPos = boxBaseY + itemList[i].yPos;
                    }
                }
                Graphics2D g2d = (Graphics2D)g;
                if (itemList != null) {
                    for (void var19_27 : itemList) {
                        this.paintTextGraphicsItem(g, (TextGraphicsItem)var19_27);
                    }
                }
                int tgiIdx = 0;
                for (int l = 0; l < lineCount; ++l) {
                    void var19_29;
                    int tgLine;
                    Integer underLineStart = null;
                    Object var19_28 = null;
                    String underLineBeginStr = null;
                    Font underLineStartFont = null;
                    Integer underLineStop = null;
                    int x1 = xMargin;
                    Integer x2 = null;
                    do {
                        void tgi;
                        if ((tgLine = (tgi = itemList[tgiIdx]).getLine()) > l) continue;
                        x1 = tgi.getX();
                        Word w = tgi.getWord();
                        List<TextFragment> tFrs = w.getTextFragments();
                        for (TextFragment tFr : tFrs) {
                            int frWidth = this.fragmentWidth(tFr);
                            Boolean ul = tFr.getUnderLine();
                            if (Boolean.TRUE.equals(ul)) {
                                if (underLineStart == null) {
                                    underLineStart = x1;
                                    Integer n = tgi.getY();
                                    underLineStartFont = this.fontByTextFragment(tFr);
                                    underLineBeginStr = tFr.getText();
                                }
                            } else if (underLineStart != null && underLineStop == null) {
                                underLineStop = x2;
                                this.paintUnderLine(g2d, underLineStartFont, underLineBeginStr, underLineStart, var19_29.intValue(), underLineStop - underLineStart);
                                underLineStart = null;
                                Object var19_31 = null;
                                underLineBeginStr = null;
                                underLineStartFont = null;
                                underLineStop = null;
                            }
                            x2 = x1 += frWidth;
                        }
                        if (++tgiIdx == itemList.length) break;
                    } while (tgLine <= l);
                    if (underLineStart == null || underLineStop != null) continue;
                    underLineStop = x1;
                    this.paintUnderLine(g2d, underLineStartFont, underLineBeginStr, underLineStart, var19_29.intValue(), underLineStop - underLineStart);
                }
            }
        }
    }

    private void paintUnderLine(Graphics2D g2d, Font f, String str, int x, int y, int width) {
        LineMetrics lm = f.getLineMetrics(str, g2d.getFontRenderContext());
        float ulOffset = lm.getUnderlineOffset();
        float ulThickness = lm.getUnderlineThickness();
        g2d.setColor(this.textColor);
        g2d.fillRect(x, y + (int)ulOffset, width, (int)ulThickness);
    }

    private void paintTextGraphicsItem(Graphics g, TextGraphicsItem textGraphicsitem) {
        this.paintWord(g, textGraphicsitem.getWord(), textGraphicsitem.getX(), textGraphicsitem.getY());
    }

    private void paintWord(Graphics g, Word w, int wx, int wy) {
        List<TextFragment> tFrs = w.getTextFragments();
        Font wf = null;
        int x = wx;
        String word = "";
        for (TextFragment tFr : tFrs) {
            int frWidth = this.fragmentWidth(tFr);
            Font f = this.fontByTextFragment(tFr);
            g.setFont(f);
            if (wf == null) {
                wf = f;
            }
            Color tColor = this.textColor;
            Color frColor = tFr.getColor();
            if (frColor != null) {
                tColor = frColor;
            }
            g.setColor(tColor);
            String t = tFr.getText();
            word = word.concat(t);
            g.drawString(t, x, wy);
            x += frWidth;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.textColor);
        try {
            this.prepareGraphics(g);
        }
        catch (ArrayIndexOutOfBoundsException arrException) {
            arrException.printStackTrace();
        }
    }

    public void showContents() {
    }

    public void hideContents() {
    }

    protected void setContents(PromptDoc promptDoc) {
        this.promptText = promptDoc;
    }

    public void setContents(String s) {
        this.promptText = this.promptDocFromString(s);
    }

    public void setContents(String s, String d) {
        this.setContents(s.replaceAll("\\s{2,}", " "));
    }

    public void setContents(String s, String d, String type) {
        this.setContents(s, d);
    }

    public void setContents(URL u) {
        this.setContents(u, null);
    }

    public void setContents(URL u, String d) {
        this.setContents(u, null, null);
    }

    public void setContents(URL u, String d, String type) {
        this.setContents(u, null, null, null);
    }

    public void setContents(URL u, String d, String type, String cs) {
        try {
            InputStreamReader r = null;
            r = cs != null ? new InputStreamReader(u.openStream(), cs) : new InputStreamReader(u.openStream());
            StringWriter sw = new StringWriter();
            char[] cbuf = new char[2048];
            int read = 0;
            while ((read = r.read(cbuf)) >= 0) {
                sw.write(cbuf, 0, read);
            }
            r.close();
            sw.close();
            this.setContents(sw.getBuffer().toString(), d);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPromptFont(Font promptFont) {
        this.promptFont = promptFont;
        this.fontSize = promptFont.getSize();
        if (this.fontSize < 12) {
            this.fontSize = 12;
        }
        this.fontStyle = promptFont.getStyle();
    }

    @Override
    public boolean getEmphasized() {
        return this.emphasized;
    }

    @Override
    public void setEmphasized(boolean emphasized) {
        this.emphasized = emphasized;
        if (emphasized) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.lightGray);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return SprCompatTextViewer.getSupportedMIMETypes(new String[]{"text/plain", "text/x-prompt"});
    }

    private List<Word> convertToLine(List<TextFormatElement> textTree) {
        ArrayList<Word> wrds = new ArrayList<Word>();
        Word currWord = null;
        for (TextFormatElement ft : textTree) {
            String t;
            Text text = null;
            ipsk.db.speech.Font f = null;
            if (ft instanceof ipsk.db.speech.Font) {
                f = (ipsk.db.speech.Font)ft;
                text = f.getText();
            } else if (ft instanceof Text) {
                text = (Text)ft;
            }
            if ((t = text.getText()) == null) continue;
            if (t.matches("^\\s.*")) {
                currWord = null;
            }
            String[] wordStrs = t.split("\\s+");
            int wordCnt = wordStrs.length;
            for (int wIdx = 0; wIdx < wordCnt; ++wIdx) {
                String wStr = wordStrs[wIdx];
                if ("".equals(wStr)) continue;
                TextFragment tfr = new TextFragment(wStr);
                if (f != null) {
                    if (ipsk.db.speech.Font.NORMAL.equals(f.getStyle())) {
                        tfr.setFontStyle(TextFragment.FontStyle.NORMAL);
                    } else if (ipsk.db.speech.Font.ITALIC.equals(f.getStyle())) {
                        tfr.setFontStyle(TextFragment.FontStyle.ITALIC);
                    }
                    if (ipsk.db.speech.Font.NORMAL.equals(f.getWeight())) {
                        tfr.setFontWeight(new TextFragment.FontWeight(400));
                    } else if (ipsk.db.speech.Font.BOLD.equals(f.getWeight())) {
                        tfr.setFontWeight(new TextFragment.FontWeight(700));
                    }
                }
                if (Text.NONE.equals(text.getDecoration())) {
                    tfr.setUnderLine(false);
                } else if (Text.UNDERLINE.equals(text.getDecoration())) {
                    tfr.setUnderLine(true);
                }
                String colorStr = text.getColor();
                if (colorStr != null) {
                    try {
                        Color c = ColorUtils.stringToColor((String)colorStr);
                        if (c != null) {
                            tfr.setColor(c);
                        }
                    }
                    catch (ParserException e) {
                        e.printStackTrace();
                    }
                }
                if (currWord == null) {
                    currWord = new Word();
                    wrds.add(currWord);
                }
                currWord.getTextFragments().add(tfr);
                if (wIdx >= wordCnt - 1 && !t.matches(".*\\s$")) continue;
                currWord = null;
            }
        }
        return wrds;
    }

    private List<Line> convertToLines(List<Block> textTree) {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (Block blck : textTree) {
            P p;
            List<Word> wrds;
            if (!(blck instanceof P) || (wrds = this.convertToLine((p = (P)blck).getTexts())).size() <= 0) continue;
            Line l = new Line(wrds);
            lines.add(l);
        }
        return lines;
    }

    private PromptDoc convertToPrompTDoc(List<Block> blocks) {
        List<Line> lines = this.convertToLines(blocks);
        PromptDoc prDoc = new PromptDoc(lines);
        return prDoc;
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems == null || this.mediaitems.length == 0) {
            throw new UnsupportedContentException("No media item to display!");
        }
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        String text = null;
        Mediaitem mi = this.mediaitems[0];
        URL u = this.applyContextToMediaitemURL(mi);
        if (u != null) {
            Charset cs = null;
            String miCharset = mi.getCharSet();
            if (miCharset != null) {
                cs = Charset.forName(miCharset.trim());
            }
            InputStreamReader r = null;
            try {
                r = cs != null ? new InputStreamReader(u.openStream(), cs) : new InputStreamReader(u.openStream());
                StringWriter sw = new StringWriter();
                char[] cbuf = new char[2048];
                int read = 0;
                while ((read = r.read(cbuf)) >= 0) {
                    sw.write(cbuf, 0, read);
                }
                sw.close();
                text = sw.getBuffer().toString();
            }
            catch (IOException e) {
                throw new PromptPresenterException(e);
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException e) {
                    throw new PromptPresenterException(e);
                }
            }
        }
        List blocks = mi.getBlocks();
        if (blocks != null && blocks.size() > 0) {
            this.promptText = this.convertToPrompTDoc(blocks);
        } else {
            text = mi.getText();
            if (text != null) {
                this.promptText = this.promptDocFromString(text.replaceAll("\\s{2,}", " "));
            }
        }
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    protected void testPrompt() {
        ArrayList<Line> p1 = new ArrayList<Line>();
        ArrayList<Word> wsl1 = new ArrayList<Word>();
        ArrayList<TextFragment> tn1s = new ArrayList<TextFragment>();
        TextFragment tn11 = new TextFragment("Wel");
        tn11.setColor(Color.GREEN);
        tn11.setUnderLine(true);
        tn1s.add(tn11);
        TextFragment tn12 = new TextFragment("come");
        tn12.setFontStyle(TextFragment.FontStyle.ITALIC);
        tn12.setColor(Color.RED);
        tn12.setUnderLine(true);
        tn1s.add(tn12);
        Word w1 = new Word(tn1s);
        wsl1.add(w1);
        TextFragment tn2 = new TextFragment("to");
        tn2.setUnderLine(true);
        Word w2 = new Word(tn2);
        wsl1.add(w2);
        TextFragment tn3 = new TextFragment("the");
        tn3.setUnderLine(true);
        Word w3 = new Word(tn3);
        wsl1.add(w3);
        Line l1 = new Line(wsl1);
        p1.add(l1);
        ArrayList<Word> wsl2 = new ArrayList<Word>();
        TextFragment tn4 = new TextFragment("compatible");
        tn4.setUnderLine(true);
        Word w4 = new Word(tn4);
        wsl2.add(w4);
        TextFragment tn5 = new TextFragment("formatted");
        tn5.setUnderLine(true);
        Word w5 = new Word(tn5);
        wsl2.add(w5);
        Line l2 = new Line(wsl2);
        p1.add(l2);
        ArrayList<Word> wsl3 = new ArrayList<Word>();
        TextFragment tn6 = new TextFragment("text");
        Word w6 = new Word(tn6);
        wsl3.add(w6);
        TextFragment tn7 = new TextFragment("viewer");
        Word w7 = new Word(tn7);
        wsl3.add(w7);
        TextFragment tn8 = new TextFragment("!!!!!!!!!!!!!!!!!!!!!!!");
        tn8.setUnderLine(true);
        Word w8 = new Word(tn8);
        wsl3.add(w8);
        Line l3 = new Line(wsl3);
        p1.add(l3);
        PromptDoc pd = new PromptDoc(p1);
        this.setContents(pd);
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SprCompatTextViewer vw = new SprCompatTextViewer();
                vw.setPreferredSize(new Dimension(600, 400));
                JFrame w = new JFrame();
                w.setDefaultCloseOperation(3);
                w.getContentPane().add(vw);
                w.pack();
                w.setVisible(true);
                vw.testPrompt();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    class LineState {
        private List<Word> words = new ArrayList<Word>();
        private Word word = null;

        LineState() {
        }

        public Word getWord() {
            return this.word;
        }

        public void setWord(Word word) {
            this.word = word;
        }

        public List<Word> getWords() {
            return this.words;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (Word w : this.words) {
                sb.append('[');
                sb.append(w.toString());
                sb.append(']');
            }
            if (this.word != null) {
                sb.append('[');
                sb.append(this.word);
            }
            return sb.toString();
        }
    }

    class TextGraphicsItem {
        protected int xPos;
        protected int yPos;
        protected int line;
        protected Word word;

        public int getLine() {
            return this.line;
        }

        public Word getWord() {
            return this.word;
        }

        protected TextGraphicsItem(int x, int y, int l, Word s) {
            this.xPos = x;
            this.yPos = y;
            this.line = l;
            this.word = s;
        }

        public int getX() {
            return this.xPos;
        }

        public int getY() {
            return this.yPos;
        }
    }

    public static class TextFragment {
        private String text;
        private String fontFamily = null;
        private FontStyle fontStyle = null;
        private Color color = null;
        private Boolean underLine = null;
        private FontWeight fontWeight = null;
        private Float fontSize = null;

        public Boolean getUnderLine() {
            return this.underLine;
        }

        public void setUnderLine(Boolean underLine) {
            this.underLine = underLine;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public FontStyle getFontStyle() {
            return this.fontStyle;
        }

        public void setFontStyle(FontStyle fontStyle) {
            this.fontStyle = fontStyle;
        }

        public FontWeight getFontWeight() {
            return this.fontWeight;
        }

        public void setFontWeight(FontWeight fontWeight) {
            this.fontWeight = fontWeight;
        }

        public Float getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(Float fontSize) {
            this.fontSize = fontSize;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getFontFamily() {
            return this.fontFamily;
        }

        public void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        public TextFragment(String textFragmentString) {
            this.text = textFragmentString;
        }

        public boolean isDefaultFont() {
            return this.fontFamily == null && this.fontStyle == null && this.fontWeight == null && this.fontSize == null;
        }

        public String toString() {
            if (this.text != null) {
                return this.text;
            }
            return "";
        }

        public static class FontWeight {
            public static final int NORMAL = 400;
            public static final int BOLD = 700;
            private int weight;

            public int getWeight() {
                return this.weight;
            }

            public FontWeight(int weight) {
                this.weight = weight;
            }

            public boolean isNormal() {
                return this.weight == 400;
            }

            public boolean isBold() {
                return this.weight == 700;
            }
        }

        public static enum FontStyle {
            NORMAL,
            ITALIC,
            OBLIQUE;

        }
    }

    public class Word {
        private List<TextFragment> textFragments = new ArrayList<TextFragment>();

        public List<TextFragment> getTextFragments() {
            return this.textFragments;
        }

        public Word(List<TextFragment> textFragments) {
            this.textFragments = textFragments;
        }

        public Word(TextFragment textFragment) {
            this.textFragments.add(textFragment);
        }

        public Word() {
        }

        public void setFontSize(int newFontSize) {
            for (TextFragment tfr : this.textFragments) {
                tfr.setFontSize(Float.valueOf(newFontSize));
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (TextFragment tfr : this.textFragments) {
                sb.append(tfr.toString());
            }
            return sb.toString();
        }
    }

    public class Line {
        private List<Word> words = new ArrayList<Word>();

        public List<Word> getWords() {
            return this.words;
        }

        public Line(List<Word> words) {
            this.words = words;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int wCnt = this.words.size();
            for (int i = 0; i < wCnt; ++i) {
                Word w = this.words.get(i);
                sb.append(w.toString());
                if (i > wCnt - 1) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
    }

    public class PromptDoc {
        private List<Line> lines = new ArrayList<Line>();

        public List<Line> getLines() {
            return this.lines;
        }

        public PromptDoc(List<Line> lines) {
            this.lines = lines;
        }

        public int wordCount() {
            int words = 0;
            for (Line line : this.lines) {
                words += line.getWords().size();
            }
            return words;
        }
    }
}

