/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;

public class ItemcodeGeneratorConfiguration
implements Cloneable {
    public String DEFAULT_PREFIX = "item";
    public int DEFAULT_FIXED_DECIMAL_PLACES = 4;
    public static int MIN_FIXED_DECIMAL_PLACES = 0;
    public static int MAX_FIXED_DECIMAL_PLACES = 10;
    private String generatorName = "Decimal Generator";
    private int fixedDecimalPlaces = this.DEFAULT_FIXED_DECIMAL_PLACES;
    private boolean useSectionName = false;
    private DecimalFormat counterFormat = null;
    private String prefix = this.DEFAULT_PREFIX;
    private int counterStart = 0;
    private int increment = 1;
    private boolean active = true;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ItemcodeGeneratorConfiguration() {
        this.setFixedDecimalPlaces(this.DEFAULT_FIXED_DECIMAL_PLACES);
    }

    public String getGeneratorName() {
        return this.generatorName;
    }

    public void setGeneratorName(String generatorName) {
        String oldGeneratorName = this.generatorName;
        this.generatorName = generatorName;
        this.propertyChangeSupport.firePropertyChange("generatorName", oldGeneratorName, this.generatorName);
    }

    public DecimalFormat counterFormat() {
        return this.counterFormat;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        String oldPrefix = this.prefix;
        this.prefix = prefix;
        this.propertyChangeSupport.firePropertyChange("prefix", oldPrefix, this.prefix);
    }

    public int getCounterStart() {
        return this.counterStart;
    }

    public void setCounterStart(int counterStart) {
        this.counterStart = counterStart;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        int oldIncrement = this.increment;
        this.increment = increment;
        this.propertyChangeSupport.firePropertyChange("increment", oldIncrement, this.increment);
    }

    public int getFixedDecimalPlaces() {
        return this.fixedDecimalPlaces;
    }

    public void setFixedDecimalPlaces(int fixedDecimalPlaces) {
        int oldFixedDecimalPlaces = this.fixedDecimalPlaces;
        this.fixedDecimalPlaces = fixedDecimalPlaces;
        if (fixedDecimalPlaces < MIN_FIXED_DECIMAL_PLACES || fixedDecimalPlaces > MAX_FIXED_DECIMAL_PLACES) {
            throw new IllegalArgumentException("Fixed decimal places must be a number between " + MIN_FIXED_DECIMAL_PLACES + " and " + MAX_FIXED_DECIMAL_PLACES);
        }
        if (fixedDecimalPlaces == 0) {
            this.counterFormat = null;
        } else {
            StringBuffer patternBuff = new StringBuffer();
            for (int i = 0; i < fixedDecimalPlaces; ++i) {
                patternBuff.append('0');
            }
            String pattern = patternBuff.toString();
            this.counterFormat = new DecimalFormat(pattern);
        }
        this.propertyChangeSupport.firePropertyChange("fixedDecimalPlaces", oldFixedDecimalPlaces, this.fixedDecimalPlaces);
    }

    public boolean isUseSectionName() {
        return this.useSectionName;
    }

    public void setUseSectionName(boolean useSectionName) {
        boolean oldUseSectionName = this.useSectionName;
        this.useSectionName = useSectionName;
        this.propertyChangeSupport.firePropertyChange("useSectionName", oldUseSectionName, this.useSectionName);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return this.propertyChangeSupport.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean oldActive = this.active;
        this.active = active;
        this.firePropertyChange("active", oldActive, this.active);
    }

    public ItemcodeGeneratorConfiguration cloneTyped() {
        ItemcodeGeneratorConfiguration clone = new ItemcodeGeneratorConfiguration();
        clone.setActive(this.isActive());
        clone.setCounterStart(this.getCounterStart());
        clone.setIncrement(this.getIncrement());
        clone.setGeneratorName(this.getGeneratorName());
        clone.setPrefix(this.getPrefix());
        clone.setFixedDecimalPlaces(this.getFixedDecimalPlaces());
        clone.setUseSectionName(this.isUseSectionName());
        return clone;
    }

    public Object clone() {
        return this.cloneTyped();
    }
}

