/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.db.speech.Group;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PromptItemsTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int COL_INDEX = 0;
    public static final int COL_GROUP = 1;
    public static final int COL_FILE = 2;
    public static final int COL_PROMPT = 3;
    private static final int LAST_COL_INDEX = 3;
    private List<Group> promptUnits = new ArrayList<Group>();

    @Override
    public Class<?> getColumnClass(int colIndex) {
        if (colIndex == 0) {
            return Integer.class;
        }
        if (colIndex == 1) {
            return Integer.class;
        }
        if (colIndex == 2) {
            return String.class;
        }
        if (colIndex == 3) {
            return String.class;
        }
        return null;
    }

    @Override
    public String getColumnName(int colIndex) {
        if (colIndex == 0) {
            return "Index in section";
        }
        if (colIndex == 1) {
            return "Gr";
        }
        if (colIndex == 2) {
            return "File";
        }
        if (colIndex == 3) {
            return "Prompt";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        int rows = 0;
        for (Group g : this.promptUnits) {
            int gRows = g.getPromptItems().size();
            rows += gRows;
        }
        return rows;
    }

    public List<PromptItem> promptItems() {
        ArrayList<PromptItem> pis = new ArrayList<PromptItem>();
        if (this.promptUnits != null) {
            for (Group g : this.promptUnits) {
                pis.addAll(g.getPromptItems());
            }
        }
        return pis;
    }

    private Integer groupOfPromptItem(PromptItem pi) {
        int grIdx = 0;
        for (Group g : this.promptUnits) {
            List pis = g.getPromptItems();
            boolean realGroup = pis.size() > 1;
            for (PromptItem gpi : g.getPromptItems()) {
                if (gpi != pi) continue;
                if (realGroup) {
                    return grIdx;
                }
                return null;
            }
            if (!realGroup) continue;
            ++grIdx;
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex > 3 || rowIndex > this.getRowCount()) {
            return null;
        }
        PromptItem rowItem = this.promptItems().get(rowIndex);
        Recording r = null;
        if (rowItem instanceof Recording) {
            r = (Recording)rowItem;
        }
        if (columnIndex == 0) {
            return rowIndex;
        }
        if (columnIndex == 1) {
            Integer grIdx = this.groupOfPromptItem(rowItem);
            return grIdx;
        }
        if (columnIndex == 2) {
            if (r == null) {
                return "";
            }
            return r.getItemcode();
        }
        if (columnIndex == 3) {
            return rowItem.getDescription();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            PromptItem pi = this.promptItems().get(rowIndex);
            if (pi instanceof Recording && aValue instanceof String) {
                Recording r = (Recording)pi;
                r.setItemcode((String)aValue);
            }
        } else if (columnIndex == 3 && aValue instanceof String) {
            PromptItem pi = this.promptItems().get(rowIndex);
            ((Mediaitem)pi.getMediaitems().get(0)).setText((String)aValue);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        PromptItem pi = this.promptItems().get(row);
        if (col == 2) {
            return !(pi instanceof Nonrecording);
        }
        if (col == 3) {
            String mType = ((Mediaitem)pi.getMediaitems().get(0)).getNNMimetype();
            for (String ptMimeType : MIMETypes.PLAINTEXTMIMETYPES) {
                if (!mType.equals(ptMimeType)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Group> getPromptUnits() {
        return this.promptUnits;
    }

    private void _setPromptUnits(List<Group> promptUnits) {
        this.releaseListeners();
        this.promptUnits = promptUnits;
        if (this.promptUnits != null) {
            for (PromptItem pi : this.promptItems()) {
                Mediaitem mi = (Mediaitem)pi.getMediaitems().get(0);
                mi.addPropertyChangeListener((PropertyChangeListener)this);
                pi.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    public void setPromptUnits(List<Group> promptUnits) {
        this._setPromptUnits(promptUnits);
        this.fireTableDataChanged();
    }

    public void setPromptUnits(List<Group> promptUnits, int deletedFirstRow, int deletedLastRow) {
        this._setPromptUnits(promptUnits);
        this.fireTableRowsDeleted(deletedFirstRow, deletedLastRow);
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block3: {
            List<PromptItem> promptItems;
            Object src;
            block2: {
                src = evt.getSource();
                promptItems = this.promptItems();
                if (!(src instanceof PromptItem)) break block2;
                for (int i = 0; i < promptItems.size(); ++i) {
                    if (src != promptItems.get(i)) continue;
                    this.fireTableRowsUpdated(i, i);
                }
                break block3;
            }
            if (!(src instanceof Mediaitem)) break block3;
            for (int i = 0; i < promptItems.size(); ++i) {
                Mediaitem mi = (Mediaitem)promptItems.get(i).getMediaitems().get(0);
                if (src != mi) continue;
                this.fireTableRowsUpdated(i, i);
            }
        }
    }

    public void releaseListeners() {
        if (this.promptUnits != null) {
            for (PromptItem oldPromptItem : this.promptItems()) {
                Mediaitem mi = (Mediaitem)oldPromptItem.getMediaitems().get(0);
                mi.removePropertyChangeListener((PropertyChangeListener)this);
                oldPromptItem.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

