/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.db.speech.Section;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.AbstractTableModel;

public class SectionsTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final int COL_INDEX = 0;
    private static final int COL_NAME = 1;
    private Section[] sections = new Section[0];

    @Override
    public Class<?> getColumnClass(int colIndex) {
        if (colIndex == 0) {
            return Integer.class;
        }
        if (colIndex == 1) {
            return String.class;
        }
        return null;
    }

    @Override
    public String getColumnName(int colIndex) {
        if (colIndex == 0) {
            return "#";
        }
        if (colIndex == 1) {
            return "Name";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.sections == null) {
            return 0;
        }
        return this.sections.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Section rowSection = this.sections[rowIndex];
        if (columnIndex == 0) {
            return rowIndex;
        }
        if (columnIndex == 1) {
            return rowSection.getName();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1 && aValue instanceof String) {
            Section s = this.sections[rowIndex];
            s.setName((String)aValue);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public Section[] getSections() {
        return this.sections;
    }

    public void setSections(Section[] sections) {
        if (this.sections != null) {
            for (Section oldSection : this.sections) {
                oldSection.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.sections = sections;
        if (this.sections != null) {
            for (Section s : this.sections) {
                s.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src instanceof Section) {
            for (int i = 0; i < this.sections.length; ++i) {
                if (src != this.sections[i]) continue;
                this.fireTableRowsUpdated(i, i);
            }
        }
    }
}

