/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.ui.ItemcodeGeneratorUI;
import ipsk.db.speech.Group;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Reccomment;
import ipsk.db.speech.Recinstructions;
import ipsk.db.speech.Recording;
import ipsk.db.speech.Section;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.swing.EnumSelectionItem;
import ipsk.swing.EnumVector;
import ipsk.text.TableReader;
import ipsk.util.LocalizableMessage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TableTextfileImporter
extends JPanel
implements ActionListener,
DocumentListener {
    public static ColumnDescriptor ITEM_CODE_DESCRIPTOR = new ColumnDescriptor("Code");
    public static ColumnDescriptor PROMPT_TEXT_DESCRIPTOR = new ColumnDescriptor("PromptText");
    public static ColumnDescriptor INSTRUCTIONS_TEXT_DESCRIPTOR = new ColumnDescriptor("InstructionsText");
    public static ColumnDescriptor COMMENT_TEXT_DESCRIPTOR = new ColumnDescriptor("CommentText");
    private ColumnDescriptor[] colDescriptors = null;
    private JButton browseButton;
    private JComboBox<String> charSetsChooser;
    private JComboBox<FieldSeparator> fieldSeparatorChooser;
    private JFileChooser fileChooser;
    private File textFile;
    private SortedMap<String, Charset> charSetMap;
    private Vector<String[]> lines = new Vector();
    private TableReader tableReader;
    private JTextField textFilePathField;
    private JLabel statusMessage;
    private static EnumVector<FieldSeparator> FIELD_SEPARATORS = new EnumVector(FieldSeparator.class);
    private JComboBox[] colDescriptorChoosers = null;
    private ItemcodeGenerator itemcodeGenerator;
    private IntegerSequenceGenerator sequenceGenerator;
    private boolean validScriptAvailable = false;
    public static final String VALID_SCRIPT_AVAILABLE_PROPNAME = "validScriptAvailable";
    private ItemcodeGeneratorUI itemCodeGeneratorPanel;

    public TableTextfileImporter() {
        this(null, new ItemcodeGenerator(), null);
    }

    public TableTextfileImporter(ColumnDescriptor[] columnDescriptors, ItemcodeGenerator itemcodeGenerator, IntegerSequenceGenerator sequenceGenerator) {
        super(new GridBagLayout());
        this.colDescriptors = columnDescriptors;
        this.itemcodeGenerator = itemcodeGenerator;
        this.sequenceGenerator = sequenceGenerator;
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 2.0;
        JPanel textFileImportPanel = new JPanel(new GridBagLayout());
        TitledBorder tb = BorderFactory.createTitledBorder("Text file import");
        textFileImportPanel.setBorder(tb);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.insets = new Insets(2, 2, 2, 2);
        c2.gridx = 0;
        c2.gridy = 0;
        c2.anchor = 17;
        textFileImportPanel.add((Component)new JLabel("Table file:"), c2);
        ++c2.gridx;
        c2.weightx = 2.0;
        c2.fill = 2;
        this.textFilePathField = new JTextField(30);
        this.textFilePathField.setEnabled(false);
        this.textFilePathField.setEditable(false);
        textFileImportPanel.add((Component)this.textFilePathField, c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        c2.fill = 0;
        this.browseButton = new JButton("Browse...");
        this.browseButton.addActionListener(this);
        textFileImportPanel.add((Component)this.browseButton, c2);
        c2.gridx = 0;
        ++c2.gridy;
        JLabel charSetLabel = new JLabel("Charset:");
        textFileImportPanel.add((Component)charSetLabel, c2);
        ++c2.gridx;
        c2.gridwidth = 1;
        this.charSetMap = Charset.availableCharsets();
        Set<String> charSetKeys = this.charSetMap.keySet();
        Charset defCharSet = Charset.defaultCharset();
        String defCharsetName = defCharSet.name();
        String[] charSetKeyStrs = charSetKeys.toArray(new String[0]);
        this.charSetsChooser = new JComboBox<String>(charSetKeyStrs);
        this.charSetsChooser.setSelectedItem(defCharsetName);
        this.charSetsChooser.addActionListener(this);
        textFileImportPanel.add(this.charSetsChooser, c2);
        c2.gridx = 0;
        ++c2.gridy;
        c2.gridwidth = 1;
        c2.anchor = 17;
        JLabel fsLabel = new JLabel("Field Separator:");
        textFileImportPanel.add((Component)fsLabel, c2);
        ++c2.gridx;
        this.fieldSeparatorChooser = new JComboBox<FieldSeparator>((Vector<FieldSeparator>)FIELD_SEPARATORS);
        this.fieldSeparatorChooser.addActionListener(this);
        textFileImportPanel.add(this.fieldSeparatorChooser, c2);
        c2.gridx = 0;
        ++c2.gridy;
        c2.anchor = 17;
        textFileImportPanel.add((Component)new JLabel("Status:"), c2);
        ++c2.gridx;
        c2.fill = 2;
        c2.weightx = 2.0;
        this.statusMessage = new JLabel("No text file loaded.");
        textFileImportPanel.add((Component)this.statusMessage, c2);
        ++c.gridy;
        this.add((Component)textFileImportPanel, c);
        JPanel mappingPanel = new JPanel(new GridBagLayout());
        TitledBorder tb2 = BorderFactory.createTitledBorder("Mapping");
        mappingPanel.setBorder(tb2);
        GridBagConstraints c3 = new GridBagConstraints();
        if (this.colDescriptors != null) {
            this.colDescriptorChoosers = new JComboBox[this.colDescriptors.length];
            c3.gridx = 0;
            c3.gridy = 0;
            c3.gridwidth = 1;
            for (int i = 0; i < this.colDescriptors.length; ++i) {
                c3.gridx = 0;
                String label = this.colDescriptors[i].toString();
                mappingPanel.add((Component)new JLabel(label + ":"), c3);
                ++c3.gridx;
                this.colDescriptorChoosers[i] = new JComboBox();
                this.colDescriptorChoosers[i].addItem(new Column(null));
                this.colDescriptorChoosers[i].addActionListener(this);
                mappingPanel.add((Component)this.colDescriptorChoosers[i], c3);
                ++c3.gridy;
            }
        }
        ++c.gridy;
        this.add((Component)mappingPanel, c);
        this.itemCodeGeneratorPanel = new ItemcodeGeneratorUI(itemcodeGenerator);
        TitledBorder tbicg = BorderFactory.createTitledBorder("Item code generator");
        this.itemCodeGeneratorPanel.setBorder(tbicg);
        ++c.gridy;
        this.add((Component)this.itemCodeGeneratorPanel, c);
        this.tableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        for (JComboBox rdch : this.colDescriptorChoosers) {
            if (src != rdch) continue;
            this.setDependencies();
            return;
        }
        if (src == this.browseButton) {
            this.fileChooser = new JFileChooser();
            int res = this.fileChooser.showDialog(this, "Select");
            if (res == 0) {
                this.textFile = this.fileChooser.getSelectedFile();
            }
        }
        if (this.textFile != null) {
            try {
                this.readFile();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not read file: " + e.getMessage());
                return;
            }
            this.tableDataChanged();
        }
    }

    public String[][] getTableData() {
        if (this.lines == null) {
            return null;
        }
        return (String[][])this.lines.toArray((T[])new String[0][]);
    }

    public void setValidScriptAvailable(boolean validScriptAvailable) {
        boolean oldValidScriptAvailable = this.validScriptAvailable;
        this.validScriptAvailable = validScriptAvailable;
        if (oldValidScriptAvailable != this.validScriptAvailable) {
            this.firePropertyChange(VALID_SCRIPT_AVAILABLE_PROPNAME, oldValidScriptAvailable, this.validScriptAvailable);
        }
    }

    public boolean isValidScriptAvailable() {
        return this.validScriptAvailable;
    }

    private boolean itemCodeColSelected() {
        for (int i = 0; i < this.colDescriptorChoosers.length; ++i) {
            Column col;
            if (!ITEM_CODE_DESCRIPTOR.equals(this.colDescriptors[i]) || (col = (Column)this.colDescriptorChoosers[i].getSelectedItem()) == null || col.getColumn() == null) continue;
            return true;
        }
        return false;
    }

    private void setDependencies() {
        if (this.textFile != null) {
            this.textFilePathField.setText("file:" + this.textFile.getPath());
            this.textFilePathField.setEnabled(true);
        } else {
            this.textFilePathField.setText("");
            this.textFilePathField.setEnabled(false);
        }
        boolean itemCodeRowSelected = this.itemCodeColSelected();
        this.itemCodeGeneratorPanel.setEnabled(!itemCodeRowSelected);
    }

    private void tableDataChanged() {
        boolean tableDataDetected = false;
        if (this.textFile != null) {
            this.textFilePathField.setText("file:" + this.textFile.getPath());
        } else {
            this.textFilePathField.setText("");
        }
        String message = "No table data";
        int maxCols = 0;
        int minCols = 0;
        if (this.lines != null && this.lines.size() > 0) {
            minCols = Integer.MAX_VALUE;
            for (String[] row : this.lines) {
                if (row.length > maxCols) {
                    maxCols = row.length;
                }
                if (row.length >= minCols) continue;
                minCols = row.length;
            }
            message = new String("Table with " + this.lines.size() + " rows and " + maxCols + " columns");
            tableDataDetected = true;
        }
        this.statusMessage.setText(message);
        if (this.colDescriptorChoosers != null) {
            for (int i = 0; i < this.colDescriptorChoosers.length; ++i) {
                JComboBox colDescriptorChooser = this.colDescriptorChoosers[i];
                ColumnDescriptor cd = this.colDescriptors[i];
                colDescriptorChooser.removeAllItems();
                colDescriptorChooser.addItem(new Column(null));
                for (int c = 0; c < maxCols; ++c) {
                    colDescriptorChooser.addItem(new Column(c));
                }
                if (minCols == 1 && PROMPT_TEXT_DESCRIPTOR.equals(cd)) {
                    colDescriptorChooser.setSelectedIndex(1);
                }
                if (minCols < 2 || i >= maxCols) continue;
                colDescriptorChooser.setSelectedIndex(i + 1);
            }
        }
        this.setValidScriptAvailable(tableDataDetected);
    }

    private void readFile() throws IOException {
        FileInputStream fis = new FileInputStream(this.textFile);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, (Charset)this.charSetMap.get(this.charSetsChooser.getSelectedItem()));
        this.tableReader = new TableReader((Reader)isr);
        EnumSelectionItem si = (EnumSelectionItem)this.fieldSeparatorChooser.getSelectedItem();
        FieldSeparator fs = (FieldSeparator)si.getEnumVal();
        Character fieldSep = Character.valueOf(fs.value());
        this.tableReader.setFieldSeparator(fieldSep.charValue());
        this.lines.clear();
        String[] line = null;
        try {
            while ((line = this.tableReader.readLineColumns()) != null) {
                this.lines.add(line);
            }
        }
        catch (IOException e) {
            this.lines.clear();
            throw e;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public Section createSection() {
        Section section = new Section();
        if (this.sequenceGenerator != null) {
            section.setSectionId(this.sequenceGenerator.getAndIncrement());
        }
        ArrayList<Group> recordings = new ArrayList<Group>();
        for (String[] line : this.lines) {
            Recording r = new Recording();
            Mediaitem mi = null;
            if (this.sequenceGenerator != null) {
                r.setRecpromptId(this.sequenceGenerator.getAndIncrement());
            }
            for (int rdi = 0; rdi < this.colDescriptors.length; ++rdi) {
                Recinstructions ri;
                ColumnDescriptor rd = this.colDescriptors[rdi];
                JComboBox rdch = this.colDescriptorChoosers[rdi];
                Column col = (Column)rdch.getSelectedItem();
                Integer colI = col.getColumn();
                String name = rd.getName();
                if (ITEM_CODE_DESCRIPTOR.equals(rd)) {
                    if (colI != null) {
                        if (line.length > colI) {
                            r.setItemcode(line[colI]);
                        }
                    } else {
                        String genItemcode = this.itemcodeGenerator.getItemCode();
                        r.setItemcode(genItemcode);
                        this.itemcodeGenerator.next();
                    }
                }
                if (colI == null) continue;
                if (PROMPT_TEXT_DESCRIPTOR.equals(rd)) {
                    if (line.length <= colI) continue;
                    if (mi == null) {
                        mi = new Mediaitem();
                        if (this.sequenceGenerator != null) {
                            mi.setMediaitemId(this.sequenceGenerator.getAndIncrement());
                        }
                    }
                    mi.setText(line[colI]);
                    continue;
                }
                if (INSTRUCTIONS_TEXT_DESCRIPTOR.equals(rd)) {
                    if (line.length <= colI) continue;
                    ri = new Recinstructions(this.sequenceGenerator.getAndIncrement());
                    ri.setRecinstructions(line[colI]);
                    r.setRecinstructions(ri);
                    continue;
                }
                if (!COMMENT_TEXT_DESCRIPTOR.equals(rd) || line.length <= colI) continue;
                ri = new Reccomment(this.sequenceGenerator.getAndIncrement());
                ri.setReccomment(line[colI]);
                r.setReccomment((Reccomment)ri);
            }
            if (mi != null) {
                ArrayList<Mediaitem> mil = new ArrayList<Mediaitem>();
                mil.add(mi);
                r.setMediaitems(mil);
            }
            if (r.getMediaitems().size() == 0) {
                Mediaitem emptyItem = new Mediaitem();
                if (this.sequenceGenerator != null) {
                    emptyItem.setMediaitemId(this.sequenceGenerator.getAndIncrement());
                }
                emptyItem.setText("");
                r.getMediaitems().add(emptyItem);
            }
            Group g = new Group();
            g.getPromptItems().add(r);
            recordings.add(g);
        }
        section.setGroups(recordings);
        return section;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.getContentPane().add(new TableTextfileImporter());
        f.pack();
        f.setVisible(true);
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
    }

    public static enum RecordSeparator {
        LF("\n", "New line (UNIX end of line)"),
        CRLF("\r\n", "Carriage return/line feed (Windows end of line)"),
        CR("\r", "Carriage return"),
        RS("\u001e", " RS  (record separator)");

        private final String value;
        private final String description;

        private RecordSeparator(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum FieldSeparator {
        TAB('\t', "Tabulator"),
        COMMA(',', "',' Comma"),
        SEMICOLON(';', "';' Semicolon"),
        COLON(':', "':' Colon"),
        HYPHEN('-', "'-' Hyphen"),
        BLANK(' ', "' ' Blank"),
        US('\u001f', " US  (unit separator)");

        private final char value;
        private final String description;

        private FieldSeparator(char value, String description) {
            this.value = value;
            this.description = description;
        }

        public char value() {
            return this.value;
        }

        public String toString() {
            return this.description;
        }
    }

    public static class Column {
        private Integer col;

        public Column(Integer row) {
            this.col = row;
        }

        public String toString() {
            if (this.col == null) {
                return "(no column)";
            }
            return this.col.toString();
        }

        public boolean equals(Object o) {
            if (o instanceof Column) {
                Column oRow = (Column)o;
                Integer oR = oRow.getColumn();
                if (oR == null) {
                    if (this.col == null) {
                        return true;
                    }
                } else {
                    return oR.equals(this.col);
                }
            }
            return false;
        }

        public Integer getColumn() {
            return this.col;
        }
    }

    public static class ColumnDescriptor {
        private String name;
        private LocalizableMessage description = null;

        public ColumnDescriptor(String name) {
            this(name, null);
        }

        public ColumnDescriptor(String name, LocalizableMessage description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public LocalizableMessage getDescription() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (o instanceof ColumnDescriptor) {
                ColumnDescriptor oCD = (ColumnDescriptor)o;
                String oN = oCD.getName();
                return oN.equals(this.name);
            }
            return false;
        }

        public String toString() {
            if (this.description != null) {
                return this.description.toString();
            }
            return this.name;
        }
    }
}

