/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.script.ui.StringSel;
import ipsk.apps.speechrecorder.script.ui.TogglePromptAsAnnotationTemplateAction;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptDocEditorKit;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyleContext;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.awt.font.AutoFontFamilyManager;
import ipsk.beans.MultiSelectPropertyState;
import ipsk.db.speech.Block;
import ipsk.db.speech.Font;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.P;
import ipsk.db.speech.Recording;
import ipsk.db.speech.Text;
import ipsk.io.StreamCopy;
import ipsk.net.URLContext;
import ipsk.net.Utils;
import ipsk.swing.JServiceSelector;
import ipsk.swing.TitledPanel;
import ipsk.swing.action.EditActions;
import ipsk.swing.action.EditActionsListener;
import ipsk.swing.filechooser.RestrictDirectoryFileSystemView;
import ipsk.swing.text.EditorKitMenu;
import ipsk.swing.text.JLocaleSelector;
import ipsk.text.ParserException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class BaseMediaitemUI
extends JPanel
implements ActionListener,
EditActionsListener,
PropertyChangeListener,
DocumentListener,
CaretListener {
    private static final long serialVersionUID = 1L;
    public static final String RESOURCE_PATH = "resources";
    public static final String[] REC_TYPES = new String[]{"Audio"};
    public static final String LOCATION_INTERNAL = "Internal";
    public static final String LOCATION_EXTERNAL = "External";
    public static final String[] LOCATIONS = new String[]{"Internal", "External"};
    public static final int ICON_WIDTH = 100;
    public static final int ICON_HEIGHT = 100;
    public static final int ROWS = 5;
    public static final int COLUMNS = 10;
    public static final int DEFAULT_FONT_SIZE = 48;
    public static final int DEFAULT_MAX_RELATIVE_SIZE_PERCENT = 1000;
    protected static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    protected UIResources uiString = null;
    protected Mediaitem mediaitem;
    protected JComboBox<String> mimeTypeWidget;
    protected JComboBox<StringSel> charsetWidget;
    protected JComboBox<String> external;
    protected JButton selectPresenterButton;
    protected JTextField promptSourceWidget;
    private EditorKitMenu promptSourceWidgetEditorKitMenu;
    protected JTextField altTextWidget;
    private EditorKitMenu altTextWidgetEditorKitMenu;
    protected JTextField mediaWidthWidget;
    protected JTextField mediaHeightWidget;
    protected JSpinner mediaVolumeWidget;
    protected JCheckBox autoPlayNonDefaultWidget;
    protected JCheckBox autoPlayWidget;
    protected JCheckBox modalPlayWidget;
    protected JCheckBox formattedCheckbox;
    protected JToggleButton boldButton;
    protected JToggleButton italicButton;
    protected JToggleButton lineThroughButton;
    protected JToggleButton underlineButton;
    protected JButton colorButton;
    protected JToggleButton defaultStyleButton;
    protected JCheckBox defaultFontSizeCheckbox;
    protected SpinnerModel relativeSizeSpinnerModel;
    protected JSpinner relativeSizeSpinner;
    protected JComboBox<String> sizeUnit;
    protected PromptDocEditorKit.SetFontSizeAction fontSizeAction;
    protected JEditorPane promptTextWidget;
    protected AutoFontFamilyManager promptFontManager;
    private String[] promptFontFamilies;
    private EditorKitMenu promptTextWidgetEditorKitMenu;
    protected JCheckBox promptAsAnnotationTemplateWidget;
    protected TogglePromptAsAnnotationTemplateAction togglePromptAsAnnotationTemplateAction;
    private JLabel imageLabel;
    protected JButton selectButton;
    protected JButton importButton;
    private File lastImportDir = null;
    protected JLabel altTextLabel;
    private JLabel annotationTemplateLabel;
    protected JLocaleSelector localeSelector;
    protected JLabel sourceLabel;
    protected TitledPanel promptTextContentsPanel;
    protected StringSel externalCharset = null;
    protected Vector<StringSel> selectableCharsets;
    protected JLabel charsetLabel;
    protected URL projectContext = null;
    protected JLabel srcTypeLabel;
    protected JLabel volumeLabel;
    protected boolean defaultPromptAutoPlay = true;
    protected EditActionsListener editActionsListener;
    protected List<PromptPresenterServiceDescriptor> availablePromptPresenters;
    protected JServiceSelector<PromptPresenter> promptPresenterSelector;
    private List<Mediaitem> mediaitems;
    private Document plainTextDocument;
    private boolean autoPlayEnabled;
    private boolean volumePropEnabled;
    private boolean modalPropEnabled;
    private boolean annotationTemplatePropEnabled;
    private boolean localePropEnabled;
    private boolean allMediaItemsOfTextType;
    protected JLabel mimeTypeLabel;
    private boolean allMediaItemsOfMediaType;
    private boolean mimeTypePropEnabled;
    private JButton selPresenterButton;
    private Font defaultPromptFont;
    private ActionListener actionListener = null;
    protected boolean adjusting = false;
    protected File resourcesDir = null;
    private File projectDir;
    private boolean applyingStateChange = false;

    public String[] getPromptFontFamilies() {
        return this.promptFontFamilies;
    }

    public void setPromptFontFamilies(String[] promptFontFamilies) {
        this.promptFontFamilies = promptFontFamilies;
        this.promptFontManager.setPreferredFontFamilies(promptFontFamilies);
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public EditActionsListener getEditActionListener() {
        return this.editActionsListener;
    }

    public void setEditActionListener(EditActionsListener editActionsListener) {
        this.editActionsListener = editActionsListener;
    }

    public BaseMediaitemUI(URL projectContext, List<PromptPresenterServiceDescriptor> availablePromptPresenters2) {
        this.availablePromptPresenters = availablePromptPresenters2;
        this.uiString = UIResources.getInstance();
        this.promptFontManager = new AutoFontFamilyManager();
        this._setProjectContext(projectContext);
    }

    protected void createWidgets() {
        StringSel defCharset;
        String[] singleMIMETypeCombinations = this.getSelectableMIMETypeCombinationsDisplayList(this.availablePromptPresenters);
        this.mimeTypeWidget = new JComboBox<String>(singleMIMETypeCombinations);
        this.mimeTypeWidget.setAlignmentX(2.0f);
        this.mimeTypeWidget.setToolTipText("The MIME-Type of the content of the URL.");
        this.charsetLabel = new JLabel("Charset", 4);
        String[] availableCharSets = Charset.availableCharsets().keySet().toArray(new String[0]);
        this.externalCharset = defCharset = new StringSel(null, "UTF-8 (Default)", true);
        this.selectableCharsets = new Vector(availableCharSets.length + 1);
        this.selectableCharsets.add(defCharset);
        for (int i = 0; i < availableCharSets.length; ++i) {
            this.selectableCharsets.add(new StringSel(availableCharSets[i], availableCharSets[i], true));
        }
        this.charsetWidget = new JComboBox<StringSel>(this.selectableCharsets);
        this.charsetWidget.setAlignmentX(2.0f);
        this.charsetWidget.setToolTipText("The Charset of the contents of the URL (default: UTF-8).");
        this.external = new JComboBox<String>(LOCATIONS);
        this.external.addActionListener(this);
        this.sourceLabel = new JLabel("Source", 4);
        this.promptSourceWidget = new JTextField(8);
        this.promptSourceWidgetEditorKitMenu = new EditorKitMenu((JTextComponent)this.promptSourceWidget, (EditActionsListener)this);
        this.promptSourceWidget.addActionListener(this);
        this.promptSourceWidget.setToolTipText("Enter a URL from which to retrieve the prompt contents.");
        this.imageLabel = new JLabel();
        this.imageLabel.setAlignmentX(0.0f);
        this.importButton = new JButton("Import");
        this.importButton.setToolTipText("Import media file to project resources folder");
        this.selectButton = new JButton("Select");
        this.selectButton.setToolTipText("Select media file from project resources folder");
        this.selPresenterButton = new JButton("Presenter...");
        this.selPresenterButton.setToolTipText("Select particular prompt presenter");
        this.altTextLabel = new JLabel("ALT-Text", 4);
        this.altTextWidget = new JTextField(10);
        this.altTextWidget.setToolTipText("The contents of this field will be shown in the tool tip window.");
        this.altTextWidgetEditorKitMenu = new EditorKitMenu((JTextComponent)this.altTextWidget, (EditActionsListener)this);
        this.annotationTemplateLabel = new JLabel("Annotation");
        this.togglePromptAsAnnotationTemplateAction = new TogglePromptAsAnnotationTemplateAction();
        this.togglePromptAsAnnotationTemplateAction.setListener(this);
        this.promptAsAnnotationTemplateWidget = new JCheckBox(this.togglePromptAsAnnotationTemplateAction);
        this.promptAsAnnotationTemplateWidget.setToolTipText("Enable if the prompt text can be used for annotation template.\nThe text is the same as the speaker should say.");
        this.localeSelector = new JLocaleSelector();
        this.localeSelector.setToolTipText("Select language of a text prompt.");
        this.mediaWidthWidget = new JTextField(4);
        this.mediaWidthWidget.setToolTipText("Enter a number > 0 to set the width of prompt display, or 0 to display the prompt in its original width or scaled to fit. This setting does not affect audio or text prompts.");
        this.mediaHeightWidget = new JTextField(4);
        this.mediaHeightWidget.setToolTipText("Enter a number > 0 to set the height of the prompt display, or 0 to display the prompt in its original width or scaled to fit. This setting does not affect audio or text prompts.");
        this.mediaVolumeWidget = new JSpinner(new SpinnerNumberModel(100, 0, 1000000, 1));
        this.mediaVolumeWidget.setToolTipText("Enter a value between 0 (silent) and 100 (full volume) for the output volume of the audio or video prompt. This setting does not affect image or text prompts.");
        this.autoPlayNonDefaultWidget = new JCheckBox("Autoplay not default");
        this.autoPlayNonDefaultWidget.addActionListener(this);
        this.autoPlayWidget = new JCheckBox("Autoplay");
        this.autoPlayWidget.setToolTipText("Check this box to start playing the prompt automatically as soon as it is displayed. This setting does not affect text or image prompts.");
        this.autoPlayWidget.setSelected(false);
        this.modalPlayWidget = new JCheckBox("Modal");
        this.modalPlayWidget.setToolTipText("Check this box to prevent the interruption of playback of the current prompt. This setting does not affect text or image prompts.");
        this.modalPlayWidget.setSelected(false);
        this.formattedCheckbox = new JCheckBox("Formatted");
        this.boldButton = new JToggleButton("<html><b>B</b></html>");
        this.italicButton = new JToggleButton("<html><i>I</i></html>");
        this.lineThroughButton = new JToggleButton("<html><strike>S</strike></html>");
        this.underlineButton = new JToggleButton("<html><u>U</u></html>");
        this.colorButton = new JButton("<html><b>Color</b></html>");
        this.defaultFontSizeCheckbox = new JCheckBox("default font size");
        int initialFntSize = 48;
        if (this.defaultPromptFont != null) {
            initialFntSize = this.defaultPromptFont.getSize();
        }
        this.relativeSizeSpinnerModel = new SpinnerNumberModel(initialFntSize, 1, 1000, 1);
        this.relativeSizeSpinner = new JSpinner(this.relativeSizeSpinnerModel);
        this.sizeUnit = new JComboBox<String>(new String[]{"%", "px"});
        this.defaultStyleButton = new JToggleButton("default style");
        this.promptTextWidget = new JEditorPane();
        this.plainTextDocument = this.promptTextWidget.getDocument();
        Font defFont = this.getFont();
        if (defFont != null) {
            FontMetrics defFm = this.getFontMetrics(defFont);
            int defLineHeight = defFm.getHeight();
            Insets ptIns = this.promptTextWidget.getMargin();
            Border ptB = this.promptTextWidget.getBorder();
            Insets bIns = ptB.getBorderInsets(this.promptTextWidget);
            int surrH = ptIns.bottom + ptIns.top;
            Dimension ptWSz = new Dimension(0, 3 * defLineHeight + surrH);
            this.promptTextWidget.setPreferredSize(ptWSz);
        }
        PromptDocEditorKit promptDocKit = new PromptDocEditorKit();
        this.promptTextWidget.setEditorKitForContentType("text/x-prompt", promptDocKit);
        for (Action a : promptDocKit.getActions()) {
            if (a instanceof StyledEditorKit.BoldAction) {
                this.boldButton.addActionListener(a);
                continue;
            }
            if (!(a instanceof StyledEditorKit.ItalicAction)) continue;
            this.italicButton.addActionListener(a);
        }
        this.lineThroughButton.addActionListener(new PromptDocEditorKit.StrikethroughAction());
        this.underlineButton.addActionListener(new PromptDocEditorKit.UnderlineAction());
        this.fontSizeAction = new PromptDocEditorKit.SetFontSizeAction();
        this.promptTextWidgetEditorKitMenu = new EditorKitMenu((JTextComponent)this.promptTextWidget, (EditActionsListener)this);
        this.promptTextWidget.addCaretListener(this);
        this.formattedCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean formatted = BaseMediaitemUI.this.formattedCheckbox.isSelected();
                if (formatted) {
                    String plainText = BaseMediaitemUI.this.promptTextWidget.getText();
                    BaseMediaitemUI.this.promptTextWidget.setContentType("text/x-prompt");
                    PromptStyleContext styleCtx = new PromptStyleContext(BaseMediaitemUI.this.defaultPromptFont);
                    ArrayList<P> ps = new ArrayList<P>();
                    P p = new P();
                    Text t = new Text();
                    t.setText(plainText);
                    p.getTexts().add(t);
                    ps.add(p);
                    try {
                        PromptStyledDocument doc = new PromptStyledDocument(styleCtx, ps);
                        BaseMediaitemUI.this.promptTextWidget.setDocument(doc);
                    }
                    catch (ParserException e1) {
                        e1.printStackTrace();
                    }
                    BaseMediaitemUI.this.mimeTypeWidget.setSelectedItem("text/x-prompt");
                } else {
                    String plainText = BaseMediaitemUI.this.promptTextWidget.getText();
                    BaseMediaitemUI.this.promptTextWidget.setContentType("text/plain");
                    BaseMediaitemUI.this.promptTextWidget.setDocument(BaseMediaitemUI.this.plainTextDocument);
                    BaseMediaitemUI.this.promptTextWidget.setText(plainText);
                    BaseMediaitemUI.this.mimeTypeWidget.setSelectedItem("text/plain");
                }
                BaseMediaitemUI.this.updateStyleActionStates();
            }
        });
        this.boldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BaseMediaitemUI.this.updateStyleActionStates();
                        }
                    });
                }
            }
        });
        this.italicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BaseMediaitemUI.this.updateStyleActionStates();
                        }
                    });
                }
            }
        });
        this.lineThroughButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    BaseMediaitemUI.this.underlineButton.setSelected(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BaseMediaitemUI.this.promptTextWidget.grabFocus();
                            BaseMediaitemUI.this.updateStyleActionStates();
                        }
                    });
                }
            }
        });
        this.underlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    BaseMediaitemUI.this.lineThroughButton.setSelected(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BaseMediaitemUI.this.promptTextWidget.grabFocus();
                            BaseMediaitemUI.this.updateStyleActionStates();
                        }
                    });
                }
            }
        });
        final BaseMediaitemUI parent = this;
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    Color c;
                    Color presetColor = DEFAULT_FOREGROUND_COLOR;
                    Document d = BaseMediaitemUI.this.promptTextWidget.getDocument();
                    if (d instanceof StyledDocument) {
                        StyledDocument sd = (StyledDocument)d;
                        int start = BaseMediaitemUI.this.promptTextWidget.getSelectionStart();
                        int end = BaseMediaitemUI.this.promptTextWidget.getSelectionEnd();
                        for (int pos = start; pos <= end; ++pos) {
                            Object fgColObj;
                            Element el = sd.getCharacterElement(pos);
                            AttributeSet elAs = el.getAttributes();
                            if (elAs == null || (fgColObj = elAs.getAttribute(StyleConstants.Foreground)) == null || !(fgColObj instanceof Color)) continue;
                            presetColor = (Color)fgColObj;
                            break;
                        }
                    }
                    if ((c = JColorChooser.showDialog(parent, "Text color", presetColor)) == null) {
                        return;
                    }
                    StyledEditorKit.ForegroundAction fgAction = new StyledEditorKit.ForegroundAction("color", c);
                    fgAction.actionPerformed(e);
                    BaseMediaitemUI.this.promptTextWidget.grabFocus();
                }
            }
        });
        this.defaultFontSizeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    BaseMediaitemUI.this.updateFontSize();
                    BaseMediaitemUI.this.updateStyleActionStates();
                    BaseMediaitemUI.this.promptTextWidget.grabFocus();
                }
            }
        });
        this.sizeUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    BaseMediaitemUI.this.updateFontSize();
                    BaseMediaitemUI.this.updateStyleActionStates();
                    BaseMediaitemUI.this.promptTextWidget.grabFocus();
                }
            }
        });
        this.relativeSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!BaseMediaitemUI.this.applyingStateChange) {
                    BaseMediaitemUI.this.updateFontSize();
                }
            }
        });
        this.defaultStyleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseMediaitemUI.this.defaultStyleButton.isSelected()) {
                    int start = BaseMediaitemUI.this.promptTextWidget.getSelectionStart();
                    int end = BaseMediaitemUI.this.promptTextWidget.getSelectionEnd();
                    Document d = BaseMediaitemUI.this.promptTextWidget.getDocument();
                    if (d instanceof StyledDocument) {
                        StyledDocument sd = (StyledDocument)d;
                        sd.setCharacterAttributes(start, end - start, new SimpleAttributeSet(), true);
                    }
                }
                BaseMediaitemUI.this.updateStyleActionStates();
            }
        });
    }

    private void updateFontSize() {
        int realSize;
        Document d = this.promptTextWidget.getDocument();
        Font.FontSize fs = null;
        if (this.defaultFontSizeCheckbox.isSelected()) {
            realSize = this.defaultPromptFont.getSize();
        } else {
            Integer sizeVal = (int)((Integer)this.relativeSizeSpinnerModel.getValue());
            BigDecimal sizeValBd = new BigDecimal(sizeVal);
            if (this.sizeUnit.getSelectedItem().equals("%")) {
                BigDecimal relSize = sizeValBd.divide(new BigDecimal(100));
                fs = new Font.FontSize(relSize, true);
                realSize = this.defaultPromptFont.getSize() * sizeVal / 100;
            } else {
                fs = new Font.FontSize(sizeValBd);
                realSize = sizeVal;
            }
        }
        PromptDocEditorKit.SetFontSizeActionEvent sfae = new PromptDocEditorKit.SetFontSizeActionEvent((Object)this.promptTextWidget, "set_font_size", fs, realSize);
        this.fontSizeAction.actionPerformed(sfae);
        this.promptTextWidget.grabFocus();
    }

    public void setSelectableMIMETypes(List<String> selectableMimeTypes) {
        String selItem = (String)this.mimeTypeWidget.getSelectedItem();
        this.mimeTypeWidget.removeAllItems();
        boolean selAvail = false;
        for (String selectabelMimeType : selectableMimeTypes) {
            this.mimeTypeWidget.addItem(selectabelMimeType);
            if (!selectabelMimeType.equals(selItem)) continue;
            selAvail = true;
        }
        if (selAvail) {
            this.mimeTypeWidget.setSelectedItem(selItem);
        }
    }

    public void setMediaitem(Mediaitem mi) {
        if (this.mediaitem != null) {
            this.mediaitem.removePropertyChangeListener((PropertyChangeListener)this);
            this._applyValues();
        }
        this.mimeTypePropEnabled = false;
        this.autoPlayEnabled = false;
        this.modalPropEnabled = false;
        this.volumePropEnabled = false;
        this.annotationTemplatePropEnabled = false;
        this.localePropEnabled = false;
        this.allMediaItemsOfTextType = false;
        this.allMediaItemsOfMediaType = false;
        this.mediaitem = mi;
        this.setEnabled(this.mediaitem != null);
        try {
            this.initializeWidgets(this.mediaitem);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (this.mediaitem != null) {
            this.mimeTypePropEnabled = true;
            this.autoPlayEnabled = true;
            this.modalPropEnabled = true;
            this.volumePropEnabled = true;
            this.annotationTemplatePropEnabled = true;
            this.localePropEnabled = true;
            this.mediaitem.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this._setDependencies();
    }

    protected void initializeWidgets(Mediaitem mediaitem) throws ParserException {
        this.promptTextWidget.getDocument().removeDocumentListener(this);
        if (this.plainTextDocument != null) {
            this.plainTextDocument.removeDocumentListener(this);
        }
        this.charsetWidget.removeActionListener(this);
        this.mimeTypeWidget.removeActionListener(this);
        if (mediaitem != null) {
            String mimetype = mediaitem.getNNMimetype();
            int availMimeSize = this.mimeTypeWidget.getItemCount();
            boolean avail = false;
            for (int i = 0; i < availMimeSize; ++i) {
                String availMime = this.mimeTypeWidget.getItemAt(i);
                if (!mimetype.equals(availMime)) continue;
                avail = true;
                break;
            }
            if (avail) {
                this.mimeTypeWidget.setSelectedItem(mimetype);
            } else {
                JOptionPane.showMessageDialog(this, "Promp presenter for MIME type " + mimetype + " not available!", "Missing prompt presenter error", 0);
            }
            StringSel selCs = this.selectableCharsets.get(this.selectableCharsets.indexOf(new StringSel(mediaitem.getCharSet())));
            this.charsetWidget.setSelectedItem(selCs);
            boolean annotationTemplate = mediaitem.getAnnotationTemplate();
            this.promptAsAnnotationTemplateWidget.setSelected(annotationTemplate);
            String langCode = mediaitem.getLanguageISO639code();
            String countrCode = mediaitem.getCountryISO3166code();
            Locale miLocale = null;
            if (langCode != null) {
                miLocale = countrCode == null ? new Locale(langCode) : new Locale(langCode, countrCode);
            }
            this.localeSelector.setSelectedLocale(miLocale);
            if (mediaitem.getSrc() != null) {
                this.external.setSelectedItem(LOCATION_EXTERNAL);
                this.promptSourceWidget.setText(mediaitem.getSrc().toString());
                this.imageLabel.setAlignmentX(0.0f);
            } else {
                this.external.setSelectedItem(LOCATION_INTERNAL);
                this.promptSourceWidget.setText("");
            }
            this.altTextWidget.setText(mediaitem.getAlt());
            this.mediaWidthWidget.setText(String.valueOf(mediaitem.getNNWidth()));
            this.mediaHeightWidget.setText(String.valueOf(mediaitem.getNNHeight()));
            Integer volume = mediaitem.getVolume();
            if (volume == null) {
                volume = 100;
            }
            this.mediaVolumeWidget.setValue(volume);
            Boolean autoPlay = mediaitem.getAutoplay();
            if (autoPlay != null) {
                this.autoPlayNonDefaultWidget.setSelected(true);
                this.autoPlayWidget.setSelected(autoPlay);
            } else {
                this.autoPlayNonDefaultWidget.setSelected(false);
                this.autoPlayWidget.setSelected(this.defaultPromptAutoPlay);
            }
            this.modalPlayWidget.setSelected(mediaitem.getNNModal());
            ArrayList<P> mediaItemParagraphs = new ArrayList<P>();
            List mediaItemBlocks = mediaitem.getBlocks();
            if (mediaItemBlocks != null && mediaItemBlocks.size() > 0) {
                for (Block bl : mediaItemBlocks) {
                    if (!(bl instanceof P)) continue;
                    mediaItemParagraphs.add((P)bl);
                }
                PromptStyleContext styleCtx = new PromptStyleContext(this.defaultPromptFont);
                PromptStyledDocument doc = new PromptStyledDocument(styleCtx, mediaItemParagraphs);
                this.promptTextWidget.setContentType("text/x-prompt");
                this.promptTextWidget.setDocument(doc);
                this.formattedCheckbox.setEnabled(true);
                this.formattedCheckbox.setSelected(true);
            } else {
                this.promptTextWidget.setContentType("text/plain");
                this.formattedCheckbox.setEnabled(true);
                this.formattedCheckbox.setSelected(false);
                this.promptTextWidget.setDocument(this.plainTextDocument);
                this.promptTextWidget.setText(mediaitem.getText());
            }
        } else {
            this.formattedCheckbox.setEnabled(false);
            this.formattedCheckbox.setSelected(false);
            this.promptTextWidget.setContentType("text/plain");
            this.promptTextWidget.setText("");
            this.promptSourceWidget.setText("");
        }
        this.promptSourceWidgetEditorKitMenu.discardAllEdits();
        this.altTextWidgetEditorKitMenu.discardAllEdits();
        this.promptTextWidgetEditorKitMenu.discardAllEdits();
        this.mimeTypeWidget.addActionListener(this);
        this.charsetWidget.addActionListener(this);
        this.promptTextWidget.getDocument().addDocumentListener(this);
    }

    protected void setDependencies() {
        this.adjusting = true;
        this._setDependencies();
        this.adjusting = false;
    }

    protected void _setDependencies() {
        boolean charSetSelEnabled;
        boolean enabled = this.isEnabled();
        boolean singleItemMode = this.mediaitem != null;
        boolean autoPlayNonDefault = this.autoPlayNonDefaultWidget.isSelected();
        if (!autoPlayNonDefault) {
            this.autoPlayWidget.setSelected(this.defaultPromptAutoPlay);
        }
        this.autoPlayWidget.setEnabled(enabled && this.autoPlayEnabled && autoPlayNonDefault);
        this.autoPlayNonDefaultWidget.setEnabled(enabled && this.autoPlayEnabled);
        this.mimeTypeLabel.setEnabled(enabled && this.mimeTypePropEnabled);
        this.mimeTypeWidget.setEnabled(enabled && this.mimeTypePropEnabled);
        boolean fileBasedProject = this.projectContext != null && "file".equalsIgnoreCase(this.projectContext.getProtocol());
        String mimeType = (String)this.mimeTypeWidget.getSelectedItem();
        if (mimeType == null) {
            mimeType = "text/plain";
        }
        String mimeMajorType = MIMETypes.getType(mimeType);
        boolean mediaType = MIMETypes.isMediaType(mimeType);
        this.external.setEnabled(enabled && this.mediaitem != null && !mediaType);
        this.srcTypeLabel.setEnabled(enabled && this.mediaitem != null && !mediaType);
        if (mediaType) {
            this.external.setSelectedItem(LOCATION_EXTERNAL);
            this.promptTextContentsPanel.setTitle("Prompt (description)");
        } else {
            this.promptTextContentsPanel.setTitle("Prompt");
        }
        boolean containsAudio = mediaType;
        this.mediaVolumeWidget.setEnabled(enabled && this.volumePropEnabled && containsAudio);
        this.volumeLabel.setEnabled(enabled && this.volumePropEnabled && containsAudio);
        boolean isExternal = this.external.getSelectedItem().equals(LOCATION_EXTERNAL);
        boolean isTextType = mimeMajorType.equalsIgnoreCase("text");
        boolean isXPromptFormatted = mimeType.equalsIgnoreCase("text/x-prompt");
        boolean bl = charSetSelEnabled = isTextType && isExternal;
        if (isTextType) {
            this.charsetWidget.removeActionListener(this);
            if (isExternal) {
                this.charsetWidget.setSelectedItem(this.externalCharset);
            } else {
                for (StringSel strSel : this.selectableCharsets) {
                    if (strSel.getString() != null) continue;
                    this.charsetWidget.setSelectedItem(strSel);
                }
                this.formattedCheckbox.setSelected(isXPromptFormatted);
            }
            this.charsetWidget.addActionListener(this);
        }
        this.charsetLabel.setEnabled(enabled && charSetSelEnabled);
        this.charsetWidget.setEnabled(enabled && charSetSelEnabled);
        this.sourceLabel.setEnabled(enabled && singleItemMode && isExternal);
        this.promptSourceWidget.setEnabled(enabled && singleItemMode && isExternal);
        boolean resourcesDirExists = this.resourcesDir != null && this.resourcesDir.exists();
        this.selectButton.setEnabled(enabled && resourcesDirExists && singleItemMode && isExternal);
        this.importButton.setVisible(fileBasedProject);
        this.importButton.setEnabled(enabled && singleItemMode && isExternal && fileBasedProject);
        this.altTextLabel.setEnabled(enabled && isExternal);
        this.altTextWidget.setEnabled(enabled && isExternal);
        this.modalPlayWidget.setEnabled(enabled && this.modalPropEnabled);
        boolean annotationTemplateUsable = isTextType;
        this.annotationTemplateLabel.setEnabled(enabled && (singleItemMode && annotationTemplateUsable || this.allMediaItemsOfTextType) && this.annotationTemplatePropEnabled);
        boolean enabledPromptAsAnnotationTemplateWidget = enabled && annotationTemplateUsable && this.annotationTemplatePropEnabled;
        this.togglePromptAsAnnotationTemplateAction.setEnabled(enabledPromptAsAnnotationTemplateWidget);
        if (!annotationTemplateUsable && this.promptAsAnnotationTemplateWidget.isSelected()) {
            this.promptAsAnnotationTemplateWidget.setSelected(false);
        }
        this.localeSelector.setEnabled(enabled && this.localePropEnabled);
        this.promptTextWidget.setEnabled(enabled && singleItemMode);
        this.promptTextContentsPanel.setEnabled(enabled && singleItemMode);
        this.updateStyleActionStates();
    }

    private void applyAutoPlay(Mediaitem mi) {
        if (this.autoPlayNonDefaultWidget.isSelected()) {
            mi.setAutoplay(Boolean.valueOf(this.autoPlayWidget.isSelected()));
        } else {
            mi.setAutoplay(null);
        }
    }

    private void applyVolume(Mediaitem mi) {
        Integer vol = (Integer)this.mediaVolumeWidget.getValue();
        if (vol == 100) {
            mi.setVolume(null);
        } else {
            mi.setVolume(vol);
        }
    }

    private void applyLocale(Mediaitem mi) {
        Locale miLocale = this.localeSelector.getSelectedLocale();
        if (miLocale == null) {
            mi.setLanguageISO639code(null);
            mi.setCountryISO3166code(null);
        } else {
            mi.setLanguageISO639code(miLocale.getLanguage());
            String miCountry = miLocale.getCountry();
            if (!"".equals(miCountry)) {
                mi.setCountryISO3166code(miCountry);
            } else {
                mi.setCountryISO3166code(null);
            }
        }
    }

    public boolean isPromptAsAnnotationTemplate() {
        return this.promptAsAnnotationTemplateWidget.isSelected();
    }

    protected void applyValues() {
        this._applyValues();
    }

    protected void _applyValues() {
        if (this.mediaitem != null) {
            this.mediaitem.removePropertyChangeListener((PropertyChangeListener)this);
            String altText = this.altTextWidget.getText();
            if (altText.equals("")) {
                this.mediaitem.setAlt(null);
            } else {
                this.mediaitem.setAlt(altText);
            }
            this.applyAutoPlay(this.mediaitem);
            this.mediaitem.setNNModal(this.modalPlayWidget.isSelected());
            this.applyVolume(this.mediaitem);
            this.mediaitem.setNNHeight(Integer.parseInt(this.mediaHeightWidget.getText()));
            this.mediaitem.setNNWidth(Integer.parseInt(this.mediaWidthWidget.getText()));
            this.mediaitem.setNNMimetype((String)this.mimeTypeWidget.getSelectedItem());
            StringSel selCharSet = (StringSel)this.charsetWidget.getSelectedItem();
            String selCharSetStr = selCharSet.getString();
            this.mediaitem.setCharSet(selCharSetStr);
            this.applyLocale(this.mediaitem);
            this.mediaitem.setAnnotationTemplate(this.promptAsAnnotationTemplateWidget.isSelected());
            if (this.external.getSelectedItem().equals(LOCATION_EXTERNAL)) {
                String promptSrcUrlStr = this.promptSourceWidget.getText();
                URI promptSrcUri = null;
                try {
                    promptSrcUri = new URI(promptSrcUrlStr);
                }
                catch (URISyntaxException e) {
                    try {
                        promptSrcUri = new URI(null, promptSrcUrlStr, null);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                this.mediaitem.setSrc(promptSrcUri);
            } else {
                this.mediaitem.setSrc(null);
            }
            Document d = this.promptTextWidget.getDocument();
            List mBlocks = this.mediaitem.getBlocks();
            if (this.formattedCheckbox.isSelected() && d instanceof PromptStyledDocument) {
                PromptStyledDocument psd = (PromptStyledDocument)d;
                List<P> pContent = psd.toPromptFormat();
                mBlocks.clear();
                for (P p : pContent) {
                    mBlocks.add(p);
                }
                this.mediaitem.setText(null);
            } else {
                mBlocks.clear();
                this.mediaitem.setText(this.promptTextWidget.getText());
            }
            this.mediaitem.removePropertyChangeListener((PropertyChangeListener)this);
        } else if (this.mediaitems != null) {
            for (Mediaitem mi : this.mediaitems) {
                if (this.autoPlayEnabled) {
                    this.applyAutoPlay(mi);
                }
                if (this.modalPropEnabled) {
                    mi.setNNModal(this.modalPlayWidget.isSelected());
                }
                if (this.volumePropEnabled) {
                    this.applyVolume(mi);
                }
                if (this.annotationTemplatePropEnabled) {
                    mi.setAnnotationTemplate(this.promptAsAnnotationTemplateWidget.isSelected());
                }
                if (!this.localePropEnabled) continue;
                this.applyLocale(mi);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.adjusting) {
            return;
        }
        Object src = e.getSource();
        if (src == this.mimeTypeWidget) {
            this.setDependencies();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, e.getID(), "mime_type_changed"));
            }
        } else if (src == this.promptAsAnnotationTemplateWidget) {
            this.setDependencies();
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(e);
            }
        } else if (src == this.autoPlayNonDefaultWidget) {
            this.setDependencies();
        } else if (src == this.charsetWidget) {
            this.externalCharset = (StringSel)this.charsetWidget.getSelectedItem();
            this.setDependencies();
        } else if (src == this.external) {
            this.setDependencies();
        } else if (src == this.selectButton) {
            RestrictDirectoryFileSystemView rfsv = new RestrictDirectoryFileSystemView(new File[]{this.resourcesDir});
            JFileChooser chooser = new JFileChooser((FileSystemView)rfsv);
            chooser.setDialogTitle("Select prompt media file");
            chooser.setFileSelectionMode(0);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File selFile = chooser.getSelectedFile();
                URI selFileUri = selFile.toURI();
                String pathStr = selFileUri.toString();
                try {
                    URI relURI = this.projectContext.toURI().relativize(selFileUri);
                    pathStr = relURI.toString();
                }
                catch (IllegalArgumentException | URISyntaxException relURI) {
                    // empty catch block
                }
                this.promptSourceWidget.setText(pathStr);
            }
        } else if (src == this.importButton) {
            JFileChooser chooser;
            block43: {
                chooser = new JFileChooser();
                chooser.setDialogTitle("Import prompt media file");
                chooser.setApproveButtonText("Import");
                chooser.setApproveButtonToolTipText("Copies file into the project workspace");
                chooser.setFileSelectionMode(0);
                try {
                    URL currentSrcUrl = new URL(this.promptSourceWidget.getText());
                    if (currentSrcUrl == null || !"file".equalsIgnoreCase(currentSrcUrl.getProtocol())) break block43;
                    File preselectedFile = null;
                    try {
                        URI preselectedURI = currentSrcUrl.toURI();
                        String preselectedFilePath = preselectedURI.getPath();
                        if (preselectedFilePath != null) {
                            preselectedFile = new File(preselectedFilePath);
                        }
                    }
                    catch (URISyntaxException preselectedURI) {
                        // empty catch block
                    }
                    if (preselectedFile != null && preselectedFile.exists()) {
                        chooser.setSelectedFile(preselectedFile);
                    }
                }
                catch (MalformedURLException currentSrcUrl) {
                    // empty catch block
                }
            }
            if (chooser.getSelectedFile() == null) {
                chooser.setCurrentDirectory(this.lastImportDir);
            }
            File resProjFile = null;
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File selFile = chooser.getSelectedFile();
                if (selFile != null) {
                    this.lastImportDir = selFile.getParentFile();
                }
                String relProjPath = JOptionPane.showInputDialog(this, "Please input relative path to store the resource", "resources/" + this.mimeTypeWidget.getSelectedItem().toString());
                String relprojResFilePath = relProjPath + "/" + selFile.getName();
                try {
                    URL projResUrl = URLContext.getContextURL((URL)this.projectContext, (String)relprojResFilePath);
                    URI projResUri = projResUrl.toURI();
                    String projResFilePath = projResUri.getPath();
                    resProjFile = new File(projResFilePath);
                    if (resProjFile.exists()) {
                        if (selFile.equals(resProjFile)) {
                            int selectSameFile = JOptionPane.showConfirmDialog(this, resProjFile + " is same file.\nDo you want to select this file?");
                            if (selectSameFile != 0) {
                                return;
                            }
                        } else {
                            Object[] options = new Object[]{"Select resource", "Overwrite", "Cancel"};
                            int selOpt = JOptionPane.showOptionDialog(this, resProjFile.getName() + " already exists in resource folder.\nPlease select action:", "Resource message", -1, 2, null, options, options[0]);
                            if (selOpt == -1) {
                                return;
                            }
                            if (selOpt != 0) {
                                if (selOpt == 1) {
                                    StreamCopy.copy((File)selFile, (File)resProjFile, (boolean)true);
                                } else if (selOpt == 2) {
                                    return;
                                }
                            }
                        }
                    } else {
                        StreamCopy.copy((File)selFile, (File)resProjFile, (boolean)true);
                    }
                    this.promptSourceWidget.setText(relprojResFilePath);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not convert to valid URL:\n" + e1.getMessage(), "Malformed URL error", 0);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    if (resProjFile != null) {
                        resProjFile.delete();
                    }
                    JOptionPane.showMessageDialog(this, "Input/Output error:\n" + e2.getMessage(), "I/O error", 0);
                }
                catch (URISyntaxException e3) {
                    e3.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not convert to valid URI:\n" + e3.getMessage(), "URI syntax error", 0);
                }
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setDependencies();
    }

    public URL getProjectContext() {
        return this.projectContext;
    }

    public void _setProjectContext(URL projectContext) {
        this.projectContext = projectContext;
        try {
            this.projectDir = Utils.fileFromDecodedURL((URL)projectContext);
            this.resourcesDir = new File(this.projectDir, RESOURCE_PATH);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setProjectContext(URL projectContext) {
        this._setProjectContext(projectContext);
        this.setDependencies();
    }

    public void providesEditActions(Object src, EditActions editActions) {
        if (this.editActionsListener != null) {
            this.editActionsListener.providesEditActions(src, editActions);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (!(src instanceof Recording) && src instanceof Mediaitem && "text".equals(propertyName)) {
            this.promptTextWidget.getDocument().removeDocumentListener(this);
            this.promptTextWidget.setText((String)evt.getNewValue());
            this.promptTextWidget.getDocument().addDocumentListener(this);
        }
    }

    public void setDefaultPromptFont(Font defaultPromptFont) {
        this.defaultPromptFont = defaultPromptFont;
    }

    public boolean isDefaultPromptAutoPlay() {
        return this.defaultPromptAutoPlay;
    }

    public void setDefaultPromptAutoPlay(boolean defaultPromptAutoPlay) {
        this.defaultPromptAutoPlay = defaultPromptAutoPlay;
    }

    private String[] getSelectableMIMETypeCombinationsDisplayList(List<PromptPresenterServiceDescriptor> availablePromptPresenters2) {
        String[] singleMIMETypeCombinations;
        HashSet<List<String>> availMimes = new HashSet<List<String>>();
        for (PromptPresenterServiceDescriptor ppsd : availablePromptPresenters2) {
            String[][] ppMimesArrs = ppsd.getSupportedMIMETypes();
            for (String[] ppMimesArr : ppMimesArrs) {
                List<String> ppMimesL = Arrays.asList(ppMimesArr);
                availMimes.add(ppMimesL);
            }
        }
        if (availMimes.size() > 0) {
            ArrayList selectableMIMETypeCombinationssorted = new ArrayList(availMimes);
            Collections.sort(selectableMIMETypeCombinationssorted, new MIMETypeCombinationsSorter());
            ArrayList<String> singleMIMETypeCombinationList = new ArrayList<String>();
            for (List mimeTypeCombi : selectableMIMETypeCombinationssorted) {
                if (mimeTypeCombi.size() != 1) continue;
                singleMIMETypeCombinationList.add((String)mimeTypeCombi.get(0));
            }
            singleMIMETypeCombinations = singleMIMETypeCombinationList.toArray(new String[0]);
        } else {
            singleMIMETypeCombinations = MIMETypes.getAllMimeTypes();
        }
        return singleMIMETypeCombinations;
    }

    protected void printDoc(Document d) {
        if (d instanceof PromptStyledDocument) {
            PromptStyledDocument pd = (PromptStyledDocument)d;
            List<P> pList = pd.toPromptFormat();
            for (P p : pList) {
                System.out.println(p);
            }
            System.out.println();
        }
    }

    protected void documentUpdate(DocumentEvent e) {
        Document d = e.getDocument();
        if (d.equals(this.promptTextWidget.getDocument())) {
            String text = this.promptTextWidget.getText();
            this.promptFontManager.applyFontCanDisplay((JTextComponent)this.promptTextWidget);
            if (this.mediaitem != null) {
                this.mediaitem.removePropertyChangeListener((PropertyChangeListener)this);
                this.mediaitem.setText(text);
                this.mediaitem.getBlocks().clear();
                this.mediaitem.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentUpdate(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentUpdate(e);
    }

    public void setMediaitems(List<Mediaitem> mis) {
        this.setMediaitem(null);
        this.mediaitems = mis;
        this.setEnabled(this.mediaitems != null && this.mediaitems.size() > 0);
        MultiSelectPropertyState mimeTypePropState = new MultiSelectPropertyState();
        MultiSelectPropertyState autoPlayPropState = new MultiSelectPropertyState();
        MultiSelectPropertyState volumePropState = new MultiSelectPropertyState();
        MultiSelectPropertyState modalPropState = new MultiSelectPropertyState();
        MultiSelectPropertyState annotationTemplPropStare = new MultiSelectPropertyState();
        MultiSelectPropertyState langCodePropState = new MultiSelectPropertyState();
        MultiSelectPropertyState countryCodePropState = new MultiSelectPropertyState();
        this.allMediaItemsOfTextType = true;
        this.allMediaItemsOfMediaType = true;
        for (Mediaitem mi : mis) {
            String mimeType = mi.getNNMimetype();
            mimeTypePropState.next((Object)mimeType);
            boolean isTextType = MIMETypes.isTextType(mimeType);
            this.allMediaItemsOfTextType = this.allMediaItemsOfTextType && isTextType;
            boolean isMediaType = MIMETypes.isMediaType(mimeType);
            this.allMediaItemsOfMediaType = this.allMediaItemsOfMediaType && isMediaType;
            Integer miVolume = mi.getVolume();
            volumePropState.next((Object)miVolume);
            Boolean miAutoPlay = mi.getAutoplay();
            autoPlayPropState.next((Object)miAutoPlay);
            Boolean miModal = mi.getModal();
            modalPropState.next((Object)miModal);
            annotationTemplPropStare.next((Object)mi.getAnnotationTemplate());
            langCodePropState.next((Object)mi.getLanguageISO639code());
            countryCodePropState.next((Object)mi.getCountryISO3166code());
        }
        boolean mimeTypesAllEqual = mimeTypePropState.allEqual();
        if (mimeTypesAllEqual) {
            this.mimeTypeWidget.setSelectedItem(mimeTypePropState.getObjectSet());
        } else {
            this.mimeTypeWidget.setSelectedIndex(0);
        }
        this.mimeTypePropEnabled = false;
        boolean bl = this.volumePropEnabled = volumePropState.allEqual() && this.allMediaItemsOfMediaType;
        if (this.volumePropEnabled) {
            Integer v = (Integer)volumePropState.getObjectSet();
            if (v != null) {
                this.mediaVolumeWidget.setValue(v);
            }
        } else {
            this.mediaVolumeWidget.setValue(100);
        }
        this.autoPlayEnabled = autoPlayPropState.allEqual();
        Boolean ap = (Boolean)autoPlayPropState.getObjectSet();
        if (this.autoPlayEnabled) {
            if (ap == null) {
                this.autoPlayNonDefaultWidget.setSelected(false);
                this.autoPlayWidget.setSelected(this.defaultPromptAutoPlay);
            } else {
                this.autoPlayNonDefaultWidget.setSelected(true);
                this.autoPlayWidget.setSelected(ap);
            }
        }
        this.modalPropEnabled = modalPropState.allEqual();
        Boolean modal = (Boolean)modalPropState.getObjectSet();
        boolean modalEff = false;
        if (modal != null) {
            modalEff = modal;
        }
        this.modalPlayWidget.setSelected(modalEff);
        this.annotationTemplatePropEnabled = annotationTemplPropStare.allEqual() && this.allMediaItemsOfTextType;
        this.localePropEnabled = langCodePropState.allEqual() && countryCodePropState.allEqual();
    }

    public String selectedMimeType() {
        return (String)this.mimeTypeWidget.getSelectedItem();
    }

    protected void updateStyleActionStates() {
        this.applyingStateChange = true;
        boolean formatted = this.formattedCheckbox.isSelected();
        this.boldButton.setEnabled(formatted);
        this.italicButton.setEnabled(formatted);
        this.lineThroughButton.setEnabled(formatted);
        this.underlineButton.setEnabled(formatted);
        this.colorButton.setEnabled(formatted);
        this.defaultStyleButton.setEnabled(formatted);
        this.defaultFontSizeCheckbox.setEnabled(formatted);
        this.relativeSizeSpinner.setEnabled(formatted);
        this.sizeUnit.setEnabled(formatted);
        if (formatted) {
            int start = this.promptTextWidget.getSelectionStart();
            int end = this.promptTextWidget.getSelectionEnd();
            Document d = this.promptTextWidget.getDocument();
            if (d instanceof StyledDocument) {
                int spinnerVal;
                StyledDocument sd = (StyledDocument)d;
                boolean firstBold = false;
                boolean firstItalic = false;
                boolean firstLinethrough = false;
                boolean firstUnderline = false;
                int firstSize = 48;
                Font.FontSize firstFontSize = null;
                boolean allBold = false;
                boolean allItalic = false;
                boolean allLinethrough = false;
                boolean allUnderline = false;
                boolean allDefault = true;
                Integer allSize = null;
                Font.FontSize allFontSize = null;
                if (end > start) {
                    Element firstEl = sd.getCharacterElement(start);
                    AttributeSet firstElAs = firstEl.getAttributes();
                    firstBold = StyleConstants.isBold(firstElAs);
                    firstItalic = StyleConstants.isItalic(firstElAs);
                    firstUnderline = StyleConstants.isUnderline(firstElAs);
                    firstLinethrough = StyleConstants.isStrikeThrough(firstElAs);
                    firstSize = StyleConstants.getFontSize(firstElAs);
                    firstFontSize = (Font.FontSize)firstElAs.getAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
                    allBold = firstBold;
                    allItalic = firstItalic;
                    allLinethrough = firstLinethrough;
                    allUnderline = firstUnderline;
                    allSize = firstSize;
                    allFontSize = firstFontSize;
                    for (int pos = start; pos < end; ++pos) {
                        Font.FontSize chFontSize;
                        Element el = sd.getCharacterElement(pos);
                        AttributeSet as = el.getAttributes();
                        allBold = allBold && StyleConstants.isBold(as);
                        allItalic = allItalic && StyleConstants.isItalic(as);
                        allUnderline = allUnderline && StyleConstants.isUnderline(as);
                        allLinethrough = allLinethrough && StyleConstants.isStrikeThrough(as);
                        int chSize = StyleConstants.getFontSize(as);
                        if (allSize != null && chSize != allSize) {
                            allSize = null;
                        }
                        if ((chFontSize = (Font.FontSize)as.getAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE)) != null) {
                            if (!chFontSize.equals(allFontSize)) {
                                allFontSize = null;
                            }
                        } else {
                            allFontSize = null;
                        }
                        allDefault = allDefault && allFontSize == null && !as.isDefined(StyleConstants.FontSize) && !as.isDefined(StyleConstants.Bold) && !as.isDefined(StyleConstants.Italic) && !as.isDefined(StyleConstants.StrikeThrough) && !as.isDefined(StyleConstants.Underline);
                    }
                } else {
                    EditorKit ek = this.promptTextWidget.getEditorKit();
                    if (ek instanceof StyledEditorKit) {
                        StyledEditorKit sek = (StyledEditorKit)ek;
                        MutableAttributeSet logStyle = sek.getInputAttributes();
                        firstBold = StyleConstants.isBold(logStyle);
                        firstItalic = StyleConstants.isItalic(logStyle);
                        firstLinethrough = StyleConstants.isStrikeThrough(logStyle);
                        firstUnderline = StyleConstants.isUnderline(logStyle);
                        firstSize = StyleConstants.getFontSize(logStyle);
                        firstFontSize = (Font.FontSize)logStyle.getAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
                        allDefault = allDefault && firstFontSize == null && !logStyle.isDefined(StyleConstants.FontSize) && !logStyle.isDefined(StyleConstants.Bold) && !logStyle.isDefined(StyleConstants.Italic) && !logStyle.isDefined(StyleConstants.StrikeThrough) && !logStyle.isDefined(StyleConstants.Underline);
                    }
                }
                this.boldButton.setSelected(firstBold || allBold);
                this.italicButton.setSelected(firstItalic || allItalic);
                this.lineThroughButton.setSelected(firstLinethrough || allLinethrough);
                this.underlineButton.setSelected(firstUnderline || allUnderline);
                this.defaultStyleButton.setSelected(allDefault);
                Font.FontSize selFontSize = firstFontSize;
                if (allFontSize != null) {
                    selFontSize = allFontSize;
                }
                boolean defFontSize = selFontSize == null;
                this.defaultFontSizeCheckbox.setSelected(defFontSize);
                this.relativeSizeSpinner.setEnabled(!defFontSize);
                this.sizeUnit.setEnabled(!defFontSize);
                if (!defFontSize) {
                    if (selFontSize.isRelative()) {
                        this.sizeUnit.setSelectedItem("%");
                        spinnerVal = selFontSize.getValue().multiply(new BigDecimal(100)).intValue();
                    } else {
                        this.sizeUnit.setSelectedItem("px");
                        spinnerVal = selFontSize.getValue().intValue();
                    }
                } else {
                    this.sizeUnit.setSelectedItem("%");
                    spinnerVal = 100;
                }
                this.relativeSizeSpinner.setValue(spinnerVal);
            }
        }
        this.applyingStateChange = false;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (!this.applyingStateChange) {
            this.updateStyleActionStates();
        }
    }

    protected void releaseListeners() {
        if (this.mediaitem != null) {
            this.mediaitem.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public static class MIMETypeCombinationsSorter
    implements Comparator<List<String>> {
        public static String[] majorMIMETypeOrder = new String[]{"text/plain", "text/", "image/", "audio/"};

        private static int getMajorIndex(List<String> mimeCombination) {
            String firstMimeType;
            int majorIndex = majorMIMETypeOrder.length;
            if (mimeCombination.size() > 0 && (firstMimeType = mimeCombination.get(0)) != null) {
                for (int i = 0; i < majorMIMETypeOrder.length; ++i) {
                    if (!firstMimeType.startsWith(majorMIMETypeOrder[i])) continue;
                    majorIndex = i;
                    break;
                }
            }
            return majorIndex;
        }

        @Override
        public int compare(List<String> arg0, List<String> arg1) {
            int majorIndex0 = MIMETypeCombinationsSorter.getMajorIndex(arg0);
            int majorIndex1 = MIMETypeCombinationsSorter.getMajorIndex(arg1);
            return majorIndex0 - majorIndex1;
        }
    }

    public static class MIMETypeSorter
    implements Comparator<String> {
        public static String[] majorMIMETypeOrder = new String[]{"text/plain", "text/", "image/", "audio/"};

        private static int getMajorIndex(String mimeType) {
            int majorIndex = majorMIMETypeOrder.length;
            if (mimeType != null) {
                for (int i = 0; i < majorMIMETypeOrder.length; ++i) {
                    if (!mimeType.startsWith(majorMIMETypeOrder[i])) continue;
                    majorIndex = i;
                    break;
                }
            }
            return majorIndex;
        }

        @Override
        public int compare(String arg0, String arg1) {
            int majorIndex0 = MIMETypeSorter.getMajorIndex(arg0);
            int majorIndex1 = MIMETypeSorter.getMajorIndex(arg1);
            return majorIndex0 - majorIndex1;
        }
    }
}

