/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.ui.GroupItemsAction;
import ipsk.apps.speechrecorder.script.ui.PromptItemUI;
import ipsk.apps.speechrecorder.script.ui.ScriptUI;
import ipsk.apps.speechrecorder.script.ui.SectionUI;
import ipsk.apps.speechrecorder.script.ui.UngroupItemsAction;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Script;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.swing.CopyAction;
import ipsk.swing.CutAction;
import ipsk.swing.JDialogPanel;
import ipsk.swing.PasteAction;
import ipsk.swing.RedoAction;
import ipsk.swing.UndoAction;
import ipsk.swing.action.EditActions;
import ipsk.swing.action.EditActionsListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.security.AllPermission;
import java.util.List;
import java.util.Set;
import javax.help.HelpBroker;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class ScriptUIDialog
extends JDialogPanel
implements ActionListener,
PropertyChangeListener,
ClipboardOwner,
FlavorListener,
EditActionsListener {
    private static final long serialVersionUID = -7053838453598657369L;
    private Script script;
    private JMenu scriptMenu;
    private JMenu sectionMenu;
    private JMenu groupMenu;
    private JMenu itemMenu;
    private JMenu editMenu;
    private CutAction dummyCutAction;
    private CopyAction dummyCopyAction;
    private PasteAction dummyPasteAction;
    private UndoAction dummyUndoAction;
    private RedoAction dummyRedoAction;
    private Clipboard clipboard = null;
    private ScriptUI scriptUI;
    private URL projectContext = null;
    private JMenuItem cutMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;

    public Set<String> getItemCodesInUse() {
        return this.scriptUI.getItemCodesInUse();
    }

    public void setItemCodesInUse(Set<String> itemCodesInUse) {
        this.scriptUI.setItemCodesInUse(itemCodesInUse);
    }

    public ScriptUIDialog(URL projectContext, List<PromptPresenterServiceDescriptor> availPromptPresenters) {
        this(projectContext, null, new ItemcodeGenerator(), null, null);
    }

    public ScriptUIDialog(URL projectContext, IntegerSequenceGenerator sequenceGenerator, ItemcodeGenerator itemcodeGenerator, List<PromptPresenterServiceDescriptor> promptPresentersClassList, HelpBroker helpBroker) {
        super(JDialogPanel.Options.OK_CANCEL);
        this.projectContext = projectContext;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkPermission(new AllPermission());
            }
            catch (SecurityException se) {
                System.err.println("WARNING: System clipboard not accessible.");
                this.clipboard = new Clipboard("Script Clipboard");
            }
        }
        if (this.clipboard == null) {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        this.clipboard.addFlavorListener(this);
        this.scriptUI = new ScriptUI(projectContext, sequenceGenerator, itemcodeGenerator, promptPresentersClassList);
        this.menuBar = new JMenuBar();
        this.scriptMenu = new JMenu("Script");
        this.scriptMenu.setMnemonic(83);
        List<Action> newactionsList = this.scriptUI.getNewActionsList();
        for (Action action : newactionsList) {
            JMenuItem nami = new JMenuItem(action);
            this.scriptMenu.add(nami);
        }
        SectionUI sectionUI = this.scriptUI.getSectionUI();
        this.sectionMenu = new JMenu("Section");
        this.sectionMenu.setMnemonic(68);
        newactionsList = sectionUI.getNewActionsList();
        for (Action na : newactionsList) {
            JMenuItem nami = new JMenuItem(na);
            this.sectionMenu.add(nami);
        }
        this.groupMenu = new JMenu("Group");
        GroupItemsAction groupItemsAction = sectionUI.getGroupItemsAction();
        JMenuItem grItsMi = new JMenuItem(groupItemsAction);
        this.groupMenu.add(grItsMi);
        UngroupItemsAction ungrItsAction = sectionUI.getUngroupItemsAction();
        JMenuItem ungrItsMi = new JMenuItem(ungrItsAction);
        this.groupMenu.add(ungrItsMi);
        JCheckBoxMenuItem randomGroupChkBox = new JCheckBoxMenuItem(sectionUI.getToggleGroupRandomAction());
        this.groupMenu.add(randomGroupChkBox);
        PromptItemUI piUI = sectionUI.getPromptItemEditor();
        this.itemMenu = new JMenu("Item");
        List<Action> actionsList = piUI.getActions();
        for (Action a : actionsList) {
            JMenuItem nami = new JMenuItem(a);
            this.itemMenu.add(nami);
        }
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        this.dummyCutAction = new CutAction(){
            private static final long serialVersionUID = 8989347922466623849L;

            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.dummyCutAction.setEnabled(false);
        this.cutMenuItem = new JMenuItem((Action)this.dummyCutAction);
        this.editMenu.add(this.cutMenuItem);
        this.dummyCopyAction = new CopyAction(){
            private static final long serialVersionUID = -1411818294539107013L;

            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.dummyCopyAction.setEnabled(false);
        this.copyMenuItem = new JMenuItem((Action)this.dummyCopyAction);
        this.editMenu.add(this.copyMenuItem);
        this.dummyPasteAction = new PasteAction(){
            private static final long serialVersionUID = -5920846157836143799L;

            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.dummyPasteAction.setEnabled(false);
        this.pasteMenuItem = new JMenuItem((Action)this.dummyPasteAction);
        this.editMenu.add(this.pasteMenuItem);
        this.dummyUndoAction = new UndoAction(){

            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.dummyUndoAction.setEnabled(false);
        this.undoMenuItem = new JMenuItem((Action)this.dummyUndoAction);
        this.editMenu.add(this.undoMenuItem);
        this.dummyRedoAction = new RedoAction(){

            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.dummyRedoAction.setEnabled(false);
        this.redoMenuItem = new JMenuItem((Action)this.dummyRedoAction);
        this.editMenu.add(this.redoMenuItem);
        this.menuBar.add(this.scriptMenu);
        this.menuBar.add(this.sectionMenu);
        this.menuBar.add(this.groupMenu);
        this.menuBar.add(this.itemMenu);
        this.menuBar.add(this.editMenu);
        if (helpBroker != null) {
            JMenu helpMenu = new JMenu("Help");
            JMenuItem helpMi = new JMenuItem("Help");
            helpMenu.add(helpMi);
            helpBroker.enableHelpOnButton((Component)helpMi, "section-7", null);
            this.menuBar.add(helpMenu);
        }
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.scriptUI, "Center");
        this.scriptUI.setEditActionListener(this);
        this.updateEditActions();
    }

    public ScriptUIDialog() {
        this(null, null);
    }

    public void setScript(Script script) {
        if (this.script != null) {
            this.script.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.script = script;
        this.setTitle();
        this.scriptUI.setScript(this.script);
        if (this.script != null) {
            this.script.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void setTitle() {
        if (this.script != null) {
            this.setFrameTitle("Script \"" + this.script.getName() + "\"");
        }
    }

    protected void applyValues() {
        this.scriptUI.applyValues();
    }

    public void disposeDialog() {
        this.releaseListeners();
        super.disposeDialog();
    }

    protected void releaseListeners() {
        this.scriptUI.releaseListeners();
        if (this.script != null) {
            this.script.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("name")) {
            this.setTitle();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void updateEditActions() {
        boolean editorEnabled = super.isEnabled();
        this.editMenu.setEnabled(editorEnabled);
        this.okButton.setEnabled(editorEnabled);
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateEditActions();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEditActions();
        if (this.scriptUI != null) {
            this.scriptUI.setEnabled(enabled);
        }
    }

    public void providesEditActions(Object src, EditActions editActions) {
        Object cut = this.dummyCutAction;
        Object copy = this.dummyCopyAction;
        Object paste = this.dummyPasteAction;
        Object undo = this.dummyUndoAction;
        Object redo = this.dummyRedoAction;
        if (editActions != null) {
            Action eCut = editActions.getCutAction();
            Action eCopy = editActions.getCopyAction();
            Action ePaste = editActions.getPasteAction();
            Action eUndo = editActions.getUndoAction();
            Action eRedo = editActions.getRedoAction();
            if (eCut != null) {
                cut = eCut;
            }
            if (eCopy != null) {
                copy = eCopy;
            }
            if (ePaste != null) {
                paste = ePaste;
            }
            if (eUndo != null) {
                undo = eUndo;
            }
            if (eRedo != null) {
                redo = eRedo;
            }
        }
        this.cutMenuItem.setAction((Action)cut);
        this.copyMenuItem.setAction((Action)copy);
        this.pasteMenuItem.setAction((Action)paste);
        this.undoMenuItem.setAction((Action)undo);
        this.redoMenuItem.setAction((Action)redo);
    }

    public void setSelectedPromptItem(PromptItem pi) {
        this.scriptUI.setSelectedPromptItem(pi);
    }

    public ScriptUI getScriptUI() {
        return this.scriptUI;
    }

    public URL getProjectContext() {
        return this.projectContext;
    }

    public void setProjectContext(URL projectContext) {
        this.projectContext = projectContext;
        this.scriptUI.setProjectContext(projectContext);
    }

    public void setInstructionsFontFamilies(String[] instructionsFontFamilies) {
        this.scriptUI.setInstructionsFontFamilies(instructionsFontFamilies);
    }

    public void setDescriptionFontFamilies(String[] descriptionFontFamilies) {
        this.scriptUI.setDescriptionFontFamilies(descriptionFontFamilies);
    }

    public void setPromptFontFamilies(String[] promptFontFamilies) {
        this.scriptUI.setPromptFontFamilies(promptFontFamilies);
    }
}

