/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import ipsk.awt.ColorUtils;
import ipsk.db.speech.Font;
import ipsk.db.speech.P;
import ipsk.db.speech.Text;
import ipsk.db.speech.TextFormatElement;
import ipsk.text.ParserException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class PromptStyledDocument
extends DefaultStyledDocument {
    public static String STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE = "fontSizeRelativeOrAbsolute";
    private Element section;

    public PromptStyledDocument() {
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        super.setCharacterAttributes(offset, length, s, replace);
    }

    @Override
    public Element getCharacterElement(int pos) {
        Element e = super.getCharacterElement(pos);
        return e;
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        String s = super.getText(offset, length);
        return s;
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        super.getText(offset, length, txt);
    }

    private boolean toContentElems(Element parent, List<TextFormatElement> ftc, MutableAttributeSet as, PositionImpl pos, boolean endsWithBlank) throws ParserException {
        int chSz = ftc.size();
        for (int i = 0; i < chSz; ++i) {
            Color c;
            TextFormatElement ft = ftc.get(i);
            SimpleAttributeSet saSet = new SimpleAttributeSet();
            Text text = null;
            Font f = null;
            if (ft instanceof Font) {
                f = (Font)ft;
                text = f.getText();
            } else if (ft instanceof Text) {
                text = (Text)ft;
            }
            String t = text.getText();
            String de = text.getDecoration();
            if (Text.UNDERLINE.equals(de)) {
                StyleConstants.setUnderline(saSet, true);
            } else if (Text.LINE_THROUGH.equals(de)) {
                StyleConstants.setStrikeThrough(saSet, true);
            } else if (Text.NONE.equals(de)) {
                StyleConstants.setUnderline(saSet, false);
            }
            String co = text.getColor();
            if (co != null && (c = ColorUtils.stringToColor((String)co)) != null) {
                StyleConstants.setForeground(saSet, c);
            }
            if (f != null) {
                String st;
                Style defStyle;
                Object defFontSize;
                String si = f.getSize();
                if (si != null && (defFontSize = (defStyle = this.getStyle("default")).getAttribute(StyleConstants.FontSize)) instanceof Number) {
                    Number defFontSizeNumber = (Number)defFontSize;
                    Font.FontSize fs = f.fontSize();
                    if (fs != null) {
                        saSet.addAttribute(STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE, fs);
                    }
                    double absSize = f.toRealFontSize(defFontSizeNumber.doubleValue());
                    StyleConstants.setFontSize(saSet, (int)absSize);
                }
                if (Font.ITALIC.equals(st = f.getStyle())) {
                    StyleConstants.setItalic(saSet, true);
                } else if (Font.NORMAL.equals(st)) {
                    StyleConstants.setBold(saSet, false);
                }
                String we = f.getWeight();
                if (Font.BOLD.equals(we)) {
                    StyleConstants.setBold(saSet, true);
                } else if (Font.NORMAL.equals(we)) {
                    StyleConstants.setBold(saSet, false);
                }
            }
            int offset = pos.getOffset();
            if (t == null) continue;
            try {
                this.insertString(offset, t, saSet);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            int tlen = t.length();
            pos.setOffset(offset += tlen);
        }
        return endsWithBlank;
    }

    public PromptStyledDocument(StyleContext styleCtx, List<P> mediaItemParagraphs) throws ParserException {
        super(styleCtx);
        this.writeLock();
        int pCnt = mediaItemParagraphs.size();
        this.section = this.getDefaultRootElement();
        PositionImpl pos = new PositionImpl();
        pos.setOffset(0);
        for (int pi = 0; pi < pCnt; ++pi) {
            P p = mediaItemParagraphs.get(pi);
            Element pe = this.createBranchElement(this.section, this.getStyle("default"));
            this.toContentElems(pe, p.getTexts(), this.getStyle("default"), pos, false);
            if (pi >= pCnt - 1) continue;
            int offset = pos.getOffset();
            String newLineT = "\n";
            try {
                this.insertString(offset, newLineT, new SimpleAttributeSet());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            int tlen = newLineT.length();
            pos.setOffset(offset += tlen);
        }
        this.writeUnlock();
    }

    public List<P> toPromptFormat() {
        this.readLock();
        ArrayList<P> prParagraphs = new ArrayList<P>();
        Element rootElem = this.getDefaultRootElement();
        int pCnt = rootElem.getElementCount();
        for (int i = 0; i < pCnt; ++i) {
            Element pe = rootElem.getElement(i);
            P p = new P();
            prParagraphs.add(p);
            int pChCnt = pe.getElementCount();
            for (int pci = 0; pci < pChCnt; ++pci) {
                Object cAttr;
                Object ulAttr;
                Object stAttr;
                Element pChE = pe.getElement(pci);
                if (!pChE.isLeaf()) continue;
                Font fe = null;
                Text te = new Text();
                AttributeSet attrSet = pChE.getAttributes();
                if (attrSet.isDefined(StyleConstants.Italic)) {
                    fe = new Font();
                    Object italicAttr = attrSet.getAttribute(StyleConstants.Italic);
                    if (Boolean.TRUE.equals(italicAttr)) {
                        fe.setStyle(Font.ITALIC);
                    } else {
                        fe.setStyle(Font.NORMAL);
                    }
                }
                if (attrSet.isDefined(StyleConstants.Bold)) {
                    Object boldAttr;
                    if (fe == null) {
                        fe = new Font();
                    }
                    if (Boolean.TRUE.equals(boldAttr = attrSet.getAttribute(StyleConstants.Bold))) {
                        fe.setWeight(Font.BOLD);
                    } else {
                        fe.setWeight(Font.NORMAL);
                    }
                }
                if (attrSet.isDefined(StyleConstants.FontSize)) {
                    Font.FontSize fs;
                    if (fe == null) {
                        fe = new Font();
                    }
                    if ((fs = (Font.FontSize)attrSet.getAttribute(STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE)) != null) {
                        fe.setSize(fs.toString());
                    } else {
                        Object fsAttr = attrSet.getAttribute(StyleConstants.FontSize);
                        String fsSizeStr = fsAttr.toString();
                        fe.setSize(fsSizeStr);
                    }
                }
                String decoration = null;
                if (attrSet.isDefined(StyleConstants.StrikeThrough) && Boolean.TRUE.equals(stAttr = attrSet.getAttribute(StyleConstants.StrikeThrough))) {
                    decoration = Text.LINE_THROUGH;
                }
                if (decoration == null && attrSet.isDefined(StyleConstants.Underline) && Boolean.TRUE.equals(ulAttr = attrSet.getAttribute(StyleConstants.Underline))) {
                    decoration = Text.UNDERLINE;
                }
                te.setDecoration(decoration);
                if (attrSet.isDefined(StyleConstants.Foreground) && (cAttr = attrSet.getAttribute(StyleConstants.Foreground)) instanceof Color) {
                    Color c = (Color)cAttr;
                    te.setColor(ColorUtils.colorToString((Color)c));
                }
                if (fe != null) {
                    fe.setText(te);
                }
                if (!(pChE instanceof AbstractDocument.LeafElement)) continue;
                AbstractDocument.LeafElement le = (AbstractDocument.LeafElement)pChE;
                int st = le.getStartOffset();
                int en = le.getEndOffset();
                try {
                    String str = this.getText(st, en - st);
                    if (en == pe.getEndOffset()) {
                        str = str.replaceFirst("\n$", "");
                    }
                    if (str.length() <= 0) continue;
                    te.setText(str);
                    if (fe != null) {
                        p.getTexts().add(fe);
                        continue;
                    }
                    p.getTexts().add(te);
                    continue;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        this.readUnlock();
        return prParagraphs;
    }

    public class PositionImpl
    implements Position {
        private int offset = 0;

        @Override
        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }
    }

    public class TextFragmentElement
    extends AbstractDocument.LeafElement {
        public TextFragmentElement(Element parent, AttributeSet attrSet, int offs1, int offs2) {
            super(PromptStyledDocument.this, parent, attrSet, offs1, offs2);
        }
    }

    public class ParagraphElement
    extends AbstractDocument.BranchElement {
        public ParagraphElement(Element parent, AttributeSet attrSet) {
            super(PromptStyledDocument.this, parent, attrSet);
            this.addAttribute(NameAttribute, "p");
        }
    }

    public class PromptDocElement
    extends DefaultStyledDocument.SectionElement {
        public PromptDocElement() {
            super(PromptStyledDocument.this);
        }
    }
}

