/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.session.action;

import ipsk.apps.speechrecorder.session.SessionManager;
import ipsk.audio.events.StartPlaybackActionEvent;
import java.awt.event.ActionEvent;

public class StartPlaybackAction
extends ipsk.audio.actions.StartPlaybackAction {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_COMMAND = new String("start_playback");
    public static final String SHORT_DESCRIPTION_VAL = new String("Start playback");
    private SessionManager sessionManager;

    public StartPlaybackAction(SessionManager sessionManager, String name) {
        this.putValue("Name", name);
        this.putValue("ActionCommandKey", ACTION_COMMAND);
        this.putValue("ShortDescription", SHORT_DESCRIPTION_VAL);
        this.sessionManager = sessionManager;
    }

    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            if (arg0 instanceof StartPlaybackActionEvent) {
                StartPlaybackActionEvent spae = (StartPlaybackActionEvent)arg0;
                long start = spae.getStartFramePosition();
                long stop = spae.getStopFramePosition();
                this.sessionManager.startPlayback(start, stop);
            } else {
                this.sessionManager.startPlayback();
            }
        }
        catch (Exception e) {
            this.sessionManager.getSpeechRecorderUI().displayError("Playback start error", e);
            e.printStackTrace();
        }
    }
}

