/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.session.progress;

import ipsk.apps.speechrecorder.RecLogger;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.session.action.SetIndexAction;
import ipsk.apps.speechrecorder.session.action.SetIndexEvent;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerEvent;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerException;
import ipsk.apps.speechrecorder.session.progress.ProgressManagerListener;
import ipsk.apps.speechrecorder.session.progress.SessionPositionChangedEvent;
import ipsk.apps.speechrecorder.storage.ActiveSessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.db.speech.Group;
import ipsk.db.speech.Mediaitem;
import ipsk.db.speech.Nonrecording;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import ipsk.db.speech.Script;
import ipsk.db.speech.Section;
import java.net.URL;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class ProgressManager
extends AbstractTableModel
implements ListSelectionModel {
    public static final String REC_SCRIPT_DTD_1 = "SpeechRecPrompts.dtd";
    public static final String REC_SCRIPT_DTD_2 = "SpeechRecPrompts_2.dtd";
    public static final String REC_SCRIPT_DTD = "SpeechRecPrompts_2.dtd";
    public static final int AUTOMATIC = 0;
    public static final int MANUAL = 1;
    public static final int SEQUENTIAL = 2;
    public static final int RANDOM = 3;
    public static final int COL_ITEM = 0;
    public static final int COL_URL = 1;
    public static final int COL_TEXT = 2;
    public static final int COL_REC = 3;
    public static final int COL_UPLOAD = 4;
    public static final int COLUMNS = 4;
    public static final String RECORDED_COL_ID = "progress.table.col.recorded";
    public static final int ERROR_MSG_MAX_ITEMS = 20;
    private String[] tableHead;
    private Logger logger;
    private UIResources uiString = null;
    private Script script;
    private boolean scriptSaved = true;
    private Integer recIndex;
    private int[] recCounter;
    private boolean[] recProcessed;
    private URL context = null;
    private String systemIdBase = null;
    private SetIndexAction setIndexAction;
    private ActiveSessionStorageManager storageManager;
    private DefaultListSelectionModel selModel;
    private String systemId = "SpeechRecPrompts_2.dtd";
    private boolean progresToNextUnrecorded = false;
    private Vector<ProgressManagerListener> listeners = new Vector();

    public SetIndexAction getSetIndexAction() {
        return this.setIndexAction;
    }

    public void setSetIndexAction(SetIndexAction setIndexAction) {
        this.setIndexAction = setIndexAction;
    }

    public ProgressManager() {
        this.logger = Logger.getLogger("ipsk.apps.speechrecorder");
        this.uiString = UIResources.getInstance();
        this.tableHead = new String[4];
        this.tableHead[0] = this.uiString.getString("ItemNo");
        this.tableHead[1] = this.uiString.getString("ItemFile");
        this.tableHead[2] = this.uiString.getString("ItemPrompt");
        this.tableHead[3] = this.uiString.getString("ItemRecStatus");
        this.selModel = new DefaultListSelectionModel();
        this.selModel.setSelectionMode(0);
        this.initialize();
    }

    public void initialize() {
        this.recIndex = null;
        this.selModel.clearSelection();
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
        this.initialize();
        this.resetItemMarkers();
        try {
            this.updateItemMarkers();
        }
        catch (ProgressManagerException e) {
            e.printStackTrace();
        }
    }

    public boolean needsSilenceDetector() {
        if (this.script != null) {
            return this.script.needsSilenceDetector();
        }
        return false;
    }

    public boolean needsBeep() {
        if (this.script != null) {
            return this.script.needsBeep();
        }
        return false;
    }

    public void updateItemMarkers() throws ProgressManagerException {
        try {
            this.checkRecordedItems();
            for (int i = 0; i < this.numberOfPromptItems(); ++i) {
                this.recProcessed[i] = this.recCounter[i] > 0;
            }
        }
        catch (ProgressManagerException e) {
            e.printStackTrace();
            throw new ProgressManagerException(e);
        }
        finally {
            this.fireTableDataChanged();
        }
    }

    public void resetItemMarkers() {
        int maxIndex = this.numberOfPromptItems();
        this.recCounter = new int[maxIndex];
        this.recProcessed = new boolean[maxIndex];
    }

    public void setStorageManager(ActiveSessionStorageManager sm) {
        this.storageManager = sm;
    }

    public Section getCurrentRecSection() {
        Integer recIndex = this.getRecIndex();
        Section section = null;
        if (recIndex != null && this.script != null) {
            section = this.script.sectionForItemIndex(recIndex.intValue());
        }
        return section;
    }

    public Section.PromptPhase currentPromptPhase() {
        Section cs = this.getCurrentRecSection();
        if (cs != null) {
            return cs.getNNPromptphase();
        }
        return null;
    }

    public String getRecSectionInfo() {
        Section section = this.getCurrentRecSection();
        if (section != null) {
            return section.getInfo();
        }
        return null;
    }

    public PromptItem getPromptItem(int promptIndex) {
        List sections;
        PromptItem promptItem = null;
        int index = promptIndex;
        if (this.script != null && (sections = this.script.getSections()) != null) {
            for (int i = 0; i < sections.size(); ++i) {
                Section s = (Section)sections.get(i);
                List pis = s.getShuffledPromptItems();
                int pisSize = pis.size();
                if (index >= pisSize) {
                    index -= pisSize;
                    continue;
                }
                promptItem = (PromptItem)pis.get(index);
                break;
            }
        }
        return promptItem;
    }

    public PromptItem getCurrentPromptItem() {
        Integer recIndex = this.getRecIndex();
        if (recIndex == null) {
            return null;
        }
        return this.getPromptItem(recIndex);
    }

    public boolean currentPromptBlocking() {
        PromptItem pi = this.getCurrentPromptItem();
        if (pi instanceof Recording) {
            return ((Recording)pi).getNNBlocked();
        }
        return false;
    }

    private void checkRecordedItems() throws ProgressManagerException {
        for (int i = 0; i < this.numberOfPromptItems(); ++i) {
            String itemCode;
            PromptItem pi = this.getPromptItem(i);
            if (!(pi instanceof Recording) || (itemCode = ((Recording)pi).getItemcode()) == null) continue;
            try {
                this.recCounter[i] = this.storageManager.getRecordedVersions(itemCode);
                continue;
            }
            catch (StorageManagerException e) {
                throw new ProgressManagerException(e);
            }
        }
    }

    public int getRecCounter(int index) {
        if (index >= this.recCounter.length) {
            return 0;
        }
        return this.recCounter[index];
    }

    public void incrementRecCounter(int index) {
        int n = index;
        this.recCounter[n] = this.recCounter[n] + 1;
        this.fireTableCellUpdated(index, 3);
    }

    public void markItemAsProcessed(int index) {
        this.recProcessed[index] = true;
        this.fireTableCellUpdated(index, 4);
    }

    public void setLogEntries() {
        RecLogger recLog = RecLogger.getInstance();
        PromptItem pi = this.getPromptItem(this.recIndex);
        if (pi instanceof Recording) {
            Recording r = (Recording)pi;
            recLog.setLogEntry("LBR: ", ((Mediaitem)r.getMediaitems().get(0)).getText());
            recLog.setLogEntry("CCD: ", r.getItemcode());
        }
    }

    public void decrementIndex() {
        if (this.recIndex > 0) {
            this.setRecIndex(this.recIndex - 1);
        } else {
            this.setRecIndex(this.numberOfPromptItems() - 1);
        }
    }

    public void incrementIndex() {
        if (this.recIndex == this.numberOfPromptItems() - 1) {
            this.setRecIndex(0);
        } else {
            this.setRecIndex(this.recIndex + 1);
        }
    }

    public Integer getRecIndex() {
        return this.recIndex;
    }

    public void setRecIndex(Integer index) {
        if (index != null && (index < 0 || index >= this.numberOfPromptItems())) {
            throw new IllegalArgumentException();
        }
        boolean changed = this.recIndex == null ? index != null : (index == null ? true : index.intValue() != this.recIndex.intValue());
        this.recIndex = index;
        if (changed) {
            if (this.recIndex != null) {
                this.selModel.setSelectionInterval(this.recIndex, this.recIndex);
            } else {
                this.selModel.clearSelection();
            }
            this.fireSessionManagerUpdate(new SessionPositionChangedEvent(this, this.recIndex));
        }
    }

    public int numberOfPromptItems() {
        if (this.script == null) {
            return 0;
        }
        return this.script.numberOfPromptItems();
    }

    public void advanceToNextRecording() {
        int tmpIndex = this.getRecIndex();
        int maxIndex = this.numberOfPromptItems();
        boolean itemAlreadyRecorded = true;
        while (itemAlreadyRecorded && tmpIndex < maxIndex) {
            PromptItem pi = this.getPromptItem(tmpIndex);
            if (pi instanceof Recording) {
                this.logger.info("recCounter[" + tmpIndex + "] = " + this.recCounter[tmpIndex]);
                if (this.recCounter[tmpIndex] == 0) {
                    itemAlreadyRecorded = false;
                    break;
                }
            }
            if (++tmpIndex != maxIndex) continue;
            int response = JOptionPane.showConfirmDialog(null, "No unrecorded items found. Continue search at first item?");
            if (response == 0) {
                tmpIndex = 0;
                continue;
            }
            tmpIndex = this.getRecIndex();
            break;
        }
        this.setRecIndex(tmpIndex);
    }

    public boolean allRecordingsDone() {
        boolean allRecordingsDone = true;
        for (int i = 0; i < this.numberOfPromptItems(); ++i) {
            PromptItem pi = this.getPromptItem(i);
            if (!(pi instanceof Recording) || this.getRecCounter(i) >= 1) continue;
            allRecordingsDone = false;
            break;
        }
        return allRecordingsDone;
    }

    @Override
    public int getRowCount() {
        return this.numberOfPromptItems();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.numberOfPromptItems() == 0) {
            return null;
        }
        PromptItem pi = this.getPromptItem(row);
        String itemCode = "";
        if (pi instanceof Recording) {
            Recording recItem = (Recording)pi;
            itemCode = recItem.getItemcode();
        }
        if (column == 0) {
            return row;
        }
        if (column == 1) {
            return itemCode;
        }
        if (column == 2) {
            return pi.getDescription();
        }
        if (column == 3) {
            if (pi instanceof Nonrecording || row >= this.recCounter.length) {
                return null;
            }
            return this.recCounter[row] > 0;
        }
        if (column == 4) {
            return this.recProcessed[row];
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return this.tableHead[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 0) {
            return Integer.class;
        }
        if (col == 1) {
            return String.class;
        }
        if (col == 2) {
            return String.class;
        }
        if (col == 3) {
            return Boolean.class;
        }
        if (col == 4) {
            return Boolean.class;
        }
        return String.class;
    }

    public String getSystemIdBase() {
        return this.systemIdBase;
    }

    public void setSystemIdBase(String string) {
        this.systemIdBase = string;
    }

    public String getScriptID() {
        return this.script.getName();
    }

    public void setContext(URL context) {
        this.context = context;
    }

    public URL getContext() {
        return this.context;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void doClose() {
        this.setScript(null);
        this.resetItemMarkers();
        this.initialize();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener l) {
        this.selModel.addListSelectionListener(l);
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
    }

    @Override
    public void clearSelection() {
        this.selModel.clearSelection();
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.selModel.getAnchorSelectionIndex();
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.selModel.getLeadSelectionIndex();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.selModel.getListeners(listenerType);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return this.selModel.getListSelectionListeners();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.selModel.getMaxSelectionIndex();
    }

    @Override
    public int getMinSelectionIndex() {
        return this.selModel.getMinSelectionIndex();
    }

    @Override
    public int getSelectionMode() {
        return this.selModel.getSelectionMode();
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.selModel.getValueIsAdjusting();
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        this.selModel.insertIndexInterval(index, length, before);
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.selModel.isLeadAnchorNotificationEnabled();
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.selModel.isSelectedIndex(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selModel.isSelectionEmpty();
    }

    public void moveLeadSelectionIndex(int leadIndex) {
        this.selModel.moveLeadSelectionIndex(leadIndex);
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        this.selModel.removeIndexInterval(index0, index1);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener l) {
        this.selModel.removeListSelectionListener(l);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        this.selModel.removeSelectionInterval(index0, index1);
    }

    @Override
    public void setAnchorSelectionIndex(int anchorIndex) {
        this.selModel.setAnchorSelectionIndex(anchorIndex);
    }

    public void setLeadAnchorNotificationEnabled(boolean flag) {
        this.selModel.setLeadAnchorNotificationEnabled(flag);
    }

    @Override
    public void setLeadSelectionIndex(int leadIndex) {
        this.selModel.setLeadSelectionIndex(leadIndex);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (this.setIndexAction != null && this.setIndexAction.isEnabled() && index0 == index1) {
            this.setIndexAction.actionPerformed(new SetIndexEvent(this, index0));
        }
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.selModel.setSelectionMode(selectionMode);
    }

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {
        this.selModel.setValueIsAdjusting(isAdjusting);
    }

    public PromptItem setCurrentPromptItem(PromptItem promptItem) {
        if (this.script == null) {
            return null;
        }
        int newIndex = 0;
        List sections = this.script.getSections();
        if (sections != null) {
            for (Section s : sections) {
                List pis = s.getGroups();
                for (Group g : pis) {
                    for (PromptItem pi : g.getPromptItems()) {
                        if (promptItem == pi) {
                            this.setRecIndex(newIndex);
                            return pi;
                        }
                        ++newIndex;
                    }
                }
            }
        }
        return null;
    }

    public synchronized void addSessionManagerListener(ProgressManagerListener acl) {
        if (acl != null && !this.listeners.contains(acl)) {
            this.listeners.addElement(acl);
        }
    }

    public synchronized void removeSessionManagerListener(ProgressManagerListener acl) {
        if (acl != null) {
            this.listeners.removeElement(acl);
        }
    }

    protected synchronized void fireSessionManagerUpdate(ProgressManagerEvent event) {
        for (ProgressManagerListener listener : this.listeners) {
            listener.update(event);
        }
    }

    public boolean isScriptSaved() {
        return this.scriptSaved;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String scriptDTD) {
        this.systemId = scriptDTD;
    }

    public boolean isProgresToNextUnrecorded() {
        return this.progresToNextUnrecorded;
    }

    public void setProgresToNextUnrecorded(boolean progresToNextUnrecorded) {
        this.progresToNextUnrecorded = progresToNextUnrecorded;
    }
}

