/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.storage;

import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.apps.speechrecorder.storage.UploadAudioFile;
import ipsk.audio.utils.AudioFormatUtils;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Script;
import ipsk.db.speech.Session;
import ipsk.io.StreamCopy;
import ipsk.net.Upload;
import ipsk.net.UploadCache;
import ipsk.net.UploadCacheListener;
import ipsk.net.UploadFile;
import ipsk.net.Utils;
import ipsk.net.event.UploadConnectionEvent;
import ipsk.net.event.UploadEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class ActiveSessionStorageManager
extends SessionStorageManager
implements UploadCacheListener {
    public static String DEF_SCRIPT_ID_FORMAT = "0000";
    public static String XML_FILENAME_EXTENSION = "xml";
    public static String DEF_ANNOTATION_FILE_SUFFIX = "_anno";
    private UploadCache uploadCache;
    private int sessionID;
    private String promptCode = "";
    private String speakerCode = null;
    private int recVersion;
    private String labelFileExtension = "txt";
    private String audioFileExtension = "wav";
    private String logFileExtension = "log";
    private String logFileSuffix = "_log";
    private String timeLogFileSuffix = "_timelog";
    private String tmpDirName;
    private String tmpFilePrefix;
    private String cacheTmpFilePrefix = this.getClass().getName() + "_cache_";
    private String convertedTmpFilePrefix = this.getClass().getName() + "_upload_";
    private String cacheMapFilename;
    private String cacheLockFilename;
    private File cacheLockFile;
    private String lockFileExtension = "lck";
    private FileLock lock;
    private FileOutputStream cacheLockFos;
    private AudioFileFormat.Type storageType;
    private boolean useAsCache = false;
    private File cacheMapFile;
    private String mapFileExtension = "map";
    private Vector<UploadFile[]> cache;
    private Logger logger;
    private File tmpDir;
    private UIResources uiString;
    private File[] currentItemRecordingFiles;
    private Status status = Status.CLOSED;

    public ActiveSessionStorageManager() {
        String packageName = this.getClass().getPackage().getName();
        this.logger = Logger.getLogger(packageName);
        this.logger.setLevel(Level.INFO);
        this.scriptIDFormat = new DecimalFormat(DEF_SCRIPT_ID_FORMAT);
        this.uploadType = this.storageType = AudioFileFormat.Type.WAVE;
        this.tmpDirName = System.getProperty("java.io.tmpdir");
        if (!this.tmpDirName.endsWith(File.separator)) {
            this.tmpDirName = this.tmpDirName.concat(File.separator);
        }
        this.tmpDir = new File(this.tmpDirName);
        this.tmpFilePrefix = this.getClass().getName();
        this.uiString = UIResources.getInstance();
        this.logger.info("Storage manager created");
    }

    protected void deleteAllTmpDirFiles() {
        File[] tmpFiles = this.tmpDir.listFiles(new PrefixNameFilter(this.tmpDir, this.tmpFilePrefix));
        if (tmpFiles == null) {
            return;
        }
        for (int i = 0; i < tmpFiles.length; ++i) {
            tmpFiles[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(boolean force) throws StorageManagerException {
        if (this.uploadType == null) {
            this.uploadType = this.storageType;
        }
        this.audioFileExtension = this.storageType.getExtension();
        if (this.useAsCache) {
            this.cacheLockFilename = this.tmpDirName + this.tmpFilePrefix + "_cache." + this.lockFileExtension;
            this.cacheLockFile = new File(this.cacheLockFilename);
            try {
                this.cacheLockFos = new FileOutputStream(this.cacheLockFile);
                FileChannel ch = this.cacheLockFos.getChannel();
                this.lock = ch.tryLock();
            }
            catch (FileNotFoundException e3) {
                throw new StorageManagerException("Error locking storage cache !");
            }
            catch (IOException e) {
                throw new StorageManagerException("Error locking storage cache !");
            }
            if (this.lock == null) {
                this.logger.warning("Cache is locked !");
                throw new StorageManagerException(this.uiString.getString("CacheAlreadyInUse"));
            }
            this.cacheMapFilename = this.tmpDirName + this.tmpFilePrefix + "_cache." + this.mapFileExtension;
            this.cacheMapFile = new File(this.cacheMapFilename);
            if (this.cacheMapFile.exists()) {
                FileInputStream fis = null;
                ObjectInputStream ois = null;
                try {
                    fis = new FileInputStream(this.cacheMapFile);
                    ois = new ObjectInputStream(fis);
                    this.cache = (Vector)ois.readObject();
                    this.logger.info("Read existing cache map " + this.cacheMapFilename);
                }
                catch (Exception e) {
                    this.logger.severe("Cannot read cache map!" + e.getMessage());
                    if (!force) {
                        throw new StorageManagerException("Cannot read cache map!", e);
                    }
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (IOException iOException) {}
                        this.cacheMapFile.delete();
                        this.logger.warning("Removed unreadable cache map!");
                        this.cache = new Vector();
                    }
                }
                finally {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException e1) {
                        this.logger.severe("Could not close object stream of cache map !" + e1.getMessage());
                        throw new StorageManagerException("Could not close object stream of cache map.", e1);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e2) {
                                this.logger.severe("Could not close !" + e2.getMessage());
                                throw new StorageManagerException("Could not close.", e2);
                            }
                        }
                    }
                }
                for (int i = 0; i < this.cache.size(); ++i) {
                    UploadAudioFile[] upload = (UploadAudioFile[])this.cache.get(i);
                    try {
                        this.upload(upload);
                        continue;
                    }
                    catch (StorageManagerException e) {
                        this.logger.severe("Storage exception !" + e);
                        if (!force) {
                            throw e;
                        }
                        this.cache.remove(i);
                        this.logger.warning("Removed upload from cache on exception.");
                    }
                }
            } else {
                this.cache = new Vector();
            }
        }
        this.status = Status.OPEN;
        this.logger.info("Storage manager opened.");
    }

    public void close() throws StorageManagerException {
        this.close(false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close(boolean forceDelete) throws StorageManagerException {
        if (this.status.equals((Object)Status.CLOSED)) {
            return;
        }
        if (!this.useAsCache) ** GOTO lbl63
        size = this.cache.size();
        i = size - 1;
        while (true) {
            if (i >= 0) {
                uploads = (UploadAudioFile[])this.cache.get(i);
                pungeOut = true;
            } else {
                size = this.cache.size();
                if (size > 0) {
                    fos = null;
                    oos = null;
                    try {
                        fos = new FileOutputStream(this.cacheMapFile);
                        oos = new ObjectOutputStream(fos);
                        oos.writeObject(this.cache);
                    }
                    catch (Exception e) {
                        throw new StorageManagerException(e);
                    }
                    finally {
                        try {
                            if (oos != null) {
                                oos.close();
                            }
                        }
                        catch (IOException e1) {
                            this.logger.severe("Error closing object stream: " + e1.getMessage());
                            throw new StorageManagerException(e1);
                        }
                        finally {
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException e2) {
                                    throw new StorageManagerException(e2);
                                }
                            }
                        }
                    }
                }
                this.cacheMapFile.delete();
                if (forceDelete) {
                    this.deleteAllTmpDirFiles();
                }
                try {
                    try {
                        if (this.lock != null) {
                            this.lock.release();
                        }
                    }
                    catch (IOException ioe) {
                        throw new StorageManagerException("Cannot unlock storage cache: " + ioe.getLocalizedMessage());
                    }
                    finally {
                        if (this.cacheLockFos != null) {
                            this.cacheLockFos.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new StorageManagerException("Cannot close lock stream !");
                }
                finally {
                    if (this.cacheLockFile != null) {
                        this.cacheLockFile.deleteOnExit();
                    }
                    this.cacheLockFile.delete();
                }
                this.status = Status.CLOSED;
                return;
            }
            for (j = 0; j < uploads.length; ++j) {
                uploadStatus = uploads[j].getStatus();
                if (uploadStatus == 3 || uploadStatus == 2) continue;
                pungeOut = false;
                this.logger.info("Hold in cache for next session: " + uploads[j] + " Status: " + uploads[j].getStatus());
                break;
            }
            if (pungeOut) {
                for (j = 0; j < uploads.length; ++j) {
                    uAf = uploads[j];
                    audioFile = uAf.getAudioCacheFile();
                    if (!audioFile.exists()) {
                        this.logger.warning("Cached audio file " + audioFile + " does not exist!");
                        continue;
                    }
                    if (audioFile.delete()) continue;
                    this.logger.severe("Cannot remove cached audio file " + audioFile);
                    System.err.println("Cannot remove " + audioFile);
                    audioFile.deleteOnExit();
                }
                this.cache.remove(i);
            }
            --i;
        }
    }

    public void open() throws StorageManagerException {
        this.open(false);
    }

    @Override
    public String getRootFileName(int sessionID, String promptCode, String speakerCode, int recVersion) {
        String rootFileName = this.getSessionNamePart(sessionID, speakerCode);
        rootFileName = rootFileName.concat(promptCode);
        if (!this.overwrite && !this.useAsCache) {
            rootFileName = rootFileName.concat("_" + this.recVersionFormat.format(new Integer(recVersion)));
        }
        return rootFileName;
    }

    @Override
    public URL[] generateAudioFileURLs(int sessionID, String speakerCode, String promptCode, int recVersion) throws StorageManagerException {
        try {
            if (this.useAsCache) {
                try {
                    String extension = this.uploadType.getExtension();
                    URL[] audioFileURLs = new URL[this.numLines];
                    URL sessionURL = this.getSessionURL(sessionID);
                    for (int line = 0; line < this.numLines; ++line) {
                        URL newURL = this.addQueryToURL(this.storageURL, "itemcode", promptCode);
                        if (speakerCode != null) {
                            newURL = this.addQueryToURL(newURL, "speakercode", speakerCode);
                        }
                        newURL = this.addQueryToURL(newURL, "session", this.sessionIDFormat.format(sessionID));
                        newURL = this.addQueryToURL(newURL, "extension", extension);
                        if (this.scriptID != null) {
                            newURL = this.addQueryToURL(newURL, "script", this.scriptID);
                        }
                        newURL = this.addQueryToURL(newURL, "line", line + "1");
                        newURL = this.addQueryToURL(newURL, "overwrite", new Boolean(this.overwrite).toString());
                        Enumeration keys = this.metadata.elements();
                        Enumeration values = this.metadata.elements();
                        while (keys.hasMoreElements() && values.hasMoreElements()) {
                            newURL = this.addQueryToURL(newURL, (String)keys.nextElement(), (String)values.nextElement());
                        }
                    }
                    return audioFileURLs;
                }
                catch (Exception ex) {
                    String msg = "Exception: " + ex.getLocalizedMessage();
                    throw new StorageManagerException(msg, ex);
                }
            }
            return super.generateAudioFileURLs(sessionID, speakerCode, promptCode, recVersion);
        }
        catch (StorageManagerException ex) {
            String msg = "Exception: " + ex.getLocalizedMessage();
            this.logger.severe(msg);
            throw ex;
        }
    }

    public void setUploadCache(UploadCache uploadCache) {
        this.uploadCache = uploadCache;
        if (uploadCache != null) {
            uploadCache.addUploadCacheListener((UploadCacheListener)this);
        }
    }

    public void upload() throws StorageManagerException {
        if (this.useAsCache) {
            try {
                this.upload(this.getUpload());
            }
            catch (IOException ex) {
                String msg = "IOException: " + ex.getLocalizedMessage();
                this.logger.severe(msg);
                throw new StorageManagerException(msg, ex);
            }
        }
    }

    private void upload(UploadAudioFile[] uploadFiles) throws StorageManagerException {
        try {
            URL[] urls = this.getConvertedAudioFiles();
            for (int line = 0; line < this.numLines; ++line) {
                try {
                    File audioFile = uploadFiles[line].getAudioCacheFile();
                    File compressedFile = File.createTempFile(this.convertedTmpFilePrefix, "." + this.uploadType.getExtension());
                    compressedFile.deleteOnExit();
                    AudioInputStream ais = AudioSystem.getAudioInputStream(audioFile);
                    try {
                        AudioSystem.write(ais, this.uploadType, compressedFile);
                        ais.close();
                    }
                    catch (IllegalArgumentException ex) {
                        this.logger.warning(ex.getLocalizedMessage() + " ais: " + ais);
                    }
                    uploadFiles[line].setFile(compressedFile);
                    uploadFiles[line].setMimeType(AudioFormatUtils.getMimetype((AudioFileFormat.Type)this.uploadType));
                    if (uploadFiles[line].getUrl() != null) continue;
                    uploadFiles[line].setUrl(urls[line]);
                    continue;
                }
                catch (Exception ex) {
                    String msg = "Exception: " + ex.getLocalizedMessage();
                    this.logger.severe(msg);
                    throw new StorageManagerException(msg, ex);
                }
            }
            this.uploadCache.upload((Upload[])uploadFiles);
        }
        catch (Exception ex) {
            String msg = "Exception: " + ex.getLocalizedMessage();
            this.logger.severe(msg);
            throw new StorageManagerException(msg, ex);
        }
    }

    public void uploadAnnotation() throws StorageManagerException {
        try {
            URL url = this.generateAnnotationFileURL();
            this.uploadCache.upload((Upload[])this.getAnnotationUpload(new URL[]{url}));
        }
        catch (Exception ex) {
            String msg = "Exception: " + ex.getLocalizedMessage();
            this.logger.severe(msg);
            throw new StorageManagerException(msg, ex);
        }
    }

    private UploadAudioFile[] getUpload() throws IOException, StorageManagerException {
        return this.getUpload(this.generateAudioFileURLs(), true);
    }

    private UploadAudioFile[] getUpload(URL[] urls) throws IOException {
        return this.getUpload(urls, false);
    }

    private UploadAudioFile[] getUpload(URL[] urls, boolean create) throws IOException {
        UploadAudioFile[] cacheEntryAudio = null;
        for (int i = this.cache.size() - 1; i >= 0; --i) {
            UploadFile[] cacheEntry = this.cache.get(i);
            if (!(cacheEntry instanceof UploadAudioFile[])) continue;
            cacheEntryAudio = (UploadAudioFile[])cacheEntry;
            boolean match = true;
            for (int j = 0; j < urls.length; ++j) {
                if (cacheEntry[j].getUrl().sameFile(urls[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return cacheEntryAudio;
        }
        return null;
    }

    private UploadFile[] getAnnotationUpload(URL[] urls) throws IOException {
        UploadFile[] cacheEntry = null;
        for (int i = this.cache.size() - 1; i >= 0; --i) {
            cacheEntry = this.cache.get(i);
            boolean match = true;
            for (int j = 0; j < urls.length; ++j) {
                if (cacheEntry[j].getUrl().sameFile(urls[j])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return cacheEntry;
        }
        return null;
    }

    public InputStream[] getCachedInputStreams() throws StorageManagerException {
        InputStream[] iss = new InputStream[this.numLines];
        try {
            if (this.useAsCache) {
                File[] files = this.getRecordingFiles();
                for (int line = 0; line < this.numLines; ++line) {
                    iss[line] = new FileInputStream(files[line]);
                }
            } else {
                URL[] urls = this.generateAudioFileURLs();
                for (int line = 0; line < this.numLines; ++line) {
                    iss[line] = urls[line].openStream();
                }
            }
        }
        catch (IOException ex) {
            String msg = "IOException: " + ex.getLocalizedMessage();
            try {
                for (int line = 0; line < this.numLines; ++line) {
                    iss[line].close();
                }
            }
            catch (IOException closeex) {
                msg = msg + " " + closeex.getLocalizedMessage();
            }
            this.logger.severe(msg);
            throw new StorageManagerException(msg, ex);
        }
        return iss;
    }

    public URL[] getCachedInputURLs() throws StorageManagerException {
        URL[] lineURLs = new URL[this.numLines];
        if (this.useAsCache) {
            File[] files = this.getRecordingFiles();
            for (int line = 0; line < this.numLines; ++line) {
                try {
                    lineURLs[line] = files[line].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    this.logger.severe(e.getMessage());
                    throw new StorageManagerException("File to URL: " + e.getMessage(), e);
                }
            }
        } else {
            URL[] urls = this.generateAudioFileURLs();
            for (int line = 0; line < this.numLines; ++line) {
                lineURLs[line] = urls[line];
            }
        }
        return lineURLs;
    }

    public File[] getCachedInputFiles() throws StorageManagerException {
        if (this.useAsCache) {
            return this.getRecordingFiles();
        }
        URL[] urls = this.generateAudioFileURLs();
        File[] files = new File[this.numLines];
        for (int line = 0; line < this.numLines; ++line) {
            URL lineURL = urls[line];
            if (lineURL.getProtocol().equalsIgnoreCase("file")) {
                try {
                    files[line] = new File(lineURL.toURI().getPath());
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new StorageManagerException("Cannot convert URL/URI to file path");
                }
            }
            throw new StorageManagerException("Cannot convert URL to file path");
        }
        return files;
    }

    public File[] getNewRecordingFiles() throws StorageManagerException {
        block9: {
            this.currentItemRecordingFiles = new File[this.numLines];
            try {
                if (this.useAsCache) {
                    URL[] urls = this.generateAudioFileURLs(this.promptCode, this.recVersion + 1);
                    UploadAudioFile[] cacheEntry = new UploadAudioFile[urls.length];
                    for (int j = 0; j < urls.length; ++j) {
                        File tmpAudioFile;
                        try {
                            tmpAudioFile = File.createTempFile(this.cacheTmpFilePrefix, "." + this.audioFileExtension);
                        }
                        catch (IOException e) {
                            throw new StorageManagerException(e);
                        }
                        cacheEntry[j] = new UploadAudioFile(null, tmpAudioFile, urls[j]);
                    }
                    this.cache.add(cacheEntry);
                    for (int i = 0; i < cacheEntry.length; ++i) {
                        this.currentItemRecordingFiles[i] = cacheEntry[i].getAudioCacheFile();
                    }
                    break block9;
                }
                URL[] urls = this.generateAudioFileURLs(this.promptCode, this.recVersion + 1);
                for (int i = 0; i < this.numLines; ++i) {
                    if (!urls[i].getProtocol().equals("file")) {
                        throw new StorageManagerException("URL protocol is not \"file\"");
                    }
                    this.currentItemRecordingFiles[i] = new File(urls[i].toURI().getPath());
                }
            }
            catch (Exception ex) {
                String msg = "Exception: " + ex.getLocalizedMessage();
                this.logger.severe(msg);
                throw new StorageManagerException(msg, ex);
            }
        }
        return this.currentItemRecordingFiles;
    }

    public File[] getCurrentItemRecordingFiles() {
        return this.currentItemRecordingFiles;
    }

    public static File fileURLToFile(URL url) throws StorageManagerException {
        if (!url.getProtocol().equals("file")) {
            throw new StorageManagerException("URL protocol is not \"file\"");
        }
        try {
            URI uri = url.toURI();
            return new File(uri.getPath());
        }
        catch (URISyntaxException e) {
            throw new StorageManagerException(e);
        }
    }

    public File[] getRecordingFiles() throws StorageManagerException {
        File[] files = new File[this.numLines];
        try {
            if (this.useAsCache) {
                UploadAudioFile[] cacheEntry = this.getUpload();
                for (int i = 0; i < cacheEntry.length; ++i) {
                    files[i] = cacheEntry[i].getAudioCacheFile();
                }
            } else {
                URL[] urls = this.generateAudioFileURLs();
                for (int i = 0; i < this.numLines; ++i) {
                    if (!urls[i].getProtocol().equals("file")) {
                        throw new StorageManagerException("URL protocol is not \"file\"");
                    }
                    files[i] = new File(urls[i].toURI().getPath());
                }
            }
        }
        catch (Exception ex) {
            String msg = "Exception: " + ex.getLocalizedMessage();
            this.logger.severe(msg);
            throw new StorageManagerException(msg, ex);
        }
        return files;
    }

    public URL getRecordingSessionInfoFile() throws StorageManagerException {
        URL sessionURL = this.getSessionURL();
        String recSessInfoFilename = this.getRecordingSessionInfoFileName();
        sessionURL = this.addDirToURL(sessionURL, recSessInfoFilename);
        return sessionURL;
    }

    private URL getLabelFile() throws StorageManagerException {
        URL sessionURL = this.getSessionURL();
        String labelFileName = this.getLabelFileName();
        sessionURL = this.addDirToURL(sessionURL, labelFileName);
        return sessionURL;
    }

    public URL[] generateAudioFileURLs() throws StorageManagerException {
        return this.generateAudioFileURLs(this.promptCode, this.recVersion);
    }

    public URL[] generateAudioFileURLs(String promptCode, int recVersion) throws StorageManagerException {
        return this.generateAudioFileURLs(this.sessionID, this.speakerCode, promptCode, recVersion);
    }

    public URL generateAnnotationFileURL() throws StorageManagerException {
        URL annotationURL;
        URL sessionURL = this.getSessionURL();
        try {
            if (this.useAsCache) {
                annotationURL = this.addQueryToURL(this.storageURL, "cmd", "store_annotation");
                annotationURL = this.addQueryToURL(annotationURL, "itemcode", this.promptCode);
                if (this.speakerCode != null) {
                    annotationURL = this.addQueryToURL(annotationURL, "speakercode", this.speakerCode);
                }
                annotationURL = this.addQueryToURL(annotationURL, "session", this.sessionIDFormat.format(this.sessionID));
                annotationURL = this.addQueryToURL(annotationURL, "extension", XML_FILENAME_EXTENSION);
                if (this.scriptID != null) {
                    annotationURL = this.addQueryToURL(annotationURL, "script", this.scriptID);
                }
                annotationURL = this.addQueryToURL(annotationURL, "overwrite", new Boolean(this.overwrite).toString());
            } else {
                annotationURL = sessionURL;
                String annotationFileName = this.getAnnotationFileName();
                annotationURL = this.addDirToURL(annotationURL, annotationFileName);
            }
        }
        catch (Exception ex) {
            String msg = "Exception: " + ex.getLocalizedMessage();
            this.logger.severe(msg);
            throw new StorageManagerException(msg, ex);
        }
        return annotationURL;
    }

    public URL[] getConvertedAudioFiles() throws StorageManagerException {
        if (this.uploadType == null) {
            return null;
        }
        return this.generateAudioFileURLs();
    }

    public String getLogFileName() {
        return this.getSessionNamePart().concat(this.logFileSuffix + "." + this.logFileExtension);
    }

    public URL getLogFile() throws StorageManagerException {
        URL sessionDir = this.getSessionURL();
        URL newURL = null;
        try {
            newURL = this.addDirToURL(sessionDir, this.getLogFileName());
            if (this.useAsCache) {
                newURL = this.addQueryToURL(newURL, "cmd", "store_log");
                if (this.speakerCode != null) {
                    newURL = this.addQueryToURL(newURL, "speakercode", this.speakerCode);
                }
                newURL = this.addQueryToURL(newURL, "session", this.sessionIDFormat.format(this.sessionID));
                newURL = this.addQueryToURL(newURL, "extension", this.logFileExtension);
                if (this.scriptID != null) {
                    newURL = this.addQueryToURL(newURL, "script", this.scriptID);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newURL;
    }

    private String getSessionNamePart(String speakerCode) {
        return this.getSessionNamePart(this.sessionID, speakerCode);
    }

    private String getSessionNamePart() {
        return this.getSessionNamePart(this.speakerCode);
    }

    public List<String> listLocalSessionIds_slow(boolean listEmptySessions) throws StorageManagerException {
        ArrayList<String> localSessionIds = null;
        URL storeUrl = this.getStorageURL();
        if ("file".equalsIgnoreCase(storeUrl.getProtocol())) {
            localSessionIds = new ArrayList<String>();
            try {
                File[] sessionDirs;
                File storeDir = Utils.fileFromDecodedURL((URL)storeUrl);
                FileFilter sessionFileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            String fn = file.getName();
                            try {
                                Number sessionNr = ActiveSessionStorageManager.this.sessionIDFormat.parse(fn);
                                if (sessionNr != null) {
                                    return true;
                                }
                            }
                            catch (ParseException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                };
                for (File sessionDir : sessionDirs = storeDir.listFiles(sessionFileFilter)) {
                    if (!listEmptySessions && sessionDir.listFiles().length <= 0) continue;
                    localSessionIds.add(sessionDir.getName());
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new StorageManagerException(e);
            }
        }
        return localSessionIds;
    }

    public Set<String> localSessionIds(boolean listEmptySessions) throws StorageManagerException {
        HashSet<String> localSessionIds = null;
        URL storeUrl = this.getStorageURL();
        if ("file".equalsIgnoreCase(storeUrl.getProtocol())) {
            localSessionIds = new HashSet<String>();
            File storeDir = null;
            try {
                storeDir = Utils.fileFromDecodedURL((URL)storeUrl);
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
                throw new StorageManagerException(e1);
            }
            if (storeDir.exists()) {
                DirectoryStream.Filter<Path> sessionDirFilter = new DirectoryStream.Filter<Path>(){

                    @Override
                    public boolean accept(Path file) throws IOException {
                        if (file.toFile().isDirectory()) {
                            String fn = file.getName(file.getNameCount() - 1).toString();
                            try {
                                Number sessionNr = ActiveSessionStorageManager.this.sessionIDFormat.parse(fn);
                                if (sessionNr != null) {
                                    return true;
                                }
                            }
                            catch (ParseException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                };
                Path storePath = storeDir.toPath();
                DirectoryStream<Path> storeDirStream = null;
                try {
                    storeDirStream = Files.newDirectoryStream(storePath, (DirectoryStream.Filter<? super Path>)sessionDirFilter);
                    for (Path sessionPath : storeDirStream) {
                        String sessionNm;
                        Path sessionPathLast;
                        boolean includeThisSession = listEmptySessions;
                        if (!listEmptySessions) {
                            try (DirectoryStream<Path> sessionDirStream = null;){
                                sessionDirStream = Files.newDirectoryStream(sessionPath);
                                Iterator<Path> sessionDirContentPathsIt = sessionDirStream.iterator();
                                if (sessionDirContentPathsIt.hasNext()) {
                                    includeThisSession = true;
                                }
                            }
                        }
                        if (!includeThisSession || (sessionPathLast = sessionPath.getName(sessionPath.getNameCount() - 1)) == null || (sessionNm = sessionPathLast.toString()) == null) continue;
                        localSessionIds.add(sessionNm);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new StorageManagerException(e);
                }
                finally {
                    if (storeDirStream != null) {
                        try {
                            storeDirStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new StorageManagerException(e);
                        }
                    }
                }
            }
        }
        return localSessionIds;
    }

    private String getRootFileName(String promptCode, String speakerCode, int recVersion) {
        String rootFileName = this.getSessionNamePart(speakerCode);
        rootFileName = rootFileName.concat(promptCode);
        if (!this.overwrite && !this.useAsCache) {
            rootFileName = rootFileName.concat("_" + this.recVersionFormat.format(new Integer(recVersion)));
        }
        return rootFileName;
    }

    public String getNewRootFileName() {
        return this.getRootFileName(this.promptCode, this.speakerCode, this.recVersion + 1);
    }

    public String getRootFileName() {
        return this.getRootFileName(this.promptCode, this.speakerCode, this.recVersion);
    }

    public String[] getRootFileNames() {
        String[] rootFileNames = new String[this.numLines];
        String rootFileName = this.getRootFileName(this.promptCode, this.speakerCode, this.recVersion);
        if (this.numLines == 1) {
            rootFileNames[0] = rootFileName;
        } else {
            for (int i = 0; i < this.numLines; ++i) {
                rootFileNames[i] = rootFileName.concat("_" + i);
            }
        }
        return rootFileNames;
    }

    public URL getItemFileURL(String suffix) throws StorageManagerException {
        URL customURL = this.getSessionURL();
        String customFileName = this.getRootFileName();
        customFileName = customFileName.concat(suffix);
        customURL = this.addDirToURL(customURL, customFileName);
        return customURL;
    }

    public String[] getAudioFileNames() {
        return this.getAudioFileNames(this.promptCode, this.speakerCode, this.audioFileExtension);
    }

    public String[] getAudioFileNames(String itemCode) {
        return this.getAudioFileNames(itemCode, this.speakerCode, this.audioFileExtension);
    }

    public String[] getAudioFileNames(String promptCode, String speakerCode, String extension) {
        String[] audioFileNames = new String[this.numLines];
        String rootFileName = this.getRootFileName(promptCode, speakerCode, this.recVersion);
        if (this.numLines == 1) {
            audioFileNames[0] = rootFileName.concat("." + extension);
        } else {
            for (int i = 0; i < this.numLines; ++i) {
                audioFileNames[i] = rootFileName.concat("_" + i + "." + extension);
            }
        }
        return audioFileNames;
    }

    public String getLabelFileName() {
        return this.getRootFileName().concat("." + this.labelFileExtension);
    }

    public String getRecordingSessionInfoFileName() {
        return "recording_session_info.xml";
    }

    public File getAnnoationFile() throws StorageManagerException {
        File file;
        block6: {
            file = null;
            try {
                if (this.useAsCache) {
                    File tmpAnnoFile;
                    URL url = this.generateAnnotationFileURL();
                    UploadFile[] cacheEntry = new UploadFile[1];
                    try {
                        tmpAnnoFile = File.createTempFile(this.cacheTmpFilePrefix, DEF_ANNOTATION_FILE_SUFFIX + "." + XML_FILENAME_EXTENSION);
                    }
                    catch (IOException e) {
                        throw new StorageManagerException(e);
                    }
                    cacheEntry[0] = new UploadFile(tmpAnnoFile, url);
                    this.cache.add(cacheEntry);
                    file = cacheEntry[0].getFile();
                    break block6;
                }
                URL url = this.generateAnnotationFileURL();
                if (!url.getProtocol().equals("file")) {
                    throw new StorageManagerException("URL protocol is not \"file\"");
                }
                file = new File(url.toURI().getPath());
            }
            catch (Exception ex) {
                String msg = "Exception: " + ex.getLocalizedMessage();
                this.logger.severe(msg);
                throw new StorageManagerException(msg, ex);
            }
        }
        return file;
    }

    public String getAnnotationFileName() {
        return this.getRootFileName(this.promptCode, this.speakerCode, this.recVersion + 1).concat(DEF_ANNOTATION_FILE_SUFFIX + "." + XML_FILENAME_EXTENSION);
    }

    public URL getSessionURL() throws StorageManagerException {
        return this.getSessionURL(this.sessionID);
    }

    public boolean isRecorded() throws StorageManagerException {
        return this.isRecorded(this.promptCode);
    }

    public boolean isRecorded(String promptCode) throws StorageManagerException {
        return this.isRecorded(promptCode, 0);
    }

    public boolean isRecorded(String promptCode, int recVersion) throws StorageManagerException {
        return this.isRecorded(this.sessionID, this.speakerCode, promptCode, recVersion);
    }

    public boolean isRecorded(int sessionID, String speakerCode, String promptCode) throws StorageManagerException {
        return this.isRecorded(sessionID, speakerCode, promptCode, 0);
    }

    @Override
    public boolean isRecorded(int sessionID, String speakerCode, String promptCode, int recVersion) throws StorageManagerException {
        if (this.useAsCache) {
            boolean recorded = true;
            URL[] urls = this.generateAudioFileURLs(sessionID, speakerCode, promptCode, recVersion);
            UploadAudioFile[] upload = null;
            try {
                upload = this.getUpload(urls, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (upload == null || upload[0].getFile() == null) {
                recorded = false;
            }
            return recorded;
        }
        return super.isRecorded(sessionID, speakerCode, promptCode, recVersion);
    }

    public int getRecordedVersions() throws StorageManagerException {
        return this.getRecordedVersions(this.promptCode);
    }

    public int getRecordedVersions(String promptCode) throws StorageManagerException {
        if (promptCode == null) {
            throw new StorageManagerException("No prompt code given");
        }
        if (!this.overwrite && !this.useAsCache) {
            int testRecversion = 0;
            while (this.isRecorded(promptCode, testRecversion)) {
                ++testRecversion;
            }
            return testRecversion;
        }
        return this.isRecorded(promptCode) ? 1 : 0;
    }

    public Set<RecordingFile> sessionRecordingFilesLazy(Session sess) throws StorageManagerException {
        HashSet<RecordingFile> rfSet = new HashSet<RecordingFile>();
        Script s = sess.getScript();
        List pis = s.promptItemsList();
        block0: for (PromptItem pi : pis) {
            if (!(pi instanceof Recording)) continue;
            Recording r = (Recording)pi;
            r.getRecordingFiles().clear();
            int recVers = 0;
            boolean recordingFound = false;
            do {
                if (!(recordingFound = this.isRecorded(sess.getSessionId(), sess.getCode(), r.getItemcode(), recVers))) continue;
                RecordingFile rf = new RecordingFile();
                rf.setRecording(r);
                rf.setSession(sess);
                rf.setVersion(Integer.valueOf(recVers));
                r.getRecordingFiles().add(rf);
                rfSet.add(rf);
                if (this.overwrite || this.useAsCache) continue block0;
                ++recVers;
            } while (recordingFound);
        }
        return rfSet;
    }

    private String[] getAudioFileNames(String itemCode, String extension) {
        String[] audioFileNames = new String[this.numLines];
        String rootFileName = this.getSessionNamePart();
        rootFileName = rootFileName.concat(itemCode);
        if (this.numLines == 1) {
            audioFileNames[0] = rootFileName.concat("." + extension);
        } else {
            for (int i = 0; i < this.numLines; ++i) {
                audioFileNames[i] = rootFileName.concat("_" + i + "." + extension);
            }
        }
        return audioFileNames;
    }

    public boolean createSessionDirectory() throws StorageManagerException {
        URL sessionDir = this.getSessionURL();
        if (!this.useAsCache) {
            File sessionDirAsFile;
            try {
                sessionDirAsFile = new File(sessionDir.toURI().getPath());
            }
            catch (URISyntaxException e) {
                return false;
            }
            return sessionDirAsFile.mkdirs();
        }
        return true;
    }

    public boolean sessionExists() throws StorageManagerException {
        URL sessionDir = this.getSessionURL();
        if (!this.useAsCache) {
            try {
                File sessionDirAsFile = new File(sessionDir.toURI().getPath());
                return sessionDirAsFile.exists();
            }
            catch (URISyntaxException e) {
                throw new StorageManagerException(e);
            }
        }
        return true;
    }

    public String getAudioFileExtension() {
        return this.audioFileExtension;
    }

    public boolean isCreateSessionDir() {
        return this.createScriptDir;
    }

    public boolean isCreateSpeakerDir() {
        return this.createSpeakerDir;
    }

    public String getLabelFileExtension() {
        return this.labelFileExtension;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public String getPromptCode() {
        return this.promptCode;
    }

    public String getScriptID() {
        return this.scriptID;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public void setSpeakerIDFormat(DecimalFormat format) {
        this.speakerIDFormat = format;
    }

    public String getSpeakerCode() {
        return this.speakerCode;
    }

    public void setSpeakerCode(String string) {
        this.speakerCode = string;
    }

    public URL getTimeLogFile() throws StorageManagerException {
        URL sessionDir = this.getSessionURL();
        URL newURL = null;
        try {
            newURL = this.addDirToURL(sessionDir, this.getTimeLogFileName());
            if (this.useAsCache) {
                newURL = this.addQueryToURL(newURL, "cmd", "store_timelog");
                if (this.speakerCode != null) {
                    newURL = this.addQueryToURL(newURL, "speakercode", this.speakerCode);
                }
                newURL = this.addQueryToURL(newURL, "session", this.sessionIDFormat.format(this.sessionID));
                newURL = this.addQueryToURL(newURL, "extension", this.logFileExtension);
                if (this.scriptID != null) {
                    newURL = this.addQueryToURL(newURL, "script", this.scriptID);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newURL;
    }

    private String getTimeLogFileName() {
        return this.getSessionNamePart().concat(this.timeLogFileSuffix + "." + this.logFileExtension);
    }

    public void setAudioFileExtension(String string) {
        this.audioFileExtension = string;
    }

    public void setCreateSessionDir(boolean b) {
        this.createScriptDir = b;
    }

    public void setCreateSpeakerDir(boolean b) {
        this.createSpeakerDir = b;
    }

    public void setLabelFileExtension(String string) {
        this.labelFileExtension = string;
    }

    public void setPromptCode(String string) {
        this.promptCode = string;
    }

    public void setScriptID(String scriptID) {
        this.scriptID = scriptID;
    }

    public void setSessionID(int i) {
        this.sessionID = i;
    }

    @Override
    public void setStorageURL(URL target) {
        super.setStorageURL(target);
        if (target.getProtocol().equalsIgnoreCase("file")) {
            this.useAsCache = false;
            try {
                this.tmpDirName = this.storageURL.toURI().getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        } else {
            this.useAsCache = true;
        }
    }

    public void setUploadType(AudioFileFormat.Type type) {
        this.uploadType = type;
    }

    public boolean isUseAsCache() {
        return this.useAsCache;
    }

    public void setUseAsCache(boolean b) {
        this.useAsCache = b;
    }

    public void tryConnect() {
    }

    public void connected() {
    }

    public void stateChanged(Upload uvb) {
    }

    public void disconnected() {
    }

    public int getRecVersion() {
        return this.recVersion;
    }

    public void setRecVersion(int recVersion) {
        this.recVersion = recVersion;
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.logger.info("Overwrite mode: " + overwrite);
        super.setOverwrite(overwrite);
    }

    public void update(UploadEvent event) {
        UploadConnectionEvent uce;
        UploadConnectionEvent.ConnectionState cs;
        if (event instanceof UploadConnectionEvent && (cs = (uce = (UploadConnectionEvent)event).getConnectionState()).equals((Object)UploadConnectionEvent.ConnectionState.TRY_CONNECT)) {
            this.tryConnect();
        }
    }

    public Integer highestSessionID() throws StorageManagerException {
        String urlProtocol;
        Integer highestId = null;
        URL stUrl = this.getStorageURL();
        if (stUrl != null && "file".equalsIgnoreCase(urlProtocol = stUrl.getProtocol())) {
            File stDir = ActiveSessionStorageManager.fileURLToFile(stUrl);
            if (stDir.exists()) {
                File[] files;
                for (File file : files = stDir.listFiles()) {
                    if (!file.isDirectory()) continue;
                    try {
                        Number sessionIdNr = this.sessionIDFormat.parse(file.getName());
                        if (sessionIdNr == null) continue;
                        int sId = sessionIdNr.intValue();
                        if (highestId != null && sId <= highestId) continue;
                        highestId = sId;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            return highestId;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File recentRecordingFile(String itemCode) throws StorageManagerException {
        File rf = null;
        int versCnt = this.getRecordedVersions(itemCode);
        if (versCnt <= 0) return rf;
        int versIdx = versCnt - 1;
        if (this.useAsCache) {
            URL[] urls = this.generateAudioFileURLs(this.sessionID, this.speakerCode, itemCode, versIdx);
            try {
                UploadAudioFile[] uplAudioFile = this.getUpload(urls);
                if (uplAudioFile == null) return rf;
                if (uplAudioFile.length <= 0) return rf;
                return uplAudioFile[0].getAudioCacheFile();
            }
            catch (IOException e) {
                throw new StorageManagerException(e);
            }
        }
        String rfNm = this.getRootFileName(itemCode, this.getSpeakerCode(), versIdx);
        URL sessionURl = this.getSessionURL();
        File sessF = ActiveSessionStorageManager.fileURLToFile(sessionURl);
        return new File(sessF, rfNm + "." + this.getAudioFileExtension());
    }

    public File sessionScriptFile() throws StorageManagerException {
        URL sessionDir = this.getSessionURL();
        if (!this.useAsCache) {
            try {
                File sessionDirAsFile = new File(sessionDir.toURI().getPath());
                File sessionScriptFile = new File(sessionDirAsFile, this.getSessionNamePart() + "_script.xml");
                return sessionScriptFile;
            }
            catch (URISyntaxException e) {
                throw new StorageManagerException(e);
            }
        }
        return null;
    }

    public URL sessionScriptURL() throws StorageManagerException {
        if (!this.useAsCache) {
            File ssf = this.sessionScriptFile();
            try {
                return ssf.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new StorageManagerException(e);
            }
        }
        return null;
    }

    public void storeSessionScriptFile(InputStream scriptStream) throws StorageManagerException {
        if (!this.useAsCache) {
            try {
                StreamCopy.copy((InputStream)scriptStream, (File)this.sessionScriptFile(), (boolean)true);
            }
            catch (IOException e) {
                throw new StorageManagerException(e);
            }
        }
    }

    private class PrefixNameFilter
    implements FilenameFilter {
        private File dir;
        private String prefix;

        public PrefixNameFilter(File dir, String prefix) {
            this.dir = dir;
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File arg0, String arg1) {
            return arg0.equals(this.dir) && arg1.startsWith(this.prefix);
        }
    }

    public static enum Status {
        CLOSED,
        OPEN;

    }
}

