/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.storage;

import ipsk.apps.speechrecorder.MetaData;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.db.speech.Project;
import ipsk.db.speech.PromptItem;
import ipsk.db.speech.Recording;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.Script;
import ipsk.db.speech.Session;
import ipsk.net.Utils;
import ipsk.text.NaturalNumberFormat;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;

public class SessionStorageManager {
    protected static final int DEF_SESSION_ID_FORMAT_DIGIT_COUNT = 4;
    public static String DEF_SESSION_ID_FORMAT = "0000";
    public static String DEF_SPEAKER_ID_FORMAT = "0000";
    public static String DEF_RECVERSION_FORMAT = "_00";
    protected URL storageURL = null;
    private boolean useSessionID = true;
    private boolean useScriptID = true;
    protected DecimalFormat speakerIDFormat;
    protected NumberFormat sessionIDFormat;
    protected DecimalFormat scriptIDFormat;
    protected int numLines = 1;
    protected AudioFileFormat.Type uploadType = null;
    protected DecimalFormat recVersionFormat;
    protected boolean createSpeakerDir = true;
    protected boolean createScriptDir = true;
    protected MetaData metadata = new MetaData();
    protected String scriptID;
    protected boolean overwrite;

    public SessionStorageManager() {
        this.sessionIDFormat = new NaturalNumberFormat(4);
        this.speakerIDFormat = new DecimalFormat(DEF_SESSION_ID_FORMAT);
        this.recVersionFormat = new DecimalFormat(DEF_RECVERSION_FORMAT);
        this.uploadType = AudioFileFormat.Type.WAVE;
    }

    public URL getStorageURL() {
        return this.storageURL;
    }

    public void setStorageURL(URL storageURL) {
        this.storageURL = storageURL;
    }

    public void setNumLines(int i) {
        this.numLines = i;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public AudioFileFormat.Type getUploadType() {
        return this.uploadType;
    }

    public DecimalFormat getSpeakerIDFormat() {
        return this.speakerIDFormat;
    }

    protected URL addQueryToURL(URL baseURL, String name, String value) throws MalformedURLException, UnsupportedEncodingException {
        Object filePart = baseURL.getFile();
        String urlEncName = URLEncoder.encode(name, "UTF-8");
        String urlEncValue = URLEncoder.encode(value, "UTF-8");
        filePart = baseURL.getQuery() == null ? (String)filePart + "?" + urlEncName + "=" + urlEncValue : (String)filePart + "&" + urlEncName + "=" + urlEncValue;
        URL url = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), (String)filePart);
        return url;
    }

    protected URL addDirToURL(URL baseURL, String dir) throws StorageManagerException {
        URL url;
        try {
            URI resUri = baseURL.toURI();
            String resUriPath = resUri.getPath();
            if (resUriPath == null) {
                throw new StorageManagerException("Could not get path from URI: " + resUri.toString());
            }
            String resPath = resUriPath.concat("/" + dir);
            resUri = new URI(resUri.getScheme(), resUri.getUserInfo(), resUri.getHost(), resUri.getPort(), resPath, resUri.getQuery(), resUri.getFragment());
            url = resUri.toURL();
        }
        catch (URISyntaxException e) {
            throw new StorageManagerException(e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new StorageManagerException(e.getMessage());
        }
        return url;
    }

    public URL getSessionURL(int sessionID) throws StorageManagerException {
        String tmpDir;
        String sessionDir = "";
        if (this.createSpeakerDir) {
            sessionDir = tmpDir = sessionDir.concat("/" + this.sessionIDFormat.format(sessionID));
        }
        if (this.createScriptDir && this.scriptID != null) {
            sessionDir = tmpDir = sessionDir.concat("/" + this.scriptIDFormat.format(this.scriptID));
        }
        URL sessionURL = this.storageURL;
        sessionURL = this.addDirToURL(this.storageURL, sessionDir);
        return sessionURL;
    }

    public String sessionIDString(int sessionID) {
        return this.sessionIDFormat.format(sessionID);
    }

    public File sessionDirForSessionID(int sessionID) throws StorageManagerException {
        URL sessURL = this.getSessionURL(sessionID);
        try {
            File sessDir = Utils.fileFromDecodedURL((URL)sessURL);
            return sessDir;
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageManagerException(e);
        }
    }

    protected String getSessionNamePart(int sessionID, String speakerCode) {
        String sessionFileName = "";
        if (speakerCode != null) {
            sessionFileName = sessionFileName.concat(speakerCode);
        }
        if (this.useSessionID) {
            sessionFileName = sessionFileName.concat(this.sessionIDString(sessionID));
        }
        if (this.useScriptID && this.scriptID != null) {
            sessionFileName = sessionFileName.concat(this.scriptID);
        }
        return sessionFileName;
    }

    public String getRootFileName(int sessionID, String promptCode, String speakerCode, int recVersion) {
        String rootFileName = this.getSessionNamePart(sessionID, speakerCode);
        rootFileName = rootFileName.concat(promptCode);
        if (!this.overwrite) {
            rootFileName = rootFileName.concat("_" + this.recVersionFormat.format(new Integer(recVersion)));
        }
        return rootFileName;
    }

    public URL[] generateAudioFileURLs(int sessionID, String speakerCode, String promptCode, int recVersion) throws StorageManagerException {
        String extension = this.uploadType.getExtension();
        URL[] audioFileURLs = new URL[this.numLines];
        URL sessionURL = this.getSessionURL(sessionID);
        for (int line = 0; line < this.numLines; ++line) {
            URL newURL = sessionURL;
            Object audioFileName = this.getRootFileName(sessionID, promptCode, speakerCode, recVersion);
            Object lineNr = this.numLines == 1 ? "" : "_" + line;
            audioFileName = (String)audioFileName + (String)lineNr + "." + extension;
            audioFileURLs[line] = newURL = this.addDirToURL(newURL, (String)audioFileName);
        }
        return audioFileURLs;
    }

    public boolean isRecorded(int sessionID, String speakerCode, String promptCode, int recVersion) throws StorageManagerException {
        boolean recorded = true;
        URL[] urls = this.generateAudioFileURLs(sessionID, speakerCode, promptCode, recVersion);
        for (int i = 0; i < this.numLines; ++i) {
            String path;
            try {
                path = urls[i].toURI().getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new StorageManagerException(e);
            }
            File f = new File(path);
            if (f.exists()) continue;
            recorded = false;
            break;
        }
        return recorded;
    }

    public boolean sessionHasRecordingFiles(Session sess) throws StorageManagerException {
        Script s = sess.getScript();
        List pis = s.promptItemsList();
        for (PromptItem pi : pis) {
            if (!(pi instanceof Recording)) continue;
            Recording r = (Recording)pi;
            int recVers = 0;
            boolean recordingFound = this.isRecorded(sess.getSessionId(), sess.getCode(), r.getItemcode(), recVers);
            if (!recordingFound) continue;
            return true;
        }
        return false;
    }

    public int getRecordedVersions(int sessionId, String sessionCode, String itemcode) throws StorageManagerException {
        int testRecversion = 0;
        while (this.isRecorded(sessionId, sessionCode, itemcode, testRecversion)) {
            ++testRecversion;
        }
        return testRecversion;
    }

    private boolean updateRecFile(Session sess, Recording r, int recVers) throws StorageManagerException {
        URL[] urls = this.generateAudioFileURLs(sess.getSessionId(), sess.getCode(), r.getItemcode(), recVers);
        boolean recorded = false;
        for (int i = 0; i < this.numLines; ++i) {
            String path;
            URL url = urls[i];
            try {
                path = url.toURI().getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new StorageManagerException(e);
            }
            File f = new File(path);
            if (!f.exists()) continue;
            recorded = true;
            RecordingFile rf = new RecordingFile();
            rf.setSession(sess);
            rf.setRecording(r);
            rf.setSignalFile(url.toExternalForm());
            sess.getRecordingFiles().add(rf);
        }
        return recorded;
    }

    public void updateRecFiles(Session sess, boolean recentVersionsOnly) throws StorageManagerException {
        Script s = sess.getScript();
        sess.setRecordingFiles(new HashSet());
        sess.markHasRecordings(null);
        List pis = s.promptItemsList();
        for (PromptItem pi : pis) {
            if (!(pi instanceof Recording)) continue;
            Recording r = (Recording)pi;
            if (this.overwrite) {
                this.updateRecFile(sess, r, 0);
                continue;
            }
            if (recentVersionsOnly) {
                int recVersions = this.getRecordedVersions(sess.getSessionId(), sess.getCode(), r.getItemcode());
                if (recVersions <= 0) continue;
                this.updateRecFile(sess, r, recVersions - 1);
                continue;
            }
            boolean recorded = false;
            int recVers = 0;
            do {
                recorded = this.updateRecFile(sess, r, recVers);
                ++recVers;
            } while (recorded);
        }
    }

    public Set<Session> sessionsLazy(Project prj, Script script) throws StorageManagerException {
        HashSet<Session> sSet = new HashSet<Session>();
        URL storeUrl = this.getStorageURL();
        if ("file".equalsIgnoreCase(storeUrl.getProtocol())) {
            File storeDir = null;
            try {
                storeDir = Utils.fileFromDecodedURL((URL)storeUrl);
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
                throw new StorageManagerException(e1);
            }
            if (storeDir.exists()) {
                DirectoryStream.Filter<Path> sessionDirFilter = new DirectoryStream.Filter<Path>(){

                    @Override
                    public boolean accept(Path file) throws IOException {
                        if (file.toFile().isDirectory()) {
                            String fn = file.getName(file.getNameCount() - 1).toString();
                            try {
                                Number sessionNr = SessionStorageManager.this.sessionIDFormat.parse(fn);
                                if (sessionNr != null) {
                                    return true;
                                }
                            }
                            catch (ParseException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                };
                Path storePath = storeDir.toPath();
                DirectoryStream<Path> storeDirStream = null;
                try {
                    storeDirStream = Files.newDirectoryStream(storePath, (DirectoryStream.Filter<? super Path>)sessionDirFilter);
                    for (Path sessionPath : storeDirStream) {
                        String sessionNm;
                        Path sessionPathLast = sessionPath.getName(sessionPath.getNameCount() - 1);
                        if (sessionPathLast == null || (sessionNm = sessionPathLast.toString()) == null) continue;
                        Number sessionNr = this.sessionIDFormat.parse(sessionNm);
                        Session s = new Session();
                        s.setProject(prj);
                        s.setStorageDirectoryURL(sessionPath.toUri().toURL().toString());
                        s.setSessionId(Integer.valueOf(sessionNr.intValue()));
                        s.setScript(script);
                        sSet.add(s);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new StorageManagerException(e);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new StorageManagerException(e);
                }
                finally {
                    if (storeDirStream != null) {
                        try {
                            storeDirStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new StorageManagerException(e);
                        }
                    }
                }
            }
        }
        return sSet;
    }

    public NumberFormat getSessionIDFormat() {
        return this.sessionIDFormat;
    }

    public void setSessionIDFormat(NumberFormat format) {
        this.sessionIDFormat = format;
    }

    public MetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetaData metadata) {
        this.metadata = metadata;
    }

    public boolean isUseScriptID() {
        return this.useScriptID;
    }

    public boolean isUseSpeakerID() {
        return this.useSessionID;
    }

    public void setUseScriptID(boolean b) {
        this.useScriptID = b;
    }

    public void setUseSpeakerID(boolean b) {
        this.useSessionID = b;
    }
}

