/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.ui;

import ipsk.swing.JDialogPanel;
import ipsk.swing.ZipFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ExportProjectUIDialog
extends JDialogPanel {
    private JCheckBox exportConfigAndScriptsOnlyCheckBox;
    private JTextField filePathField;
    private JButton browseButton;
    private JFileChooser fileChooser;
    private File exportFile;

    public File getExportFile() {
        return this.exportFile;
    }

    public void setExportFile(File exportFile) {
        this.exportFile = exportFile;
        if (exportFile != null) {
            this.setApplyingEnabled(true);
        }
        String path = exportFile.getAbsolutePath();
        this.filePathField.setText(path);
    }

    public ExportProjectUIDialog() {
        super(JDialogPanel.Options.OK_CANCEL);
        Insets ins;
        this.okButton.setText("Export");
        this.setFrameTitle("Export project");
        this.setApplyingEnabled(false);
        JPanel cfgP = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = ins = new Insets(1, 1, 1, 1);
        gc.gridx = 0;
        gc.gridy = 0;
        this.exportConfigAndScriptsOnlyCheckBox = new JCheckBox("Export project configuration and scripts with resources only (without speaker database and recording files)");
        this.exportConfigAndScriptsOnlyCheckBox.setSelected(false);
        gc.gridwidth = 2;
        cfgP.add((Component)this.exportConfigAndScriptsOnlyCheckBox, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        cfgP.add((Component)new JLabel("ZIP file:"), gc);
        ++gc.gridx;
        gc.weightx = 2.0;
        gc.fill = 2;
        this.filePathField = new JTextField(20);
        cfgP.add((Component)this.filePathField, gc);
        this.browseButton = new JButton("Browse...");
        ++gc.gridx;
        gc.fill = 0;
        gc.weightx = 0.0;
        cfgP.add((Component)this.browseButton, gc);
        this.browseButton.addActionListener((ActionListener)((Object)this));
        this.getContentPane().add(cfgP);
    }

    public boolean isExportSessionData() {
        return !this.exportConfigAndScriptsOnlyCheckBox.isSelected();
    }

    protected void applyValues() {
        String path = this.filePathField.getText();
        Object exportFile = null;
        if (!"".equals(path)) {
            this.setExportFile(new File(path));
        }
        super.applyValues();
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.browseButton) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileFilter((FileFilter)new ZipFileFilter());
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setSelectedFile(this.exportFile);
            int res = this.fileChooser.showDialog((Component)((Object)this), "Select");
            if (res == 0) {
                this.setExportFile(this.fileChooser.getSelectedFile());
            }
        } else {
            super.actionPerformed(ae);
        }
    }
}

