/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.workspace;

import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.config.ConfigHelper;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.config.SpeakersConfiguration;
import ipsk.apps.speechrecorder.config.WorkspaceProject;
import ipsk.apps.speechrecorder.db.export.emu.EmuExportWorker;
import ipsk.apps.speechrecorder.project.ProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptHandlerException;
import ipsk.apps.speechrecorder.workspace.WorkspaceException;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.io.FileUtils;
import ipsk.io.StreamCopy;
import ipsk.net.URLContext;
import ipsk.net.Utils;
import ipsk.swing.JProgressDialogPanel;
import ipsk.util.ProgressStatus;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;

public class WorkspaceManager
extends AbstractListModel<String> {
    private static final long serialVersionUID = 1L;
    public static final String PROJECT_CONFIG_PACKAGE = "ipsk.apps.speechrecorder.config.ProjectConfiguration";
    public static final int COL_NAME = 0;
    private File workspaceDir = null;
    private SpeechRecorder speechRecorder;
    private List<WorkspaceProject> workspaceProjects = new ArrayList<WorkspaceProject>();
    private PropertyChangeSupport propertyChangeSupport;
    private HashSet<String> lockedProjects = new HashSet();

    public WorkspaceManager(File workspaceDir, SpeechRecorder speechRecorder) {
        this.speechRecorder = speechRecorder;
        this.workspaceDir = workspaceDir;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void lock(String projectName) {
        HashSet oldlockedPrjs = (HashSet)this.lockedProjects.clone();
        this.lockedProjects.add(projectName);
        this.propertyChangeSupport.firePropertyChange("lockedProjects", oldlockedPrjs, this.lockedProjects);
    }

    public void unlock(String projectName) {
        HashSet oldlockedPrjs = (HashSet)this.lockedProjects.clone();
        this.lockedProjects.remove(projectName);
        this.propertyChangeSupport.firePropertyChange("lockedProjects", oldlockedPrjs, this.lockedProjects);
    }

    public boolean locked(String projectName) {
        return this.lockedProjects.contains(projectName);
    }

    public boolean hasLock() {
        return !this.lockedProjects.isEmpty();
    }

    public boolean locked(WorkspaceProject workspaceProject) {
        ProjectConfiguration prjCfg;
        if (workspaceProject != null && (prjCfg = workspaceProject.getConfiguration()) != null) {
            String projectName = prjCfg.getName();
            return this.locked(projectName);
        }
        return false;
    }

    public WorkspaceProject[] scanWorkspace() throws WorkspaceException {
        File[] projectDirs;
        DOMCodec domCodec;
        Package configBasePack;
        this.fireIntervalRemoved(this, 0, this.workspaceProjects.size());
        DOMConverter domConverter = new DOMConverter();
        try {
            configBasePack = Class.forName(PROJECT_CONFIG_PACKAGE).getPackage();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
            throw new WorkspaceException("Package ipsk.apps.speechrecorder.config.ProjectConfiguration", e1);
        }
        try {
            domCodec = new DOMCodec(configBasePack);
        }
        catch (DOMCodecException e1) {
            e1.printStackTrace();
            throw new WorkspaceException("Could not create DOM codec", e1);
        }
        ArrayList<WorkspaceProject> newWorkspaceProjectsList = new ArrayList<WorkspaceProject>();
        if (this.workspaceDir.exists() && (projectDirs = this.workspaceDir.listFiles()) != null) {
            for (int i = 0; i < projectDirs.length; ++i) {
                File[] projectFiles;
                String projNameByDirName;
                File projectDir = projectDirs[i];
                if (projectDir == null || !projectDir.isDirectory() || projectDir.isHidden()) continue;
                File projectConfigFile = null;
                String projName = projNameByDirName = projectDir.getName();
                String standardProjectFilename = projNameByDirName + "_project.prj";
                File standardProjectFile = new File(projectDir, standardProjectFilename);
                if (standardProjectFile.exists()) {
                    projectConfigFile = standardProjectFile;
                }
                if (projectConfigFile == null && (projectFiles = projectDir.listFiles()) != null) {
                    for (int j = 0; j < projectFiles.length; ++j) {
                        File projectFile = projectFiles[j];
                        if (!projectFile.isFile() || projectFile.isHidden() || !projectFile.getName().endsWith("_project.prj")) continue;
                        if (projectConfigFile != null) {
                            throw new WorkspaceException("Multiple project file candidates in " + projNameByDirName + ": " + projectConfigFile.getName() + " ," + projectFile.getName());
                        }
                        projectConfigFile = projectFile;
                    }
                }
                if (projectConfigFile == null) continue;
                ProjectConfiguration p = null;
                try {
                    Document d = domConverter.readXML((InputStream)new FileInputStream(projectConfigFile));
                    p = (ProjectConfiguration)domCodec.readDocument(d);
                    projName = p.getName();
                }
                catch (Exception d) {
                    // empty catch block
                }
                WorkspaceProject wp = new WorkspaceProject(projName, p, projectConfigFile);
                newWorkspaceProjectsList.add(wp);
            }
        }
        List<WorkspaceProject> oldWorkspaceProjects = this.workspaceProjects;
        this.workspaceProjects = newWorkspaceProjectsList;
        this.propertyChangeSupport.firePropertyChange("workspaceProjects", oldWorkspaceProjects, this.workspaceProjects);
        this.fireIntervalAdded(this, 0, this.workspaceProjects.size());
        return newWorkspaceProjectsList.toArray(new WorkspaceProject[0]);
    }

    public String getColumnName(int colIndex) {
        if (colIndex == 0) {
            return "Name";
        }
        return null;
    }

    public Class<?> getColumnClass(int colIndex) {
        if (colIndex == 0) {
            return String.class;
        }
        return null;
    }

    public File getWorkspaceDir() {
        return this.workspaceDir;
    }

    public List<WorkspaceProject> getWorkspaceProjects() {
        return this.workspaceProjects;
    }

    public WorkspaceProject projectByName(String name) {
        for (WorkspaceProject wp : this.workspaceProjects) {
            String wpName;
            ProjectConfiguration pc = wp.getConfiguration();
            if (pc == null || !(wpName = pc.getName()).equals(name)) continue;
            return wp;
        }
        return null;
    }

    public void openProject(String projectName) throws WorkspaceException {
        try {
            this.speechRecorder.openProject(projectName);
        }
        catch (SpeechRecorderException e) {
            throw new WorkspaceException(e);
        }
    }

    public void exportToEmuDB(URL projectContext, ProjectConfiguration prCfg, Path outDir) throws WorkspaceException {
        try {
            EmuExportWorker emuExporter = new EmuExportWorker();
            emuExporter.setProjectContext(projectContext);
            emuExporter.config(prCfg);
            emuExporter.setExportBasepath(outDir);
            JProgressDialogPanel progressDialog = new JProgressDialogPanel((Worker)emuExporter, "Export project to EmuDB", "Exporting...");
            emuExporter.open();
            emuExporter.start();
            JFrame parent = null;
            Object val = progressDialog.showDialog(parent);
            ProgressStatus finalStatus = emuExporter.getProgressStatus();
            emuExporter.close();
            if (val.equals(2)) {
                finalStatus.canceled();
            }
            if (!finalStatus.isDone() && finalStatus.isError()) {
                JOptionPane.showMessageDialog(null, finalStatus.getMessage(), "EMU export error", 0);
            }
        }
        catch (ProjectManagerException | WorkerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "EMU export ", 0);
        }
    }

    public void renameProject(String oldName, String newName) throws WorkspaceException {
        File projectOldBkpFile;
        block27: {
            ConfigHelper ch;
            String newRecsUrlStr;
            URL oldPrjDirURL;
            WorkspaceProject wp = this.projectByName(oldName);
            ProjectConfiguration wpPc = wp.getConfiguration();
            if (this.locked(wp)) {
                throw new WorkspaceException("Project " + wpPc.getName() + " is in use.");
            }
            File wsPDir = new File(this.workspaceDir, oldName);
            URI oldPrjDirURI = wsPDir.toURI();
            try {
                oldPrjDirURL = oldPrjDirURI.toURL();
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
                throw new WorkspaceException(e2);
            }
            URLContext oldPrjCtx = new URLContext(oldPrjDirURL);
            File newWsPDir = new File(this.workspaceDir, newName);
            if (newWsPDir.exists()) {
                throw new WorkspaceException("Could not rename project: Path " + newWsPDir + " already exists!");
            }
            boolean renamed = wsPDir.renameTo(newWsPDir);
            if (!renamed) {
                throw new WorkspaceException("Could not rename folder " + wsPDir + " to " + newWsPDir);
            }
            URL dirURL = null;
            URI dirURI = newWsPDir.toURI();
            try {
                dirURL = dirURI.toURL();
            }
            catch (MalformedURLException e1) {
                throw new WorkspaceException("Could not convert to URL: " + dirURL + ": " + e1.getMessage());
            }
            wpPc.setName(newName);
            RecordingConfiguration recCfg = wpPc.getRecordingConfiguration();
            String recsUrlStr = recCfg.getUrl();
            try {
                newRecsUrlStr = oldPrjCtx.renameContextSpec(dirURL, recsUrlStr);
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
                throw new WorkspaceException(e2);
            }
            recCfg.setUrl(newRecsUrlStr);
            File oldProjectFile = new File(newWsPDir, oldName + "_project.prj");
            File newProjectFile = new File(newWsPDir, newName + "_project.prj");
            try {
                ch = new ConfigHelper();
            }
            catch (DOMCodecException | ClassNotFoundException e2) {
                throw new WorkspaceException(e2);
            }
            try {
                ch.writeConfig(wpPc, newProjectFile);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new WorkspaceException(e1);
            }
            projectOldBkpFile = FileUtils.moveToBackup((File)oldProjectFile, (String)".bak");
            this.scanWorkspace();
            WorkspaceProject newWsp = this.projectByName(newName);
            ProjectConfiguration pc = newWsp.getConfiguration();
            try {
                String newPromptsFn;
                File newPromptsFile;
                String oldPromptsFileName;
                URL promptsURL;
                File promptsFile;
                PromptConfiguration prCfg;
                String prUrl;
                SpeakersConfiguration spksCfg = pc.getSpeakers();
                String spksUrl = spksCfg.getSpeakersUrl();
                if (spksUrl != null && !spksUrl.equals("")) {
                    String newSpksFn;
                    File newSpksFile;
                    String oldSpksFileName;
                    File spksParent;
                    URL speakerURL;
                    File spksFile;
                    String newSpksSpec = oldPrjCtx.renameContextSpec(dirURL, spksUrl);
                    if (!spksUrl.equals(newSpksSpec)) {
                        spksCfg.setSpeakersUrl(newSpksSpec);
                        ch.writeConfig(pc, newProjectFile);
                    }
                    if ((spksFile = Utils.fileFromDecodedURL((URL)(speakerURL = URLContext.getContextURL((URL)dirURL, (String)newSpksSpec)))) != null && newWsPDir.equals(spksParent = spksFile.getParentFile()) && (oldSpksFileName = spksFile.getName()).startsWith(oldName) && !(newSpksFile = new File(spksParent, newSpksFn = oldSpksFileName.replaceFirst("^" + oldName, newName))).exists() && spksFile.renameTo(newSpksFile)) {
                        spksCfg.setSpeakersUrl(newSpksFn);
                        ch.writeConfig(pc, newProjectFile);
                    }
                }
                if ((prUrl = (prCfg = pc.getPromptConfiguration()).getPromptsUrl()) == null || prUrl.equals("")) break block27;
                String newPromptSpec = oldPrjCtx.renameContextSpec(dirURL, prUrl);
                if (!prUrl.equals(newPromptSpec)) {
                    prCfg.setPromptsUrl(newPromptSpec);
                    ch.writeConfig(pc, newProjectFile);
                }
                if ((promptsFile = Utils.fileFromDecodedURL((URL)(promptsURL = URLContext.getContextURL((URL)dirURL, (String)newPromptSpec)))) == null) break block27;
                RecscriptHandler scriptHandler = new RecscriptHandler();
                String contextUrlStr = Utils.createAsciiURLExtFormFromFile((File)newWsPDir);
                scriptHandler.setSystemIdBase(contextUrlStr);
                try {
                    scriptHandler.renameContext(promptsFile, oldPrjDirURL, dirURL);
                }
                catch (RecscriptHandlerException e) {
                    e.printStackTrace();
                    throw new WorkspaceException("Could not rename recording script context: " + e.getLocalizedMessage(), e);
                }
                File promptsParent = promptsFile.getParentFile();
                if (newWsPDir.equals(promptsParent) && (oldPromptsFileName = promptsFile.getName()).startsWith(oldName) && !(newPromptsFile = new File(promptsParent, newPromptsFn = oldPromptsFileName.replaceFirst("^" + oldName, newName))).exists() && promptsFile.renameTo(newPromptsFile)) {
                    prCfg.setPromptsUrl(newPromptsFn);
                    ch.writeConfig(pc, newProjectFile);
                }
            }
            catch (MalformedURLException e) {
                throw new WorkspaceException(e);
            }
            catch (DOMCodecException e) {
                throw new WorkspaceException(e);
            }
            catch (DOMConverterException e) {
                throw new WorkspaceException(e);
            }
            catch (IOException e) {
                throw new WorkspaceException(e);
            }
            catch (URISyntaxException e) {
                throw new WorkspaceException(e);
            }
        }
        if (projectOldBkpFile != null) {
            projectOldBkpFile.delete();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public String getElementAt(int rowIndex) {
        WorkspaceProject proj = this.workspaceProjects.get(rowIndex);
        return proj.getName();
    }

    @Override
    public int getSize() {
        return this.workspaceProjects.size();
    }

    public void closeActiveProject() throws WorkspaceException {
        try {
            this.speechRecorder.closeActiveProject();
        }
        catch (SpeechRecorderException e) {
            throw new WorkspaceException(e);
        }
    }

    public void duplicateProject(String currentName, String newName) throws WorkspaceException, ProjectManagerException {
        URL newPromptsUrl;
        Object newPromptsUrlStr;
        String newRecsUrlStr;
        URL orgPromptsUrl;
        URL oldPrjDirURL;
        ProjectConfiguration dupPc;
        ConfigHelper ch;
        WorkspaceProject wp = this.projectByName(currentName);
        ProjectConfiguration orgPc = wp.getConfiguration();
        if (this.locked(wp)) {
            throw new WorkspaceException("Project " + orgPc.getName() + " is in use.");
        }
        try {
            ch = new ConfigHelper();
        }
        catch (DOMCodecException | ClassNotFoundException e) {
            throw new WorkspaceException(e);
        }
        ProjectManager dupProjectManager = new ProjectManager();
        try {
            dupPc = ch.cloneConfiguration(orgPc);
        }
        catch (DOMCodecException e) {
            throw new WorkspaceException(e);
        }
        File wsPDir = new File(this.workspaceDir, currentName);
        URI oldPrjDirURI = wsPDir.toURI();
        try {
            oldPrjDirURL = oldPrjDirURI.toURL();
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            throw new WorkspaceException(e2);
        }
        URLContext oldPrjCtx = new URLContext(oldPrjDirURL);
        PromptConfiguration promptCfg = dupPc.getPromptConfiguration();
        String orgPromptsUrlStr = promptCfg.getPromptsUrl();
        try {
            orgPromptsUrl = oldPrjCtx.getContextURL(orgPromptsUrlStr);
            if (!orgPromptsUrl.getProtocol().equalsIgnoreCase("file")) {
                throw new WorkspaceException("To duplicate the project the prompts URL must be a file !");
            }
        }
        catch (MalformedURLException e) {
            throw new WorkspaceException(e);
        }
        File newWsPDir = new File(this.workspaceDir, newName);
        if (newWsPDir.exists()) {
            throw new WorkspaceException("Could not duplicate project: Path " + newWsPDir + " already exists!");
        }
        try {
            Files.createDirectory(newWsPDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new WorkspaceException("Could not create folder " + newWsPDir);
        }
        URL dirURL = null;
        URI dirURI = newWsPDir.toURI();
        try {
            dirURL = dirURI.toURL();
        }
        catch (MalformedURLException e1) {
            throw new WorkspaceException("Could not convert to URL: " + dirURL + ": " + e1.getMessage());
        }
        dupPc.setName(newName);
        SpeakersConfiguration dupSpkCfg = dupPc.getSpeakers();
        dupSpkCfg.setSpeakersUrl(newName + "_speakers.xml");
        File speakersFile = new File(newWsPDir, dupSpkCfg.getSpeakersUrl());
        dupProjectManager.createEmptySpeakerDatabase(speakersFile, false);
        RecordingConfiguration recCfg = dupPc.getRecordingConfiguration();
        String recsUrlStr = recCfg.getUrl();
        try {
            newRecsUrlStr = oldPrjCtx.renameContextSpec(dirURL, recsUrlStr);
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            throw new WorkspaceException(e2);
        }
        recCfg.setUrl(newRecsUrlStr);
        URLContext newPrjCtx = new URLContext(dirURL);
        try {
            newPromptsUrlStr = orgPromptsUrlStr.equals(currentName + "_script.xml") ? newName + "_script.xml" : oldPrjCtx.renameContextSpec(dirURL, orgPromptsUrlStr);
            newPromptsUrl = newPrjCtx.getContextURL((String)newPromptsUrlStr);
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            throw new WorkspaceException(e2);
        }
        try {
            File[] orgDtdFiles;
            File orgScriptFile = Utils.fileFromDecodedURL((URL)orgPromptsUrl);
            File newScriptFile = Utils.fileFromDecodedURL((URL)newPromptsUrl);
            File orgScriptDir = orgScriptFile.getParentFile();
            File newScriptDir = newScriptFile.getParentFile();
            for (File orgDtdFile : orgDtdFiles = orgScriptDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches("SpeechRecPrompts.*[.]dtd");
                }
            })) {
                File newDtdFile = new File(newScriptDir, orgDtdFile.getName());
                StreamCopy.copy((File)orgDtdFile, (File)newDtdFile, (boolean)true);
            }
            StreamCopy.copy((File)orgScriptFile, (File)newScriptFile, (boolean)true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        promptCfg.setPromptsUrl((String)newPromptsUrlStr);
        File newProjectFile = new File(newWsPDir, newName + "_project.prj");
        try {
            ch.writeConfig(dupPc, newProjectFile);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new WorkspaceException(e1);
        }
        this.scanWorkspace();
    }
}

