/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.workspace.ui;

import ipsk.io.FilenameValidator;
import ipsk.util.LocalizableMessage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ProjectDuplicateDialog
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private JTextField nameField;
    private static JButton okButton;
    private static JButton cancelButton;
    private static JOptionPane selPane;
    private Document nameDoc;
    private JTextField statusLabel;
    private DuplicateModel duplicateModel;
    private String originalName;
    private List<String> existingNames;

    public ProjectDuplicateDialog(List<String> existingProjectNames, DuplicateModel duplicateModel) {
        super(new GridBagLayout());
        this.existingNames = existingProjectNames;
        this.duplicateModel = duplicateModel;
        this.originalName = duplicateModel.getOriginalName();
        okButton = new JButton("OK");
        okButton.setEnabled(false);
        okButton.addActionListener(this);
        cancelButton = new JButton("Cancel");
        cancelButton.setEnabled(true);
        cancelButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Project name of duplicate"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new JTextField(20);
        this.nameDoc = this.nameField.getDocument();
        this.nameDoc.addDocumentListener(this);
        this.add((Component)this.nameField, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 2.0;
        c.fill = 2;
        this.statusLabel = new JTextField(30);
        this.statusLabel.setEditable(false);
        this.add((Component)this.statusLabel, c);
        this.nameField.setText(this.originalName);
    }

    public static Object showDialog(Component parent, List<String> existingProjects, DuplicateModel renameModel) {
        ProjectDuplicateDialog pv = new ProjectDuplicateDialog(existingProjects, renameModel);
        selPane = new JOptionPane(pv, -1, 2, null, new Object[]{okButton, cancelButton});
        JDialog dialog = selPane.createDialog(parent, "Duplicate Project");
        dialog.setVisible(true);
        return selPane.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == okButton) {
            selPane.setValue(0);
        } else if (src == cancelButton) {
            selPane.setValue(2);
        }
    }

    public String getNewName() {
        return null;
    }

    private void documentChanged(Document d) {
        if (d == this.nameDoc) {
            String name = this.nameField.getText();
            if ("".equals(name)) {
                this.statusLabel.setText("Project name must not be empty.");
                okButton.setEnabled(false);
            } else if (this.originalName.equals(name)) {
                this.statusLabel.setText("Name of duplicate project must differ.");
                okButton.setEnabled(false);
            } else if (this.existingNames.contains(name)) {
                this.statusLabel.setText("Project with this name already exists.");
                okButton.setEnabled(false);
            } else {
                FilenameValidator.ValidationResult vr = FilenameValidator.validate((String)name);
                if (vr.isValid()) {
                    this.statusLabel.setText("");
                    this.duplicateModel.setNewName(name);
                    okButton.setEnabled(true);
                } else {
                    LocalizableMessage lm = vr.getMessage();
                    String locText = lm.localize();
                    this.statusLabel.setText(locText);
                    okButton.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }

    public static class DuplicateModel {
        private String originalName;
        private String newName;

        public DuplicateModel(String originalName) {
            this.originalName = originalName;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public boolean changed() {
            if (this.originalName != null) {
                return !this.originalName.equals(this.newName);
            }
            return false;
        }
    }
}

