/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.workspace.ui;

import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.WorkspaceProject;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.ui.ExportProjectUIDialog;
import ipsk.apps.speechrecorder.workspace.WorkspaceException;
import ipsk.apps.speechrecorder.workspace.WorkspaceManager;
import ipsk.apps.speechrecorder.workspace.ui.ProjectDeleteDialog;
import ipsk.apps.speechrecorder.workspace.ui.ProjectDuplicateDialog;
import ipsk.apps.speechrecorder.workspace.ui.ProjectEmuDBExportDialog;
import ipsk.apps.speechrecorder.workspace.ui.ProjectExporter;
import ipsk.apps.speechrecorder.workspace.ui.ProjectRenameDialog;
import ipsk.net.Utils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;

public class WorkspaceProjectsPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ListDataListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private WorkspaceManager workspaceManager;
    private JScrollPane projectsScrollPane;
    private JList<String> projectsList;
    private JMenuItem openMi;
    private JMenuItem closeMi;
    private JMenu exportMenu;
    private JMenuItem exportToArchMi;
    private JMenuItem exportToEmuDBMi;
    private JMenuItem deleteMi;
    private JMenuItem renameMi;
    private JMenuItem duplicateMi;
    private ListSelectionModel listSelectionModel;

    public WorkspaceProjectsPanel(WorkspaceManager workspaceManager) {
        super(new GridBagLayout());
        this.workspaceManager = workspaceManager;
        this.workspaceManager.addListDataListener(this);
        this.workspaceManager.addPropertyChangeListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.projectsList = new JList<String>(workspaceManager);
        this.projectsList.setSelectionMode(0);
        this.listSelectionModel = this.projectsList.getSelectionModel();
        this.listSelectionModel.addListSelectionListener(this);
        this.projectsScrollPane = new JScrollPane(this.projectsList);
        this.add((Component)this.projectsScrollPane, c);
        this.openMi = new JMenuItem("Open");
        this.openMi.addActionListener(this);
        this.closeMi = new JMenuItem("Close");
        this.closeMi.addActionListener(this);
        this.exportMenu = new JMenu("Export");
        this.exportToArchMi = new JMenuItem("Export to SpeechRecorder project Zip archive...");
        this.exportToArchMi.addActionListener(this);
        this.exportMenu.add(this.exportToArchMi);
        this.exportToEmuDBMi = new JMenuItem("Export as EMU-DB...");
        this.exportToEmuDBMi.addActionListener(this);
        this.exportMenu.add(this.exportToEmuDBMi);
        this.deleteMi = new JMenuItem("Delete...");
        this.deleteMi.addActionListener(this);
        this.renameMi = new JMenuItem("Rename...");
        this.renameMi.addActionListener(this);
        this.duplicateMi = new JMenuItem("Duplicate configuration and script...");
        this.duplicateMi.addActionListener(this);
        JPopupMenu jPopupMenu = new JPopupMenu(){
            private static final long serialVersionUID = 1L;

            @Override
            public void show(Component invoker, int x, int y) {
                int row = WorkspaceProjectsPanel.this.projectsList.locationToIndex(new Point(x, y));
                if (row != -1) {
                    WorkspaceProjectsPanel.this.projectsList.setSelectedIndex(row);
                }
                super.show(invoker, x, y);
            }
        };
        jPopupMenu.add(this.openMi);
        jPopupMenu.add(this.closeMi);
        jPopupMenu.add(this.exportMenu);
        jPopupMenu.add(this.deleteMi);
        jPopupMenu.add(this.renameMi);
        jPopupMenu.add(this.duplicateMi);
        this.projectsList.setComponentPopupMenu(jPopupMenu);
        this.updateUIDependencies();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String currentName;
        ProjectDuplicateDialog.DuplicateModel dpM;
        Object res;
        Object src = ae.getSource();
        WorkspaceProject selProj = null;
        int selRow = this.projectsList.getSelectedIndex();
        if (selRow >= 0) {
            selProj = this.workspaceManager.getWorkspaceProjects().get(selRow);
        }
        if ((src == this.openMi || src == this.exportToEmuDBMi || src == this.exportToArchMi || src == this.deleteMi || src == this.renameMi || src == this.duplicateMi) && selProj != null && this.workspaceManager.locked(selProj)) {
            String msg = "Please close project first.";
            JOptionPane.showMessageDialog(this, msg, "Project", 1);
            return;
        }
        if (src == this.openMi) {
            if (selProj != null) {
                try {
                    this.workspaceManager.openProject(selProj.getName());
                }
                catch (WorkspaceException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not open project: \n" + e.getLocalizedMessage(), "Project open error", 0);
                }
            }
        } else if (src == this.closeMi) {
            if (selProj != null) {
                try {
                    this.workspaceManager.closeActiveProject();
                }
                catch (WorkspaceException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not close project: \n" + e.getLocalizedMessage(), "Project close error", 0);
                }
            }
        } else if (src == this.exportToArchMi) {
            if (selProj != null) {
                ProjectConfiguration selPrjCfg = selProj.getConfiguration();
                File projectDir = new File(this.workspaceManager.getWorkspaceDir(), selPrjCfg.getName());
                try {
                    URL projectContext = Utils.createAsciiURLFromFile((File)projectDir);
                    this.exportProjectAsZipArchive(projectContext, selPrjCfg);
                }
                catch (MalformedURLException | URISyntaxException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Could not export project:\n" + e.getLocalizedMessage(), "Export project error!", 0);
                }
            }
        } else if (src == this.exportToEmuDBMi) {
            if (selProj != null) {
                ProjectConfiguration selPrjCfg = selProj.getConfiguration();
                File projectDir = new File(this.workspaceManager.getWorkspaceDir(), selPrjCfg.getName());
                ProjectEmuDBExportDialog peed = new ProjectEmuDBExportDialog(selProj, projectDir);
                Object res2 = peed.showDialog(this);
                if (res2.equals(0)) {
                    try {
                        URL projectContext = Utils.createAsciiURLFromFile((File)projectDir);
                        this.workspaceManager.exportToEmuDB(projectContext, selPrjCfg, peed.getBaseDir());
                    }
                    catch (WorkspaceException | MalformedURLException | URISyntaxException e) {
                        JOptionPane.showMessageDialog(this, "Could not export project to EmuDB:\n" + e.getLocalizedMessage(), "emuDB export project error!", 0);
                    }
                }
            }
        } else if (src == this.deleteMi) {
            if (selProj != null) {
                File projectDir = new File(this.workspaceManager.getWorkspaceDir(), selProj.getConfiguration().getName());
                ProjectDeleteDialog projdelDlg = new ProjectDeleteDialog(selProj, projectDir);
                projdelDlg.showDialog(this);
                try {
                    this.workspaceManager.scanWorkspace();
                }
                catch (WorkspaceException e) {
                    JOptionPane.showMessageDialog(this, "Workspace scan error:\n" + e.getLocalizedMessage(), "Workspace scan error!", 0);
                }
            }
        } else if (src == this.renameMi) {
            String currentName2;
            ProjectRenameDialog.RenameModel rnM;
            Object res3;
            if (selProj != null && (res3 = ProjectRenameDialog.showDialog(this, new ArrayList<String>(), rnM = new ProjectRenameDialog.RenameModel(currentName2 = selProj.getConfiguration().getName()))).equals(0) && rnM.changed()) {
                try {
                    this.workspaceManager.renameProject(currentName2, rnM.getNewName());
                }
                catch (WorkspaceException e) {
                    JOptionPane.showMessageDialog(this, "Could not rename project:\n" + e.getLocalizedMessage(), "Rename project error!", 0);
                }
            }
        } else if (src == this.duplicateMi && selProj != null && (res = ProjectDuplicateDialog.showDialog(this, new ArrayList<String>(), dpM = new ProjectDuplicateDialog.DuplicateModel(currentName = selProj.getConfiguration().getName()))).equals(0) && dpM.changed()) {
            try {
                this.workspaceManager.duplicateProject(currentName, dpM.getNewName());
            }
            catch (ProjectManagerException | WorkspaceException e) {
                JOptionPane.showMessageDialog(this, "Could not duplicate project:\n" + e.getLocalizedMessage(), "Duplicate project error!", 0);
            }
        }
        this.updateUIDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProjectAsZipArchive(URL projectContext, ProjectConfiguration prCfg) {
        File file;
        String suggestedExportBaseDirName = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        File suggestedExportBaseDir = new File(suggestedExportBaseDirName);
        File suggestedExportFile = new File(suggestedExportBaseDir, prCfg.getName() + ".zip");
        ExportProjectUIDialog epd = new ExportProjectUIDialog();
        epd.setExportFile(suggestedExportFile);
        Object returnVal = epd.showDialog(this);
        if (!(returnVal.equals(2) || (file = epd.getExportFile()).exists() && JOptionPane.showConfirmDialog(this, file.getName() + " exists. Do you want to overwrite ?", "Overwrite file ?", 0) != 0)) {
            this.setCursor(new Cursor(3));
            ProjectExporter pe = new ProjectExporter();
            try {
                pe.exportProject(projectContext, prCfg, file, epd.isExportSessionData(), this);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project export", 0);
                e.printStackTrace();
            }
            finally {
                this.setCursor(null);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        this.updateUIDependencies();
    }

    private void updateUIDependencies() {
        WorkspaceProject selProj = null;
        int selRow = this.projectsList.getSelectedIndex();
        if (selRow >= 0) {
            selProj = this.workspaceManager.getWorkspaceProjects().get(selRow);
            boolean hasLock = this.workspaceManager.hasLock();
            boolean selPrjLocked = this.workspaceManager.locked(selProj);
            this.openMi.setEnabled(!hasLock && !selPrjLocked);
            this.closeMi.setEnabled(selPrjLocked);
            this.exportMenu.setEnabled(!selPrjLocked);
            this.exportToArchMi.setEnabled(!selPrjLocked);
            this.exportToEmuDBMi.setEnabled(!selPrjLocked);
            this.renameMi.setEnabled(!selPrjLocked);
            this.deleteMi.setEnabled(!selPrjLocked);
            this.duplicateMi.setEnabled(!selPrjLocked);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent arg0) {
        this.updateUIDependencies();
    }

    @Override
    public void intervalAdded(ListDataEvent arg0) {
        this.updateUIDependencies();
    }

    @Override
    public void intervalRemoved(ListDataEvent arg0) {
        this.updateUIDependencies();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        this.updateUIDependencies();
    }
}

