/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import java.util.Locale;

public abstract class MIMETypes {
    public static final String PLAINTEXTMIMETYPE = "text/plain";
    public static final String FORMATTEDPROMPTTEXTMIMETYPE = "text/x-prompt";
    public static final String[] PLAINTEXTMIMETYPES = new String[]{"text/plain"};
    public static final String[] FALSE_PLAINTEXTMIMETYPES = new String[]{"text/UTF-8", "text/ISO-8859-1"};
    public static final String[] FORMATTEDTEXTMIMETYPES = new String[]{"text/html", "text/rtf"};
    public static final String[] IMAGEMIMETYPES = new String[]{"image/jpeg", "image/png"};
    public static final String[] IMAGEICONMIMETYPES = new String[]{"image/gif"};
    public static final String[] AUDIOMIMETYPES = new String[]{"audio/wav", "audio/x-wav", "audio/wave", "audio/x-wave", "audio/vnd.wave", "audio/aif", "audio/basic"};

    public static boolean isOfType(String mime, String[] givenMIMETypes) {
        boolean isEqual = false;
        for (int i = 0; i < givenMIMETypes.length && !isEqual; ++i) {
            isEqual = mime.toLowerCase(Locale.ENGLISH).equals(givenMIMETypes[i].toLowerCase(Locale.ENGLISH));
        }
        return isEqual;
    }

    public static String getType(String mime) {
        String majorTypeStr = mime.substring(0, mime.indexOf("/"));
        if (majorTypeStr != null) {
            return majorTypeStr.trim();
        }
        return null;
    }

    public static boolean isTextType(String mime) {
        String mimeMajorType = MIMETypes.getType(mime);
        return mimeMajorType.equalsIgnoreCase("text");
    }

    public static boolean isMediaType(String mime) {
        String mimeMajorType = MIMETypes.getType(mime);
        return mimeMajorType.startsWith("image") || mimeMajorType.startsWith("audio") || mimeMajorType.startsWith("video");
    }

    public static String getDescription(String mime) {
        return mime.substring(mime.indexOf("/") + 1, mime.length());
    }

    public static String[] getAllMimeTypes() {
        int i;
        String[] allTypes = new String[1 + FORMATTEDTEXTMIMETYPES.length + IMAGEMIMETYPES.length + AUDIOMIMETYPES.length];
        int offset = 0;
        allTypes[offset] = PLAINTEXTMIMETYPE;
        ++offset;
        for (i = 0; i < FORMATTEDTEXTMIMETYPES.length; ++i) {
            allTypes[i + offset] = FORMATTEDTEXTMIMETYPES[i];
        }
        offset += FORMATTEDTEXTMIMETYPES.length;
        for (i = 0; i < IMAGEMIMETYPES.length; ++i) {
            allTypes[i + offset] = IMAGEMIMETYPES[i];
        }
        offset += IMAGEMIMETYPES.length;
        for (i = 0; i < AUDIOMIMETYPES.length; ++i) {
            allTypes[i + offset] = AUDIOMIMETYPES[i];
        }
        return allTypes;
    }
}

