/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ipsk.apps.speechrecorder.Speaker;
import ipsk.apps.speechrecorder.SpeakerDatabaseLoader;
import ipsk.apps.speechrecorder.storage.ActiveSessionStorageManager;
import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.db.speech.Person;
import ipsk.db.speech.Session;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SpeakerManager
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static int COL_ID = 0;
    public static int COL_CODE = 1;
    public static int COL_NAME = 2;
    public static int COL_FORENAME = 3;
    public static int COL_GENDER = 4;
    public static int COL_ACCENT = 5;
    public static int COL_BIRTHDATE = 6;
    private SpeakerDatabaseLoader spkDBLoader;
    private List<ipsk.apps.speechrecorder.db.Speaker> tableRows = new ArrayList<ipsk.apps.speechrecorder.db.Speaker>();
    private Vector<String> tableColumns = null;
    private int index;
    private boolean isEditable;
    private int maxID;
    private boolean databaseSaved;
    private static final Format DEFAULT_SESSION_PERSON_ID_FORMAT = new DecimalFormat("0000");
    private Set<Session> sessions;
    private SessionStorageManager storageManager;

    public Set<Session> getSessions() {
        return this.sessions;
    }

    public void setSessions(Set<Session> sessions) {
        this.sessions = sessions;
    }

    public SessionStorageManager getStorageManager() {
        return this.storageManager;
    }

    public void setStorageManager(ActiveSessionStorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public SpeakerManager() {
        this.init();
    }

    public SpeakerManager(URL url) {
        this();
        this.loadURL(url);
    }

    private void init() {
        if (this.tableRows != null) {
            this.tableRows.clear();
        } else {
            this.tableRows = new ArrayList<ipsk.apps.speechrecorder.db.Speaker>();
        }
        this.tableColumns = Speaker.getDescription();
        this.index = -1;
        this.isEditable = false;
        this.databaseSaved = true;
    }

    public void loadURL(URL url) {
        this.tableColumns = Speaker.getDescription();
        this.spkDBLoader = new SpeakerDatabaseLoader(url, this.tableColumns);
        this.tableRows = this.spkDBLoader.getDatabase();
        this.maxID = this.spkDBLoader.getMaxID();
        this.index = this.tableRows.size() - 1;
        this.databaseSaved = true;
        this.fireTableDataChanged();
    }

    public List<ipsk.apps.speechrecorder.db.Speaker> getSpeakersList() {
        return this.tableRows;
    }

    public int getSpeakerCount() {
        return this.tableRows.size();
    }

    public void setIndex(int i) {
        this.index = i >= -1 && i < this.getSpeakerCount() ? i : 0;
    }

    public int getIndex() {
        return this.index;
    }

    public ipsk.apps.speechrecorder.db.Speaker getSpeaker() {
        if (this.index < 0 || this.index >= this.tableRows.size()) {
            return null;
        }
        return this.tableRows.get(this.getIndex());
    }

    public ipsk.apps.speechrecorder.db.Speaker speakerAtIndex(int index) {
        return this.tableRows.get(index);
    }

    public int getNewSpeakerID() {
        ++this.maxID;
        return this.maxID;
    }

    public void addNewSpeaker() {
        int spkAndSessId = this.getNewSpeakerID();
        Session sess = new Session(spkAndSessId);
        this.sessions.add(sess);
        ipsk.apps.speechrecorder.db.Speaker spk = new ipsk.apps.speechrecorder.db.Speaker(spkAndSessId);
        spk.setUuid(UUID.randomUUID().toString());
        spk.getSessions().add(sess);
        sess.getSpeakers().add(spk);
        this.tableRows.add(spk);
        this.setIndex(this.getSpeakerCount() - 1);
        this.fireTableRowsInserted(this.getIndex(), this.getIndex());
        this.editSpeaker(true);
        this.databaseSaved = false;
    }

    public void deleteSpeaker(int delIndex) {
        if (delIndex < this.tableRows.size() && delIndex >= 0) {
            ipsk.apps.speechrecorder.db.Speaker spk = this.tableRows.remove(delIndex);
            if (this.sessions != null) {
                for (Session s : this.sessions) {
                    s.getSpeakers().remove((Object)spk);
                }
            }
            this.fireTableRowsDeleted(delIndex, delIndex);
            if (delIndex > 0) {
                this.setIndex(delIndex - 1);
            }
            this.databaseSaved = false;
        }
    }

    public void editSpeaker(boolean allowEditing) {
        this.isEditable = allowEditing;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public String getColumnName(int c) {
        return this.tableColumns.elementAt(c);
    }

    @Override
    public int getRowCount() {
        return this.tableRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        boolean isSpeechDB = SpeakerDatabaseLoader.DatabaseType.SPEECH_DB.equals((Object)this.getDatabaseType());
        ipsk.apps.speechrecorder.db.Speaker spk = this.tableRows.get(row);
        Object val = null;
        if (spk != null) {
            if (column == COL_ID) {
                int personId = spk.getPersonId();
                Format spkSessFmt = DEFAULT_SESSION_PERSON_ID_FORMAT;
                if (this.storageManager != null) {
                    spkSessFmt = this.storageManager.getSpeakerIDFormat();
                }
                val = spkSessFmt == null ? Integer.valueOf(personId) : spkSessFmt.format(personId);
            } else if (column == COL_CODE) {
                val = spk.getCode();
            } else if (column == COL_NAME) {
                val = spk.getName();
            } else if (column == COL_FORENAME) {
                val = spk.getForename();
            } else if (column == COL_GENDER) {
                val = isSpeechDB ? spk.getSex() : spk.getGender();
            } else if (column == COL_ACCENT) {
                val = spk.getAccent();
            } else if (column == COL_BIRTHDATE) {
                val = isSpeechDB ? spk.getDateOfBirth() : spk.getDateOfBirthString();
            }
        }
        return val;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        boolean isSpeechDB = SpeakerDatabaseLoader.DatabaseType.SPEECH_DB.equals((Object)this.getDatabaseType());
        ipsk.apps.speechrecorder.db.Speaker spk = this.tableRows.get(row);
        String strVal = null;
        if (value instanceof String) {
            strVal = (String)value;
        }
        if (column == COL_CODE) {
            spk.setCode(strVal);
        } else if (column == COL_NAME) {
            spk.setName(strVal);
        } else if (column == COL_FORENAME) {
            spk.setForename(strVal);
        } else if (column == COL_GENDER) {
            if (isSpeechDB) {
                spk.setSex((Person.Sex)value);
            } else {
                spk.setGender(strVal);
            }
        } else if (column == COL_ACCENT) {
            spk.setAccent(strVal);
        } else if (column == COL_BIRTHDATE) {
            if (isSpeechDB) {
                if (value instanceof Date) {
                    spk.setDateOfBirth((Date)value);
                }
            } else {
                spk.setDateOfBirthString(strVal);
            }
        }
        this.databaseSaved = false;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (SpeakerDatabaseLoader.DatabaseType.SPEECH_DB.equals((Object)this.getDatabaseType())) {
            Class cl = String.class;
            if (column != COL_CODE && column != COL_NAME && column != COL_FORENAME) {
                if (column == COL_GENDER) {
                    cl = Person.Sex.class;
                } else if (column != COL_ACCENT && column == COL_BIRTHDATE) {
                    cl = Date.class;
                }
            }
            return cl;
        }
        Object columnObject = this.getValueAt(0, column);
        if (columnObject == null) {
            return String.class;
        }
        return columnObject.getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col > 0) {
            if (col == COL_CODE) {
                ipsk.apps.speechrecorder.db.Speaker spk;
                Set spkSesss;
                if (this.isEditable && (spkSesss = (spk = this.tableRows.get(row)).getSessions()) != null && spkSesss.size() > 0) {
                    for (Session sess : spkSesss) {
                        if (!sess.hasRecordings()) continue;
                        return false;
                    }
                }
                return this.isEditable;
            }
            return this.isEditable;
        }
        return false;
    }

    public SpeakerDatabaseLoader getDatabaseLoader() {
        return this.spkDBLoader;
    }

    public boolean isDatabaseSaved() {
        return this.databaseSaved;
    }

    public void setDatabaseSaved(boolean databaseSaved) {
        this.databaseSaved = databaseSaved;
    }

    public void close() {
        this.init();
    }

    public SpeakerDatabaseLoader.DatabaseType getDatabaseType() {
        return this.spkDBLoader.getDatabaseType();
    }
}

