/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder;

import ips.annot.model.AnnotatedAudioClip;
import ips.annot.view.AnnotationAudioClipUI;
import ips.media.MediaLengthUnit;
import ipsk.apps.speechrecorder.DialogTargetProvider;
import ipsk.apps.speechrecorder.ErrorHandler;
import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.PluginLoadingException;
import ipsk.apps.speechrecorder.ProgressViewer;
import ipsk.apps.speechrecorder.RecStatus;
import ipsk.apps.speechrecorder.RecTransporter;
import ipsk.apps.speechrecorder.RecWindow;
import ipsk.apps.speechrecorder.RecWindowFrame;
import ipsk.apps.speechrecorder.RecWindowWindow;
import ipsk.apps.speechrecorder.SpeakerDatabaseViewer;
import ipsk.apps.speechrecorder.SpeakerManager;
import ipsk.apps.speechrecorder.SpeakerViewer;
import ipsk.apps.speechrecorder.Speakers;
import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.SpeechRecorderPluginException;
import ipsk.apps.speechrecorder.SplashPanel;
import ipsk.apps.speechrecorder.SplashScreen;
import ipsk.apps.speechrecorder.UIResources;
import ipsk.apps.speechrecorder.actions.EditScriptAction;
import ipsk.apps.speechrecorder.actions.ExportScriptAction;
import ipsk.apps.speechrecorder.actions.ImportScriptAction;
import ipsk.apps.speechrecorder.actions.PrintScriptAction;
import ipsk.apps.speechrecorder.annotation.auto.ProjectAutoAnnotatorWorker;
import ipsk.apps.speechrecorder.annotation.auto.ProjectUpdateAutoAnnotationsUIDialog;
import ipsk.apps.speechrecorder.config.DescriptionFont;
import ipsk.apps.speechrecorder.config.InstructionFont;
import ipsk.apps.speechrecorder.config.KeyInputMap;
import ipsk.apps.speechrecorder.config.KeyStrokeAction;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.PromptFont;
import ipsk.apps.speechrecorder.config.Prompter;
import ipsk.apps.speechrecorder.config.TransportPanel;
import ipsk.apps.speechrecorder.config.WorkspaceProject;
import ipsk.apps.speechrecorder.config.ui.ProjectConfigurationView;
import ipsk.apps.speechrecorder.db.ExportSpeakersUIDialog;
import ipsk.apps.speechrecorder.monitor.RecMonitor;
import ipsk.apps.speechrecorder.monitor.StartStopSignal;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.apps.speechrecorder.project.NewProjectConfiguration;
import ipsk.apps.speechrecorder.project.NewProjectDialog;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptViewer;
import ipsk.apps.speechrecorder.prompting.PromptViewerListener;
import ipsk.apps.speechrecorder.prompting.Prompter;
import ipsk.apps.speechrecorder.prompting.PrompterException;
import ipsk.apps.speechrecorder.prompting.event.PromptViewerEvent;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.RecScriptManager;
import ipsk.apps.speechrecorder.script.ui.ExportScriptUIDialog;
import ipsk.apps.speechrecorder.script.ui.ImportScriptUIDialog;
import ipsk.apps.speechrecorder.script.ui.ScriptSourceEditor;
import ipsk.apps.speechrecorder.script.ui.ScriptUI;
import ipsk.apps.speechrecorder.script.ui.ScriptUIDialog;
import ipsk.apps.speechrecorder.session.SessionManager;
import ipsk.apps.speechrecorder.session.action.SetIndexAction;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.apps.speechrecorder.ui.ExportProjectUIDialog;
import ipsk.apps.speechrecorder.ui.InfoViewer;
import ipsk.apps.speechrecorder.workspace.WorkspaceException;
import ipsk.apps.speechrecorder.workspace.ui.ProjectExporter;
import ipsk.apps.speechrecorder.workspace.ui.WorkspacePanel;
import ipsk.audio.AudioController2;
import ipsk.audio.AudioControllerException;
import ipsk.audio.Profile;
import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.ui.AudioClipScrollPane;
import ipsk.audio.arr.clip.ui.AudioClipUIContainer;
import ipsk.audio.arr.clip.ui.AudioClipsUIContainer;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.AudioTimeScaleUI;
import ipsk.audio.arr.clip.ui.FourierUI;
import ipsk.audio.arr.clip.ui.FragmentActionBarUI;
import ipsk.audio.dsp.LevelInfo;
import ipsk.audio.mixer.ui.PortMixersUI;
import ipsk.audio.ui.LevelMeter;
import ipsk.audio.utils.AudioFormatUtils;
import ipsk.audio.view.AudioStatus;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.print.ComponentPrinter;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.Reccomment;
import ipsk.db.speech.script.Recinstructions;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.script.Section;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.net.UploadCacheUI;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.swing.JPopupMenuListener;
import ipsk.swing.JProgressDialogPanel;
import ipsk.swing.ZipFileFilter;
import ipsk.swing.action.tree.ActionFolder;
import ipsk.swing.action.tree.ActionGroup;
import ipsk.swing.action.tree.ActionList;
import ipsk.swing.action.tree.ActionNode;
import ipsk.swing.action.tree.ActionTreeRoot;
import ipsk.swing.action.tree.CheckActionLeaf;
import ipsk.swing.action.tree.JMenuBuilder;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import ipsk.util.SystemHelper;
import ipsk.util.apps.UpdateManager;
import ipsk.util.apps.descriptor.ApplicationVersionDescriptor;
import ipsk.util.apps.ui.UpdateDialogUI;
import ipsk.xml.DOMConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.UnsupportedOperationException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.w3c.dom.Document;

public class SpeechRecorderUI
extends JFrame
implements ActionListener,
PromptViewerListener,
ErrorHandler,
DialogTargetProvider {
    private static final long serialVersionUID = 5486901704480120471L;
    private static final boolean DEBUG = false;
    private final int UPDATE_DELAY = 200;
    private boolean waiting;
    private PromptConfiguration promptConfiguration;
    private static final float LEFT_FRACTION = 0.7f;
    private static final float TOP_FRACTION = 0.5f;
    private static final String ACTION_CMD_SCRIPT_SOURCE_EDIT = "script.source.edit";
    public static final String[] ICON_FILENAMES = new String[]{"icons/speechrecorder_16x16.png", "icons/speechrecorder_32x32.png", "icons/speechrecorder_64x64.png", "icons/speechrecorder_128x128.png", "icons/speechrecorder_256x256.png"};
    private List<Image> iconImages = new ArrayList<Image>();
    private Dimension screenSize;
    private GraphicsConfiguration expScreenConfig;
    private GraphicsConfiguration spkScreenConfig;
    static final JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu fileMenu;
    protected JMenuItem miPrint;
    protected JMenuItem miSave;
    private JMenu miAppPrefsMenu;
    private JMenuItem miUpdateManagerConfig;
    protected JMenuItem miQuit;
    protected JMenu editMenu;
    protected JMenuItem miUndo;
    protected JMenuItem miCut;
    protected JMenuItem miCopy;
    protected JMenuItem miPaste;
    protected JMenuItem miClear;
    protected JMenuItem miSelectAll;
    private JMenu workspaceMenu;
    private JMenuItem miWorkspace;
    private JMenu projectMenu;
    protected JMenuItem miNew;
    protected JMenu openSubMenu;
    protected JMenuItem[] miAvailableProjects;
    protected JMenuItem miClose;
    protected JMenuItem miImport;
    protected JMenuItem miExport;
    protected JMenuItem miUpdateAutoAnnotation;
    private JMenu speakersMenu;
    protected JMenuItem miSpkSettings;
    protected JMenuItem miSpkTableExport;
    private JMenuItem miSessionClipView;
    private JMenu scriptMenu;
    protected JMenuItem miEditScript;
    protected JMenuItem miEditScriptSrc;
    private JMenuItem miImportScript;
    private JMenuItem miExportScript;
    private JMenuItem miPrintScript;
    protected JMenu settingsMenu;
    protected JMenuItem miProjectSettings;
    protected JMenuItem miRecSettings;
    protected JMenuItem miSkipSettings;
    protected JMenu helpMenu;
    protected JMenuItem miHelp;
    protected JMenuItem miAbout;
    protected JMenuItem miInfo;
    private JMenuItem miCheckUpdates;
    private JMenuItem miContact;
    private SpeakerViewer speakerViewer;
    private InfoViewer infoViewer;
    private RecTransporter recTransporter;
    private RecMonitor recMonitor;
    private RecWindow recWindow;
    private RecWindowFrame recWindowFrame;
    private RecWindowWindow recwindowWindow;
    private boolean fullScreenMode = false;
    private LevelMeter recLevel;
    public static final int LEVEL_METER_DISABLE = 0;
    public static final int LEVEL_METER_PLAYBACK = 1;
    public static final int LEVEL_METER_CAPTURE = 2;
    public static final int LEVEL_METER_RECORDING = 3;
    private int levelMeterMode;
    private AudioClipUIContainer audioUI;
    private AudioClipScrollPane arrScrollPane;
    private JPanel progressPanel;
    private ProgressViewer progressViewer;
    private UploadCacheUI uploadCacheUI;
    private JSplitPane dataPane;
    private SpeechRecorder speechRecorder;
    private ActiveProjectManager projectManager;
    private SessionManager sessionManager;
    private PortMixersUI mixerUI;
    protected Locale currentLocale = Locale.getDefault();
    protected String language = this.currentLocale.getLanguage();
    protected String country = this.currentLocale.getCountry();
    protected UIResources uiString = null;
    private String defaultTitle;
    private Cursor defCursor;
    private Cursor waitCursor;
    private Timer updateTimer;
    private boolean fileSystemWorkspaceEnabled = true;
    private boolean editingEnabled;
    private ScriptUIDialog scriptUIDialog = null;
    private ScriptSourceEditor scriptSrcEditor = null;
    private boolean instructionNumbering = true;
    private boolean autoRecording;
    private boolean playbackEnabled;
    private boolean progressPaused = true;
    private Prompter prompter;
    private SetIndexAction setIndexAction;
    private EditScriptAction editScriptAction;
    private JPanel recMonitorPanel;
    private List<PromptPresenterServiceDescriptor> promptPresentersClassList;
    private HelpBroker helpBroker;
    private AudioSignalUI audioSignalView;
    private FourierUI sonagram;
    private ToggleSubjectDisplayAction toggleSubjectDisplayAction;
    private WorkspacePanel workspaceDialog;
    private ProjectConfigurationView promptConfigurationView;
    protected SpeakerDatabaseViewer spkDbView;
    private ExportSpeakersUIDialog exportSpeakersDialog;
    private ImportScriptUIDialog importScriptDialog;
    private ExportScriptUIDialog exportScriptDialog;
    private ImportScriptAction importScriptAction;
    private ExportScriptAction exportScriptAction;
    private PrintScriptAction printScriptAction;
    private SplashScreen splashScreen;
    private Mixer promptMixer = null;
    private int promptAudioChannelOffset = 0;
    private boolean applyWorkaroundBugID0006 = false;
    private boolean applyWorkaroundBugID0007 = false;
    private Font promptFont;
    private Font instrunctionsFont;
    private Font descriptionsFont;
    private PromptFont promptFontConfig;
    private String[] instructionsFontFamilies;
    private String[] descriptionFontFamilies;
    private JMenuItem miScriptResources;

    public boolean isFileSystemWorkspaceEnabled() {
        return this.fileSystemWorkspaceEnabled;
    }

    public void setFileSystemWorkspaceEnabled(boolean fileSystemWorkspaceEnabled) {
        this.fileSystemWorkspaceEnabled = fileSystemWorkspaceEnabled;
        this.miWorkspace.setEnabled(fileSystemWorkspaceEnabled);
    }

    public int getPromptAudioChannelOffset() {
        return this.promptAudioChannelOffset;
    }

    public void setPromptAudioChannelOffset(int promptAudioChannelOffset) {
        this.promptAudioChannelOffset = promptAudioChannelOffset;
    }

    public Mixer getPromptMixer() {
        return this.promptMixer;
    }

    public void setPromptMixer(Mixer promptMixer) {
        this.promptMixer = promptMixer;
    }

    private void addFileMenuItems() {
        this.miPrint = new JMenuItem(this.uiString.getString("MenuItemPrint"));
        this.miPrint.setEnabled(true);
        this.fileMenu.add(this.miPrint);
        this.miPrint.addActionListener(this);
        this.miSave = new JMenuItem(this.uiString.getString("MenuItemSave"));
        this.miSave.setAccelerator(KeyStroke.getKeyStroke(83, 4));
        this.miSave.setEnabled(false);
        this.fileMenu.add(this.miSave);
        this.miSave.addActionListener(this);
        this.miAppPrefsMenu = new JMenu("Preferences...");
        this.miUpdateManagerConfig = new JMenuItem("Update manager ...");
        this.miUpdateManagerConfig.setEnabled(false);
        UpdateManager updateManager = this.speechRecorder.getUpdateManager();
        if (updateManager != null) {
            this.miAppPrefsMenu.add(this.miUpdateManagerConfig);
            this.miUpdateManagerConfig.addActionListener(this);
            this.miUpdateManagerConfig.setEnabled(true);
            this.fileMenu.add(this.miAppPrefsMenu);
        }
        this.miQuit = new JMenuItem(this.uiString.getString("MenuItemQuit"));
        this.fileMenu.add(this.miQuit).setEnabled(true);
        this.miQuit.addActionListener(this);
        mainMenuBar.add(this.fileMenu);
    }

    private void addProjectMenuItems() {
        this.miNew = new JMenuItem(this.uiString.getString("MenuItemNew"));
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(78, 4));
        this.projectMenu.add(this.miNew).setEnabled(false);
        this.miNew.addActionListener(this);
        this.openSubMenu = new JMenu(this.uiString.getString("MenuItemOpen"));
        this.miAvailableProjects = new JMenuItem[0];
        this.projectMenu.add(this.openSubMenu).setEnabled(false);
        this.miClose = new JMenuItem(this.uiString.getString("MenuItemClose"));
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, 4));
        this.projectMenu.add(this.miClose).setEnabled(false);
        this.miClose.addActionListener(this);
        this.miImport = new JMenuItem(this.uiString.getString("MenuItemImport"));
        this.miImport.setAccelerator(KeyStroke.getKeyStroke(73, 4));
        this.projectMenu.add(this.miImport).setEnabled(false);
        this.miImport.addActionListener(this);
        this.miExport = new JMenuItem(this.uiString.getString("MenuItemExport"));
        this.miExport.setAccelerator(KeyStroke.getKeyStroke(69, 4));
        this.projectMenu.add(this.miExport).setEnabled(false);
        this.miExport.addActionListener(this);
        this.miUpdateAutoAnnotation = new JMenuItem("Update auto annotations...");
        this.projectMenu.add(this.miUpdateAutoAnnotation);
        this.miUpdateAutoAnnotation.addActionListener(this);
        this.miProjectSettings = new JMenuItem(this.uiString.getString("MenuItemPreferences"));
        this.miProjectSettings.addActionListener(this);
        this.projectMenu.add(this.miProjectSettings).setEnabled(false);
        mainMenuBar.add(this.projectMenu);
    }

    public void addSpeakersMenuItems() {
        this.miSpkSettings = new JMenuItem(this.uiString.getString("MenuItemSpeakerSettings"));
        this.miSpkSettings.addActionListener(this);
        this.speakersMenu.add(this.miSpkSettings).setEnabled(false);
        this.miSpkTableExport = new JMenuItem("Table export ...");
        this.miSpkTableExport.addActionListener(this);
        this.speakersMenu.add(this.miSpkTableExport).setEnabled(false);
        mainMenuBar.add(this.speakersMenu);
    }

    public void addScriptMenuItems() {
        this.miEditScript = new JMenuItem(this.editScriptAction);
        this.scriptMenu.add(this.miEditScript);
        this.miEditScriptSrc = new JMenuItem("Edit script XML source");
        this.miEditScriptSrc.setActionCommand(ACTION_CMD_SCRIPT_SOURCE_EDIT);
        this.miEditScriptSrc.addActionListener(this);
        this.miEditScriptSrc.setEnabled(false);
        this.scriptMenu.add(this.miEditScriptSrc);
        this.miScriptResources = new JMenuItem("Script resources...");
        this.miScriptResources.addActionListener(this);
        this.miScriptResources.setEnabled(false);
        this.scriptMenu.add(this.miScriptResources);
        this.printScriptAction = new PrintScriptAction(this.speechRecorder, "Print script...");
        this.printScriptAction.setEnabled(false);
        this.miImportScript = new JMenuItem(this.importScriptAction);
        this.miExportScript = new JMenuItem(this.exportScriptAction);
        this.miPrintScript = new JMenuItem(this.printScriptAction);
        this.scriptMenu.add(this.miImportScript);
        this.scriptMenu.add(this.miExportScript);
        mainMenuBar.add(this.scriptMenu);
    }

    public void addEditMenuItems() {
        this.miUndo = new JMenuItem(this.uiString.getString("MenuItemUndo"));
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, 4));
        this.editMenu.add(this.miUndo).setEnabled(false);
        this.miUndo.addActionListener(this);
        this.editMenu.addSeparator();
        this.miCut = new JMenuItem(this.uiString.getString("MenuItemCut"));
        this.miCut.setAccelerator(KeyStroke.getKeyStroke(88, 4));
        this.editMenu.add(this.miCut).setEnabled(false);
        this.miCut.addActionListener(this);
        this.miCopy = new JMenuItem(this.uiString.getString("MenuItemCopy"));
        this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, 4));
        this.editMenu.add(this.miCopy).setEnabled(false);
        this.miCopy.addActionListener(this);
        this.miPaste = new JMenuItem(this.uiString.getString("MenuItemPaste"));
        this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, 4));
        this.editMenu.add(this.miPaste).setEnabled(false);
        this.miPaste.addActionListener(this);
        this.miClear = new JMenuItem(this.uiString.getString("MenuItemClear"));
        this.editMenu.add(this.miClear).setEnabled(false);
        this.miClear.addActionListener(this);
        this.editMenu.addSeparator();
        this.miSelectAll = new JMenuItem(this.uiString.getString("MenuItemSelectAll"));
        this.miSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 4));
        this.editMenu.add(this.miSelectAll).setEnabled(false);
        this.miSelectAll.addActionListener(this);
        mainMenuBar.add(this.editMenu);
    }

    public void addViewMenuItems() {
        ActionTreeRoot ascActionTree = this.arrScrollPane.getActionTreeRoot();
        ActionFolder signalViewFolder = new ActionFolder("signalview", new LocalizableMessage("Signal view"));
        ActionTreeRoot shiftedAscActionTree = ascActionTree.shiftFromTopLevel(signalViewFolder);
        ActionTreeRoot afft = new ActionTreeRoot();
        ActionFolder avf = ActionFolder.buildTopLevelFolder((String)"view");
        ActionGroup subjectViewGroup = new ActionGroup("view.subjectGroup");
        subjectViewGroup.add((ActionNode)this.toggleSubjectDisplayAction);
        avf.add((ActionNode)subjectViewGroup);
        afft.add((ActionNode)avf);
        afft.merge((ActionList)shiftedAscActionTree);
        JMenuBuilder pmb = new JMenuBuilder((ActionFolder)ascActionTree);
        JPopupMenu pm = pmb.buildJPopupMenu();
        JPopupMenuListener pml = new JPopupMenuListener(pm);
        this.arrScrollPane.addMouseListener((MouseListener)pml);
        this.audioUI.addPopupMouseListener((MouseListener)pml);
        JMenuBuilder menuBuilder = new JMenuBuilder((ActionFolder)afft);
        JMenu viewMenu = menuBuilder.buildMenu("view");
        mainMenuBar.add(viewMenu);
    }

    public void addSettingsMenuItems() {
        this.miRecSettings = new JMenuItem(this.uiString.getString("MenuItemRecordingSettings"));
        this.miRecSettings.addActionListener(this);
        this.settingsMenu.add(this.miRecSettings).setEnabled(true);
        this.miSkipSettings = new JMenuItem(this.uiString.getString("MenuItemSkipSettings"));
        this.miSkipSettings.addActionListener(this);
        this.settingsMenu.add(this.miSkipSettings).setEnabled(false);
        mainMenuBar.add(this.settingsMenu);
    }

    private void addHelpMenuItems() {
        this.miAbout = new JMenuItem("About");
        this.miAbout.addActionListener(this);
        this.miAbout.setEnabled(true);
        this.helpMenu.add(this.miAbout);
        this.miHelp = new JMenuItem("Help");
        this.miHelp.setEnabled(true);
        if (this.helpBroker != null) {
            this.helpMenu.add(this.miHelp);
            HelpSet helpSet = this.helpBroker.getHelpSet();
            this.helpBroker.enableHelpOnButton((Component)this.miHelp, helpSet.getHomeID().getIDString(), helpSet);
        }
        this.miInfo = new JMenuItem("Info");
        this.miInfo.addActionListener(this);
        this.miInfo.setEnabled(true);
        this.helpMenu.add(this.miInfo);
        this.miContact = new JMenuItem("Contact");
        boolean desktopSupported = Desktop.isDesktopSupported();
        if (desktopSupported) {
            this.miContact.addActionListener(this);
            this.miContact.setEnabled(true);
            this.helpMenu.add(this.miContact);
        }
        UpdateManager updateManager = this.speechRecorder.getUpdateManager();
        this.miCheckUpdates = new JMenuItem("Check for updates...");
        if (updateManager != null) {
            this.helpMenu.add(this.miCheckUpdates);
            this.miCheckUpdates.setEnabled(true);
            this.miCheckUpdates.addActionListener(this);
        }
        mainMenuBar.add(this.helpMenu);
    }

    public void addMenus() {
        mainMenuBar.removeAll();
        this.fileMenu = new JMenu(this.uiString.getString("MenuFile"));
        this.addFileMenuItems();
        this.editMenu = new JMenu(this.uiString.getString("MenuEdit"));
        this.addViewMenuItems();
        this.workspaceMenu = new JMenu("Workspace");
        mainMenuBar.add(this.workspaceMenu);
        this.miWorkspace = new JMenuItem("Workspace...");
        this.workspaceMenu.add(this.miWorkspace);
        this.miWorkspace.setEnabled(this.fileSystemWorkspaceEnabled);
        this.miWorkspace.addActionListener(this);
        this.projectMenu = new JMenu(this.uiString.getString("MenuProject"));
        this.addProjectMenuItems();
        this.speakersMenu = new JMenu(this.uiString.getString("MenuSpeakers"));
        this.addSpeakersMenuItems();
        this.scriptMenu = new JMenu(this.uiString.getString("MenuScript"));
        this.addScriptMenuItems();
        this.settingsMenu = new JMenu(this.uiString.getString("MenuSettings"));
        this.addSettingsMenuItems();
        mainMenuBar.add(Box.createHorizontalGlue());
        this.helpMenu = new JMenu(this.uiString.getString("MenuHelp"));
        this.addHelpMenuItems();
        this.setJMenuBar(mainMenuBar);
    }

    public SpeechRecorderUI(SpeechRecorder spRec, int expScreenIdx, GraphicsConfiguration exc, GraphicsConfiguration spkc) {
        this.speechRecorder = spRec;
        this.expScreenConfig = exc;
        this.spkScreenConfig = spkc;
        this.uiString = UIResources.getInstance();
        this.getContentPane().setLayout(new BorderLayout());
        WindowAdapter wa = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SpeechRecorderUI.this.handleQuit();
            }
        };
        this.setDefaultCloseOperation(0);
        this.addWindowListener(wa);
        this.getContentPane().setLayout(new BorderLayout());
        this.updateTimer = new Timer(200, this);
        this.updateTimer.setRepeats(true);
        this.toggleSubjectDisplayAction = new ToggleSubjectDisplayAction(new LocalizableMessage(this.uiString.getString("MenuItemSpeakerWindow")));
        this.toggleSubjectDisplayAction.setSelected(false);
        this.toggleSubjectDisplayAction.setEnabled(false);
        this.defCursor = this.getContentPane().getCursor();
        this.waitCursor = new Cursor(3);
        String helpHS = "ipsk/apps/speechrecorder/manual/SpeechRecorderUserManual_jh.hs";
        ClassLoader cl = this.getClass().getClassLoader();
        URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
        if (hsURL != null) {
            try {
                HelpSet helpSet = new HelpSet(null, hsURL);
                this.helpBroker = helpSet.createHelpBroker();
                try {
                    this.helpBroker.setScreen(expScreenIdx);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            catch (HelpSetException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void createUI(ActiveProjectManager projectManager) throws PluginLoadingException {
        this.projectManager = projectManager;
        this.sessionManager = projectManager.getSessionManager();
        this.setIndexAction = this.sessionManager.getSetIndexAction();
        this.editScriptAction = projectManager.getEditScriptAction();
        this.importScriptAction = projectManager.getImportScriptAction();
        this.exportScriptAction = projectManager.getExportScriptAction();
        this.setIndexAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SpeechRecorderUI.this.miSkipSettings.setEnabled(SpeechRecorderUI.this.setIndexAction.isEnabled());
            }
        });
        this.getContentPane().removeAll();
        this.screenSize = this.expScreenConfig.getBounds().getSize();
        this.iconImages = new ArrayList<Image>();
        for (String ifn : ICON_FILENAMES) {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(ifn));
            Image iconImage = imageIcon.getImage();
            this.iconImages.add(iconImage);
        }
        this.setIconImages(this.iconImages);
        this.recTransporter = new RecTransporter(this.speechRecorder, this.sessionManager.getRecTransporterActions());
        this.recMonitor = new RecMonitor();
        RecStatus rs = RecStatus.getInstance();
        rs.attach(this.recTransporter);
        this.recLevel = new LevelMeter();
        this.recLevel.setUseIntervalPeakLevel(true);
        this.recLevel.addActionListener((ActionListener)this);
        this.levelMeterMode = 0;
        AnnotatedAudioClip audioClip = this.sessionManager.getAudioClip();
        this.audioUI = new AudioClipUIContainer();
        this.audioUI.setMediaLengthUnit(MediaLengthUnit.TIME);
        this.audioSignalView = new AudioSignalUI();
        this.audioSignalView.setUseThread(true);
        this.sonagram = new FourierUI();
        this.sonagram.setUseThread(true);
        FourierUI.Profile sonagramProfile = FourierUI.Profile.PHONETIC1;
        this.sonagram.setMaxFrequency(sonagramProfile.getMaxFrequency());
        this.sonagram.setDynamicRangeDB(sonagramProfile.getDynamicRangeDB());
        this.sonagram.setWindowSize(sonagramProfile.getWindowLength());
        this.sonagram.setEmphasisPerOctaveDB(sonagramProfile.getEmphasisPerOctaveDB());
        AnnotationAudioClipUI annoClipUI = new AnnotationAudioClipUI(audioClip);
        annoClipUI.setStartPlaybackAction((StartPlaybackAction)this.sessionManager.getStartPlaybackAction());
        this.audioUI.add((Component)annoClipUI);
        FragmentActionBarUI fragmentActionBar = new FragmentActionBarUI();
        fragmentActionBar.setStartPlaybackAction((StartPlaybackAction)this.sessionManager.getStartPlaybackAction());
        this.audioUI.add((Component)fragmentActionBar);
        AudioTimeScaleUI timeScale = new AudioTimeScaleUI();
        this.audioUI.add((Component)this.audioSignalView);
        this.audioUI.add((Component)this.sonagram);
        this.audioUI.add((Component)timeScale);
        this.audioUI.setAudioClip((AudioClip)audioClip);
        this.audioUI.setFixXZoomFitToPanel(true);
        this.arrScrollPane = new AudioClipScrollPane();
        this.arrScrollPane.setShowYScales(true);
        this.arrScrollPane.setAudioClipUiContainer(this.audioUI);
        this.addMenus();
        this.speakerViewer = new SpeakerViewer();
        this.speakerViewer.setMinimumSize(new Dimension(0, 0));
        this.infoViewer = new InfoViewer(projectManager);
        this.prompter = new Prompter();
        this.prompter.setDialogTargetProvider(this);
        PromptViewer promptViewer = new PromptViewer(this.promptPresentersClassList, this.prompter.getStartPromptPlaybackAction(), this.prompter.getStopPromptPlaybackAction());
        promptViewer.setDialogTargetProvider(this.prompter.getDialogTargetProvider());
        this.prompter.setExperimenterViewer(promptViewer);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.progressViewer = new ProgressViewer(this.sessionManager.getProgressManager(), this.setIndexAction, this.editScriptAction);
        this.progressPanel.add((Component)this.progressViewer, "Center");
        this.recMonitorPanel = new JPanel();
        this.recMonitorPanel.setLayout(new BorderLayout());
        this.recMonitorPanel.add((Component)this.recMonitor, "West");
        this.recMonitorPanel.add((Component)promptViewer, "Center");
        this.recMonitorPanel.add((Component)new JLabel(this.uiString.getString("SpeakerWindow"), 0), "North");
        JPanel recSignalPanel = new JPanel();
        recSignalPanel.setLayout(new BorderLayout());
        recSignalPanel.add((Component)this.recLevel, "West");
        recSignalPanel.add((Component)this.arrScrollPane, "Center");
        recSignalPanel.add((Component)new JLabel(this.uiString.getString("SignalDisplay"), 0), "North");
        this.dataPane = new JSplitPane(0, this.speakerViewer, this.progressPanel);
        JSplitPane recordingPane = new JSplitPane(0, this.recMonitorPanel, recSignalPanel);
        this.defaultTitle = this.uiString.getString("SpeechRecorder") + " " + SpeechRecorder.VERSION + " Copyright \u00a9 2004-2020";
        this.setTitle(this.defaultTitle);
        recordingPane.setDividerLocation((int)(this.screenSize.getHeight() * 0.5));
        recordingPane.setMinimumSize(new Dimension(0, 0));
        JSplitPane displayPanel = new JSplitPane(1, recordingPane, this.dataPane);
        displayPanel.setDividerLocation((int)(this.screenSize.getWidth() * (double)0.7f));
        displayPanel.setMinimumSize(new Dimension(0, 0));
        this.getContentPane().add((Component)this.recTransporter, "South");
        this.getContentPane().add((Component)displayPanel, "Center");
    }

    public Prompter getPrompter() {
        return this.prompter;
    }

    public void showSplashScreen(boolean closeable) {
        this.splashScreen = new SplashScreen(this.expScreenConfig, closeable);
        this.splashScreen.setIconImages(this.iconImages);
        this.splashScreen.showScreen();
    }

    public boolean isInstructionNumbering() {
        return this.instructionNumbering;
    }

    public void setInstructionNumbering(boolean instructionNumbering) {
        this.instructionNumbering = instructionNumbering;
        if (this.prompter != null) {
            this.prompter.setInstructionNumbering(instructionNumbering);
        }
    }

    public void configure() {
        TransportPanel t;
        String osName = System.getProperty("os.name");
        String javaVersion = System.getProperty("java.version");
        String javaVendor = System.getProperty("java.vendor");
        boolean isMacOSX = "Mac OS X".equalsIgnoreCase(osName);
        boolean isOracleJava7 = "Oracle corporation".equalsIgnoreCase(javaVendor) && javaVersion.startsWith("1.7.0");
        boolean bl = this.applyWorkaroundBugID0006 = isMacOSX && isOracleJava7;
        if (this.applyWorkaroundBugID0006) {
            System.err.println("Applying workaround for bug ID 0006");
        }
        boolean bl2 = this.applyWorkaroundBugID0007 = isMacOSX && isOracleJava7;
        if (this.applyWorkaroundBugID0007) {
            System.err.println("Applying workaround for bug ID 0007");
        }
        ProjectConfiguration configuration = this.projectManager.getConfiguration();
        this.setTitle(configuration.getName() + " - " + this.defaultTitle);
        if (this.projectManager.isUsingUploadCache()) {
            this.uploadCacheUI = (UploadCacheUI)this.getUploadCacheUI();
            this.progressPanel.add((Component)this.uploadCacheUI, "South");
        }
        this.promptConfiguration = this.projectManager.getConfiguration().getPromptConfiguration();
        PromptViewer promptViewer = this.prompter.getExperimenterViewer();
        promptViewer.setContext(this.projectManager.getProjectContext());
        this.promptFontConfig = this.promptConfiguration.getPromptFont();
        InstructionFont instructionsFontCfg = this.promptConfiguration.getInstructionsFont();
        DescriptionFont descriptionFontCfg = this.promptConfiguration.getDescriptionFont();
        this.promptFont = this.promptFontConfig.toFont();
        this.instrunctionsFont = instructionsFontCfg.toFont();
        this.descriptionsFont = descriptionFontCfg.toFont();
        promptViewer.setPromptFont(this.promptFont);
        this.instructionsFontFamilies = instructionsFontCfg.getFamily();
        this.descriptionFontFamilies = descriptionFontCfg.getFamily();
        if (this.scriptUIDialog != null) {
            this.scriptUIDialog.setPromptFontConfig(this.promptFontConfig);
            this.scriptUIDialog.setInstructionsFontFamilies(this.instructionsFontFamilies);
            this.scriptUIDialog.setDescriptionFontFamilies(this.descriptionFontFamilies);
        }
        this.progressViewer.setUseablePromptFontFamilies(this.promptFontConfig.getFamily());
        promptViewer.setInstructionsFont(this.instrunctionsFont);
        this.descriptionsFont = this.promptConfiguration.getDescriptionFont().toFont();
        promptViewer.setDescriptionFont(this.descriptionsFont);
        ipsk.apps.speechrecorder.config.Prompter prompterCfg = null;
        ipsk.apps.speechrecorder.config.Prompter[] prompterCfgs = this.promptConfiguration.getPrompter();
        if (prompterCfgs != null && prompterCfgs.length > 0) {
            prompterCfg = prompterCfgs[0];
        }
        if (prompterCfg != null) {
            Boolean fullScreenModeCfg = prompterCfg.getFullScreenMode();
            if (fullScreenModeCfg != null && fullScreenModeCfg.booleanValue()) {
                boolean supported;
                boolean bl3 = supported = !this.applyWorkaroundBugID0007 && this.spkScreenConfig.getDevice().isFullScreenSupported();
                if (!supported) {
                    JOptionPane.showConfirmDialog(this, "You configured fullscreen mode for speaker window, but this Java plaform does not support it.", "WARNING: Fullscreen mode", 2);
                }
                this.fullScreenMode = supported;
            } else {
                this.fullScreenMode = false;
            }
        } else {
            this.fullScreenMode = false;
        }
        if (prompterCfg != null && prompterCfg.getSpeakerWindowType().equals((Object)Prompter.SpeakerWindowType.WINDOW)) {
            try {
                if (this.recwindowWindow == null) {
                    this.recwindowWindow = new RecWindowWindow(this.sessionManager.getRecTransporterActions(), this.promptPresentersClassList, this.spkScreenConfig, this.prompter);
                }
                this.recWindow = this.recwindowWindow;
                Rectangle spkScreenBounds = this.spkScreenConfig.getBounds();
                Window recWin = this.recWindow.getWindow();
                recWin.setIconImages(this.iconImages);
                recWin.setSize(spkScreenBounds.width, spkScreenBounds.height);
                recWin.validate();
            }
            catch (PluginLoadingException e) {
                e.printStackTrace();
            }
        } else {
            if (this.recWindowFrame == null) {
                try {
                    this.recWindowFrame = new RecWindowFrame(this.sessionManager.getRecTransporterActions(), this.promptPresentersClassList, this.spkScreenConfig, this.prompter);
                    this.recWindowFrame.setIconImages(this.iconImages);
                }
                catch (PluginLoadingException e) {
                    e.printStackTrace();
                }
            } else {
                this.recWindowFrame.dispose();
            }
            this.recWindowFrame.setUndecorated(this.fullScreenMode);
            this.recWindow = this.recWindowFrame;
        }
        this.recWindow.attachToRecStatus();
        this.prompter.addSubjectViewer(this.recWindow.getPromptViewer());
        this.prompter.setPromptMixer(this.promptMixer);
        this.prompter.setAudioChannelOffset(this.promptAudioChannelOffset);
        this.setInstructionNumbering(this.instructionNumbering);
        this.sessionManager.setSpeakerWindowShowing(false);
        WindowAdapter wa = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SpeechRecorderUI.this.sessionManager.setSpeakerWindowShowing(false);
            }
        };
        this.recWindow.getWindow().addWindowListener(wa);
        PromptViewer recPromptViewer = this.recWindow.getPromptViewer();
        recPromptViewer.setContext(this.projectManager.getProjectContext());
        recPromptViewer.setPromptFont(this.promptConfiguration.getPromptFont().toFont());
        recPromptViewer.setInstructionsFont(this.promptConfiguration.getInstructionsFont().toFont());
        recPromptViewer.setDescriptionFont(this.promptConfiguration.getDescriptionFont().toFont());
        this.speakerViewer.setData(this.projectManager.getSpeaker());
        this.dataPane.resetToPreferredSizes();
        boolean autoPromptPlay = this.promptConfiguration.getAutomaticPromptPlay();
        this.prompter.setAutomaticPromptPlay(autoPromptPlay);
        boolean automaticRecording = Section.Mode.getByValue((String)configuration.getRecordingConfiguration().getMode()).equals((Object)Section.Mode.AUTORECORDING);
        this.recTransporter.setAutoRecording(automaticRecording);
        this.recWindow.setTransporterShowing(this.promptConfiguration.getShowButtonsInPromptWindow());
        if (prompterCfg != null && (t = prompterCfg.getTransportPanel()) != null) {
            this.recWindow.getRecTransporter().setShowRecStartAction(t.isShowStartRecordAction());
            this.recWindow.getRecTransporter().setShowRecStopAction(t.isShowStopRecordAction());
        }
        this.recLevel.setAudioFormat(this.projectManager.getAudioFileFormat().getFormat());
        KeyInputMap keyMap = configuration.getControl().getKeyInputMap();
        if (keyMap != null) {
            KeyStrokeAction[] keyStrokeActions = keyMap.getKeyStrokeAction();
            this.recTransporter.clearActionKeyCodes();
            for (int i = 0; i < keyStrokeActions.length; ++i) {
                KeyStrokeAction ksa = keyStrokeActions[i];
                int keyCode = ksa.getCode();
                int modifierMask = 0;
                if (ksa.getShift()) {
                    modifierMask |= 1;
                }
                if (ksa.isAlt()) {
                    modifierMask |= 8;
                }
                if (ksa.isCtrl()) {
                    modifierMask |= 2;
                }
                KeyStroke ks = KeyStroke.getKeyStroke(keyCode, modifierMask);
                Action a = this.projectManager.getActionByActionCommand(ksa.getAction());
                this.recTransporter.addKeyStrokeAction(ks, a);
            }
            if (keyStrokeActions.length >= 1) {
                this.recTransporter.setConsumeAllKeys(keyMap.isConsumeallkeys());
            }
        }
        this.recWindow.setAutoRecording(automaticRecording);
        this.sonagram.setVisible(false);
        this.miNew.setEnabled(false);
        this.openSubMenu.setEnabled(false);
        this.miImport.setEnabled(false);
        this.exportScriptAction.setEnabled(true);
        this.printScriptAction.setEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    public void setPromptItem(PromptItem pi) throws PromptPresenterException {
        if (pi != null) {
            Font[] allPromptFonts;
            List mis = pi.getMediaitems();
            for (Mediaitem mi : mis) {
                String miMimeType = mi.getNNMimetype();
                if (!MIMETypes.isOfType(miMimeType, MIMETypes.PLAINTEXTMIMETYPES)) continue;
                String miText = mi.getText();
                if (miText != null && this.promptFont.canDisplayUpTo(miText) != -1) {
                    void var8_9;
                    allPromptFonts = this.promptConfiguration.getPromptFont().toFonts();
                    Object var8_10 = null;
                    Font[] fontArray = allPromptFonts;
                    int n = fontArray.length;
                    for (int i = 0; i < n; ++i) {
                        Font af = fontArray[i];
                        if (af.canDisplayUpTo(miText) != -1) continue;
                        Font font = af;
                        break;
                    }
                    if (var8_9 == null) {
                        this.displayError("Font error", "Prompt cannot be dislayed with current selected font !!");
                        continue;
                    }
                    this.prompter.setPromptFont((Font)var8_9);
                    continue;
                }
                this.prompter.setPromptFont(this.promptFont);
            }
            if (pi instanceof Recording) {
                String descrText;
                Reccomment descr;
                String instrText;
                Recording r = (Recording)pi;
                Recinstructions instrs = r.getRecinstructions();
                if (instrs != null && (instrText = instrs.getRecinstructions()) != null) {
                    if (this.instrunctionsFont.canDisplayUpTo(instrText) != -1) {
                        Font[] allPromptFonts2 = this.promptConfiguration.getInstructionsFont().toFonts();
                        Font altFont2 = null;
                        for (Font af : allPromptFonts2) {
                            if (af.canDisplayUpTo(instrText) != -1) continue;
                            altFont2 = af;
                            break;
                        }
                        if (altFont2 == null) {
                            this.displayError("Font error", "Prompt instruction cannot be dislayed with current selected font !!");
                        } else {
                            this.prompter.setInstructionsFont(altFont2);
                        }
                    } else {
                        this.prompter.setInstructionsFont(this.instrunctionsFont);
                    }
                }
                if ((descr = r.getReccomment()) != null && (descrText = descr.getReccomment()) != null) {
                    if (this.descriptionsFont.canDisplayUpTo(descrText) != -1) {
                        void var8_16;
                        allPromptFonts = this.promptConfiguration.getDescriptionFont().toFonts();
                        Object var8_14 = null;
                        for (Font af : allPromptFonts) {
                            if (af.canDisplayUpTo(descrText) != -1) continue;
                            Font font = af;
                            break;
                        }
                        if (var8_16 == null) {
                            this.displayError("Font error", "Prompt description/comment cannot be dislayed with current selected font !!");
                        } else {
                            this.prompter.setDescriptionFont((Font)var8_16);
                        }
                    } else {
                        this.prompter.setDescriptionFont(this.descriptionsFont);
                    }
                }
            }
        }
        this.prompter.setPromptItem(pi);
        String itemCode = null;
        if (pi instanceof Recording) {
            itemCode = ((Recording)pi).getItemcode();
            this.recTransporter.setItemCode(itemCode);
            this.recWindow.getRecTransporter().setItemCode(itemCode);
        }
        this.recTransporter.setItemCode(itemCode);
        if (this.recWindow != null) {
            this.recWindow.getRecTransporter().setItemCode(itemCode);
        }
        try {
            this.prompter.prepare();
        }
        catch (PromptPresenterException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Prompt plugin error", 0);
            throw e;
        }
    }

    public void setRecIndex(Integer recIndex) {
        this.prompter.setRecIndex(recIndex);
    }

    public void setRecMonitorsStatus(StartStopSignal.State status) {
        RecMonitor wMonitor;
        if (this.recMonitor != null) {
            this.recMonitor.setStartStopSignalStatus(status);
        }
        if (this.recWindow != null && (wMonitor = this.recWindow.getRecMonitor()) != null) {
            wMonitor.setStartStopSignalStatus(status);
        }
    }

    public void init() {
        this.setRecMonitorsStatus(StartStopSignal.State.OFF);
        this.progressViewer.setEnabled(false);
        this.setIndexAction.setEnabled(false);
        this.miSkipSettings.setEnabled(false);
        this.recTransporter.setKeyButtonBindingEnabled(false);
        this.prompter.addPromptViewerListener(this);
        this.prompter.init();
        this.toggleSubjectDisplayAction.setEnabled(true);
    }

    public void idle() {
        this.progressViewer.setEnabled(true);
        this.updateTimer.start();
        this.setIndexAction.setEnabled(true);
        this.recTransporter.setKeyButtonBindingEnabled(true);
    }

    public void setPromptStartControlEnabled(boolean enabled) {
        this.prompter.setStartControlEnabled(enabled);
    }

    public void setShowPromptViewers(boolean showPromptViewers) {
        this.prompter.setShowPrompt(showPromptViewers);
    }

    public void startPromptAutoplay() throws PrompterException {
        this.prompter.autoPlay();
    }

    private void stopSession() {
        try {
            this.sessionManager.stop();
            this.setLevelMeterMode(0);
        }
        catch (SpeechRecorderException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Speechrecorder stop session error:\n" + e.getLocalizedMessage(), "Speechrecorder stop session error", 0);
        }
    }

    public void closeSession() {
        GraphicsDevice spkGd;
        this.setRecMonitorsStatus(StartStopSignal.State.OFF);
        if (this.scriptUIDialog != null) {
            this.scriptUIDialog.setScript(null);
        }
        this.recTransporter.setKeyButtonBindingEnabled(false);
        this.setTitle(this.defaultTitle);
        this.updateTimer.stop();
        this.setIndexAction.setEnabled(false);
        this.miImport.setEnabled(true);
        this.miNew.setEnabled(true);
        this.openSubMenu.setEnabled(true);
        this.miClose.setEnabled(false);
        this.speakerViewer.setData(null);
        this.setShowPromptViewers(false);
        this.closePrompt();
        this.prompter.removePromptViewerListener(this);
        try {
            this.setPromptItem(null);
        }
        catch (PromptPresenterException e) {
            e.printStackTrace();
        }
        this.toggleSubjectDisplayAction.setEnabled(false);
        if (this.spkScreenConfig != null && (spkGd = this.spkScreenConfig.getDevice()) != null && spkGd.isFullScreenSupported()) {
            spkGd.setFullScreenWindow(null);
        }
        if (this.recWindow != null) {
            this.prompter.removeSubjectViewer(this.recWindow.getPromptViewer());
            this.recWindow.detachFromRecStatus();
            Window w = this.recWindow.getWindow();
            SystemHelper.disposeWindowForReuse((Window)w);
        }
    }

    public void handleQuit() {
        boolean confirmed = true;
        try {
            confirmed = this.projectManager.close();
        }
        catch (AudioControllerException e) {
            e.printStackTrace();
            this.displayError("Audiocontroller error", e.getLocalizedMessage());
        }
        catch (StorageManagerException e) {
            e.printStackTrace();
            this.displayError("Storage error", e.getLocalizedMessage());
        }
        catch (WorkspaceException e) {
            e.printStackTrace();
            this.displayError("Workspace error", e.getLocalizedMessage());
        }
        catch (SpeechRecorderException e) {
            e.printStackTrace();
            this.displayError("SpeechRecorder error", e.getLocalizedMessage());
        }
        if (confirmed) {
            this.speechRecorder.shutdown();
        }
    }

    public void updateView() {
        if (this.levelMeterMode == 1) {
            this.setPlaybackLevel();
        } else if (this.levelMeterMode == 2 || this.levelMeterMode == 3) {
            this.setCaptureLevel();
        }
        long playbackPos = this.projectManager.getAudioController().getPlaybackFramePosition();
        this.audioUI.getAudioClip().setFramePosition(playbackPos);
    }

    @Override
    public void actionPerformed(ActionEvent newEvent) {
        Object eventSource = newEvent.getSource();
        if (eventSource == this.updateTimer) {
            this.updateView();
        } else {
            for (int i = 0; i < this.miAvailableProjects.length; ++i) {
                if (eventSource != this.miAvailableProjects[i]) continue;
                this.doOpenProject(newEvent.getActionCommand());
            }
            String actionCommand = newEvent.getActionCommand();
            if (eventSource == this.miNew) {
                this.doNew();
            } else if (eventSource == this.miWorkspace) {
                this.doWorkspaceUI();
            } else if (eventSource == this.miClose) {
                this.doClose();
            } else if (eventSource == this.miImport) {
                this.doImportProject();
            } else if (eventSource == this.miExport) {
                this.doExportProject();
            } else if (eventSource == this.miUpdateAutoAnnotation) {
                this.doUpdateAnnotations();
            } else if (eventSource == this.miPrint) {
                this.doPrint();
            } else if (eventSource == this.miSave) {
                this.doSave();
            } else if (eventSource == this.miUpdateManagerConfig) {
                this.doUpdateManagerConfig();
            } else if (eventSource == this.miQuit) {
                this.doQuit();
            } else if (eventSource == this.recLevel) {
                this.resetPeakLevelHolds();
            } else if (actionCommand.equals(this.miProjectSettings.getActionCommand())) {
                this.doProjectSettings();
            } else if (actionCommand.equals(this.miSpkSettings.getActionCommand())) {
                this.doSpkSettings();
            } else if (actionCommand.equals(this.miSpkTableExport.getActionCommand())) {
                this.doSpkTableExport();
            } else if (actionCommand.equals(this.miRecSettings.getActionCommand())) {
                this.doRecSettings();
            } else if (actionCommand.equals(this.miEditScriptSrc.getActionCommand())) {
                this.doEditScriptSource();
            } else if (actionCommand.equals(this.miScriptResources.getActionCommand())) {
                this.doScriptResources();
            } else if (actionCommand.equals(this.miImportScript.getActionCommand())) {
                this.doImportScript();
            } else if (actionCommand.equals(this.miExportScript.getActionCommand())) {
                this.doExportScript();
            } else if (actionCommand.equals(this.miPrintScript.getActionCommand())) {
                this.doPrintScript();
            } else if (actionCommand.equals(this.miSkipSettings.getActionCommand())) {
                this.doSkipSettings();
            } else if (actionCommand.equals(this.miInfo.getActionCommand())) {
                this.doInfo();
            } else if (actionCommand.equals(this.miContact.getActionCommand())) {
                this.doContact();
            } else if (actionCommand.equals(this.miAbout.getActionCommand())) {
                this.doAbout();
            } else if (actionCommand.equals(this.miCheckUpdates.getActionCommand())) {
                this.doCheckUpdates();
            }
        }
    }

    private void doSpkTableExport() {
        if (this.exportSpeakersDialog == null) {
            this.exportSpeakersDialog = new ExportSpeakersUIDialog();
        }
        Speakers speakers = this.projectManager.getSpeakerManager().getDatabaseLoader().getSpeakersDb();
        this.exportSpeakersDialog.setSpeakers(speakers);
        Object retVal = this.exportSpeakersDialog.showDialog(this);
    }

    private void doSessionClipsView() {
        List<AudioClip> acList = this.projectManager.getSessionClipList();
        if (acList != null) {
            System.out.println("Session recording count: " + acList.size());
            AudioClipsUIContainer sacsUi = new AudioClipsUIContainer();
            sacsUi.setAudioClips(acList);
            JScrollPane sp = new JScrollPane((Component)sacsUi);
            JFrame f = new JFrame();
            f.getContentPane().add(sp);
            f.setVisible(true);
            sacsUi.setFixXZoomFitToPanel(false);
            sacsUi.setXZoom(400.0);
            f.setExtendedState(6);
        }
    }

    public void doExportScript() {
        if (this.exportScriptDialog == null) {
            this.exportScriptDialog = new ExportScriptUIDialog();
        }
        RecScriptManager rsm = this.projectManager.getRecScriptManager();
        Script script = rsm.getScript();
        this.exportScriptDialog.setScript(script);
        Object retVal = this.exportScriptDialog.showDialog(this);
        if (!retVal.equals(2)) {
            // empty if block
        }
    }

    public void doPrintScript() {
    }

    public void doImportScript() {
        this.stopSession();
        this.projectManager.init();
        RecScriptManager recScriptManager = this.projectManager.getRecScriptManager();
        if (this.migrateScriptDTDIfRequired()) {
            Section newSection;
            Object retVal;
            Script script = recScriptManager.getScript();
            this.projectManager.resetItemcodeGenerator();
            ItemcodeGenerator icg = this.projectManager.getItemcodeGenerator();
            if (this.importScriptDialog == null) {
                this.importScriptDialog = new ImportScriptUIDialog(icg, (IntegerSequenceGenerator)this.projectManager.getSequenceGenerator());
            }
            if (!(retVal = this.importScriptDialog.showDialog(this)).equals(2) && (newSection = this.importScriptDialog.getSection()) != null) {
                script.getSections().add(newSection);
                newSection.setScript(script);
                recScriptManager.setScript(script);
                recScriptManager.setScriptSaved(false);
            }
        }
        try {
            this.projectManager.start();
        }
        catch (AudioControllerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Audio controller error:\n" + e.getLocalizedMessage(), "Session start error", 0);
        }
        catch (ProjectManagerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Project manager error:\n" + e.getLocalizedMessage(), "Session start error", 0);
        }
    }

    private void doAbout() {
        this.recTransporter.setKeyButtonBindingEnabled(false);
        SplashPanel splash = new SplashPanel();
        JFrame frame = new JFrame("About");
        frame.setIconImages(this.iconImages);
        frame.getContentPane().add(splash);
        frame.pack();
        frame.setVisible(true);
    }

    private void doInfo() {
        this.recTransporter.setKeyButtonBindingEnabled(false);
        this.infoViewer.setData();
        JOptionPane.showMessageDialog(this, this.infoViewer, "Info", 1);
    }

    private void doContact() {
        URI contactUri = null;
        try {
            contactUri = new URI("mailto:speechrecorder@phonetik.uni-muenchen.de");
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this, "Intern URI syntax error:\n" + e.getLocalizedMessage(), "Contact mail error", 0);
        }
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.mail(contactUri);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Could not open mail application:\n" + e.getLocalizedMessage(), "Contact mail error", 0);
            }
        }
    }

    public void doCheckUpdates() {
        UpdateManager updateManager;
        if (this.speechRecorder.checkAppUpdatesConsent(true) && (updateManager = this.speechRecorder.getUpdateManager()) != null) {
            updateManager.startLoadApplicationDescriptor();
            UpdateDialogUI updateDialog = new UpdateDialogUI(updateManager);
            Object res = updateDialog.showDialog((JFrame)this);
            if (res instanceof UpdateDialogUI.DownloadActionOption) {
                UpdateDialogUI.DownloadActionOption dao = (UpdateDialogUI.DownloadActionOption)res;
                ApplicationVersionDescriptor appDs = dao.getApplicationVersionDescriptor();
                try {
                    updateManager.desktopBrowseApplicationDownload(appDs);
                    if (dao.isRequestApplicationQuit()) {
                        this.handleQuit();
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Could not browse " + appDs + ": " + e.getLocalizedMessage(), "Open download URL error", 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOpenProject(String projectName) {
        this.projectManager.init();
        this.setWaiting(true);
        try {
            this.speechRecorder.openProject(projectName);
        }
        catch (SpeechRecorderPluginException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not load plugin class: " + e.getLocalizedMessage(), "Project open", 0);
            try {
                this.projectManager.close();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1.getLocalizedMessage(), "Project close", 0);
            }
        }
        catch (SpeechRecorderException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project open", 0);
            try {
                this.projectManager.close();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1.getLocalizedMessage(), "Project close", 0);
            }
        }
        finally {
            this.setWaiting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNew() {
        NewProjectConfiguration newProject = new NewProjectConfiguration();
        Object selectedValue = NewProjectDialog.showDialog(this, newProject, this.speechRecorder.getDefWorkspaceDir());
        if (selectedValue == null) {
            return;
        }
        if (selectedValue instanceof Integer) {
            int value = (Integer)selectedValue;
            if (value == 0) {
                this.setWaiting(true);
                this.repaint();
                try {
                    this.projectManager.close();
                    this.projectManager.newProject(newProject);
                    this.showSpeakerDatabase();
                    this.projectManager.start();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "New Project", 0);
                    e.printStackTrace();
                }
                finally {
                    this.setWaiting(false);
                }
            } else {
                return;
            }
        }
    }

    public void doClose() {
        try {
            this.projectManager.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project close", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImportProject() {
        this.projectManager.init();
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter((FileFilter)new ZipFileFilter());
        fc.setAcceptAllFileFilterUsed(true);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.setWaiting(true);
            File file = fc.getSelectedFile();
            try {
                this.speechRecorder.importProject(file);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project import", 0);
                e.printStackTrace();
            }
            finally {
                this.setWaiting(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExportProject() {
        if (this.projectManager.saveAllProjectDataInteractive()) {
            File file;
            String suggestedExportBaseDirName = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
            File suggestedExportBaseDir = new File(suggestedExportBaseDirName);
            File suggestedExportFile = new File(suggestedExportBaseDir, this.projectManager.getConfiguration().getName() + ".zip");
            ExportProjectUIDialog epd = new ExportProjectUIDialog();
            epd.setExportFile(suggestedExportFile);
            Object returnVal = epd.showDialog(this);
            if (!(returnVal.equals(2) || (file = epd.getExportFile()).exists() && JOptionPane.showConfirmDialog(this, file.getName() + " exists. Do you want to overwrite ?", "Overwrite file ?", 0) != 0)) {
                this.setWaiting(true);
                try {
                    ProjectExporter pe = new ProjectExporter();
                    pe.exportProject(this.projectManager.getProjectContext(), this.projectManager.getConfiguration(), file, epd.isExportSessionData(), this);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project export", 0);
                    e.printStackTrace();
                }
                finally {
                    this.setWaiting(false);
                }
            }
        }
    }

    private void doUpdateAnnotations() {
        ProjectUpdateAutoAnnotationsUIDialog d;
        Object returnVal;
        if (this.projectManager.saveAllProjectDataInteractive() && !(returnVal = (d = new ProjectUpdateAutoAnnotationsUIDialog()).showDialog(this)).equals(2)) {
            int res;
            boolean overwrite = d.isOverwriteAnnoFiles();
            if (overwrite && (res = JOptionPane.showConfirmDialog(this, "Do you really want to overwrite the annotation files of this project?", "Annotation files overwrite warning", 2, 2)) != 0) {
                return;
            }
            ProjectAutoAnnotatorWorker paaw = new ProjectAutoAnnotatorWorker(this.projectManager);
            paaw.setOverwriteAnnotationFiles(d.isOverwriteAnnoFiles());
            JProgressDialogPanel progressDialog = new JProgressDialogPanel((Worker)paaw, "Update auto annotations", "Updating...");
            try {
                paaw.open();
            }
            catch (WorkerException workerException) {
                // empty catch block
            }
            paaw.start();
            Object val = progressDialog.showDialog((JFrame)this);
            ProgressStatus finalStatus = paaw.getProgressStatus();
            try {
                paaw.close();
            }
            catch (WorkerException workerException) {
                // empty catch block
            }
            if (val.equals(2)) {
                finalStatus.canceled();
            }
            if (!finalStatus.isDone() && finalStatus.isError()) {
                JOptionPane.showMessageDialog(null, finalStatus.getMessage(), "Project auto annotation update error: ", 0);
            }
        }
    }

    private void doPrint() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        ComponentPrinter cp = new ComponentPrinter((Component)this.getContentPane());
        printJob.setPrintable((Printable)cp);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Print error", 0);
                e.printStackTrace();
                return;
            }
        }
    }

    public void doSave() {
        try {
            this.projectManager.saveProject();
            this.projectManager.saveScript();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project save", 0);
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        this.projectManager.init();
        try {
            DOMCodec dc = new DOMCodec();
            Document d = dc.createDocument((Object)this.projectManager.getConfiguration());
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                DOMConverter dco = new DOMConverter();
                dco.writeXML(d, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
                URL projURL = file.toURI().toURL();
                this.projectManager.setProjectURL(projURL);
                this.miSave.setEnabled(this.projectManager.getConfiguration().getEditable());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project save as", 0);
        }
    }

    public void doQuit() {
        this.handleQuit();
    }

    public void doUndo() {
    }

    public void doCut() {
    }

    public void doCopy() {
    }

    public void doPaste() {
    }

    public void doClear() {
    }

    public void doSelectAll() {
    }

    public void doWorkspaceUI() {
        if (this.workspaceDialog == null) {
            this.workspaceDialog = new WorkspacePanel(this.speechRecorder.getWorkspaceManager());
        }
        this.workspaceDialog.showDialog(this);
        List<WorkspaceProject> wsPrjs = this.speechRecorder.getWorkspaceManager().getWorkspaceProjects();
        this.setWorkspaceProjects(wsPrjs.toArray(new WorkspaceProject[wsPrjs.size()]));
    }

    public void closeWorkspaceDialog() {
        if (this.workspaceDialog != null) {
            this.workspaceDialog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProjectSettings() {
        this.projectManager.init();
        ProjectConfiguration newProject = null;
        URL projectUrl = this.projectManager.getProjectURL();
        try {
            newProject = this.projectManager.getConfigurationCopy();
            if (this.promptConfigurationView == null) {
                this.promptConfigurationView = new ProjectConfigurationView(newProject, (AudioController2)this.projectManager.getAudioController(), this.sessionManager.getActions(), this.speechRecorder.getBundleAnnotationPersistorServiceDescriptors(), this.speechRecorder.getAutoAnnotatorPluginManager(), this.projectManager, this.helpBroker);
            }
            this.promptConfigurationView.setProjectConfiguration(newProject);
            this.promptConfigurationView.setProjectContext(projectUrl);
            this.promptConfigurationView.setIconImages(this.iconImages);
            Object selectedValue = this.promptConfigurationView.showDialog(null);
            if (selectedValue != null && selectedValue instanceof Integer) {
                int value = (Integer)selectedValue;
                if (value == 0) {
                    this.setWaiting(true);
                    this.projectManager.close();
                    this.projectManager.setProjectURL(projectUrl);
                    newProject = this.promptConfigurationView.getProjectConfiguration();
                    AudioFormat newAudioFormat = newProject.getRecordingConfiguration().getFormat().toAudioFormat();
                    Profile profile = Profile.SPEECH_RECORDING;
                    List fmtWarns = AudioFormatUtils.getFormatQualityWarningsForProfile((AudioFormat)newAudioFormat, (Profile)profile);
                    if (fmtWarns != null && fmtWarns.size() > 0) {
                        StringBuffer msgSb = new StringBuffer("Recommended settings for " + profile + ":\n");
                        for (LocalizableMessage fmtwarn : fmtWarns) {
                            msgSb.append(fmtwarn.localize());
                            msgSb.append('\n');
                        }
                        JOptionPane.showMessageDialog(this, msgSb, "Audio format quality", 2);
                    }
                    boolean canceled = this.projectManager.configure(newProject);
                    this.projectManager.setProjectConfigurationSaved(false);
                    if (!canceled) {
                        this.showSpeakerDatabase();
                        this.projectManager.start();
                    }
                } else {
                    this.projectManager.start();
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Project change", 0);
            e.printStackTrace();
        }
        finally {
            this.setWaiting(false);
        }
    }

    private void doUpdateManagerConfig() {
        this.speechRecorder.configureUpdateManagerInteractive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSpeakerDatabase() {
        try {
            this.projectManager.rebuildDb();
        }
        catch (StorageManagerException e) {
            this.displayError("Error updating session list", "Could not update in memory db: " + e.getLocalizedMessage());
        }
        boolean waitStatusBefore = this.isWaiting();
        this.setWaiting(false);
        final SpeechRecorderUI owner = this;
        Runnable doSpeakerShow = new Runnable(){

            @Override
            public void run() {
                if (SpeechRecorderUI.this.spkDbView == null) {
                    SpeechRecorderUI.this.spkDbView = new SpeakerDatabaseViewer(owner, SpeechRecorderUI.this.projectManager.getSpeakerManager());
                    SpeechRecorderUI.this.spkDbView.setIconImages(SpeechRecorderUI.this.iconImages);
                }
                SpeechRecorderUI.this.spkDbView.displayViewer();
            }
        };
        if (EventQueue.isDispatchThread()) {
            doSpeakerShow.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(doSpeakerShow);
            }
            catch (Exception e) {
                System.err.println("Speaker selection error !! " + e.getLocalizedMessage());
                return;
            }
            finally {
                this.setWaiting(waitStatusBefore);
            }
        }
        this.setWaiting(waitStatusBefore);
        this.speakerViewer.setData(this.projectManager.getSpeaker());
        try {
            this.projectManager.saveSpeakerDatabase();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Speaker database saving error", 0);
            e.printStackTrace();
        }
    }

    public void doSpkSettings() {
        this.stopSession();
        this.projectManager.init();
        this.showSpeakerDatabase();
        SpeakerManager speakerManager = this.projectManager.getSpeakerManager();
        if (speakerManager.getSpeaker() == null) {
            this.projectManager.init();
        } else {
            try {
                this.projectManager.start();
            }
            catch (AudioControllerException e) {
                JOptionPane.showMessageDialog(this, "Audio controller error:\n" + e.getLocalizedMessage(), "Session start error", 0);
                e.printStackTrace();
            }
            catch (ProjectManagerException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Project manager error:\n" + e.getLocalizedMessage(), "Session start error", 0);
            }
        }
    }

    private boolean migrateScriptDTDIfRequired() {
        RecScriptManager recScriptManager = this.projectManager.getRecScriptManager();
        boolean dtdOK = true;
        try {
            if (recScriptManager.isNewVersionOfDTDFileRequired()) {
                int val = JOptionPane.showConfirmDialog(this, "The recording script needs needs to be migrated to a newer format. The converted script cannot be used with older Speechrecorder versions!", "Recording script format migration", 2, -1);
                if (val == 0) {
                    recScriptManager.createDTDFileIfRequired();
                } else {
                    dtdOK = false;
                }
            }
        }
        catch (IOException e) {
            dtdOK = false;
        }
        return dtdOK;
    }

    public void doEditScript() {
        this.doEditScript(null);
    }

    public void doEditScript(PromptItem requestPromptItem) {
        RecScriptManager recScriptManager = this.projectManager.getRecScriptManager();
        if (requestPromptItem == null) {
            requestPromptItem = this.sessionManager.getProgressManager().getCurrentPromptItem();
        }
        this.stopSession();
        this.projectManager.init();
        if (this.migrateScriptDTDIfRequired()) {
            Object retVal;
            Script script = recScriptManager.getScript();
            this.projectManager.resetItemcodeGenerator();
            ItemcodeGenerator icg = this.projectManager.getItemcodeGenerator();
            if (this.scriptUIDialog == null) {
                this.scriptUIDialog = new ScriptUIDialog(this.projectManager.getProjectContext(), (IntegerSequenceGenerator)this.projectManager.getSequenceGenerator(), icg, this.promptPresentersClassList, this.helpBroker);
                this.scriptUIDialog.setPromptFontConfig(this.promptFontConfig);
                this.scriptUIDialog.setInstructionsFontFamilies(this.instructionsFontFamilies);
                this.scriptUIDialog.setDescriptionFontFamilies(this.descriptionFontFamilies);
            }
            ScriptUI scriptUI = this.scriptUIDialog.getScriptUI();
            scriptUI.setDefaultPromptFont(this.promptFont);
            scriptUI.setDefaultSectionMode(recScriptManager.getDefaultMode());
            scriptUI.setDefaultPreRecording(recScriptManager.getDefaultPreDelay());
            scriptUI.setDefaultPostRecording(recScriptManager.getDefaultPostDelay());
            scriptUI.setDefaultPromptAutoPlay(recScriptManager.isDefaultAutomaticPromptPlay());
            Script editScript = null;
            Integer requestPosition = script.promptItemIndex(requestPromptItem);
            try {
                DOMCodec dc = new DOMCodec();
                script.getSessions().clear();
                for (PromptItem pi : script.promptItemsList()) {
                    if (!(pi instanceof Recording)) continue;
                    Recording r = (Recording)pi;
                    r.getRecordingFiles().clear();
                }
                editScript = (Script)dc.copy((Object)script);
                editScript.updateUpwardsRelations();
            }
            catch (DOMCodecException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Script clone error:\n" + e.getLocalizedMessage(), "Script clone error", 0);
            }
            this.scriptUIDialog.setScript(editScript);
            try {
                this.projectManager.updateItemCodesInUseSet();
            }
            catch (StorageManagerException e) {
                e.printStackTrace();
                this.displayError("Could not update used item code set: ", e);
            }
            this.scriptUIDialog.setItemCodesInUse(this.projectManager.getItemCodesInUse());
            if (requestPosition != null) {
                List editPiList = editScript.promptItemsList();
                int editPiListsize = editPiList.size();
                if (requestPosition < editPiListsize) {
                    this.scriptUIDialog.setSelectedPromptItem((PromptItem)editPiList.get(requestPosition));
                }
            }
            if (!(retVal = this.scriptUIDialog.showDialog(this, Dialog.ModalityType.DOCUMENT_MODAL)).equals(2)) {
                recScriptManager.setScript(editScript);
                recScriptManager.setScriptSaved(false);
            }
        }
        try {
            this.projectManager.start();
        }
        catch (AudioControllerException e) {
            JOptionPane.showMessageDialog(this, "Audio controller error:\n" + e.getLocalizedMessage(), "Session start error", 0);
            e.printStackTrace();
        }
        catch (ProjectManagerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Project manager error:\n" + e.getLocalizedMessage(), "Session start error", 0);
        }
    }

    private void doEditScriptSource() {
        this.stopSession();
        this.projectManager.init();
        RecScriptManager recScriptManager = this.projectManager.getRecScriptManager();
        if (this.migrateScriptDTDIfRequired()) {
            Script script = recScriptManager.getScript();
            if (this.scriptSrcEditor == null) {
                this.scriptSrcEditor = new ScriptSourceEditor();
            }
            String xmlSystemID = this.projectManager.getProjectContext().toExternalForm();
            this.scriptSrcEditor.setSystemIdBase(xmlSystemID);
            this.scriptSrcEditor.setSystemId("SpeechRecPrompts_4.dtd");
            this.scriptSrcEditor.setScript(script);
            Object retVal = this.scriptSrcEditor.showDialog(this);
            if (!retVal.equals(2)) {
                this.projectManager.setScriptSaved(false);
                Script editedScript = this.scriptSrcEditor.getScript();
                recScriptManager.setScript(editedScript);
            }
        }
        try {
            this.projectManager.start();
        }
        catch (AudioControllerException e) {
            JOptionPane.showMessageDialog(this, "Audio controller error:\n" + e.getLocalizedMessage(), "Session start error", 0);
            e.printStackTrace();
        }
        catch (ProjectManagerException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Project manager error:\n" + e.getLocalizedMessage(), "Session start error", 0);
        }
    }

    public void doScriptResources() {
        File projectDir = null;
        try {
            projectDir = this.projectManager.getProjectDir();
        }
        catch (MalformedURLException | URISyntaxException e) {
            JOptionPane.showMessageDialog(this, "Could not get project direcory resources directory: " + e.getLocalizedMessage(), "Project resources directory error", 0);
            e.printStackTrace();
        }
        if (projectDir != null) {
            File resourcesDir = new File(projectDir, "resources");
            if (!resourcesDir.exists()) {
                int res = JOptionPane.showConfirmDialog(this, "Project resource directory " + resourcesDir.getPath() + " does not exist.\nCreate ?", "Project resources directory", 2);
                if (res == 0) {
                    Path resourcespath = resourcesDir.toPath();
                    try {
                        Files.createDirectory(resourcespath, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Could not create project resources directory " + resourcespath + ": " + e.getLocalizedMessage(), "Project resources directory error", 0);
                    }
                } else {
                    return;
                }
            }
            if (resourcesDir != null && resourcesDir.exists()) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop d = Desktop.getDesktop();
                        d.open(resourcesDir);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(this, "Could not open project resources directory:\n" + resourcesDir + "\nError: " + e.getLocalizedMessage(), "Project resources directory open error", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "Your Java desktop is not supported. Please navigate your file manager manually to the directory:\n" + resourcesDir, "Project resources directory open error", 0);
                }
            }
        }
    }

    public void doRecSettings() {
        if (this.mixerUI == null) {
            this.setWaiting(true);
            try {
                this.mixerUI = new PortMixersUI();
            }
            catch (LineUnavailableException e) {
                this.setWaiting(false);
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Mixer device error", 0);
                e.printStackTrace();
            }
            this.setWaiting(false);
        }
        this.mixerUI.showDialog((Frame)this);
    }

    public void doSkipSettings() {
        this.recTransporter.setKeyButtonBindingEnabled(false);
        String s = JOptionPane.showInputDialog(this.uiString.getString("SkipNItemsText"));
        if (s != null) {
            try {
                int skipTo = Integer.parseInt(s);
                this.sessionManager.setRecIndex(skipTo);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, s + " is not a number !", "Warning", 2);
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showMessageDialog(null, "Cannot skip to index " + s, "Warning", 2);
            }
        }
        this.recTransporter.setKeyButtonBindingEnabled(true);
    }

    public void doDisplaySettings() {
        if (this.recWindow != null) {
            boolean recWindowActive = this.recWindow.isWindowActive();
            this.sessionManager.setSpeakerWindowShowing(!recWindowActive);
        }
    }

    public JComponent getUploadCacheUI() {
        return new UploadCacheUI(this.projectManager.getUploadCache());
    }

    public Component getActiveComponent() {
        if (this.recWindow != null && this.recWindow.isWindowActive()) {
            return this.recWindow.getWindow();
        }
        return this;
    }

    @Override
    public Component getDialogTarget() {
        if (this.expScreenConfig == this.spkScreenConfig) {
            return this.getActiveComponent();
        }
        return this;
    }

    @Override
    public void displayError(String title, Throwable cause) {
        JOptionPane.showMessageDialog(this.getDialogTarget(), cause.getLocalizedMessage(), title, 0);
        cause.printStackTrace();
    }

    @Override
    public void displayError(String title, String errMsg) {
        JOptionPane.showMessageDialog(this.getDialogTarget(), errMsg, title, 0);
        System.err.println(errMsg);
    }

    public void setProjectConfigurationSaved(boolean b) {
        boolean editable = this.projectManager.getConfiguration().getEditable();
        this.miSave.setEnabled(!b && editable);
    }

    public void setWorkspaceProjects(WorkspaceProject[] workspaceProjects) {
        this.openSubMenu.removeAll();
        this.miAvailableProjects = new JMenuItem[workspaceProjects.length];
        if (workspaceProjects.length > 0) {
            for (int i = 0; i < workspaceProjects.length; ++i) {
                String description;
                String wspNm;
                WorkspaceProject wsp = workspaceProjects[i];
                if (wsp == null || (wspNm = wsp.getName()) == null) continue;
                this.miAvailableProjects[i] = new JMenuItem(wspNm);
                this.openSubMenu.add(this.miAvailableProjects[i]);
                ProjectConfiguration pc = wsp.getConfiguration();
                if (pc != null && (description = pc.getDescription()) != null && !"".equals(description)) {
                    this.miAvailableProjects[i].setToolTipText(description);
                }
                this.miAvailableProjects[i].addActionListener(this);
            }
        }
    }

    void setWaiting(boolean b) {
        this.waiting = b;
        if (this.waiting) {
            this.getContentPane().setCursor(this.waitCursor);
        } else {
            this.getContentPane().setCursor(this.defCursor);
        }
    }

    public void setEnableOpenOrNewProject(boolean b) {
        this.miNew.setEnabled(b);
        this.miImport.setEnabled(b);
        this.openSubMenu.setEnabled(b);
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setSpeakerWindowShowing(boolean showWindow) {
        assert (EventQueue.isDispatchThread());
        this.toggleSubjectDisplayAction.setSelected(showWindow);
        this.recWindow.setWindowActive(showWindow);
        Window w = this.recWindow.getWindow();
        if (w instanceof Frame) {
            Frame f = (Frame)w;
            if (showWindow) {
                if (!this.fullScreenMode) {
                    f.pack();
                }
            } else if (this.applyWorkaroundBugID0006) {
                f.setExtendedState(0);
            }
            f.setVisible(showWindow);
            if (showWindow) {
                f.setExtendedState(6);
            }
        } else {
            w.setVisible(showWindow);
        }
        if (this.fullScreenMode) {
            if (showWindow) {
                this.spkScreenConfig.getDevice().setFullScreenWindow(w);
            } else {
                this.spkScreenConfig.getDevice().setFullScreenWindow(null);
            }
        }
        PromptViewer promptViewer = this.prompter.getExperimenterViewer();
        promptViewer.setSilent(showWindow);
    }

    public LevelMeter getLevelMeter() {
        return this.recLevel;
    }

    public int getLevelMeterMode() {
        return this.levelMeterMode;
    }

    public void setLevelMeterMode(int levelMeterMode) {
        int lastMode = this.levelMeterMode;
        this.levelMeterMode = levelMeterMode;
        if (levelMeterMode == 0) {
            this.recLevel.setAudioStatus(AudioStatus.Status.OFF);
            this.updateTimer.stop();
            this.abandonLevelDecay();
            if (lastMode == 3 || lastMode == 2) {
                this.resetCaptureIntervalPeakLevel();
                this.resetCaptureLevel();
            } else if (lastMode == 1) {
                this.setPlaybackLevel();
            }
        } else {
            if (levelMeterMode == 3) {
                this.recLevel.setAudioStatus(AudioStatus.Status.RECORDING);
            } else if (levelMeterMode == 1) {
                this.recLevel.setAudioStatus(AudioStatus.Status.PLAYBACK);
            } else if (levelMeterMode == 2) {
                this.recLevel.setAudioStatus(AudioStatus.Status.CAPTURE);
            }
            this.setLevelMeterLight(levelMeterMode == 2);
            this.updateTimer.start();
        }
    }

    private void setPlaybackLevel() {
        if (this.recLevel != null) {
            LevelInfo[] lis = this.projectManager.getAudioController().getPlaybackLevelInfos();
            this.recLevel.setLevelInfos(lis);
            if (lis != null) {
                for (LevelInfo li : lis) {
                    li.resetIntervalPeakLevel();
                }
            }
        }
    }

    private void setLevelMeterLight(boolean light) {
        if (this.recLevel != null) {
            if (light) {
                this.recLevel.setTransparency(0.3f);
            } else {
                this.recLevel.setTransparency(1.0f);
            }
        }
    }

    private void resetCaptureIntervalPeakLevel() {
        LevelInfo[] lis;
        if (this.recLevel != null && (lis = this.projectManager.getAudioController().getCaptureLevelInfos()) != null) {
            for (LevelInfo li : lis) {
                li.resetIntervalPeakLevel();
            }
        }
    }

    private void setCaptureLevel() {
        if (this.recLevel != null) {
            LevelInfo[] lis = this.projectManager.getAudioController().getCaptureLevelInfos();
            this.recLevel.setLevelInfos(lis);
            this.resetCaptureIntervalPeakLevel();
        }
    }

    private void abandonLevelDecay() {
        if (this.recLevel != null) {
            this.recLevel.abandonDecay();
        }
    }

    private void resetCaptureLevel() {
        LevelInfo[] lis;
        if (this.recLevel != null && (lis = this.projectManager.getAudioController().getCaptureLevelInfos()) != null) {
            LevelInfo[] resetLis = new LevelInfo[lis.length];
            for (int i = 0; i < lis.length; ++i) {
                resetLis[i] = new LevelInfo();
                lis[i].mergePeakLevelHold(resetLis[i]);
            }
            this.recLevel.setLevelInfos(resetLis);
            this.resetCaptureIntervalPeakLevel();
        }
    }

    private void resetPeakLevelHolds(LevelInfo[] lis) {
        if (lis != null) {
            for (LevelInfo li : lis) {
                li.resetPeakLevelHold();
            }
        }
    }

    private void resetPeakLevelHolds() {
        if (this.recLevel != null) {
            LevelInfo[] cLis = this.projectManager.getAudioController().getCaptureLevelInfos();
            this.resetPeakLevelHolds(cLis);
            LevelInfo[] pLis = this.projectManager.getAudioController().getPlaybackLevelInfos();
            this.resetPeakLevelHolds(pLis);
            this.updateView();
        }
    }

    public void setEditingEnabled(boolean b) {
        boolean projectEditable = this.projectManager.isProjectEditable();
        this.editingEnabled = b;
        if (this.scriptUIDialog != null) {
            this.scriptUIDialog.setEnabled(projectEditable && this.editingEnabled);
        }
        this.miExport.setEnabled(projectEditable && this.editingEnabled);
        this.miClose.setEnabled(projectEditable && this.editingEnabled);
        this.miProjectSettings.setEnabled(projectEditable && this.editingEnabled);
        this.miSpkSettings.setEnabled(projectEditable && this.editingEnabled);
        this.miSpkTableExport.setEnabled(projectEditable && this.editingEnabled);
        this.miEditScriptSrc.setEnabled(projectEditable && this.editingEnabled);
        this.miScriptResources.setEnabled(projectEditable && this.editingEnabled);
        this.progressViewer.setEditEnabled(projectEditable && this.editingEnabled);
    }

    public void openPlayPrompt() throws PrompterException {
        this.prompter.open();
    }

    public void startPlayPrompt() {
        this.prompter.start();
    }

    public void stopPlayPrompt() {
        this.prompter.stop();
    }

    public void closePrompt() {
        this.prompter.close();
    }

    public boolean isPromptClosed() {
        boolean promptViewerClosed = this.prompter.isPresenterClosed();
        return promptViewerClosed;
    }

    @Override
    public void update(PromptViewerEvent promptViewerEvent) {
        this.sessionManager.update(promptViewerEvent);
    }

    public void updateSaveEnable() {
        ProjectConfiguration pc = this.projectManager.getConfiguration();
        if (pc != null) {
            boolean editable = pc.getEditable();
            boolean saved = this.projectManager.isProjectConfigurationSaved() && this.projectManager.getSpeakerManager().isDatabaseSaved() && this.projectManager.isScriptSaved();
            this.miSave.setEnabled(!saved && editable);
        }
    }

    public PromptViewer getPromptViewer() {
        PromptViewer promptViewer = this.prompter.getExperimenterViewer();
        return promptViewer;
    }

    public RecWindow getRecWindow() {
        return this.recWindow;
    }

    public void setProjectContext(URL projectContext) {
        if (this.progressViewer != null) {
            this.progressViewer.setProjectContext(projectContext);
        }
        if (this.scriptUIDialog != null) {
            this.scriptUIDialog.setProjectContext(projectContext);
        }
    }

    public void setRecDisplay(URL[] recUrls) {
    }

    public boolean isAutoRecording() {
        return this.autoRecording;
    }

    public void setAutoRecording(boolean autoRecording) {
        this.autoRecording = autoRecording;
        this.recTransporter.setAutoRecording(autoRecording);
        this.recWindow.getRecTransporter().setAutoRecording(autoRecording);
    }

    public boolean isPlaybackEnabled() {
        return this.playbackEnabled;
    }

    public void setPlaybackEnabled(boolean playbackEnabled) {
        this.playbackEnabled = playbackEnabled;
        this.recTransporter.setPlaybackEnabled(playbackEnabled);
        this.recWindow.getRecTransporter().setPlaybackEnabled(playbackEnabled);
    }

    public boolean isProgressPaused() {
        return this.progressPaused;
    }

    public void setProgressPaused(boolean progressPaused) {
        this.progressPaused = progressPaused;
        this.recTransporter.setProgressPaused(progressPaused);
        this.recWindow.getRecTransporter().setProgressPaused(progressPaused);
    }

    public void setStartStopSignalClass(Class<? extends StartStopSignal> startStopSignalPlugin) throws PluginLoadingException {
        StartStopSignal startStopSignal = null;
        StartStopSignal startStopSignalRecWindow = null;
        try {
            startStopSignal = startStopSignalPlugin.getConstructor(new Class[0]).newInstance(new Object[0]);
            startStopSignalRecWindow = startStopSignalPlugin.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new PluginLoadingException(startStopSignalPlugin, e);
        }
        this.recMonitor.setStartStopSignal(startStopSignal);
        this.recWindow.getRecMonitor().setStartStopSignal(startStopSignalRecWindow);
    }

    public void setPromptPresenterServiceDescriptors(List<PromptPresenterServiceDescriptor> promptPresenterClassList) {
        this.promptPresentersClassList = promptPresenterClassList;
    }

    public class ToggleSubjectDisplayAction
    extends CheckActionLeaf {
        public ToggleSubjectDisplayAction(LocalizableMessage displayName) {
            super(displayName);
        }

        public void actionPerformed(ActionEvent arg0) {
            SpeechRecorderUI.this.doDisplaySettings();
        }
    }
}

