/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.annotation.auto;

import ips.annot.model.db.Bundle;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.Session;
import ips.annot.model.emu.EmuDB;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AutoAnnotationManager {
    private Session annotationSession;

    public Session getAnnotationSession() {
        return this.annotationSession;
    }

    public void setAnnotationSession(Session annotationSession) {
        this.annotationSession = annotationSession;
    }

    public Bundle buildBundle(EmuDB dbConfig, String bundleName, File[] recFiles) throws IOException, UnsupportedAudioFileException, AudioSourceException {
        Bundle bundle = new Bundle();
        bundle.setSession(this.annotationSession);
        bundle.setName(bundleName);
        if (dbConfig != null) {
            List lvldefs = dbConfig.getLevelDefinitions();
            for (LevelDefinition lvlDef : lvldefs) {
                Level lvl = new Level();
                lvl.setDefinition(lvlDef);
                lvl.setBundle(bundle);
                bundle.getLevels().add(lvl);
            }
        }
        if (recFiles != null && recFiles.length > 0) {
            File masterFile = recFiles[0];
            bundle.setAnnotates(masterFile.getName());
            ConvenienceFileAudioSource cfas = new ConvenienceFileAudioSource(masterFile);
            AudioFormat af = cfas.getFormat();
            long fl = cfas.getFrameLength();
            bundle.setSampleRate(Float.valueOf(af.getSampleRate()));
            bundle.setFrameLength(Long.valueOf(fl));
        }
        ArrayList<String> sigPathes = new ArrayList<String>();
        for (File rf : recFiles) {
            sigPathes.add(rf.getAbsolutePath());
        }
        bundle.setSignalpaths(sigPathes);
        return bundle;
    }
}

