/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.annotation.auto;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.autoannotator.BundleAutoAnnotation;
import ips.annot.autoannotator.ParsedAutoAnnotation;
import ips.annot.model.db.Bundle;
import ipsk.awt.ProgressWorker;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressEvent;
import ipsk.util.ProgressStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class AutoAnnotationWorker
extends ProgressWorker {
    private BlockingQueue<AutoAnnotator.AnnotationRequest> queue = new LinkedBlockingQueue<AutoAnnotator.AnnotationRequest>();
    private List<AutoAnnotator> autoAnnotators = new ArrayList<AutoAnnotator>();

    public AutoAnnotationWorker() {
        super("Auto annotation worker");
    }

    public void request(AutoAnnotator.AnnotationRequest annotationRequest) {
        this.queue.add(annotationRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() throws WorkerException {
        while (this.progressStatus.getStatus().isRunning()) {
            ProgressStatus progressStatus = this.progressStatus;
            synchronized (progressStatus) {
                if (Worker.State.CANCEL.equals((Object)this.progressStatus.getStatus())) {
                    this.progressStatus.canceled();
                    break;
                }
            }
            try {
                Bundle bundle;
                AutoAnnotator.AnnotationRequest ar = this.queue.poll(600L, TimeUnit.SECONDS);
                if (ar == null || (bundle = ar.getBundle()) == null) continue;
                Exception exception = null;
                for (AutoAnnotator annotator : this.autoAnnotators) {
                    try {
                        if (!annotator.isBundleSupported(bundle)) continue;
                        annotator.setAnnotationRequest(ar);
                        AutoAnnotation anno = (AutoAnnotation)annotator.call();
                        if (anno == null) continue;
                        if (anno instanceof BundleAutoAnnotation) {
                            Bundle resBundle = ((BundleAutoAnnotation)anno).getBundle();
                            if (resBundle == null) continue;
                            bundle = resBundle;
                            continue;
                        }
                        if (!(anno instanceof ParsedAutoAnnotation)) continue;
                        ParsedAutoAnnotation paa = (ParsedAutoAnnotation)anno;
                        bundle.getLevels().addAll(paa.getLevels());
                    }
                    catch (Exception e) {
                        exception = e;
                        break;
                    }
                }
                if (exception != null) continue;
                BundleAnnotatedEvent bae = new BundleAnnotatedEvent((Object)this, bundle, this.progressStatus.clone());
                this.fireProgressEvent(bae);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public List<AutoAnnotator> getAutoAnnotators() {
        return this.autoAnnotators;
    }

    public class BundleAnnotatedEvent
    extends ProgressEvent {
        private Bundle annotatedBundle;

        public BundleAnnotatedEvent(Object arg0, Bundle bundle, ProgressStatus progressStatus) {
            super(arg0, progressStatus);
            this.annotatedBundle = bundle;
        }

        public Bundle getAnnotatedBundle() {
            return this.annotatedBundle;
        }
    }
}

