/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.annotation.auto;

import ips.annot.BundleAnnotationPersistor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.io.BundleAnnotationFilePersistor;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Session;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationManager;
import ipsk.apps.speechrecorder.annotation.auto.impl.PromptAutoAnnotator;
import ipsk.apps.speechrecorder.annotation.auto.impl.TemplateAutoAnnotator;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.db.speech.LocalizedText;
import ipsk.db.speech.Project;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.script.Recording;
import ipsk.text.EncodeException;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressUpdate;
import ipsk.util.Task;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.sound.sampled.AudioFormat;

public class ProjectAutoAnnotator
implements Task {
    private ActiveProjectManager projectManager;
    private volatile boolean cancelRequest = false;

    public ProjectAutoAnnotator(ActiveProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void autoAnnotateProject(boolean overwrite, ProgressUpdate progressUpdate) throws IOException, URISyntaxException, SpeechRecorderException, ProjectManagerException {
        if (progressUpdate != null) {
            progressUpdate.getProgressStatus().setIndeterminate(true);
        }
        AutoAnnotationManager autoAnnotationManager = new AutoAnnotationManager();
        try {
            if (progressUpdate != null) {
                progressUpdate.getProgressStatus().setMessage(new LocalizableMessage("Calculate approximate duration..."));
                progressUpdate.fireProgressEvent();
            }
            this.projectManager.rebuildDb();
            Project prjDb = this.projectManager.getProjectDb();
            SessionStorageManager projectStorageManager = this.projectManager.getProjectStorageManager();
            int recFileCnt = 0;
            Set sesss = prjDb.getSessions();
            for (ipsk.db.speech.Session sess : sesss) {
                projectStorageManager.updateRecFiles(sess, true);
                Set rfs = sess.getRecordingFiles();
                if (rfs == null) continue;
                recFileCnt += rfs.size();
            }
            if (progressUpdate != null) {
                progressUpdate.getProgressStatus().setLength((long)recFileCnt);
                progressUpdate.getProgressStatus().setIndeterminate(false);
                progressUpdate.getProgressStatus().setMessage(new LocalizableMessage("Auto annotating..."));
                progressUpdate.fireProgressEvent();
            }
            List<BundleAnnotationPersistor> bundleAnnotationPersistorList = this.projectManager.getBundleAnnotationPersistorList();
            int annotRecFileCnt = 0;
            for (ipsk.db.speech.Session sess : sesss) {
                Session annotSession = new Session();
                projectStorageManager.updateRecFiles(sess, true);
                int sessionId = sess.getSessionId();
                String sessIdStr = projectStorageManager.sessionIDString(sessionId);
                if (progressUpdate != null) {
                    progressUpdate.getProgressStatus().setMessage(new LocalizableMessage("Auto annotating session \"" + sessIdStr + "\"..."));
                    progressUpdate.fireProgressEvent();
                }
                File sessDir = projectStorageManager.sessionDirForSessionID(sessionId);
                annotSession.setName(sessIdStr);
                autoAnnotationManager.setAnnotationSession(annotSession);
                Set rfs = sess.getRecordingFiles();
                if (rfs == null) continue;
                for (RecordingFile rf : rfs) {
                    Recording r = rf.getRecording();
                    String ic = r.getItemcode();
                    int recVers = 0;
                    Integer recVersion = rf.getVersion();
                    if (recVersion != null) {
                        recVers = recVersion;
                    }
                    String bundleRootFn = projectStorageManager.getRootFileName(sessionId, ic, sess.getCode(), recVers);
                    String sigUrlsStr = rf.getSignalFile();
                    URL sigUrl = new URL(sigUrlsStr);
                    File recFile = new File(sigUrl.toURI().getPath());
                    boolean annotRequired = false;
                    if (this.cancelRequest) {
                        if (progressUpdate != null) {
                            progressUpdate.getProgressStatus().canceled();
                            progressUpdate.fireProgressEvent();
                        }
                        return;
                    }
                    if (overwrite) {
                        annotRequired = true;
                    } else {
                        for (BundleAnnotationPersistor bap : bundleAnnotationPersistorList) {
                            BundleAnnotationFilePersistor bafp;
                            File annoFile;
                            if (!(bap instanceof BundleAnnotationFilePersistor) || (annoFile = new File(sessDir, bundleRootFn + (bafp = (BundleAnnotationFilePersistor)bap).getPreferredFilenameSuffix() + "." + bafp.getPreferredFileExtension())).exists()) continue;
                            annotRequired = true;
                            break;
                        }
                    }
                    if (annotRequired) {
                        ArrayList<String> sigPathes;
                        String annotates;
                        String bNm;
                        Session s;
                        Bundle annotBundle = null;
                        if (annotBundle == null) {
                            annotBundle = new Bundle();
                        }
                        if ((s = annotBundle.getSession()) == null) {
                            annotBundle.setSession(annotSession);
                        }
                        if ((bNm = annotBundle.getName()) == null) {
                            annotBundle.setName(bundleRootFn);
                        }
                        if ((annotates = annotBundle.getAnnotates()) == null) {
                            annotBundle.setAnnotates(recFile.getName());
                        }
                        if ((sigPathes = annotBundle.getSignalpaths()) == null) {
                            sigPathes = new ArrayList<String>();
                        }
                        if (sigPathes.size() == 0) {
                            sigPathes.add(recFile.getAbsolutePath());
                            annotBundle.setSignalpaths(sigPathes);
                        }
                        Float sr = annotBundle.getSampleRate();
                        Long frLen = annotBundle.getFrameLength();
                        if (sr == null || frLen == null) {
                            try {
                                ConvenienceFileAudioSource cfas = new ConvenienceFileAudioSource(recFile);
                                AudioFormat af = cfas.getFormat();
                                long fl = cfas.getFrameLength();
                                annotBundle.setSampleRate(Float.valueOf(af.getSampleRate()));
                                annotBundle.setFrameLength(Long.valueOf(fl));
                            }
                            catch (AudioSourceException e) {
                                e.printStackTrace();
                            }
                        }
                        for (AutoAnnotator aa : this.projectManager.getEnabledAutoAnnotators()) {
                            if (!aa.isBundleSupported(annotBundle)) continue;
                            AutoAnnotator.AnnotationRequest ar = new AutoAnnotator.AnnotationRequest(annotBundle);
                            aa.setAnnotationRequest(ar);
                            if (aa instanceof PromptAutoAnnotator) {
                                PromptAutoAnnotator paa = (PromptAutoAnnotator)aa;
                                paa.open();
                                paa.setPromptText(r.getDescription());
                                paa.call();
                                paa.close();
                                continue;
                            }
                            if (aa instanceof TemplateAutoAnnotator) {
                                TemplateAutoAnnotator taa = (TemplateAutoAnnotator)aa;
                                taa.open();
                                String templText = null;
                                LocalizedText lt = r.annotationTemplateLocalizedText();
                                if (lt != null) {
                                    templText = lt.getText();
                                    Locale templLocale = lt.getLocale();
                                    if (templLocale == null) {
                                        templLocale = Locale.getDefault();
                                    }
                                    annotBundle.setLocale(templLocale);
                                }
                                taa.setTemplateText(templText);
                                taa.call();
                                taa.close();
                                continue;
                            }
                            aa.open();
                            aa.call();
                            aa.close();
                        }
                        for (BundleAnnotationPersistor bap : bundleAnnotationPersistorList) {
                            BundleAnnotationFilePersistor bafp;
                            File annoFile;
                            if (!(bap instanceof BundleAnnotationFilePersistor) || (annoFile = new File(sessDir, bundleRootFn + (bafp = (BundleAnnotationFilePersistor)bap).getPreferredFilenameSuffix() + "." + bafp.getPreferredFileExtension())).exists() && !overwrite) continue;
                            bafp.setFile(annoFile);
                            if (!bap.isWritable(annotBundle)) continue;
                            try {
                                bap.write(annotBundle);
                            }
                            catch (EncodeException ee) {
                                ee.printStackTrace();
                            }
                        }
                    }
                    ++annotRecFileCnt;
                    if (progressUpdate == null) continue;
                    progressUpdate.getProgressStatus().setProgress((long)annotRecFileCnt);
                    progressUpdate.fireProgressEvent();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        this.cancelRequest = true;
    }
}

