/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.KeyInputMap;
import ipsk.apps.speechrecorder.config.KeyStrokeAction;
import ipsk.apps.speechrecorder.session.action.CloseSpeakerDisplayAction;
import ipsk.swing.JKeyChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class KeyInputMapView
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox[] enableBoxes;
    private JKeyChooser[] keyChoosers;
    private JLabel[] ctrlLabels;
    private JCheckBox[] ctrlModifierBoxes;
    private JLabel[] shiftLabels;
    private JCheckBox[] shiftModifierBoxes;
    private JLabel[] altLabels;
    private JCheckBox[] altModifierBoxes;
    private JCheckBox consumeAllBox;
    private Action[] actions;

    public KeyInputMapView(Action[] actions) {
        super(new GridBagLayout());
        this.actions = actions;
        int actionCount = 0;
        if (actions != null) {
            actionCount = actions.length;
        }
        this.enableBoxes = new JCheckBox[actionCount];
        this.keyChoosers = new JKeyChooser[actionCount];
        this.shiftLabels = new JLabel[actionCount];
        this.shiftModifierBoxes = new JCheckBox[actionCount];
        this.altLabels = new JLabel[actionCount];
        this.altModifierBoxes = new JCheckBox[actionCount];
        this.ctrlLabels = new JLabel[actionCount];
        this.ctrlModifierBoxes = new JCheckBox[actionCount];
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 19;
        c.fill = 2;
        c.gridy = 0;
        for (int i = 0; i < actionCount; ++i) {
            c.gridx = 0;
            this.add((Component)new JLabel(actions[i].getValue("ShortDescription") + ": "), c);
            ++c.gridx;
            this.enableBoxes[i] = new JCheckBox();
            this.enableBoxes[i].addActionListener(this);
            this.add((Component)this.enableBoxes[i], c);
            ++c.gridx;
            this.keyChoosers[i] = new JKeyChooser();
            this.keyChoosers[i].setEnabled(false);
            this.ctrlLabels[i] = new JLabel("Ctrl");
            this.ctrlModifierBoxes[i] = new JCheckBox();
            this.shiftLabels[i] = new JLabel("Shift");
            this.shiftModifierBoxes[i] = new JCheckBox();
            this.altLabels[i] = new JLabel("Alt");
            this.altModifierBoxes[i] = new JCheckBox();
            this.setEnabled(i, false);
            this.keyChoosers[i].addActionListener((ActionListener)this);
            this.add((Component)this.keyChoosers[i], c);
            ++c.gridx;
            this.add((Component)this.shiftLabels[i], c);
            ++c.gridx;
            this.shiftModifierBoxes[i].addActionListener(this);
            this.add((Component)this.shiftModifierBoxes[i], c);
            ++c.gridx;
            this.add((Component)this.altLabels[i], c);
            ++c.gridx;
            this.altModifierBoxes[i].addActionListener(this);
            this.add((Component)this.altModifierBoxes[i], c);
            ++c.gridx;
            this.add((Component)this.ctrlLabels[i], c);
            ++c.gridx;
            this.ctrlModifierBoxes[i].addActionListener(this);
            this.add((Component)this.ctrlModifierBoxes[i], c);
            ++c.gridy;
        }
        c.gridx = 0;
        this.add((Component)new JLabel("Ignore other key strokes "), c);
        ++c.gridx;
        this.consumeAllBox = new JCheckBox();
        this.consumeAllBox.addActionListener(this);
        this.add((Component)this.consumeAllBox, c);
    }

    public void setKeyInputmap(KeyInputMap keyInputMap) {
        this.consumeAllBox.setSelected(keyInputMap.isConsumeallkeys());
        KeyStrokeAction[] kas = keyInputMap.getKeyStrokeAction();
        int actionCount = 0;
        if (this.actions != null) {
            actionCount = this.actions.length;
        }
        block0: for (int i = 0; i < actionCount; ++i) {
            this.setEnabled(i, false);
            for (int j = 0; j < kas.length; ++j) {
                String actionCmd = kas[j].getAction();
                if (!actionCmd.equals(this.actions[i].getValue("ActionCommandKey"))) continue;
                this.keyChoosers[i].setSelectedItemByCode(kas[j].getCode());
                this.enableBoxes[i].setSelected(true);
                this.setEnabled(i, true);
                this.shiftModifierBoxes[i].setSelected(kas[j].getShift());
                this.altModifierBoxes[i].setSelected(kas[j].isAlt());
                this.ctrlModifierBoxes[i].setSelected(kas[j].isCtrl());
                continue block0;
            }
        }
    }

    public boolean isCloseSpeakerDisplayActionBound() {
        for (int i = 0; i < this.actions.length; ++i) {
            Action a = this.actions[i];
            if (!(a instanceof CloseSpeakerDisplayAction) || !this.enableBoxes[i].isSelected()) continue;
            return true;
        }
        return false;
    }

    public void bindCloseSpeakerDisplayActiontoEscape() {
        for (int i = 0; i < this.actions.length; ++i) {
            Action a = this.actions[i];
            if (!(a instanceof CloseSpeakerDisplayAction)) continue;
            this.setEnabled(i, true);
            this.enableBoxes[i].setSelected(true);
            this.keyChoosers[i].setSelectedItemByCode(27);
            this.shiftModifierBoxes[i].setSelected(false);
            this.ctrlModifierBoxes[i].setSelected(false);
            this.altModifierBoxes[i].setSelected(false);
            break;
        }
    }

    private void setEnabled(int i, boolean enabled) {
        this.keyChoosers[i].setEnabled(enabled);
        this.shiftLabels[i].setEnabled(enabled);
        this.shiftModifierBoxes[i].setEnabled(enabled);
        this.ctrlLabels[i].setEnabled(enabled);
        this.ctrlModifierBoxes[i].setEnabled(enabled);
        this.altLabels[i].setEnabled(enabled);
        this.altModifierBoxes[i].setEnabled(enabled);
    }

    public void applyValues(KeyInputMap keyInputMap) {
        keyInputMap.setConsumeallkeys(this.consumeAllBox.isSelected());
        ArrayList<KeyStrokeAction> newkas = new ArrayList<KeyStrokeAction>();
        for (int i = 0; i < this.actions.length; ++i) {
            KeyStrokeAction ka = new KeyStrokeAction();
            boolean enabled = this.enableBoxes[i].isSelected();
            if (!enabled) continue;
            ka.setAction((String)this.actions[i].getValue("ActionCommandKey"));
            JKeyChooser.Key k = (JKeyChooser.Key)this.keyChoosers[i].getSelectedItem();
            ka.setCode(k.getCode());
            ka.setShift(this.shiftModifierBoxes[i].isSelected());
            ka.setAlt(this.altModifierBoxes[i].isSelected());
            ka.setCtrl(this.ctrlModifierBoxes[i].isSelected());
            newkas.add(ka);
        }
        keyInputMap.setKeyStrokeAction(newkas.toArray(new KeyStrokeAction[0]));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src != this.consumeAllBox) {
            for (int i = 0; i < this.actions.length; ++i) {
                boolean enabled = this.enableBoxes[i].isSelected();
                this.setEnabled(i, enabled);
            }
        }
    }
}

