/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.config.Logger;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LoggerView
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Level[] availLevels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    protected JTextField nameField;
    protected JComboBox levelSelect;
    private JComboBox handlerBox;

    public LoggerView() {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 19;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Name"), c);
        c.gridx = 1;
        this.nameField = new JTextField();
        this.nameField.setEditable(false);
        this.add((Component)this.nameField, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Level"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.levelSelect = new JComboBox<Level>(this.availLevels);
        this.add((Component)this.levelSelect, c);
        this.levelSelect.addActionListener(this);
        c.gridx = 0;
        ++c.gridy;
        ++c.gridx;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Handlername"), c);
        c.gridx = 1;
        String[] defHandlers = new String[SpeechRecorder.DEF_LOG_HANDLERS.length];
        for (int i = 0; i < SpeechRecorder.DEF_LOG_HANDLERS.length; ++i) {
            defHandlers[i] = SpeechRecorder.DEF_LOG_HANDLERS[i].getName();
        }
        this.handlerBox = new JComboBox<String>(defHandlers);
        this.add((Component)this.handlerBox, c);
    }

    public void setLogger(Logger logger) {
        this.nameField.setText(logger.getName());
        this.levelSelect.setSelectedItem(Level.parse(logger.getLevel()));
        this.handlerBox.setSelectedItem(logger.getHandlerName());
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] childs = this.getComponents();
        for (int i = 0; i < childs.length; ++i) {
            childs[i].setEnabled(enabled);
        }
    }

    public void applyValues(Logger l) {
        l.setLevel(((Level)this.levelSelect.getSelectedItem()).getName());
    }

    public void revalidatePanel() {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (src == this.levelSelect) {
            // empty if block
        }
    }
}

