/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.ConfigHelper;
import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.ui.audio.DeviceChooserTabs;
import ipsk.audio.AudioController2;
import javax.swing.JTabbedPane;

public class PlaybackView
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private AudioController2 audioController;
    private DeviceChooserTabs playbackListChooser;

    public PlaybackView(AudioController2 audioController) {
        this.audioController = audioController;
        this.playbackListChooser = new DeviceChooserTabs(audioController, AudioController2.DeviceType.PLAYBACK);
        this.addTab("Device", this.playbackListChooser);
    }

    public void setProjectConfiguration(ProjectConfiguration project) {
        MixerName[] orgPlayMixerNames = project.getPlaybackMixerName();
        MixerName[] playMixerNames = ConfigHelper.getAJSConvertedMixerNames(this.audioController, orgPlayMixerNames);
        this.playbackListChooser.setSelectedMixerNames(playMixerNames);
    }

    public void applyValues(ProjectConfiguration p) {
        this.playbackListChooser.stopEditing();
        MixerName[] playMixerNames = this.playbackListChooser.getSelectedMixerNames();
        p.setPlaybackMixerName(playMixerNames);
    }
}

