/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.audio.AudioController2;
import ipsk.swing.text.EditorKitMenu;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.UUID;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ProjectConfigurationPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private ProjectConfiguration p;
    private JTextField nameField;
    private Document nameDoc;
    private JTextField uuidField;
    private JTextArea descrArea;
    private Document descrDoc;

    public ProjectConfigurationPanel(AudioController2 audioController) {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 19;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)new JLabel("Name"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new JTextField(20);
        Font defFont = this.getFont();
        if (defFont != null) {
            Font boldFont = defFont.deriveFont(1);
            this.nameField.setFont(boldFont);
        }
        this.nameField.setEditable(false);
        this.nameDoc = this.nameField.getDocument();
        this.nameDoc.addDocumentListener(this);
        EditorKitMenu nameEkm = new EditorKitMenu((JTextComponent)this.nameField, false);
        nameEkm.setPopupMenuActiv(true);
        this.add((Component)this.nameField, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("UUID"), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 21;
        this.uuidField = new JTextField(36);
        this.uuidField.setEditable(false);
        EditorKitMenu uuidEkm = new EditorKitMenu((JTextComponent)this.uuidField, false);
        uuidEkm.setPopupMenuActiv(true);
        this.add((Component)this.uuidField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Description"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.descrArea = new JTextArea(5, 20);
        this.descrDoc = this.descrArea.getDocument();
        this.descrDoc.addDocumentListener(this);
        EditorKitMenu edMenu = new EditorKitMenu((JTextComponent)this.descrArea);
        edMenu.setPopupMenuActiv(true);
        JScrollPane sp = new JScrollPane(this.descrArea);
        this.add((Component)sp, c);
    }

    public void setProjectConfiguration(ProjectConfiguration project) {
        this.p = project;
        this.nameField.setText(this.p.getName());
        String uuidStr = "";
        UUID uuid = this.p.getUuid();
        if (uuid != null) {
            uuidStr = uuid.toString();
        }
        this.uuidField.setText(uuidStr);
        this.descrArea.setText(this.p.getDescription());
    }

    public void applyValues(ProjectConfiguration template) {
        template.setName(this.nameField.getText());
        template.setDescription(this.descrArea.getText());
    }

    public void documentChanged(DocumentEvent de) {
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }
}

