/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui;

import ips.annot.BundleAnnotationPersistorServiceDescriptor;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationPluginManager;
import ipsk.apps.speechrecorder.config.Annotation;
import ipsk.apps.speechrecorder.config.Control;
import ipsk.apps.speechrecorder.config.LoggingConfiguration;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.SpeakersConfiguration;
import ipsk.apps.speechrecorder.config.ui.AnnotationPanel;
import ipsk.apps.speechrecorder.config.ui.LoggingConfigurationView;
import ipsk.apps.speechrecorder.config.ui.PlaybackView;
import ipsk.apps.speechrecorder.config.ui.ProjectConfigurationPanel;
import ipsk.apps.speechrecorder.config.ui.PromptConfigurationView;
import ipsk.apps.speechrecorder.config.ui.RecordingView;
import ipsk.apps.speechrecorder.config.ui.SpeakersView;
import ipsk.apps.speechrecorder.config.ui.TransportView;
import ipsk.apps.speechrecorder.project.ActiveProjectManager;
import ipsk.audio.AudioController2;
import ipsk.swing.JDialogPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.List;
import javax.help.HelpBroker;
import javax.swing.Action;
import javax.swing.JTabbedPane;

public class ProjectConfigurationView
extends JDialogPanel
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private SpeakersView speakersView;
    private ProjectConfiguration project;
    private JTabbedPane tabPane;
    private ProjectConfigurationPanel projectPanel;
    private RecordingView recView;
    private PlaybackView playView;
    private TransportView transportView;
    private PromptConfigurationView promptingView;
    private AnnotationPanel annotationPanel;
    private LoggingConfigurationView loggingView;

    public ProjectConfigurationView(ProjectConfiguration project, AudioController2 audioController, Action[] actions, List<BundleAnnotationPersistorServiceDescriptor> bapsds, AutoAnnotationPluginManager autoAnnotationPluginManager, ActiveProjectManager activeProjectManager, HelpBroker helpBroker) {
        super(JDialogPanel.Options.OK_CANCEL, helpBroker != null);
        this.project = project;
        this.setFrameTitle("Project \"" + project.getName() + "\" configuration");
        if (helpBroker != null) {
            helpBroker.enableHelpOnButton((Component)this.getHelpButton(), "subsection-30", null);
        }
        this.tabPane = new JTabbedPane();
        this.projectPanel = new ProjectConfigurationPanel(audioController);
        this.speakersView = new SpeakersView();
        this.recView = new RecordingView(audioController);
        this.playView = new PlaybackView(audioController);
        this.transportView = new TransportView(actions);
        this.promptingView = new PromptConfigurationView(audioController, this.transportView.getKeyInputMapView(), activeProjectManager);
        this.annotationPanel = new AnnotationPanel(bapsds, autoAnnotationPluginManager);
        this.loggingView = new LoggingConfigurationView();
        this.tabPane.addTab("Project", this.projectPanel);
        this.tabPane.addTab("Speakers", this.speakersView);
        this.tabPane.addTab("Recording", this.recView);
        this.tabPane.addTab("Playback", this.playView);
        this.tabPane.addTab("Control", this.transportView);
        this.tabPane.addTab("Prompting", this.promptingView);
        this.tabPane.addTab("Annotation", this.annotationPanel);
        this.tabPane.addTab("Logging", this.loggingView);
        this.setContentPane(this.tabPane);
        this.setProjectConfiguration(project);
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        this.project = projectConfiguration;
        this.setFrameTitle("Project \"" + this.project.getName() + "\" configuration");
        this.projectPanel.setProjectConfiguration(this.project);
        SpeakersConfiguration speakersConfig = this.project.getSpeakers();
        this.speakersView.setSpeakersConfiguration(speakersConfig);
        this.recView.setProjectConfiguration(this.project);
        this.playView.setProjectConfiguration(this.project);
        Control control = this.project.getControl();
        this.transportView.setControl(control);
        this.promptingView.setProjectConfiguration(this.project);
        Annotation anno = this.project.getAnnotation();
        this.annotationPanel.setAnnotationConfig(anno);
        LoggingConfiguration loggingConfiguration = this.project.getLoggingConfiguration();
        this.loggingView.setLoggingConfiguration(loggingConfiguration);
    }

    public ProjectConfiguration getProjectConfiguration() {
        ProjectConfiguration pc = new ProjectConfiguration();
        this.projectPanel.applyValues(pc);
        this.speakersView.applyValues(pc.getSpeakers());
        this.recView.applyValues(pc);
        this.playView.applyValues(pc);
        this.transportView.applyValues(pc.getControl());
        this.promptingView.applyValues(pc);
        this.annotationPanel.applyValues(pc.getAnnotation());
        this.loggingView.applyValues(pc.getLoggingConfiguration());
        return pc;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        this.setValue(2);
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public void setProjectContext(URL projectContext) {
        this.promptingView.setProjectContext(projectContext);
    }
}

