/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.audio;

import ipsk.audio.AudioController2;
import ipsk.audio.AudioControllerException;
import ipsk.audio.DeviceInfo;
import ipsk.audio.DeviceProvider;
import ipsk.audio.DeviceProviderInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.Mixer;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeviceChooser
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -389739661431600386L;
    private JComboBox<DeviceView> deviceSelector;
    private Vector<ActionListener> listeners = new Vector();
    private DeviceProviderInfo defaultDeviceProviderInfo;
    private boolean fireActionEvents = true;

    public DeviceChooser(AudioController2 controller, AudioController2.DeviceType deviceType) {
        this.deviceSelector = new JComboBox();
        this.deviceSelector.addActionListener(this);
        this.deviceSelector.addItem(new DeviceView());
        List providerInfos = null;
        try {
            providerInfos = controller.getDeviceProviderInfos();
        }
        catch (AudioControllerException e) {
            e.printStackTrace();
            return;
        }
        for (DeviceProviderInfo dpi : providerInfos) {
            if (AudioController2.DeviceType.CAPTURE.equals((Object)deviceType)) {
                if (!dpi.isProvidesCaptureDevices()) continue;
                this.defaultDeviceProviderInfo = dpi;
                break;
            }
            if (!AudioController2.DeviceType.PLAYBACK.equals((Object)deviceType) || !dpi.isProvidesPlaybackDevices()) continue;
            this.defaultDeviceProviderInfo = dpi;
            break;
        }
        if (this.defaultDeviceProviderInfo != null) {
            DeviceProvider defDp = null;
            try {
                defDp = controller.getInstance(this.defaultDeviceProviderInfo);
            }
            catch (AudioControllerException e) {
                e.printStackTrace();
                return;
            }
            List dis = null;
            if (AudioController2.DeviceType.CAPTURE.equals((Object)deviceType)) {
                dis = defDp.getCaptureDeviceInfos();
            } else if (AudioController2.DeviceType.PLAYBACK.equals((Object)deviceType)) {
                dis = defDp.getPlaybackDeviceInfos();
            }
            if (dis != null && dis.size() > 0) {
                for (DeviceInfo di : dis) {
                    DeviceView dv = new DeviceView(di);
                    this.deviceSelector.addItem(dv);
                }
            }
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)new JLabel("Select device:"), c);
        ++c.gridx;
        this.add(this.deviceSelector, c);
        this.updateEnabledActions();
    }

    public List<DeviceInfo> selectableDeviceInfos() {
        ComboBoxModel<DeviceView> cbm = this.deviceSelector.getModel();
        int cbmSize = cbm.getSize();
        ArrayList<DeviceInfo> dis = new ArrayList<DeviceInfo>();
        for (int i = 0; i < cbmSize; ++i) {
            DeviceView idv = (DeviceView)cbm.getElementAt(i);
            dis.add(idv.getDeviceInfo());
        }
        return dis;
    }

    public void setSelectedDeviceInfo(DeviceInfo deviceInfo) {
        this.fireActionEvents = false;
        ComboBoxModel<DeviceView> cbm = this.deviceSelector.getModel();
        int cbmSize = cbm.getSize();
        DeviceView reqSel = new DeviceView(deviceInfo);
        DeviceView sel = null;
        for (int i = 0; i < cbmSize; ++i) {
            DeviceView idv = (DeviceView)cbm.getElementAt(i);
            if (!reqSel.equals(idv)) continue;
            sel = reqSel;
            break;
        }
        if (sel == null) {
            this.deviceSelector.setEnabled(false);
        } else {
            this.deviceSelector.setSelectedItem(sel);
        }
        this.fireActionEvents = true;
    }

    public DeviceInfo getSelectedDeviceInfo() {
        DeviceView dv = (DeviceView)this.deviceSelector.getSelectedItem();
        return dv.getDeviceInfo();
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] children;
        super.setEnabled(enabled);
        for (Component ch : children = this.getComponents()) {
            ch.setEnabled(enabled);
        }
        if (enabled) {
            this.updateEnabledActions();
        }
    }

    private boolean simpleViewPossible() {
        return false;
    }

    private void updateEnabledActions() {
        boolean simpleViewPossible = this.simpleViewPossible();
        if (!simpleViewPossible) {
            // empty if block
        }
        if (this.isEnabled()) {
            // empty if block
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object src = arg0.getSource();
        if (this.fireActionEvents && src == this.deviceSelector) {
            this.fireAction();
        }
        this.updateEnabledActions();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.updateEnabledActions();
    }

    protected synchronized void fireAction() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 1001, "device_chooser_changed"));
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener != null && !this.listeners.contains(actionListener)) {
            this.listeners.addElement(actionListener);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.removeElement(actionListener);
        }
    }

    public DeviceProviderInfo getDefaultDeviceProviderInfo() {
        return this.defaultDeviceProviderInfo;
    }

    public class DeviceView {
        private DeviceInfo deviceInfo;

        public DeviceView() {
            this(null);
        }

        public DeviceView(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
        }

        public String toString() {
            if (this.deviceInfo == null) {
                return "(Default device)";
            }
            Mixer.Info mInfo = this.deviceInfo.getMixerInfo();
            if (mInfo != null) {
                return mInfo.getName();
            }
            return "";
        }

        public Mixer.Info getMixerInfo() {
            Mixer.Info mInfo = null;
            if (this.deviceInfo != null) {
                mInfo = this.deviceInfo.getMixerInfo();
            }
            return mInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DeviceView) {
                DeviceView oDv = (DeviceView)o;
                DeviceProviderInfo oDpi = oDv.getDeviceProviderInfo();
                if (oDpi != null ? !oDpi.equals(this.getDeviceProviderInfo()) : this.getDeviceProviderInfo() != null) {
                    return false;
                }
                Mixer.Info oMi = oDv.getMixerInfo();
                if (oMi != null ? oMi.equals(this.getMixerInfo()) : this.getMixerInfo() == null) {
                    return true;
                }
            }
            return false;
        }

        public DeviceProviderInfo getDeviceProviderInfo() {
            DeviceProviderInfo deviceProviderInfo = null;
            if (this.deviceInfo != null) {
                deviceProviderInfo = this.deviceInfo.getDeviceProviderInfo();
            }
            return deviceProviderInfo;
        }

        public DeviceInfo getDeviceInfo() {
            return this.deviceInfo;
        }
    }
}

