/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.prompt;

import ipsk.apps.speechrecorder.config.MixerName;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.ui.PromptAudioChannelRoutingView;
import ipsk.apps.speechrecorder.config.ui.audio.DeviceChooserTabs;
import ipsk.audio.AudioController2;
import javax.swing.JTabbedPane;

public class PromptAudioView
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private DeviceChooserTabs dvc;
    private PromptAudioChannelRoutingView pcr;

    public PromptAudioView(AudioController2 ac) {
        this.dvc = new DeviceChooserTabs(ac, AudioController2.DeviceType.PLAYBACK);
        this.pcr = new PromptAudioChannelRoutingView();
        this.addTab("Device", this.dvc);
        this.addTab("Channel routing", this.pcr);
    }

    public void setProjectConfiguration(ProjectConfiguration projectConfiguration) {
        MixerName[] promptPlayMixerNames = projectConfiguration.getPromptPlaybackMixerName();
        this.dvc.setSelectedMixerNames(promptPlayMixerNames);
        PromptConfiguration promptConfiguration = projectConfiguration.getPromptConfiguration();
        this.pcr.setPromptConfiguration(promptConfiguration);
    }

    public void applyValues(ProjectConfiguration p) {
        this.dvc.stopEditing();
        MixerName[] promptPlayMixerNames = this.dvc.getSelectedMixerNames();
        p.setPromptPlaybackMixerName(promptPlayMixerNames);
        this.pcr.applyValues(p.getPromptConfiguration());
    }
}

