/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.config.ui.recording;

import ipsk.apps.speechrecorder.config.ChannelRouting;
import javax.swing.table.AbstractTableModel;

public class ChannelRoutingTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private int SRC_CH = 0;
    private int ASS = 1;
    private int TRG_CH = 2;
    private String[] colNames = new String[]{"Source ch.", "Assigned", "Target ch."};
    private Class<?>[] colClasses = new Class[]{Integer.class, Boolean.class, Integer.class};
    private int inChannels = 0;
    private Integer minInputChannelCount = null;
    private int[] routing = null;

    @Override
    public int getRowCount() {
        return this.inChannels;
    }

    @Override
    public int getColumnCount() {
        return this.colClasses.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.colNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.colClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == this.ASS) {
            return true;
        }
        if (columnIndex == this.SRC_CH) {
            return false;
        }
        if (columnIndex == this.TRG_CH && this.routing != null) {
            for (int r : this.routing) {
                if (r != rowIndex) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int inCh = rowIndex;
        Integer outChannel = null;
        boolean assigned = false;
        if (this.routing != null) {
            for (int outCh = 0; outCh < this.routing.length; ++outCh) {
                int inChR = this.routing[outCh];
                if (inChR != inCh) continue;
                assigned = true;
                outChannel = outCh;
                break;
            }
        }
        if (columnIndex == this.SRC_CH) {
            return rowIndex;
        }
        if (columnIndex == this.ASS) {
            return assigned;
        }
        if (columnIndex == this.TRG_CH) {
            return outChannel;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == this.ASS && aValue instanceof Boolean) {
            boolean assigned = (Boolean)aValue;
            int[] oldRouting = this.routing;
            if (assigned) {
                if (oldRouting == null) {
                    oldRouting = new int[]{};
                }
                int[] newRouting = new int[oldRouting.length + 1];
                for (int i = 0; i < oldRouting.length; ++i) {
                    newRouting[i] = oldRouting[i];
                }
                newRouting[newRouting.length - 1] = rowIndex;
                this.routing = newRouting;
            } else {
                int[] newRouting = new int[oldRouting.length - 1];
                int j = 0;
                for (int i = 0; i < oldRouting.length; ++i) {
                    int oldValue = oldRouting[i];
                    if (oldValue == rowIndex) continue;
                    newRouting[j] = oldValue;
                    ++j;
                }
                this.routing = newRouting;
            }
            this.fireTableDataChanged();
        }
    }

    private int getInChannelCount() {
        int inChs = 0;
        int minChIdx = 0;
        if (this.routing != null) {
            for (int r : this.routing) {
                if (r <= minChIdx) continue;
                minChIdx = r;
            }
        }
        inChs = minChIdx + 1;
        if (this.minInputChannelCount != null && this.minInputChannelCount > this.inChannels) {
            inChs = this.minInputChannelCount;
        }
        return inChs;
    }

    public void setRouting(ChannelRouting config) {
        this.minInputChannelCount = config.getSrcChannelCount();
        this.routing = config.getAssign();
        this.inChannels = this.getInChannelCount();
        this.fireTableDataChanged();
    }

    public void setMinChannelCount(int minCh) {
        this.minInputChannelCount = minCh;
        this.inChannels = this.getInChannelCount();
        this.fireTableDataChanged();
    }
}

