/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.db.export.emu;

import ips.annot.autoannotator.AutoAnnotation;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.model.PredefinedLevelDefinition;
import ips.annot.model.db.AttributeDefinition;
import ips.annot.model.db.Bundle;
import ips.annot.model.db.Item;
import ips.annot.model.db.Level;
import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.Link;
import ips.annot.model.db.LinkDefinition;
import ips.annot.model.db.Session;
import ips.annot.model.emu.EmuBundleAnnotationPersistor;
import ips.annot.model.emu.EmuDB;
import ips.annot.model.emu.webapp.EMUwebAppConfig;
import ipsk.apps.speechrecorder.SpeechRecorderException;
import ipsk.apps.speechrecorder.annotation.auto.AutoAnnotationManager;
import ipsk.apps.speechrecorder.annotation.auto.impl.PromptAutoAnnotator;
import ipsk.apps.speechrecorder.annotation.auto.impl.TemplateAutoAnnotator;
import ipsk.apps.speechrecorder.project.ProjectManager;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ConvenienceFileAudioSource;
import ipsk.db.speech.LocalizedText;
import ipsk.db.speech.RecordingFile;
import ipsk.db.speech.script.Recording;
import ipsk.io.StreamCopy;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public class EmuExporter
extends ProjectManager {
    private Bundle buildBundle(String bundleName, Session session, Recording promptItem, Path recFile) throws IOException, UnsupportedAudioFileException {
        Bundle bundle = new Bundle();
        bundle.setSession(session);
        bundle.setName(bundleName);
        try {
            bundle.setAnnotates(recFile.getFileName().toString());
            ConvenienceFileAudioSource cfas = new ConvenienceFileAudioSource(recFile.toFile());
            AudioFormat af = cfas.getFormat();
            long fl = cfas.getFrameLength();
            bundle.setSampleRate(Float.valueOf(af.getSampleRate()));
            bundle.setFrameLength(Long.valueOf(fl));
            ArrayList<String> sigPathes = new ArrayList<String>();
            sigPathes.add(recFile.toAbsolutePath().toString());
            bundle.setSignalpaths(sigPathes);
            String string = promptItem.getDescription();
        }
        catch (AudioSourceException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    public void exportProjectAsEmuDB(Path exportDir) throws IOException, URISyntaxException, SpeechRecorderException, ProjectManagerException {
        boolean link = true;
        URL projectURL = this.getProjectContext();
        File projDir = new File(projectURL.toURI().getPath());
        String prjNm = this.project.getName();
        Path emuDBDir = exportDir.resolve(prjNm + "_emuDB");
        if (Files.exists(emuDBDir, new LinkOption[0])) {
            throw new ProjectManagerException("EmuDB directory " + emuDBDir + " already exists!");
        }
        Files.createDirectories(emuDBDir, new FileAttribute[0]);
        Path emuDBCfgFile = emuDBDir.resolve(prjNm + "_DBconfig.json");
        EmuDB emuDB = new EmuDB();
        emuDB.setName(this.project.getName());
        UUID prjUuid = this.project.getUuid();
        if (prjUuid == null) {
            prjUuid = UUID.randomUUID();
        }
        emuDB.setUuid(prjUuid);
        LevelDefinition prtLvlDef = new LevelDefinition(PredefinedLevelDefinition.PRT);
        AttributeDefinition prtAttrDef = new AttributeDefinition();
        prtAttrDef.setName(PredefinedLevelDefinition.PRT.getKeyName());
        prtAttrDef.setType("STRING");
        prtLvlDef.addAttributeDefinition(prtAttrDef);
        emuDB.getLevelDefinitions().add(prtLvlDef);
        LevelDefinition tplLvlDef = new LevelDefinition(PredefinedLevelDefinition.TPL);
        AttributeDefinition tplAttrDef = new AttributeDefinition();
        tplAttrDef.setName(PredefinedLevelDefinition.TPL.getKeyName());
        tplAttrDef.setType("STRING");
        tplLvlDef.addAttributeDefinition(tplAttrDef);
        emuDB.getLevelDefinitions().add(tplLvlDef);
        if (link) {
            LinkDefinition linkPrtTplDef = new LinkDefinition();
            linkPrtTplDef.setType("ONE_TO_MANY");
            linkPrtTplDef.setSuperLevel(prtLvlDef);
            linkPrtTplDef.setSubLevel(tplLvlDef);
            emuDB.getLinkDefinitions().add(linkPrtTplDef);
        }
        emuDB.setEMUwebAppConfig(EMUwebAppConfig.defaultWithDefaultPerspective());
        HashMap<String, String> jaxbEclipseLinkPropsmap = new HashMap<String, String>();
        jaxbEclipseLinkPropsmap.put("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
        try {
            JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{EmuDB.class}, jaxbEclipseLinkPropsmap);
            Marshaller m = jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("eclipselink.media-type", (Object)"application/json");
            m.marshal((Object)emuDB, emuDBCfgFile.toFile());
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new ProjectManagerException(e);
        }
        EmuBundleAnnotationPersistor bPers = new EmuBundleAnnotationPersistor();
        AutoAnnotationManager autoAnnotationManager = new AutoAnnotationManager();
        PromptAutoAnnotator paa = new PromptAutoAnnotator();
        TemplateAutoAnnotator taa = new TemplateAutoAnnotator();
        try {
            this.rebuildDb();
            String recFileExt = this.projectStorageManager.getUploadType().getExtension();
            Set sesss = this.projectDb.getSessions();
            for (ipsk.db.speech.Session sess : sesss) {
                Session annotSession = new Session();
                this.projectStorageManager.updateRecFiles(sess, true);
                int sessionId = sess.getSessionId();
                String sessIdStr = this.projectStorageManager.sessionIDString(sessionId);
                annotSession.setName(sessIdStr);
                String emuSessDirName = sessIdStr + "_ses";
                Path emuDbSessDir = emuDBDir.resolve(emuSessDirName);
                Files.createDirectory(emuDbSessDir, new FileAttribute[0]);
                autoAnnotationManager.setAnnotationSession(annotSession);
                Set rfs = sess.getRecordingFiles();
                for (RecordingFile rf : rfs) {
                    Recording r = rf.getRecording();
                    String ic = r.getItemcode();
                    int recVers = 0;
                    Integer recVersion = rf.getVersion();
                    if (recVersion != null) {
                        recVers = recVersion;
                    }
                    String emuBundleName = this.projectStorageManager.getRootFileName(sessionId, ic, sess.getCode(), recVers);
                    Path emuDbBndlDir = emuDbSessDir.resolve(emuBundleName + "_bndl");
                    Files.createDirectory(emuDbBndlDir, new FileAttribute[0]);
                    String sigUrlsStr = rf.getSignalFile();
                    URL sigUrl = new URL(sigUrlsStr);
                    File recFile = new File(sigUrl.toURI().getPath());
                    Path emuRecFile = emuDbBndlDir.resolve(emuBundleName + "." + recFileExt);
                    StreamCopy.copy((File)recFile, (File)emuRecFile.toFile());
                    Bundle b = autoAnnotationManager.buildBundle(emuDB, emuBundleName, new File[]{emuRecFile.toFile()});
                    paa.open();
                    paa.setPromptText(r.getDescription());
                    paa.setAnnotationRequest(new AutoAnnotator.AnnotationRequest(b));
                    paa.call();
                    paa.close();
                    taa.open();
                    String templText = null;
                    LocalizedText lt = r.annotationTemplateLocalizedText();
                    if (lt != null) {
                        templText = lt.getText();
                    }
                    taa.setTemplateText(templText);
                    taa.setAnnotationRequest(new AutoAnnotator.AnnotationRequest(b));
                    AutoAnnotation taan = taa.call();
                    taa.close();
                    if (link) {
                        Object bLvl2;
                        List bLvls = b.getLevels();
                        Item prtIt = null;
                        for (Object bLvl2 : bLvls) {
                            List its;
                            if (!PromptAutoAnnotator.PREDEFINED_LEVEL_DEFINITION.getKeyName().equals(bLvl2.getName()) || (its = bLvl2.getItems()).size() != 1) continue;
                            prtIt = (Item)its.get(0);
                        }
                        Item tplIt = null;
                        bLvl2 = bLvls.iterator();
                        while (bLvl2.hasNext()) {
                            List its;
                            Level bLvl3 = (Level)bLvl2.next();
                            if (!TemplateAutoAnnotator.PREDEFINED_LEVEL_DEFINITION.getKeyName().equals(bLvl3.getName()) || (its = bLvl3.getItems()).size() != 1) continue;
                            tplIt = (Item)its.get(0);
                        }
                        if (prtIt != null & tplIt != null) {
                            Link ln = new Link();
                            ln.setFrom(prtIt);
                            ln.setTo(tplIt);
                            b.getLinksAsSet().add(ln);
                        }
                    }
                    Path emuAnnotFile = emuDbBndlDir.resolve(emuBundleName + "_annot.json");
                    bPers.setFile(emuAnnotFile.toFile());
                    bPers.write(b);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

