/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.project;

import ipsk.apps.speechrecorder.SpeakerManager;
import ipsk.apps.speechrecorder.config.ItemcodeGeneratorConfiguration;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.PromptConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.db.Speaker;
import ipsk.apps.speechrecorder.project.NewProjectConfiguration;
import ipsk.apps.speechrecorder.project.ProjectManagerException;
import ipsk.apps.speechrecorder.script.RecScriptManager;
import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptHandlerException;
import ipsk.apps.speechrecorder.script.RecscriptManagerException;
import ipsk.apps.speechrecorder.storage.SessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.beans.DOMCodec;
import ipsk.beans.DOMCodecException;
import ipsk.db.speech.Project;
import ipsk.db.speech.Session;
import ipsk.db.speech.script.Script;
import ipsk.io.FileUtils;
import ipsk.io.StreamCopy;
import ipsk.net.URLContext;
import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXB;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class ProjectManager {
    public static final String PROJECT_VERSION = "4.0.0";
    public static final String PROJECT_FILE_EXTENSION = "_project.prj";
    public static final String SPEAKER_FILE_SUFFIX = "_speakers.xml";
    public static final String REC_SCRIPT_FILE_EXTENSION = "_script.xml";
    public static final String DEFAULT_RESOURCE_PATH = "resources";
    public static final String REC_SCRIPT_EXAMPLE = "ExampleRecScript_4.xml";
    protected Project projectDb;
    protected ProjectConfiguration project;
    protected URL projectContext = null;
    protected URL projectURL;
    protected DOMCodec domCodec;
    protected DOMConverter domConverter;
    protected SpeakerManager speakerManager;
    protected String speakerFileName;
    protected URL speakerURL;
    protected SessionStorageManager projectStorageManager;
    protected RecScriptManager recScriptManager;
    protected URL promptFile;
    protected URL recBaseURL;
    protected int numLines;
    protected boolean projectConfigurationSaved;

    public SessionStorageManager getProjectStorageManager() {
        return this.projectStorageManager;
    }

    public ProjectManager() throws ProjectManagerException {
        try {
            Package configBasePack = Class.forName("ipsk.apps.speechrecorder.config.ProjectConfiguration").getPackage();
            this.domCodec = new DOMCodec(configBasePack);
        }
        catch (DOMCodecException | ClassNotFoundException e) {
            throw new ProjectManagerException(e);
        }
        this.domConverter = new DOMConverter();
        this.speakerManager = new SpeakerManager();
        this.recScriptManager = new RecScriptManager();
        this.projectStorageManager = new SessionStorageManager();
    }

    public void init() {
    }

    public URL getProjectContext() {
        return this.projectContext;
    }

    public void setProjectContext(URL context) {
        this.projectContext = context;
    }

    protected void setConfiguration(ProjectConfiguration newProject) {
        this.project = newProject;
    }

    public ProjectConfiguration getConfiguration() {
        return this.project;
    }

    public void config(ProjectConfiguration cfgProject) throws ProjectManagerException {
        try {
            this.commonConfig(cfgProject);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            throw new ProjectManagerException(e1);
        }
        PromptConfiguration pc = cfgProject.getPromptConfiguration();
        String promptFileName = pc.getPromptsUrl();
        if (promptFileName != null && !promptFileName.equals("")) {
            try {
                this.promptFile = URLContext.getContextURL((URL)this.projectContext, (String)promptFileName);
                this.recScriptManager.load(this.promptFile);
            }
            catch (RecscriptManagerException | MalformedURLException e) {
                e.printStackTrace();
                throw new ProjectManagerException(e);
            }
        } else {
            throw new ProjectManagerException("Prompt file not configured");
        }
        String newSpeakerFilename = this.project.getSpeakers().getSpeakersUrl();
        if (this.speakerFileName == null || !this.speakerFileName.equals(newSpeakerFilename)) {
            this.speakerFileName = this.project.getSpeakers().getSpeakersUrl();
            if (this.speakerFileName != null && !this.speakerFileName.equals("")) {
                try {
                    this.speakerURL = URLContext.getContextURL((URL)this.projectContext, (String)this.speakerFileName);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    throw new ProjectManagerException(e);
                }
            } else {
                throw new ProjectManagerException("Speaker database not configured");
            }
        }
        this.speakerManager.loadURL(this.speakerURL);
    }

    protected void commonConfig(ProjectConfiguration cfgProject) throws MalformedURLException {
        this.projectDb = new Project();
        this.projectDb.setName(cfgProject.getName());
        this.project = cfgProject;
        this.recScriptManager.setContext(this.projectContext);
        RecordingConfiguration recCfg = this.project.getRecordingConfiguration();
        String recDirName = recCfg.getUrl();
        this.recBaseURL = URLContext.getContextURL((URL)this.projectContext, (String)recDirName);
        this.projectStorageManager.setStorageURL(this.recBaseURL);
        this.numLines = 1;
        this.projectStorageManager.setNumLines(this.numLines);
        boolean overwrite = recCfg.getOverwrite();
        this.projectStorageManager.setOverwrite(overwrite);
    }

    public URL getProjectURL() {
        return this.projectURL;
    }

    public void setProjectURL(URL url) {
        this.projectURL = url;
    }

    public File getProjectDir() throws MalformedURLException, URISyntaxException {
        ProjectConfiguration pc = this.getConfiguration();
        if (pc != null) {
            String dirStr = pc.getDirectory();
            URL projectDirURL = new URL(this.projectContext, dirStr);
            return new File(projectDirURL.toURI().getPath());
        }
        return null;
    }

    public Project getProjectDb() {
        return this.projectDb;
    }

    public void createEmptySpeakerDatabase(File speakerDbFile, boolean overwrite) {
        if (overwrite || !speakerDbFile.exists()) {
            JAXB.marshal(new ArrayList(), (File)speakerDbFile);
        }
    }

    public void rebuildDb() throws StorageManagerException {
        Script script = this.recScriptManager.getScript();
        this.projectDb.getScripts().clear();
        this.projectDb.getScripts().add(script);
        script.getSessions().clear();
        Set<Session> sesss = this.projectStorageManager.sessionsLazy(this.projectDb, script);
        this.projectDb.setSessions(sesss);
        List<Speaker> speakersList = this.speakerManager.getSpeakersList();
        for (Speaker spk : speakersList) {
            spk.getSessions().clear();
        }
        for (Session s : sesss) {
            s.setScript(script);
            script.getSessions().add(s);
            s.getSpeakers().clear();
            for (Speaker spk : speakersList) {
                if (!spk.getPersonId().equals(s.getSessionId())) continue;
                s.setCode(spk.getCode());
                s.getSpeakers().add(spk);
                spk.getSessions().add(s);
            }
            boolean hasRecs = this.projectStorageManager.sessionHasRecordingFiles(s);
            s.setRecordingFiles(null);
            s.markHasRecordings(Boolean.valueOf(hasRecs));
        }
        this.speakerManager.setSessions(sesss);
    }

    public void saveProject() throws ProjectManagerException {
        Document d;
        String fPath;
        try {
            fPath = this.getProjectURL().toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new ProjectManagerException(e);
        }
        File f = new File(fPath);
        ProjectConfiguration pc = this.getConfiguration();
        pc.setVersion(PROJECT_VERSION);
        try {
            d = this.domCodec.createDocument((Object)this.getConfiguration());
        }
        catch (DOMCodecException e) {
            throw new ProjectManagerException(e);
        }
        FileUtils.moveToBackup((File)f, (String)".bak");
        try {
            FileOutputStream fos = new FileOutputStream(f);
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, Charset.forName("UTF-8"));
            this.domConverter.writeXML(d, (Writer)ow);
            ow.close();
            this.setProjectConfigurationSaved(true);
        }
        catch (DOMConverterException | IOException e) {
            throw new ProjectManagerException(e);
        }
    }

    public void saveScript() throws ProjectManagerException {
        File dtdFile;
        RecscriptHandler recScriptHandler = new RecscriptHandler();
        recScriptHandler.setValidating(true);
        Script script = this.recScriptManager.getScript();
        try {
            dtdFile = new File(this.getProjectDir(), "SpeechRecPrompts_4.dtd");
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ProjectManagerException(e);
        }
        if (!dtdFile.exists()) {
            InputStream is = RecscriptHandler.class.getResourceAsStream("SpeechRecPrompts_4.dtd");
            try {
                FileOutputStream fos = new FileOutputStream(dtdFile);
                StreamCopy.copy((InputStream)is, (OutputStream)fos);
            }
            catch (IOException e) {
                throw new ProjectManagerException(e);
            }
        }
        StringWriter stringWriter = new StringWriter();
        try {
            recScriptHandler.writeXML(script, (Writer)stringWriter);
            StringReader stringReader = new StringReader(stringWriter.toString());
            recScriptHandler.readScriptFromXML(stringReader, this.projectContext.toExternalForm());
        }
        catch (RecscriptHandlerException | DOMConverterException | ParserConfigurationException e) {
            throw new ProjectManagerException(e);
        }
        String promptFileName = this.project.getPromptConfiguration().getPromptsUrl();
        if (promptFileName != null && !promptFileName.equals("")) {
            URL promptFile;
            try {
                promptFile = URLContext.getContextURL((URL)this.projectContext, (String)promptFileName);
            }
            catch (MalformedURLException e) {
                throw new ProjectManagerException(e);
            }
            String protocol = promptFile.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                String fPath;
                try {
                    fPath = promptFile.toURI().getPath();
                }
                catch (URISyntaxException e) {
                    throw new ProjectManagerException(e);
                }
                File f = new File(fPath);
                FileUtils.moveToBackup((File)f, (String)".bak");
                recScriptHandler = new RecscriptHandler();
                recScriptHandler.setValidating(true);
                try {
                    recScriptHandler.writeXML(script, (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(f), Charset.forName("UTF-8")));
                }
                catch (DOMConverterException | FileNotFoundException | ParserConfigurationException e) {
                    throw new ProjectManagerException(e);
                }
            }
            throw new ProjectManagerException("Cannot save script to URL: " + promptFile + ", protocol " + protocol + "not supported.");
        }
        throw new ProjectManagerException("Cannot save script to empty URL!");
        this.recScriptManager.setScriptSaved(true);
    }

    public void createNewProject(NewProjectConfiguration newProjectConfig) throws ProjectManagerException {
        FileOutputStream fos;
        File projectDir;
        ProjectConfiguration newProject = newProjectConfig.getProjectConfiguration();
        try {
            URL projectDirURL = new URL(this.projectContext, newProject.getDirectory());
            projectDir = new File(projectDirURL.toURI().getPath());
        }
        catch (IOException | URISyntaxException e) {
            throw new ProjectManagerException(e);
        }
        URI pdURI = projectDir.toURI();
        String projectDirURIstr = pdURI.toASCIIString();
        String projectFilename = newProject.getName() + PROJECT_FILE_EXTENSION;
        String recScriptFileName = newProject.getName() + REC_SCRIPT_FILE_EXTENSION;
        String speakersFilename = newProject.getName() + SPEAKER_FILE_SUFFIX;
        File projectFile = new File(projectDir, projectFilename);
        File recScriptFile = new File(projectDir, recScriptFileName);
        File speakersFile = new File(projectDir, speakersFilename);
        InputStream is = RecscriptHandler.class.getResourceAsStream("SpeechRecPrompts_4.dtd");
        try {
            fos = new FileOutputStream(new File(projectDir, "SpeechRecPrompts_4.dtd"));
            StreamCopy.copy((InputStream)is, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new ProjectManagerException(e);
        }
        if (newProjectConfig.isUseExampleScript()) {
            is = RecscriptHandler.class.getResourceAsStream(REC_SCRIPT_EXAMPLE);
            try {
                fos = new FileOutputStream(recScriptFile);
                StreamCopy.copy((InputStream)is, (OutputStream)fos);
            }
            catch (IOException e) {
                throw new ProjectManagerException(e);
            }
            ItemcodeGeneratorConfiguration icCfg = newProject.getPromptConfiguration().getItemcodeGeneratorConfiguration();
            icCfg.setGeneratorName("Demo script itemcode generator");
            icCfg.setPrefix("demo_");
            icCfg.setFixedDecimalPlaces(3);
            icCfg.setCounterStart(70);
            icCfg.setActive(true);
        } else {
            Script newScript = new Script();
            newScript.setPropertyChangeSupportEnabled(true);
            this.recScriptManager.setScript(newScript);
        }
        this.createEmptySpeakerDatabase(speakersFile, true);
        URI recScriptURI = recScriptFile.toURI();
        URI projectDirURI = projectDir.toURI();
        URI recScriptRelURI = projectDirURI.relativize(recScriptURI);
        newProject.getPromptConfiguration().setPromptsUrl(recScriptRelURI.toString());
        URI speakersFileURI = speakersFile.toURI();
        URI speakersFileRelURI = projectDirURI.relativize(speakersFileURI);
        newProject.getSpeakers().setSpeakersUrl(speakersFileRelURI.toString());
        newProject.getRecordingConfiguration().setUrl("RECS/");
        this.setConfiguration(newProject);
        try {
            this.setProjectURL(projectFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new ProjectManagerException(e);
        }
        String systemIdBase = this.projectContext.toExternalForm();
        this.recScriptManager.setSystemIdBase(systemIdBase);
        try {
            this.commonConfig(newProject);
        }
        catch (MalformedURLException e) {
            throw new ProjectManagerException(e);
        }
        this.saveProject();
        if (!newProjectConfig.isUseExampleScript()) {
            this.saveScript();
        }
    }

    public boolean isProjectConfigurationSaved() {
        return this.projectConfigurationSaved;
    }

    public void setProjectConfigurationSaved(boolean saved) {
        this.projectConfigurationSaved = saved;
    }
}

