/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.MIMETypes;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;

@Title(value="Audio prompter")
@Description(value="Presents audio using Java applet audio interface. (Warning! No transport control!)")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=1)
public class PromptAudioViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    private static final PromptPresenterServiceDescriptor DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(PromptAudioViewer.class.getName(), new LocalizableMessage("Audio prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{1, 0, 0}), new LocalizableMessage("Presents audio using Java applet audio interface. (Warning! No transport control!)"), PromptAudioViewer.getSupportedMIMETypes());
    private ImageIcon audioImage;
    private JButton audioButton;
    private URL audioURL = null;
    private Font audioButtonFont = new Font("sans-serif", 1, 36);

    public PromptAudioViewer() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.audioImage = new ImageIcon(this.getClass().getResource("icons/playAudio.gif"));
        this.createAudioButton(null, null);
    }

    private void createAudioButton(ImageIcon icon, String text) {
        if (this.audioButton != null) {
            this.remove(this.audioButton);
        }
        this.audioButton = new JButton();
        this.audioButton.setFont(this.audioButtonFont);
        this.audioButton.setVerticalTextPosition(3);
        this.audioButton.setHorizontalTextPosition(0);
        this.audioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromptAudioViewer.this.start();
            }
        });
        if (icon != null) {
            this.audioButton.setIcon(icon);
        }
        if (text != null) {
            this.audioButton.setText(text);
        }
        this.add((Component)this.audioButton, "Center");
    }

    public void start() {
        if (this.audioURL != null) {
            Applet.newAudioClip(this.audioURL).play();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getSize());
    }

    public void close() {
    }

    public void setStartControlEnabled(boolean startEnabled) {
    }

    public void setStopControlEnabled(boolean stopEnabled) {
    }

    public void stop() {
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        URL url = this.applyContextToMediaitemURL(mi);
        String description = mi.getDescription();
        this.audioURL = url;
        if (description == null) {
            this.createAudioButton(this.audioImage, null);
        } else {
            this.createAudioButton(null, description);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        String[][] mtypes = new String[MIMETypes.AUDIOMIMETYPES.length][1];
        for (int i = 0; i < MIMETypes.AUDIOMIMETYPES.length; ++i) {
            mtypes[i][0] = MIMETypes.AUDIOMIMETYPES[i];
        }
        return mtypes;
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }
}

