/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.prompting;

import ipsk.apps.speechrecorder.prompting.BasicPromptPresenter;
import ipsk.apps.speechrecorder.prompting.BasicPromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter;
import ipsk.apps.speechrecorder.prompting.presenter.PromptPresenterException;
import ipsk.apps.speechrecorder.prompting.presenter.UnsupportedContentException;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptDocEditorKit;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyleContext;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.db.speech.script.VirtualViewBox;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.text.ParserException;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.Description;
import ipsk.util.services.Title;
import ipsk.util.services.Vendor;
import ipsk.util.services.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

@Title(value="Scrollable formatted text prompter")
@Description(value="Presents Speechrecorder formatted text in a scrollable pane.")
@Vendor(value="Institute of Phonetics and Speech processing, Munich")
@Version(major=0, minor=0, subminor=1)
public class ScrollableFormattedPromptTextViewer
extends BasicPromptPresenter
implements PromptPresenter {
    private static final long serialVersionUID = 1L;
    public static final PromptPresenterServiceDescriptor DESCRIPTOR = new BasicPromptPresenterServiceDescriptor(ScrollableFormattedPromptTextViewer.class.getName(), new LocalizableMessage("Scrollable formatted text prompter"), "Institute of Phonetics and Speech processing, Munich", new ipsk.text.Version(new int[]{0, 0, 1}), new LocalizableMessage("Presents formatted prompt text in a scrollable pane."), ScrollableFormattedPromptTextViewer.getSupportedMIMETypes());
    public static final float VIRTUAL_HEIGHT = 600.0f;
    public static final String DEF_CHARSET = "UTF-8";
    private JTextPane textPane;
    private JScrollPane scrollPane;
    private Color backgroundColor = Color.WHITE;
    private static String DEFAULT_FONT_NAME = "sans-serif";
    private static int DEFAULT_FONT_STYLE = 1;
    private int DEFAULT_FONT_SIZE = 48;
    private int fontSize;
    private boolean updatingDoc = false;
    private Integer renderedHeight = null;

    public ScrollableFormattedPromptTextViewer() {
        this.setBackground(this.backgroundColor);
        this.textPane = new JTextPane();
        this.scrollPane = new JScrollPane(this.textPane);
        this.textPane.setEditable(false);
        PromptDocEditorKit promptDocKit = new PromptDocEditorKit(true);
        this.textPane.setEditorKitForContentType("text/x-prompt", promptDocKit);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 2.0;
        gbc.weighty = 2.0;
        this.add((Component)this.scrollPane, gbc);
        this.fontSize = this.DEFAULT_FONT_SIZE;
        this.promptFont = new Font(DEFAULT_FONT_NAME, DEFAULT_FONT_STYLE, this.fontSize);
    }

    @Override
    public void setPromptFont(Font promptFont) {
        this.promptFont = promptFont;
    }

    @Override
    public boolean getEmphasized() {
        return this.emphasized;
    }

    @Override
    public void setEmphasized(boolean emphasized) {
        this.emphasized = emphasized;
        if (emphasized) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.lightGray);
        }
    }

    public static String[][] getSupportedMIMETypes() {
        return ScrollableFormattedPromptTextViewer.getSupportedMIMETypes(new String[]{"text/x-prompt"});
    }

    @Override
    public void loadContents() throws PromptPresenterException {
        if (this.mediaitems == null || this.mediaitems.length == 0) {
            throw new UnsupportedContentException("No media item to display!");
        }
        if (this.mediaitems.length > 1) {
            throw new UnsupportedContentException("Multiple media items not supported!");
        }
        Mediaitem mi = this.mediaitems[0];
        PromptDoc prompt = mi.getPromptDoc();
        if (prompt != null) {
            int h;
            Document cDoc;
            PromptStyledDocument doc;
            PromptStyleContext psc = null;
            VirtualViewBox vvb = mi.getDefaultVirtualViewBox();
            psc = vvb == null ? new PromptStyleContext(this.promptFont) : this.scaledPromptStyleContext(vvb.getHeight());
            try {
                doc = new PromptStyledDocument(psc, prompt);
            }
            catch (ParserException e) {
                throw new PromptPresenterException(e);
            }
            this.updatingDoc = true;
            String cCt = this.textPane.getContentType();
            if (!"text/x-prompt".equals(cCt)) {
                this.textPane.setContentType("text/x-prompt");
            }
            if ((cDoc = this.textPane.getDocument()) == null || !cDoc.equals(doc)) {
                this.textPane.setDocument(doc);
            }
            if ((h = this.getHeight()) > 0) {
                this.renderedHeight = h;
            }
            this.updatingDoc = false;
        } else {
            this.renderedHeight = null;
        }
    }

    @Override
    public void doLayout() {
        boolean heightChanged;
        boolean bl = heightChanged = this.renderedHeight == null || this.renderedHeight.intValue() != this.getHeight();
        if (heightChanged && !this.updatingDoc) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScrollableFormattedPromptTextViewer.this.loadContents();
                    }
                    catch (PromptPresenterException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        super.doLayout();
    }

    private PromptStyleContext scaledPromptStyleContext(int virtualHeight) {
        Font resFnt = this.promptFont;
        int h = this.getHeight();
        if (h > 0) {
            Font scaledPromptFont;
            int promptFontSize = this.promptFont.getSize();
            float scaledPromptFontSize = promptFontSize * h / virtualHeight;
            resFnt = scaledPromptFont = this.promptFont.deriveFont(scaledPromptFontSize);
        }
        return new PromptStyleContext(resFnt);
    }

    @Override
    public PromptPresenterServiceDescriptor getServiceDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public static void main(String[] args) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ScrollableFormattedPromptTextViewer vw = new ScrollableFormattedPromptTextViewer();
                vw.setPreferredSize(new Dimension(600, 400));
                JFrame w = new JFrame();
                w.setDefaultCloseOperation(3);
                w.getContentPane().add(vw);
                w.pack();
                w.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }
}

