/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.apps.speechrecorder.script.ItemcodeGeneratorConfiguration;
import ipsk.util.collections.CollectionChangedEvent;
import ipsk.util.collections.CollectionListener;
import ipsk.util.collections.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.Set;

public class ItemcodeGenerator
implements CollectionListener,
PropertyChangeListener {
    private ItemcodeGeneratorConfiguration config;
    private PropertyChangeSupport propertyChangeSupport;
    private Integer counterValue = null;
    private ObservableList<String> itemcodesList;

    public ItemcodeGenerator() {
        this(new ItemcodeGeneratorConfiguration());
    }

    public ItemcodeGenerator(ItemcodeGeneratorConfiguration itemcodeGeneratorConfiguration) {
        this.config = itemcodeGeneratorConfiguration;
        this.config.addPropertyChangeListener(this);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    private String getItemCode(Integer counterVal) {
        if (this.config.isActive()) {
            DecimalFormat counterFormat;
            StringBuffer sb = new StringBuffer();
            String prefix = this.config.getPrefix();
            if (prefix != null) {
                sb.append(prefix);
            }
            String countstrValue = (counterFormat = this.config.counterFormat()) != null ? counterFormat.format(counterVal) : counterVal.toString();
            sb.append(countstrValue);
            return sb.toString();
        }
        return "";
    }

    public String getItemCode() {
        return this.getItemCode(this.getCounterValue());
    }

    public void next() {
        if (this.config.isActive()) {
            int cv = this.getCounterValue();
            int increment = this.config.getIncrement();
            this.setCounterValue(cv + increment);
        }
    }

    public void toNext(Set<String> existingItemCodes) {
        if (this.config.isActive()) {
            Integer counterVal = this.getCounterValue();
            boolean exists = true;
            int increment = this.config.getIncrement();
            do {
                String itemcode;
                if (!(exists = existingItemCodes.contains(itemcode = this.getItemCode(counterVal)))) continue;
                counterVal = counterVal + increment;
            } while (exists);
            this.setCounterValue(counterVal);
        }
    }

    public int getCounterValue() {
        if (this.counterValue == null) {
            int counterStart = this.config.getCounterStart();
            this.counterValue = counterStart;
        }
        return this.counterValue;
    }

    public void setCounterValue(Integer counterValue) {
        Integer oldCounterValue = this.counterValue;
        String oldItemcode = this.getItemCode();
        this.counterValue = counterValue;
        this.firePropertyChange("counterValue", oldCounterValue, this.counterValue);
        String itemcode = this.getItemCode();
        this.firePropertyChange("itemCode", oldItemcode, itemcode);
    }

    public void reset() {
        this.setCounterValue(null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return this.propertyChangeSupport.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public ItemcodeGeneratorConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(ItemcodeGeneratorConfiguration config) {
        ItemcodeGeneratorConfiguration oldConfig = this.config;
        oldConfig.removePropertyChangeListener(this);
        this.config = config;
        this.config.addPropertyChangeListener(this);
        this.firePropertyChange("config", oldConfig, this.config);
        this.reset();
    }

    public ObservableList<String> getItemcodesList() {
        return this.itemcodesList;
    }

    public void setItemcodesList(ObservableList<String> itemcodesList) {
        ObservableList<String> oldList = this.itemcodesList;
        if (oldList != null) {
            oldList.removeCollectionListener((CollectionListener)this);
        }
        this.itemcodesList = itemcodesList;
        this.itemcodesList.addCollectionListener((CollectionListener)this);
        this.firePropertyChange("itemcodesList", oldList, this.itemcodesList);
    }

    public void collectionChanged(CollectionChangedEvent collectionChangedEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange("config" + evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }
}

