/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script;

import ipsk.apps.speechrecorder.script.ItemCodeValidator;
import ipsk.apps.speechrecorder.script.RecScriptChangedEvent;
import ipsk.apps.speechrecorder.script.RecScriptManagerClosedEvent;
import ipsk.apps.speechrecorder.script.RecScriptStoreStatusChanged;
import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptHandlerException;
import ipsk.apps.speechrecorder.script.RecscriptManagerEvent;
import ipsk.apps.speechrecorder.script.RecscriptManagerException;
import ipsk.apps.speechrecorder.script.RecscriptManagerListener;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.script.Section;
import ipsk.db.speech.script.prompt.Mediaitem;
import ipsk.io.StreamCopy;
import ipsk.net.MIMEType;
import ipsk.net.URLContext;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.text.ParserException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;

public class RecScriptManager {
    public static final int AUTOMATIC = 0;
    public static final int MANUAL = 1;
    public static final int SEQUENTIAL = 2;
    public static final int RANDOM = 3;
    public static final String RECORDED_COL_ID = "progress.table.col.recorded";
    public static final int ERROR_MSG_MAX_ITEMS = 20;
    private Logger logger;
    private RecscriptHandler recScriptHandler;
    private URL scriptURL;
    private Script script;
    private boolean scriptSaved = true;
    private URL context = null;
    private boolean defaultSpeakerDisplay;
    private Section.Mode defaultMode;
    private int defaultPreDelay;
    private int defaultPostDelay;
    private boolean defaultAutomaticPromptPlay = true;
    private boolean setIndexActionsEnabled = false;
    private boolean progresToNextUnrecorded = false;
    private Vector<RecscriptManagerListener> listeners = new Vector();
    private List<PromptItem> promptItemsList = null;
    private ItemCodeValidator itemCodeValidator;

    public URL getScriptURL() {
        return this.scriptURL;
    }

    public RecScriptManager() {
        this.recScriptHandler = new RecscriptHandler();
        this.itemCodeValidator = new ItemCodeValidator();
        this.logger = Logger.getLogger("ipsk.apps.speechrecorder");
    }

    public void setSequenceGenerator(IntegerSequenceGenerator sequenceGenerator) {
        this.recScriptHandler.setSeqGen(sequenceGenerator);
    }

    public IntegerSequenceGenerator getSequenceGenerator() {
        return this.recScriptHandler.getSeqGen();
    }

    public Set<String> getExistingCodes() {
        return this.itemCodeValidator.getExistingCodes();
    }

    public boolean isNewVersionOfDTDFileRequired() throws MalformedURLException {
        return this.recScriptHandler.isNewVersionOfDTDFileRequired();
    }

    public void createDTDFileIfRequired() throws IOException {
        this.recScriptHandler.createDTDFileIfRequired();
    }

    public Script getScript() {
        return this.script;
    }

    private void applyDefaults() {
        if (this.script != null) {
            this.script.defaultSectionMode(this.defaultMode);
            this.script.defaultSpeakerDisplay(this.defaultSpeakerDisplay);
            this.script.defaultPrerecdelay(this.defaultPreDelay);
            this.script.defaultPostrecdelay(this.defaultPostDelay);
            this.script.defaultAutoplay(this.defaultAutomaticPromptPlay);
        }
    }

    public void setScript(Script script) {
        this.script = script;
        this.applyDefaults();
        this.itemCodeValidator.clear();
        if (script == null) {
            this.promptItemsList = null;
        } else {
            this.promptItemsList = script.promptItemsList();
            if (this.validItemCodes()) {
                this.logger.info("Item codes unique.");
            } else {
                this.logger.warning("Warning: NON-UNIQUE item codes!");
            }
            this.analyzeScriptResources();
        }
        this.fireRecscriptManagerUpdate(new RecScriptChangedEvent(this));
    }

    public void shuffleItems() {
        if (this.script != null) {
            this.script.shuffleItems();
        }
    }

    public void load(URL promptURL) throws RecscriptManagerException {
        this.load(promptURL, false);
    }

    public void load(URL promptURL, boolean force) throws RecscriptManagerException {
        String promptURLString = promptURL.toExternalForm();
        try {
            promptURL = URLContext.getContextURL((URL)this.context, (String)promptURLString);
        }
        catch (MalformedURLException e) {
            throw new RecscriptManagerException(e);
        }
        Script script = this.readRecScriptXMLFile(promptURL, force);
        this.setScriptSaved(true);
        this.scriptURL = promptURL;
        this.setScript(script);
    }

    public void loadWithoutDTD(URL promptURL) throws RecscriptManagerException {
        String promptURLString = promptURL.toExternalForm();
        try {
            this.scriptURL = URLContext.getContextURL((URL)this.context, (String)promptURLString);
        }
        catch (MalformedURLException e) {
            throw new RecscriptManagerException(e);
        }
        Script script = this.readRecScriptXMLFileWithoutDTD(this.scriptURL);
        this.setScriptSaved(true);
        this.setScript(script);
    }

    public void storeToFile(File scriptFile) throws IOException {
        if (this.scriptURL == null) {
            throw new IllegalStateException();
        }
        InputStream scriptStream = this.scriptURL.openStream();
        StreamCopy.copy((InputStream)scriptStream, (File)scriptFile, (boolean)true);
    }

    public Script readRecScriptXMLFile(URL recScriptURL) throws RecscriptManagerException {
        return this.readRecScriptXMLFile(recScriptURL, false);
    }

    public Script readRecScriptXMLFile(URL recScriptURL, boolean force) throws RecscriptManagerException {
        this.logger.entering("readRecScriptXMLFile", "recScriptURLString");
        try {
            return this.recScriptHandler.readRecScriptXMLFile(recScriptURL, force);
        }
        catch (RecscriptHandlerException e) {
            e.printStackTrace();
            throw new RecscriptManagerException(e);
        }
    }

    public Script readRecScriptXMLFileWithoutDTD(URL recScriptURL) throws RecscriptManagerException {
        this.logger.entering("readRecScriptXMLFile", "recScriptURLString");
        try {
            return this.recScriptHandler.readRecScriptXMLFileWithoutDTD(recScriptURL);
        }
        catch (RecscriptHandlerException e) {
            e.printStackTrace();
            throw new RecscriptManagerException(e);
        }
    }

    public Section getRecSectionForItem(int itemIndex) {
        List sections;
        int index = itemIndex;
        Section recSection = null;
        if (this.script != null && (sections = this.script.getSections()) != null) {
            for (int i = 0; i < sections.size(); ++i) {
                Section tmpRecSection = (Section)sections.get(i);
                if (index >= tmpRecSection.getGroups().size()) {
                    index -= tmpRecSection.getGroups().size();
                    continue;
                }
                recSection = tmpRecSection;
                break;
            }
        }
        return recSection;
    }

    public PromptItem shuffledPromptItem(int promptIndex) {
        List sections;
        PromptItem promptItem = null;
        int index = promptIndex;
        if (this.script != null && (sections = this.script.getSections()) != null) {
            for (int i = 0; i < sections.size(); ++i) {
                Section s = (Section)sections.get(i);
                List pis = s.getShuffledPromptItems();
                int pisSize = pis.size();
                if (index >= pisSize) {
                    index -= pisSize;
                    continue;
                }
                promptItem = (PromptItem)pis.get(index);
                break;
            }
        }
        return promptItem;
    }

    private boolean validItemCodes() {
        boolean allValid = true;
        StringBuffer errorMessage = new StringBuffer("Invalid item codes!\n");
        int invalidItemCount = 0;
        int maxIdx = this.getMaxIndex();
        for (int i = 0; i < maxIdx; ++i) {
            PromptItem pi = this.promptItemsList.get(i);
            if (!(pi instanceof Recording)) continue;
            String itemCode = ((Recording)pi).getItemcode();
            String validationMessage = this.itemCodeValidator.validateItemCode(itemCode);
            if (validationMessage == null) {
                this.itemCodeValidator.getExistingCodes().add(itemCode);
                continue;
            }
            allValid = false;
            if (invalidItemCount < 20) {
                errorMessage.append("item #" + i + " code \"" + itemCode + "\": " + validationMessage);
                errorMessage.append("\n");
            }
            ++invalidItemCount;
        }
        if (invalidItemCount > 20) {
            int moreInvalidItems = invalidItemCount - 20;
            errorMessage.append("...and " + moreInvalidItems + " more invalid item code(s).");
            errorMessage.append('\n');
        }
        if (!allValid) {
            errorMessage.append("Please correct the recording script.");
            JOptionPane.showMessageDialog(null, errorMessage.toString(), "Warning", 2);
        }
        return allValid;
    }

    public void analyzeScriptResources() {
        int maxAudioPromptChs = 0;
        if (this.script != null) {
            List prItemsList = this.script.promptItemsList();
            for (PromptItem pi : prItemsList) {
                List mis = pi.getMediaitems();
                for (Mediaitem mi : mis) {
                    String srcURLString = mi.getSrcStr();
                    String mimeStr = mi.getNNMimetype();
                    if (srcURLString == null) continue;
                    try {
                        URL srcURL = URLContext.getContextURL((URL)this.context, (String)srcURLString);
                        MIMEType mime = null;
                        String mimeMajorType = null;
                        try {
                            mime = MIMEType.parse((String)mimeStr);
                            mimeMajorType = mime.getType();
                        }
                        catch (ParserException e) {
                            e.printStackTrace();
                        }
                        if ("audio".equalsIgnoreCase(mimeMajorType)) {
                            try {
                                AudioFileFormat aff = ThreadSafeAudioSystem.getAudioFileFormat((URL)srcURL);
                                int chs = aff.getFormat().getChannels();
                                if (chs == -1 || chs <= maxAudioPromptChs) continue;
                                maxAudioPromptChs = chs;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (UnsupportedAudioFileException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        try {
                            URLConnection urlConn = srcURL.openConnection();
                            urlConn.connect();
                            InputStream is = urlConn.getInputStream();
                            is.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    catch (MalformedURLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    }

    public int getMaxIndex() {
        if (this.script == null) {
            return 0;
        }
        return this.promptItemsList.size();
    }

    public String getSystemIdBase() {
        return this.recScriptHandler.getSystemIdBase();
    }

    public void setSystemIdBase(String string) {
        this.recScriptHandler.setSystemIdBase(string);
    }

    public String getScriptID() {
        return this.script.getName();
    }

    public void setContext(URL context) {
        this.context = context;
    }

    public URL getContext() {
        return this.context;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void doClose() {
        this.setScript(null);
        this.fireRecscriptManagerUpdate(new RecScriptManagerClosedEvent(this));
    }

    public boolean isDefaultSpeakerDisplay() {
        return this.defaultSpeakerDisplay;
    }

    public void setDefaultSpeakerDisplay(boolean defaultSpeakerDisplay) {
        this.defaultSpeakerDisplay = defaultSpeakerDisplay;
        this.applyDefaults();
        this.fireRecscriptManagerUpdate(new RecScriptChangedEvent(this));
    }

    public Section.Mode getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Section.Mode defaultMode) {
        this.defaultMode = defaultMode;
        this.applyDefaults();
        this.fireRecscriptManagerUpdate(new RecScriptChangedEvent(this));
    }

    public int getDefaultPreDelay() {
        return this.defaultPreDelay;
    }

    public void setDefaultPreDelay(int defaultPreDelay) {
        this.defaultPreDelay = defaultPreDelay;
    }

    public int getDefaultPostDelay() {
        return this.defaultPostDelay;
    }

    public void setDefaultPostDelay(int defaultPostDelay) {
        this.defaultPostDelay = defaultPostDelay;
    }

    public synchronized void addRecscriptManagerListener(RecscriptManagerListener acl) {
        if (acl != null && !this.listeners.contains(acl)) {
            this.listeners.addElement(acl);
        }
    }

    public synchronized void removeRecscriptManagerListener(RecscriptManagerListener acl) {
        if (acl != null) {
            this.listeners.removeElement(acl);
        }
    }

    protected synchronized void fireRecscriptManagerUpdate(RecscriptManagerEvent event) {
        for (RecscriptManagerListener listener : this.listeners) {
            listener.update(event);
        }
    }

    public boolean isScriptSaved() {
        return this.scriptSaved;
    }

    public void setScriptSaved(boolean scriptSaved) {
        this.scriptSaved = scriptSaved;
        this.fireRecscriptManagerUpdate(new RecScriptStoreStatusChanged(this));
    }

    public boolean isSetIndexActionsEnabled() {
        return this.setIndexActionsEnabled;
    }

    public void setSetIndexActionsEnabled(boolean setIndexActionsEnabled) {
        this.setIndexActionsEnabled = setIndexActionsEnabled;
    }

    public boolean isDefaultAutomaticPromptPlay() {
        return this.defaultAutomaticPromptPlay;
    }

    public void setDefaultAutomaticPromptPlay(boolean automaticPromptPlayDefault) {
        this.defaultAutomaticPromptPlay = automaticPromptPlayDefault;
    }

    public String getSystemId() {
        return this.recScriptHandler.getSystemId();
    }

    public void setSystemId(String scriptDTD) {
        this.recScriptHandler.setSystemId(scriptDTD);
    }

    public boolean isProgresToNextUnrecorded() {
        return this.progresToNextUnrecorded;
    }

    public void setProgresToNextUnrecorded(boolean progresToNextUnrecorded) {
        this.progresToNextUnrecorded = progresToNextUnrecorded;
    }
}

