/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.script.RecscriptHandler;
import ipsk.apps.speechrecorder.script.RecscriptHandlerException;
import ipsk.db.speech.script.Script;
import ipsk.swing.ApplyException;
import ipsk.swing.JDialogPanel;
import ipsk.swing.text.xml.JXMLPaneEditor;
import ipsk.swing.text.xml.XMLParserEvent;
import ipsk.swing.text.xml.XMLParserListener;
import ipsk.xml.DOMConverterException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;

public class ScriptSourceEditor
extends JDialogPanel
implements PropertyChangeListener,
XMLParserListener {
    private Script script;
    private String scriptId = null;
    private RecscriptHandler handler = new RecscriptHandler();
    private String systemIdBase;
    private String systemId;
    private JXMLPaneEditor editor = new JXMLPaneEditor();
    private boolean applying;

    public ScriptSourceEditor() {
        super(JDialogPanel.Options.OK_CANCEL);
        this.editor.addValidationListener((XMLParserListener)this);
        this.editor.setPreferredSize(new Dimension(500, 600));
        this.setContentPane((Container)this.editor);
        this.revalidate();
        this.repaint();
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
        if (this.script != null) {
            this.script.addPropertyChangeListener((PropertyChangeListener)this);
        }
        try {
            this.updateText();
        }
        catch (DOMConverterException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private void updateText() throws DOMConverterException, ParserConfigurationException {
        if (this.script != null) {
            StringWriter strWriter = new StringWriter();
            this.handler.writeXML(this.script, this.systemId, strWriter);
            this.editor.setText(strWriter.toString());
        } else {
            this.editor.setText("");
            this.editor.setEnabled(false);
        }
    }

    protected void checkApply() throws ApplyException {
        InputSource is = new InputSource(this.systemIdBase);
        String xmlSource = new String(this.editor.getText());
        is.setCharacterStream(new StringReader(xmlSource));
        Script newScript = new Script();
        try {
            this.handler.insertScriptElementsFromXML(newScript, is);
        }
        catch (RecscriptHandlerException e) {
            throw new ApplyException("Script parse error", e.getMessage());
        }
    }

    protected void applyValues() {
        this.applying = true;
        InputSource is = new InputSource(this.systemIdBase);
        String xmlSource = new String(this.editor.getText());
        is.setCharacterStream(new StringReader(xmlSource));
        Script newScript = new Script();
        try {
            this.handler.insertScriptElementsFromXML(newScript, is);
            this.script = newScript;
        }
        catch (RecscriptHandlerException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), "Error parsing XML script", 0);
        }
        this.applying = false;
        try {
            this.updateText();
        }
        catch (DOMConverterException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            if (!this.applying) {
                this.updateText();
            }
        }
        catch (DOMConverterException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void update(XMLParserEvent e) {
        Exception ex = e.getParseException();
        this.setApplyingEnabled(ex == null);
    }

    public void disposeDialog() {
        if (this.script != null) {
            this.script.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.disposeDialog();
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public String getSystemIdBase() {
        return this.systemIdBase;
    }

    public void setSystemIdBase(String systemIdBase) {
        this.systemIdBase = systemIdBase;
        this.editor.setSystemId(systemIdBase);
    }
}

