/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui;

import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.apps.speechrecorder.script.ItemcodeGenerator;
import ipsk.apps.speechrecorder.script.MetadataTableModel;
import ipsk.apps.speechrecorder.script.SectionsTableModel;
import ipsk.apps.speechrecorder.script.ui.AddMetadataPropertyAction;
import ipsk.apps.speechrecorder.script.ui.AddSectionAction;
import ipsk.apps.speechrecorder.script.ui.ItemcodeGeneratorUI;
import ipsk.apps.speechrecorder.script.ui.SectionUI;
import ipsk.db.speech.script.Group;
import ipsk.db.speech.script.Metadata;
import ipsk.db.speech.script.PromptGroupsList;
import ipsk.db.speech.script.PromptItem;
import ipsk.db.speech.script.PromptItemsList;
import ipsk.db.speech.script.Property;
import ipsk.db.speech.script.Recording;
import ipsk.db.speech.script.Script;
import ipsk.db.speech.script.Section;
import ipsk.db.speech.script.VirtualViewBox;
import ipsk.persistence.IntegerSequenceGenerator;
import ipsk.swing.CopyAction;
import ipsk.swing.CutAction;
import ipsk.swing.PasteAction;
import ipsk.swing.RedoAction;
import ipsk.swing.UndoAction;
import ipsk.swing.action.EditActions;
import ipsk.swing.action.EditActionsListener;
import ipsk.swing.text.EditorKitMenu;
import ipsk.util.collections.ObservableArrayList;
import ipsk.util.collections.ObservableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class ScriptUI
extends JPanel
implements ListSelectionListener,
ActionListener,
PropertyChangeListener,
ClipboardOwner,
FlavorListener,
TableModelListener,
TableColumnModelListener,
EditActionsListener,
FocusListener,
StateEditable {
    private static final long serialVersionUID = 9051086308204571026L;
    private Script script;
    private JTextField nameField;
    private MetadataTableModel metadataTableModel;
    private JPanel metadataPanel;
    private JTable metadataTable;
    private JPanel viewPanel;
    private JCheckBox useVirtualBoxCheckBox;
    private JLabel virtualBoxHeightLabel;
    private JSpinner virtualBoxHeightSpinner;
    private SpinnerNumberModel virtualBoxHeightSpinnerNumberModel;
    private JPanel sectionsPanel;
    private SectionsTableModel sectionTableModel;
    private JTable sectionsTable;
    private AddMetadataPropertyAction addMetadataPropertyAction;
    private AddSectionAction addSectionAction;
    private CutAction cutSectionAction;
    private CopyAction copySectionAction;
    private CopyAction copyMetadataPropertyAction;
    private PasteAction pasteSectionAction;
    private PasteAction pasteMetadataPropertyAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private Clipboard clipboard = null;
    private JSplitPane splitPane;
    private SectionUI sectionUI;
    private JScrollPane scrollPane;
    private boolean marginChange = false;
    private boolean userSized = false;
    private URL projectContext = null;
    private EditActions editSectionActions;
    private EditActions editMetadataPropertyActions;
    private EditActionsListener editActionsListener;
    private List<Action> newActionsList;
    private Section.Mode defaultSectionMode = Section.Mode.MANUAL;
    private int defaultPreRecording;
    private int defaultPostRecording;
    private boolean defaultPromptAutoPlay = true;
    private ObservableList<String> itemCodesList = new ObservableArrayList();
    private Set<String> itemCodesInUse = null;
    private UndoManager undoManager = new UndoManager();
    private List<PromptPresenterServiceDescriptor> availablePromptPresenters;
    private CutAction cutMetadataPropertyAction;
    private IntegerSequenceGenerator sequenceGenerator;
    private ItemcodeGenerator itemcodeGenerator;

    public void setInstructionsFontFamilies(String[] instructionsFontFamilies) {
        this.sectionUI.setInstructionsFontFamilies(instructionsFontFamilies);
    }

    public void setDescriptionFontFamilies(String[] descriptionFontFamilies) {
        this.sectionUI.setDescriptionFontFamilies(descriptionFontFamilies);
    }

    public void setPromptFontConfig(ipsk.apps.speechrecorder.config.Font promptFontConfig) {
        this.sectionUI.setPromptFontFamilies(promptFontConfig.getFamily());
    }

    public SectionUI getSectionUI() {
        return this.sectionUI;
    }

    public URL getProjectContext() {
        return this.projectContext;
    }

    public void setProjectContext(URL projectContext) {
        this.projectContext = projectContext;
        this.sectionUI.setProjectContext(this.projectContext);
    }

    public Set<String> getItemCodesInUse() {
        return this.itemCodesInUse;
    }

    public void setItemCodesInUse(Set<String> itemCodesInUse) {
        this.itemCodesInUse = itemCodesInUse;
        this.sectionUI.setItemCodesInUse(itemCodesInUse);
    }

    public ScriptUI(URL projectContext, IntegerSequenceGenerator sequenceGenerator, ItemcodeGenerator itemcodeGenerator, List<PromptPresenterServiceDescriptor> promptPresentersClassList) {
        super(new BorderLayout());
        this.projectContext = projectContext;
        this.sequenceGenerator = sequenceGenerator;
        this.itemcodeGenerator = itemcodeGenerator;
        this.availablePromptPresenters = promptPresentersClassList;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkPermission(new AllPermission());
            }
            catch (SecurityException se) {
                System.err.println("WARNING: System clipboard not accessible.");
                this.clipboard = new Clipboard("Script Clipboard");
            }
        }
        if (this.clipboard == null) {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        this.clipboard.addFlavorListener(this);
        final ScriptUI ampal = this;
        this.addMetadataPropertyAction = new AddMetadataPropertyAction(){
            private static final long serialVersionUID = -7518637055732090023L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                ampal.actionPerformed(ae);
            }
        };
        this.addMetadataPropertyAction.setEnabled(false);
        final ScriptUI asal = this;
        this.addSectionAction = new AddSectionAction(){
            private static final long serialVersionUID = -1771803589437890001L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                asal.actionPerformed(ae);
            }
        };
        this.addSectionAction.setEnabled(false);
        final ScriptUI al = this;
        this.cutSectionAction = new CutAction(){
            private static final long serialVersionUID = 6101617971307295382L;

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.cutSectionAction.putValue("ActionCommandKey", (Object)(CutAction.ACTION_COMMAND + "_section"));
        this.cutSectionAction.setEnabled(false);
        this.cutMetadataPropertyAction = new CutAction(){
            private static final long serialVersionUID = 451031345451371880L;

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.cutMetadataPropertyAction.putValue("ActionCommandKey", (Object)(CutAction.ACTION_COMMAND + "_metadata_property"));
        this.cutMetadataPropertyAction.setEnabled(false);
        this.copySectionAction = new CopyAction(){
            private static final long serialVersionUID = 8631641300808763372L;

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.copySectionAction.putValue("ActionCommandKey", (Object)(CopyAction.ACTION_COMMAND + "_section"));
        this.copySectionAction.setEnabled(false);
        this.copyMetadataPropertyAction = new CopyAction(){
            private static final long serialVersionUID = -656609839645719928L;

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.copyMetadataPropertyAction.putValue("ActionCommandKey", (Object)(CopyAction.ACTION_COMMAND + "_metadata_property"));
        this.copyMetadataPropertyAction.setEnabled(false);
        this.pasteMetadataPropertyAction = new PasteAction(){
            private static final long serialVersionUID = -7806292733670303839L;

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.pasteMetadataPropertyAction.putValue("ActionCommandKey", (Object)(PasteAction.ACTION_COMMAND + "_metadata_property"));
        this.pasteMetadataPropertyAction.setEnabled(false);
        this.pasteSectionAction = new PasteAction(){
            private static final long serialVersionUID = 7446884452860757692L;

            public void actionPerformed(ActionEvent ae) {
                al.actionPerformed(ae);
            }
        };
        this.pasteSectionAction.putValue("ActionCommandKey", (Object)(PasteAction.ACTION_COMMAND + "_section"));
        this.pasteSectionAction.setEnabled(false);
        this.undoAction = new UndoAction(){
            private static final long serialVersionUID = -8261733834310117974L;

            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
        this.redoAction = new RedoAction(){
            private static final long serialVersionUID = 8317910445407384268L;

            public void actionPerformed(ActionEvent e) {
                al.actionPerformed(e);
            }
        };
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        JPanel scriptPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        JLabel nameLabel = new JLabel("Name (Id):");
        scriptPanel.add((Component)nameLabel, c);
        this.nameField = new JTextField(8);
        EditorKitMenu nameFieldEkm = new EditorKitMenu((JTextComponent)this.nameField);
        nameFieldEkm.setPopupMenuActiv(true);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 2.0;
        scriptPanel.add((Component)this.nameField, c);
        this.metadataTableModel = new MetadataTableModel();
        this.metadataTable = new JTable(this.metadataTableModel);
        this.metadataTable.setPreferredScrollableViewportSize(new Dimension(150, 20));
        this.metadataTable.setDragEnabled(true);
        this.metadataTable.getSelectionModel().setSelectionMode(0);
        this.metadataTable.getSelectionModel().addListSelectionListener(this);
        this.metadataTableModel.addTableModelListener(this);
        this.metadataTable.addFocusListener(this);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        JScrollPane metaDataScrollPane = new JScrollPane(this.metadataTable);
        this.metadataPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mc = new GridBagConstraints();
        mc.gridx = 0;
        mc.gridy = 0;
        mc.weightx = 1.0;
        mc.weighty = 1.0;
        mc.insets = new Insets(1, 2, 1, 2);
        mc.fill = 1;
        this.metadataPanel.setBorder(BorderFactory.createTitledBorder("Metadata"));
        this.metadataPanel.add((Component)metaDataScrollPane, mc);
        scriptPanel.add((Component)this.metadataPanel, c);
        ++c.gridy;
        this.viewPanel = new JPanel(new GridBagLayout());
        mc.gridx = 0;
        mc.gridy = 0;
        mc.weightx = 1.0;
        mc.weighty = 1.0;
        mc.fill = 0;
        mc.anchor = 512;
        this.viewPanel.setBorder(BorderFactory.createTitledBorder("View"));
        this.useVirtualBoxCheckBox = new JCheckBox("Use virtual box view");
        this.useVirtualBoxCheckBox.addActionListener(this);
        this.virtualBoxHeightSpinnerNumberModel = new SpinnerNumberModel(600, 10, 60000, 50);
        this.virtualBoxHeightSpinner = new JSpinner(this.virtualBoxHeightSpinnerNumberModel);
        mc.gridwidth = 2;
        this.viewPanel.add((Component)this.useVirtualBoxCheckBox, mc);
        mc.gridwidth = 1;
        ++mc.gridy;
        this.virtualBoxHeightLabel = new JLabel("Virtual box height:");
        this.viewPanel.add((Component)this.virtualBoxHeightLabel, mc);
        ++mc.gridx;
        this.viewPanel.add((Component)this.virtualBoxHeightSpinner, mc);
        scriptPanel.add((Component)this.viewPanel, c);
        this.sectionTableModel = new SectionsTableModel();
        this.sectionsTable = new JTable(this.sectionTableModel);
        this.sectionsTable.setPreferredScrollableViewportSize(new Dimension(150, 100));
        this.sectionsTable.setDragEnabled(true);
        this.sectionsTable.getSelectionModel().setSelectionMode(0);
        this.sectionsTable.getSelectionModel().addListSelectionListener(this);
        this.sectionTableModel.addTableModelListener(this);
        this.sectionsTable.getColumnModel().addColumnModelListener(this);
        this.sectionsTable.addFocusListener(this);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 2.0;
        c.weighty = 4.0;
        c.fill = 1;
        this.scrollPane = new JScrollPane(this.sectionsTable);
        this.sectionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints sc = new GridBagConstraints();
        sc.gridx = 0;
        sc.gridy = 0;
        sc.weightx = 1.0;
        sc.weighty = 1.0;
        sc.fill = 1;
        this.sectionsPanel.setBorder(BorderFactory.createTitledBorder("Sections"));
        this.sectionsPanel.add((Component)this.scrollPane, sc);
        scriptPanel.add((Component)this.sectionsPanel, c);
        ItemcodeGeneratorUI itemCodeGenUI = new ItemcodeGeneratorUI(itemcodeGenerator);
        TitledBorder tbicg = BorderFactory.createTitledBorder("Item code generator");
        itemCodeGenUI.setBorder(tbicg);
        ++c.gridy;
        scriptPanel.add((Component)itemCodeGenUI, c);
        this.editMetadataPropertyActions = new EditActions("Metadata UI", (Action)this.cutMetadataPropertyAction, (Action)this.copyMetadataPropertyAction, (Action)this.pasteMetadataPropertyAction);
        this.editSectionActions = new EditActions("Edit section UI", (Action)this.cutSectionAction, (Action)this.copySectionAction, (Action)this.pasteSectionAction, this.undoAction, this.redoAction);
        this.updateEditActions();
        InputMap metadataImap = this.metadataTable.getInputMap();
        metadataImap.put(KeyStroke.getKeyStroke("ctrl X"), this.cutMetadataPropertyAction.getValue("ActionCommandKey"));
        metadataImap.put(KeyStroke.getKeyStroke("ctrl C"), this.copyMetadataPropertyAction.getValue("Name"));
        metadataImap.put(KeyStroke.getKeyStroke("ctrl V"), this.pasteMetadataPropertyAction.getValue("Name"));
        ActionMap metadataMap = this.metadataTable.getActionMap();
        metadataMap.put(this.cutMetadataPropertyAction.getValue("ActionCommandKey"), (Action)this.cutMetadataPropertyAction);
        metadataMap.put(this.copyMetadataPropertyAction.getValue("Name"), (Action)this.copyMetadataPropertyAction);
        metadataMap.put(this.pasteMetadataPropertyAction.getValue("Name"), (Action)this.pasteMetadataPropertyAction);
        InputMap imap = this.sectionsTable.getInputMap();
        imap.put(KeyStroke.getKeyStroke("ctrl X"), this.cutSectionAction.getActionCommand());
        imap.put(KeyStroke.getKeyStroke("ctrl C"), this.copySectionAction.getActionCommand());
        imap.put(KeyStroke.getKeyStroke("ctrl V"), this.pasteSectionAction.getActionCommand());
        ActionMap map = this.sectionsTable.getActionMap();
        map.put(this.cutSectionAction.getActionCommand(), (Action)this.cutSectionAction);
        map.put(this.copySectionAction.getActionCommand(), (Action)this.copySectionAction);
        map.put(this.pasteSectionAction.getActionCommand(), (Action)this.pasteSectionAction);
        this.sectionUI = new SectionUI(projectContext, sequenceGenerator, this.itemCodesList, itemcodeGenerator, this.availablePromptPresenters);
        scriptPanel.setMinimumSize(new Dimension(0, 0));
        this.sectionUI.setMinimumSize(new Dimension(0, 0));
        this.splitPane = new JSplitPane(1, true, scriptPanel, this.sectionUI);
        this.add((Component)this.splitPane, "Center");
        this.sectionUI.setEditActionListener(this);
        this.newActionsList = new ArrayList<Action>();
        this.newActionsList.add(this.addMetadataPropertyAction);
        this.newActionsList.add(this.addSectionAction);
        this.updateView();
    }

    public ScriptUI() {
        this(null, null, new ItemcodeGenerator(), null);
    }

    private void setTableSections(Section[] tableSections) {
        this.sectionTableModel.setSections(tableSections);
        if (tableSections != null && tableSections.length > 0) {
            this.sectionsTable.setRowSelectionInterval(0, 0);
        } else {
            this.sectionUI.setSection(null);
        }
    }

    private void setSectionsCopy() {
        List sections;
        Section[] sectionsCopy = null;
        if (this.script != null && (sections = this.script.getSections()) != null) {
            sectionsCopy = new Section[sections.size()];
            for (int i = 0; i < sections.size(); ++i) {
                sectionsCopy[i] = (Section)sections.get(i);
            }
        }
        this.setTableSections(sectionsCopy);
    }

    public void setScript(Script script) {
        this.script = script;
        boolean useVirtualBox = false;
        if (script != null) {
            this.nameField.setText(script.getName());
            Metadata md = script.getMetadata();
            if (md == null) {
                this.metadataTableModel.getMetadataProperties().clear();
            } else {
                this.metadataTableModel.setMetadataProperties(md.getProperties());
            }
            VirtualViewBox vvb = script.getVirtualViewBox();
            if (vvb != null) {
                useVirtualBox = true;
                this.virtualBoxHeightSpinnerNumberModel.setValue(vvb.getHeight());
            }
        }
        this.useVirtualBoxCheckBox.setSelected(useVirtualBox);
        this.setSectionsCopy();
        this.itemCodesList.clear();
        if (script != null) {
            Set sics = script.itemCodesSet();
            this.itemCodesList.addAll((Collection)sics);
        }
        this.undoManager.discardAllEdits();
        this.updateEditActions();
        this.updateView();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean adjusting = e.getValueIsAdjusting();
        if (adjusting) {
            return;
        }
        this.updateEditActions();
        boolean editorEnabled = super.isEnabled();
        Object src = e.getSource();
        if (src == this.sectionsTable.getSelectionModel()) {
            ListSelectionModel lsm = this.sectionsTable.getSelectionModel();
            int startIndex = lsm.getMinSelectionIndex();
            int stopIndex = lsm.getMaxSelectionIndex();
            if (startIndex >= 0) {
                if (startIndex == stopIndex) {
                    Section currSection = this.sectionTableModel.getSections()[startIndex];
                    this.sectionUI.setSection(currSection);
                } else {
                    this.sectionUI.setSection(null);
                }
            }
            if (lsm.isSelectionEmpty()) {
                this.copySectionAction.setEnabled(false);
                this.cutSectionAction.setEnabled(false);
            } else {
                this.copySectionAction.setEnabled(editorEnabled);
                this.cutSectionAction.setEnabled(editorEnabled);
                if (this.editActionsListener != null) {
                    this.editActionsListener.providesEditActions((Object)this, this.editSectionActions);
                }
            }
        } else if (src == this.metadataTable.getSelectionModel()) {
            ListSelectionModel lsm = this.metadataTable.getSelectionModel();
            if (lsm.isSelectionEmpty()) {
                this.copyMetadataPropertyAction.setEnabled(false);
                this.cutMetadataPropertyAction.setEnabled(false);
            } else {
                this.copyMetadataPropertyAction.setEnabled(editorEnabled);
                this.cutMetadataPropertyAction.setEnabled(editorEnabled);
                if (this.editActionsListener != null) {
                    this.editActionsListener.providesEditActions((Object)this, this.editMetadataPropertyActions);
                }
            }
        }
    }

    protected void applyValues() {
        this.sectionUI.applyValues();
        this.script.setName(this.nameField.getText());
        TableCellEditor cellEditor = this.metadataTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        List<Property> mdps = this.metadataTableModel.getMetadataProperties();
        Metadata md = this.script.getMetadata();
        if (mdps.size() > 0) {
            if (md == null) {
                md = new Metadata();
            }
            md.setProperties(mdps);
        } else {
            md = null;
        }
        this.script.setMetadata(md);
        if (this.useVirtualBoxCheckBox.isSelected()) {
            VirtualViewBox vvb = new VirtualViewBox();
            vvb.setHeight(this.virtualBoxHeightSpinnerNumberModel.getNumber().intValue());
            this.script.setVirtualViewBox(vvb);
        } else {
            this.script.setVirtualViewBox(null);
        }
        cellEditor = this.sectionsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        ArrayList<Section> sectionsList = new ArrayList<Section>(Arrays.asList(this.sectionTableModel.getSections()));
        this.script.setSections(sectionsList);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (!this.copyMetadataPropertyAction.getActionCommand().equals(cmd)) {
            if (this.copySectionAction.getActionCommand().equals(cmd)) {
                this.applyValues();
                Section copySection = this.getSelectedSection();
                this.clipboard.setContents((Transferable)copySection, this);
            } else if (this.pasteMetadataPropertyAction.getActionCommand().equals(cmd)) {
                try {
                    this.insert((Property)this.clipboard.getContents(this).getTransferData(Property.CLASS_DATA_FLAVOR));
                }
                catch (UnsupportedFlavorException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (this.pasteSectionAction.getActionCommand().equals(cmd)) {
                DataFlavor[] avDfs = this.clipboard.getAvailableDataFlavors();
                try {
                    for (DataFlavor df : avDfs) {
                        if (Section.CLASS_DATA_FLAVOR.equals(df)) {
                            this.insert((Section)this.clipboard.getContents(this).getTransferData(Section.CLASS_DATA_FLAVOR));
                            continue;
                        }
                        if (PromptItemsList.CLASS_DATA_FLAVOR.equals(df)) {
                            PromptItemsList pilD = (PromptItemsList)this.clipboard.getContents(this).getTransferData(PromptGroupsList.CLASS_DATA_FLAVOR);
                            if (pilD == null) continue;
                            this.sectionUI.insert((List<PromptItem>)pilD);
                            continue;
                        }
                        if (PromptGroupsList.CLASS_DATA_FLAVOR.equals(df)) {
                            PromptGroupsList pulD = (PromptGroupsList)this.clipboard.getContents(this).getTransferData(PromptGroupsList.CLASS_DATA_FLAVOR);
                            if (pulD == null) continue;
                            this.sectionUI.insertPromptGroups((List<Group>)pulD);
                            continue;
                        }
                        if (!PromptItem.CLASS_DATA_FLAVOR.equals(df)) continue;
                        this.sectionUI.insert((PromptItem)this.clipboard.getContents(this).getTransferData(PromptItem.CLASS_DATA_FLAVOR));
                    }
                }
                catch (UnsupportedFlavorException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (this.cutMetadataPropertyAction.getActionCommand().equals(cmd)) {
                this.clipboard.setContents((Transferable)this.getSelectedMetadataProperty(), this);
                this.removeSelectedMetadataProperty();
            } else if (this.cutSectionAction.getActionCommand().equals(cmd)) {
                this.clipboard.setContents((Transferable)this.getSelectedSection(), this);
                this.removeSelectedSection();
            } else if (this.addMetadataPropertyAction.getActionCommand().equals(cmd)) {
                Property newProperty = new Property();
                this.insert(newProperty);
            } else if (this.addSectionAction.getActionCommand().equals(cmd)) {
                Section nSection = new Section();
                if (this.sequenceGenerator != null) {
                    nSection.setSectionId(this.sequenceGenerator.getAndIncrement());
                }
                nSection.setPropertyChangeSupportEnabled(true);
                this.insert(nSection);
            } else if (this.undoAction.getActionCommand().equals(cmd)) {
                this.undoManager.undo();
            } else if (this.redoAction.getActionCommand().equals(cmd)) {
                this.undoManager.redo();
            }
        }
        this.updateView();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src instanceof Script && evt.getPropertyName().equals("name")) {
            this.nameField.setText(this.script.getName());
        }
    }

    public void removeSelectedMetadataProperty() {
        TableCellEditor cellEditor = this.metadataTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        List<Property> props = this.metadataTableModel.getMetadataProperties();
        int selRow = this.metadataTable.getSelectedRow();
        if (selRow >= 0) {
            props.remove(selRow);
            int newCount = props.size();
            this.metadataTableModel.fireTableDataChanged();
            if (newCount == 0) {
                this.script.setMetadata(null);
                this.metadataTable.clearSelection();
            } else {
                int newSelRow = selRow - 1;
                if (newSelRow < 0) {
                    newSelRow = 0;
                }
                this.metadataTable.setRowSelectionInterval(newSelRow, newSelRow);
            }
        }
        this.updateEditActions();
    }

    public void removeSelectedSection() {
        StateEdit removeStateEdit = new StateEdit(this, "Remove section");
        TableCellEditor cellEditor = this.sectionsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        this.sectionUI.applyValues();
        ArrayList<Section> newSections = new ArrayList<Section>(Arrays.asList(this.sectionTableModel.getSections()));
        int selRow = this.sectionsTable.getSelectedRow();
        if (selRow >= 0) {
            Section removedSect = newSections.remove(selRow);
            if (removedSect != null) {
                List removedIcs = removedSect.itemCodesList();
                for (String icToRemove : removedIcs) {
                    this.itemCodesList.remove((Object)icToRemove);
                }
            }
            int newSectionCount = newSections.size();
            this.sectionTableModel.setSections(newSections.toArray(new Section[0]));
            if (newSectionCount == 0) {
                this.sectionUI.setSection(null);
                this.sectionsTable.clearSelection();
            } else {
                int newSelRow = selRow - 1;
                if (newSelRow < 0) {
                    newSelRow = 0;
                }
                this.sectionsTable.setRowSelectionInterval(newSelRow, newSelRow);
            }
        }
        removeStateEdit.end();
        this.undoManager.addEdit(removeStateEdit);
        this.updateEditActions();
    }

    public Property getSelectedMetadataProperty() {
        int selRow = this.metadataTable.getSelectedRow();
        List<Property> mdps = this.metadataTableModel.getMetadataProperties();
        return mdps.get(selRow);
    }

    public Section getSelectedSection() {
        return this.sectionTableModel.getSections()[this.sectionsTable.getSelectedRow()];
    }

    public void insert(Property property) {
        TableCellEditor cellEditor = this.metadataTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        List<Property> newProperties = this.metadataTableModel.getMetadataProperties();
        ListSelectionModel selModel = this.metadataTable.getSelectionModel();
        int insertIndex = 0;
        if (!selModel.isSelectionEmpty()) {
            insertIndex = this.metadataTable.getSelectedRow() + 1;
        }
        newProperties.add(insertIndex, property);
        this.metadataTableModel.fireTableDataChanged();
        this.metadataTable.setRowSelectionInterval(insertIndex, insertIndex);
        this.updateEditActions();
    }

    public void insert(Section section) {
        section.setScript(this.script);
        StateEdit insertStateEdit = new StateEdit(this, "Insert section");
        TableCellEditor cellEditor = this.sectionsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        ArrayList<Section> newSections = new ArrayList<Section>(Arrays.asList(this.sectionTableModel.getSections()));
        ListSelectionModel selModel = this.sectionsTable.getSelectionModel();
        int insertIndex = 0;
        if (!selModel.isSelectionEmpty()) {
            insertIndex = this.sectionsTable.getSelectedRow() + 1;
        }
        List gs = section.getGroups();
        for (Group g : gs) {
            List pis = g.getPromptItems();
            for (PromptItem pi : pis) {
                if (!(pi instanceof Recording)) continue;
                Recording recording = (Recording)pi;
                String itemcode = recording.getItemcode();
                if (this.itemcodeGenerator.getConfig().isActive() && (itemcode == null || "".equals(itemcode) || this.itemCodesList.contains((Object)itemcode))) {
                    HashSet<String> ics = new HashSet<String>((Collection<String>)this.itemCodesList);
                    this.itemcodeGenerator.toNext(ics);
                    String icGen = this.itemcodeGenerator.getItemCode();
                    recording.setItemcode(icGen);
                }
                this.itemCodesList.add((Object)recording.getItemcode());
            }
        }
        newSections.add(insertIndex, section);
        this.sectionTableModel.setSections(newSections.toArray(new Section[0]));
        this.sectionsTable.setRowSelectionInterval(insertIndex, insertIndex);
        insertStateEdit.end();
        this.undoManager.addEdit(insertStateEdit);
        this.updateEditActions();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void updateEditActions() {
        boolean editorEnabled = super.isEnabled();
        boolean clipBoardSectionDataAvail = false;
        boolean clipBoardMetadataPropertyAvail = false;
        try {
            clipBoardMetadataPropertyAvail = this.clipboard.isDataFlavorAvailable(Property.CLASS_DATA_FLAVOR);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.pasteMetadataPropertyAction.setEnabled(editorEnabled && clipBoardMetadataPropertyAvail);
        try {
            clipBoardSectionDataAvail = this.clipboard.isDataFlavorAvailable(Section.CLASS_DATA_FLAVOR) || this.clipboard.isDataFlavorAvailable(PromptItem.CLASS_DATA_FLAVOR) || this.clipboard.isDataFlavorAvailable(PromptItemsList.CLASS_DATA_FLAVOR) || this.clipboard.isDataFlavorAvailable(PromptGroupsList.CLASS_DATA_FLAVOR);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.pasteSectionAction.setEnabled(editorEnabled && clipBoardSectionDataAvail);
        this.addMetadataPropertyAction.setEnabled(editorEnabled);
        this.addSectionAction.setEnabled(editorEnabled);
        this.undoAction.update(this.undoManager);
        this.redoAction.update(this.undoManager);
    }

    protected void updateView() {
        boolean useVirtualBox = this.useVirtualBoxCheckBox.isSelected();
        this.virtualBoxHeightLabel.setEnabled(useVirtualBox);
        this.virtualBoxHeightSpinner.setEnabled(useVirtualBox);
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateEditActions();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEditActions();
        if (this.sectionUI != null) {
            this.sectionUI.setEnabled(enabled);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.marginChange = true;
        TableColumnModel colModel = this.sectionsTable.getColumnModel();
        int tableWidth = this.sectionsTable.getPreferredScrollableViewportSize().width;
        int cols = colModel.getColumnCount();
        int totalWidth = 0;
        for (int mc = 0; mc < cols; ++mc) {
            int vc = this.sectionsTable.convertColumnIndexToView(mc);
            TableColumn indCol = colModel.getColumn(vc);
            int prefWidth = 0;
            for (int i = 0; i < this.sectionTableModel.getRowCount(); ++i) {
                Component cc = this.sectionsTable.prepareRenderer(this.sectionsTable.getCellRenderer(i, vc), i, vc);
                Dimension pd = cc.getPreferredSize();
                if (pd.width <= prefWidth) continue;
                prefWidth = pd.width;
            }
            indCol.setMinWidth(prefWidth += this.sectionsTable.getIntercellSpacing().width * 2);
            if (!this.userSized) {
                if (mc == 1) {
                    indCol.setPreferredWidth(tableWidth - totalWidth);
                } else {
                    indCol.setPreferredWidth(prefWidth);
                }
            }
            totalWidth += indCol.getPreferredWidth();
        }
        this.sectionsTable.doLayout();
        this.marginChange = false;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (!this.marginChange) {
            this.userSized = true;
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public void providesEditActions(Object src, EditActions editActions) {
        if (this.editActionsListener != null) {
            this.editActionsListener.providesEditActions(src, editActions);
        }
    }

    public EditActionsListener getEditActionListener() {
        return this.editActionsListener;
    }

    public void setEditActionListener(EditActionsListener editActionsListener) {
        this.editActionsListener = editActionsListener;
    }

    @Override
    public void focusGained(FocusEvent e) {
        ListSelectionModel sectLsm;
        Component c = e.getComponent();
        int eId = e.getID();
        if (eId == 1004 && c != this.metadataTable && c == this.sectionsTable && !(sectLsm = this.sectionsTable.getSelectionModel()).isSelectionEmpty()) {
            this.cutSectionAction.setEnabled(true);
            this.providesEditActions(this, this.editSectionActions);
        }
        this.updateEditActions();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public List<Action> getNewActionsList() {
        return this.newActionsList;
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        Section[] tableSections;
        Section[] currSects;
        for (Section cs : currSects = this.sectionTableModel.getSections()) {
            List sIcs = cs.itemCodesList();
            this.itemCodesList.removeAll((Collection)sIcs);
        }
        for (Section cs : tableSections = (Section[])state.get("sections")) {
            List sIcs = cs.itemCodesList();
            this.itemCodesList.addAll((Collection)sIcs);
        }
        this.setTableSections(tableSections);
        Integer selRow = (Integer)state.get("_sections.selected_row");
        if (selRow == null || selRow == -1) {
            this.sectionsTable.clearSelection();
        } else {
            this.sectionsTable.setRowSelectionInterval(selRow, selRow);
        }
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        state.put("sections", this.sectionTableModel.getSections());
        state.put("_sections.selected_row", this.sectionsTable.getSelectedRow());
    }

    public void setSelectedSection(Section section) {
        Section[] sections = this.sectionTableModel.getSections();
        for (int i = 0; i < sections.length; ++i) {
            if (sections[i] != section) continue;
            this.sectionsTable.setRowSelectionInterval(i, i);
        }
    }

    public void setSelectedPromptItem(PromptItem pi) {
        Section s;
        Group piG;
        if (pi != null && (piG = pi.getGroup()) != null && (s = piG.getSection()) != null && this.script != null) {
            Integer sectionPos = null;
            List scrSects = this.script.getSections();
            for (int si = 0; si < scrSects.size(); ++si) {
                Section scrSect = (Section)scrSects.get(si);
                if (!s.equals(scrSect)) continue;
                sectionPos = si;
            }
            if (sectionPos != null) {
                this.sectionsTable.setRowSelectionInterval(sectionPos, sectionPos);
                this.sectionUI.setSelectedPromptItem(pi);
            }
        }
    }

    public void setDefaultPromptFont(Font defaultPromptFont) {
        this.sectionUI.setDefaultPromptFont(defaultPromptFont);
    }

    public Section.Mode getDefaultSectionMode() {
        return this.defaultSectionMode;
    }

    public void setDefaultSectionMode(Section.Mode defaultSectionMode) {
        this.defaultSectionMode = defaultSectionMode;
        if (this.sectionUI != null) {
            this.sectionUI.setDefaultMode(defaultSectionMode);
        }
    }

    public int getDefaultPreRecording() {
        return this.defaultPreRecording;
    }

    public void setDefaultPreRecording(int defaultPreRecording) {
        this.defaultPreRecording = defaultPreRecording;
        if (this.sectionUI != null) {
            this.sectionUI.setDefaultPreRecording(defaultPreRecording);
        }
    }

    public int getDefaultPostRecording() {
        return this.defaultPostRecording;
    }

    public void setDefaultPostRecording(int defaultPostRecording) {
        this.defaultPostRecording = defaultPostRecording;
        if (this.sectionUI != null) {
            this.sectionUI.setDefaultPostRecording(defaultPostRecording);
        }
    }

    public boolean isDefaultPromptAutoPlay() {
        return this.defaultPromptAutoPlay;
    }

    public void setDefaultPromptAutoPlay(boolean defaultPromptAutoPlay) {
        this.defaultPromptAutoPlay = defaultPromptAutoPlay;
        if (this.sectionUI != null) {
            this.sectionUI.setDefaultPromptAutoPlay(defaultPromptAutoPlay);
        }
    }

    protected void releaseListeners() {
        this.sectionUI.releaseListeners();
        if (this.script != null) {
            this.script.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

