/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptDocEditorKit;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyleContext;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.db.speech.script.prompt.doc.Block;
import ipsk.db.speech.script.prompt.doc.Body;
import ipsk.db.speech.script.prompt.doc.Font;
import ipsk.db.speech.script.prompt.doc.Linebreak;
import ipsk.db.speech.script.prompt.doc.P;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.db.speech.script.prompt.doc.Text;
import ipsk.swing.text.EditorKitMenu;
import ipsk.text.ParserException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class JPromptDocumentEditor
extends JPanel
implements ActionListener,
DocumentListener,
CaretListener {
    private final JEditorPane editorPane;
    private JTextPane srcEditorPane;
    private JPanel buttonPanel;
    private EditorKit editorKit;
    private Document srcDoc;
    private Document doc;
    private Color editorForeGroundColor = Color.BLACK;
    private JToggleButton boldButton;
    private JToggleButton italicButton;
    private JToggleButton defaultStyleButton;

    public JPromptDocumentEditor() {
        super(new GridBagLayout());
        KeyStroke[] kstrks;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        this.editorPane = new JEditorPane();
        this.editorPane.setEditorKitForContentType("text/x-prompt", new PromptDocEditorKit());
        this.editorPane.setPreferredSize(new Dimension(300, 100));
        this.editorPane.setContentType("text/x-prompt");
        EditorKitMenu epEkm = new EditorKitMenu((JTextComponent)this.editorPane);
        epEkm.setPopupMenuActiv(true);
        this.doc = this.editorPane.getDocument();
        this.editorPane.addCaretListener(this);
        this.editorKit = this.editorPane.getEditorKit();
        InputMap inMap = this.editorPane.getInputMap();
        KeyStroke shiftEnterKeyStroke = KeyStroke.getKeyStroke(10, 1);
        inMap.put(shiftEnterKeyStroke, PromptDocEditorKit.LineBreakAction.ACTION_COMMAND);
        for (KeyStroke keyStroke : kstrks = inMap.allKeys()) {
            Object val = inMap.get(keyStroke);
            System.out.println(keyStroke + " -> " + val);
        }
        ActionMap actions = this.editorPane.getActionMap();
        actions.put(PromptDocEditorKit.LineBreakAction.ACTION_COMMAND, new PromptDocEditorKit.LineBreakAction());
        this.srcEditorPane = new JTextPane();
        this.srcEditorPane.setPreferredSize(new Dimension(300, 100));
        this.srcEditorPane.setContentType("text/plain");
        EditorKitMenu sepEkm = new EditorKitMenu((JTextComponent)this.srcEditorPane);
        sepEkm.setPopupMenuActiv(true);
        this.srcDoc = this.srcEditorPane.getDocument();
        this.add((Component)new JScrollPane(this.editorPane), c);
        ++c.gridx;
        this.add((Component)new JScrollPane(this.srcEditorPane), c);
        c.gridx = 0;
        ++c.gridy;
        this.buttonPanel = new JPanel();
        JToolBar toolBar = new JToolBar();
        this.boldButton = new JToggleButton("<html><b>B</b></html>");
        this.italicButton = new JToggleButton("<html><i>i</i></html>");
        this.defaultStyleButton = new JToggleButton("Default style");
        for (Action a : this.editorKit.getActions()) {
            String name = (String)a.getValue("Name");
            if (name.equals("font-bold")) {
                this.boldButton.addActionListener(a);
                continue;
            }
            if (!name.equals("font-italic")) continue;
            this.italicButton.addActionListener(a);
        }
        JButton jButton = new JButton("Write");
        jButton.addActionListener(this);
        toolBar.add(this.defaultStyleButton);
        toolBar.add(this.boldButton);
        toolBar.add(this.italicButton);
        JButton colorButton = new JButton("Color");
        final JPromptDocumentEditor parent = this;
        toolBar.add(colorButton);
        SpinnerNumberModel model = new SpinnerNumberModel(12, 8, 1000, 10);
        final JSpinner fontSizeSpinner = new JSpinner(model);
        fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer value = (Integer)fontSizeSpinner.getValue();
                StyledEditorKit.FontSizeAction fsAction = new StyledEditorKit.FontSizeAction("font-size-" + value.toString(), value);
                fsAction.actionPerformed(new ActionEvent(JPromptDocumentEditor.this.editorPane, 1001, value.toString()));
            }
        });
        colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c;
                if (JPromptDocumentEditor.this.editorKit instanceof StyledEditorKit && JPromptDocumentEditor.this.doc instanceof StyledDocument) {
                    StyledEditorKit sek = (StyledEditorKit)JPromptDocumentEditor.this.editorKit;
                    StyledDocument sd = (StyledDocument)JPromptDocumentEditor.this.doc;
                    JPromptDocumentEditor.this.editorForeGroundColor = sd.getForeground(sek.getInputAttributes());
                }
                if ((c = JColorChooser.showDialog(parent, "Text color", JPromptDocumentEditor.this.editorForeGroundColor)) == null) {
                    return;
                }
                StyledEditorKit.ForegroundAction fgAction = new StyledEditorKit.ForegroundAction("color", c);
                fgAction.actionPerformed(e);
                JPromptDocumentEditor.this.editorForeGroundColor = c;
            }
        });
        toolBar.add(colorButton);
        toolBar.add(fontSizeSpinner);
        this.buttonPanel.add(toolBar);
        this.buttonPanel.add(jButton);
        this.add((Component)this.buttonPanel, c);
        this.doc.addDocumentListener(this);
        this.srcDoc.addDocumentListener(this);
    }

    public static void main(String[] args) {
        Runnable guiRunnable = new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("Test");
                f.setDefaultCloseOperation(3);
                JPromptDocumentEditor e = new JPromptDocumentEditor();
                f.add(e);
                f.pack();
                f.setVisible(true);
                ArrayList<P> ps = new ArrayList<P>();
                P p = new P();
                Text ft1 = new Text();
                ft1.setText("How ");
                p.getTexts().add(ft1);
                Text ft2 = new Text();
                ft2.setText("did ");
                Font b1 = new Font();
                b1.setWeight(Font.BOLD);
                b1.setText(ft2);
                p.getTexts().add(b1);
                Text ft3 = new Text();
                ft3.setText("you");
                p.getTexts().add(ft3);
                ps.add(p);
                P p2 = new P();
                Text ft4 = new Text();
                ft4.setText("Line1");
                p2.getTexts().add(ft4);
                ps.add(p2);
                P p3 = new P();
                Text ft5 = new Text();
                ft5.setText("Line3");
                p3.getTexts().add(ft5);
                Linebreak nl = new Linebreak();
                p3.getTexts().add(nl);
                Text ft6 = new Text();
                ft6.setText("Line4");
                p3.getTexts().add(ft6);
                ps.add(p3);
                PromptDoc pd = new PromptDoc();
                Body body = new Body();
                pd.setBody(body);
                body.setBlocks(ps);
                PromptStyleContext sc = new PromptStyleContext();
                try {
                    PromptStyledDocument psd = new PromptStyledDocument(sc, pd);
                    psd.addDocumentListener(e);
                    e.setDocument(psd);
                }
                catch (ParserException e1) {
                    e1.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(guiRunnable);
    }

    protected void setDocument(PromptStyledDocument psd) {
        this.editorPane.setDocument(psd);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Document doc = this.editorPane.getDocument();
        try {
            this.editorKit.write(System.out, doc, 0, doc.getLength());
            Document d = this.editorPane.getDocument();
            if (d instanceof PromptStyledDocument) {
                PromptStyledDocument pd = (PromptStyledDocument)d;
                pd.dump(System.out);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    private void updateSourcePane(DocumentEvent e) {
        Document d = e.getDocument();
        if (d == this.doc) {
            StringWriter sw = new StringWriter();
            try {
                this.editorKit.write(sw, d, 0, d.getLength());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            String srcText = sw.toString();
            this.srcDoc.removeDocumentListener(this);
            this.srcEditorPane.setText(srcText);
            this.srcDoc.addDocumentListener(this);
        } else if (d == this.srcDoc) {
            try {
                StringReader in = new StringReader(this.srcDoc.getText(0, this.srcDoc.getLength()));
                this.doc.removeDocumentListener(this);
                this.doc.remove(0, this.doc.getLength());
                this.editorKit.read(in, this.doc, 0);
                this.doc.addDocumentListener(this);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void printDoc(DocumentEvent e) {
        Document d = e.getDocument();
        if (d instanceof PromptStyledDocument) {
            PromptStyledDocument pd = (PromptStyledDocument)d;
            PromptDoc pr = pd.toPromptFormat();
            Body pdBody = pr.getBody();
            if (pdBody != null) {
                List pList = pdBody.getBlocks();
                for (Block p : pList) {
                    System.out.println(p);
                }
            }
            System.out.println();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSourcePane(e);
    }

    private String elementToDescr(Element e) {
        StringBuffer sb = new StringBuffer();
        sb.append(e.getName() + "\n");
        sb.append(e.getClass().getName() + "\n");
        int eCnt = e.getElementCount();
        for (int i = 0; i < eCnt; ++i) {
            sb.append("Child: " + this.elementToDescr(e.getElement(i)) + "\n");
        }
        return sb.toString();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateSourcePane(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSourcePane(e);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        int start = this.editorPane.getSelectionStart();
        int end = this.editorPane.getSelectionEnd();
        Document d = this.editorPane.getDocument();
        if (d instanceof StyledDocument) {
            StyledDocument sd = (StyledDocument)d;
            boolean allDefault = true;
            boolean allBold = false;
            boolean allItalic = false;
            if (end > start) {
                allBold = true;
                allItalic = true;
                for (int pos = start; pos < end; ++pos) {
                    Element el = sd.getCharacterElement(pos);
                    AttributeSet as = el.getAttributes();
                    allDefault = allDefault && !as.isDefined(StyleConstants.Bold) && !as.isDefined(StyleConstants.Italic) && !as.isDefined(StyleConstants.Underline);
                    allBold = allBold && StyleConstants.isBold(as);
                    allItalic = allItalic && StyleConstants.isItalic(as);
                }
            }
            this.defaultStyleButton.setSelected(allDefault);
            this.boldButton.setSelected(allBold);
            this.italicButton.setSelected(allItalic);
        }
    }
}

