/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyleContext;
import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.db.speech.script.prompt.doc.Font;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.text.ParserException;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PromptDocEditorKit
extends StyledEditorKit {
    JEditorPane installedToPane;
    private ViewFactory defaultViewFactory;

    public PromptDocEditorKit() {
        this(false);
    }

    public PromptDocEditorKit(boolean viewOnly) {
        this.defaultViewFactory = new PromptDocFactory(viewOnly);
    }

    @Override
    public void install(JEditorPane c) {
        this.installedToPane = c;
        super.install(c);
    }

    @Override
    public void deinstall(JEditorPane c) {
        this.installedToPane = null;
        super.deinstall(c);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.defaultViewFactory;
    }

    @Override
    public String getContentType() {
        return "text/x-prompt";
    }

    @Override
    public Document createDefaultDocument() {
        PromptStyleContext c = new PromptStyleContext();
        PromptStyledDocument d = null;
        try {
            d = new PromptStyledDocument(c, new PromptDoc());
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return d;
    }

    public static class SetFontSizeAction
    extends StyledEditorKit.StyledTextAction {
        public SetFontSizeAction() {
            super("set-font-size");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null && e instanceof SetFontSizeActionEvent) {
                SimpleAttributeSet sas;
                SetFontSizeActionEvent sfae = (SetFontSizeActionEvent)e;
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                Font.FontSize fs = sfae.getFontSize();
                boolean replace = false;
                if (fs == null) {
                    PromptStyledDocument psd;
                    Style defStyle;
                    Object defFontSize;
                    sas = new SimpleAttributeSet(attr);
                    replace = true;
                    sas.removeAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
                    Document d = editor.getDocument();
                    if (d instanceof PromptStyledDocument && (defFontSize = (defStyle = (psd = (PromptStyledDocument)d).getStyle("default")).getAttribute(StyleConstants.FontSize)) instanceof Number) {
                        Number defFontSizeNumber = (Number)defFontSize;
                        StyleConstants.setFontSize(sas, defFontSizeNumber.intValue());
                    }
                } else {
                    sas = new SimpleAttributeSet();
                    sas.addAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE, fs);
                    StyleConstants.setFontSize(sas, sfae.getSize());
                }
                this.setCharacterAttributes(editor, sas, replace);
            }
        }
    }

    public static class SetFontSizeActionEvent
    extends ActionEvent {
        private static final long serialVersionUID = 1L;
        private int size;
        private Font.FontSize fontSize;

        public SetFontSizeActionEvent(Object source, String command, Font.FontSize fontSize, int size) {
            super(source, 1001, command);
            this.fontSize = fontSize;
            this.size = size;
        }

        public Font.FontSize getFontSize() {
            return this.fontSize;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static class StrikethroughAction
    extends StyledEditorKit.StyledTextAction {
        public StrikethroughAction() {
            super("strike-through");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean strikethrough = !StyleConstants.isStrikeThrough(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setStrikeThrough(sas, strikethrough);
                if (strikethrough) {
                    StyleConstants.setUnderline(sas, false);
                }
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    public static class UnderlineAction
    extends StyledEditorKit.StyledTextAction {
        public UnderlineAction() {
            super("underline");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean underline = !StyleConstants.isUnderline(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setUnderline(sas, underline);
                if (underline) {
                    StyleConstants.setStrikeThrough(sas, false);
                }
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    public static class LineBreakAction
    extends StyledEditorKit.StyledTextAction {
        public static final String ACTION_COMMAND = new String("br");

        public LineBreakAction() {
            super(ACTION_COMMAND);
            this.putValue("ActionCommandKey", ACTION_COMMAND);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane editor = this.getEditor(e);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                SimpleAttributeSet attrSave = new SimpleAttributeSet(attr);
                Document d = editor.getDocument();
                if (d instanceof PromptStyledDocument) {
                    PromptStyledDocument psd = (PromptStyledDocument)d;
                    Caret caret = editor.getCaret();
                    int dot = caret.getDot();
                    try {
                        psd.insertLineBreak(dot);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                    this.setCharacterAttributes(editor, attrSave, false);
                    caret.setDot(dot + 1);
                }
            }
        }
    }

    public static class PromptDocFactory
    implements ViewFactory {
        private boolean viewOnly;

        public PromptDocFactory() {
            this(false);
        }

        public PromptDocFactory(boolean viewOnly) {
            this.viewOnly = viewOnly;
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    AttributeSet pAttrs = elem.getAttributes();
                    Object viewAttr = pAttrs.getAttribute(PromptStyledDocument.VIEW_ELEMENT_NAME);
                    if (!this.viewOnly || Boolean.TRUE.equals(viewAttr)) {
                        return new ParagraphView(elem);
                    }
                    return new EmptyView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
                if (PromptStyledDocument.LINE_BREAK_ELEMENT_NAME.equals(kind)) {
                    return new LineBreakView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    public static class LineBreakView
    extends LabelView {
        public LineBreakView(Element elem) {
            super(elem);
        }

        @Override
        public int getBreakWeight(int axis, float pos, float len) {
            if (axis == 0) {
                return 3000;
            }
            return super.getBreakWeight(axis, pos, len);
        }
    }

    public static class EmptyView
    extends View {
        public EmptyView(Element elem) {
            super(elem);
        }

        @Override
        public float getPreferredSpan(int axis) {
            return 0.0f;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            return null;
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
            return 0;
        }
    }
}

