/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import ipsk.awt.ColorUtils;
import ipsk.db.speech.script.prompt.doc.Block;
import ipsk.db.speech.script.prompt.doc.Body;
import ipsk.db.speech.script.prompt.doc.Font;
import ipsk.db.speech.script.prompt.doc.Linebreak;
import ipsk.db.speech.script.prompt.doc.P;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.db.speech.script.prompt.doc.Text;
import ipsk.db.speech.script.prompt.doc.TextFormatElement;
import ipsk.text.ParserException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class PromptStyledDocument
extends DefaultStyledDocument {
    public static String LINE_BREAK_ELEMENT_NAME = "linebreakelement";
    public static String VIEW_ELEMENT_NAME = "viewelement";
    public static String STYLE_ATTR_DEFAULT_FONTSIZE = "defaultFontSize";
    public static String STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE = "fontSizeRelativeOrAbsolute";
    public static String STYLE_ATTR_USE_VIRTUAL_SCALE_BOX = "useVirtualScaleBox";
    public static String STYLE_ATTR_VIRTUAL_HEIGHT = "virtualHeight";
    private PromptDoc promptDoc;

    protected AbstractDocument.AbstractElement createDefaultRoot_Dis() {
        this.writeLock();
        DefaultStyledDocument.SectionElement section = new DefaultStyledDocument.SectionElement(this);
        AbstractDocument.BranchElement paragraph = new AbstractDocument.BranchElement(this, section, null);
        SimpleAttributeSet sAttrSet = new SimpleAttributeSet(this.getStyle("default"));
        sAttrSet.addAttribute("$ename", "section");
        AbstractDocument.BranchElement lineSection = new AbstractDocument.BranchElement(this, paragraph, sAttrSet);
        AbstractDocument.BranchElement lineBranch = new AbstractDocument.BranchElement(this, lineSection, null);
        AbstractDocument.LeafElement brk = new AbstractDocument.LeafElement(this, lineBranch, null, 0, 1);
        Element[] buff = new Element[]{brk};
        lineBranch.replace(0, 0, buff);
        buff[0] = lineBranch;
        lineSection.replace(0, 0, buff);
        buff[0] = lineSection;
        paragraph.replace(0, 0, buff);
        buff[0] = paragraph;
        section.replace(0, 0, buff);
        this.writeUnlock();
        return section;
    }

    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        return super.createDefaultRoot();
    }

    public PromptStyledDocument() {
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        super.setCharacterAttributes(offset, length, s, replace);
    }

    @Override
    public Element getCharacterElement(int pos) {
        Element e = super.getCharacterElement(pos);
        return e;
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        String s = super.getText(offset, length);
        return s;
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        super.getText(offset, length, txt);
    }

    private void toContentElems(List<DefaultStyledDocument.ElementSpec> elSpecList, List<TextFormatElement> ftc, MutableAttributeSet as) throws ParserException {
        int chSz = ftc.size();
        for (int i = 0; i < chSz; ++i) {
            TextFormatElement ft = ftc.get(i);
            SimpleAttributeSet saSet = new SimpleAttributeSet(this.getStyle("default"));
            StyleConstants.setSpaceAbove(saSet, 0.0f);
            StyleConstants.setSpaceBelow(saSet, 0.0f);
            Text text = null;
            Font f = null;
            String t = null;
            if (ft instanceof Font) {
                f = (Font)ft;
                text = f.getText();
                t = text.getText();
            } else if (ft instanceof Text) {
                text = (Text)ft;
                t = text.getText();
            } else if (ft instanceof Linebreak) {
                SimpleAttributeSet brkSet = new SimpleAttributeSet();
                brkSet.addAttribute("$ename", LINE_BREAK_ELEMENT_NAME);
                DefaultStyledDocument.ElementSpec nlTg = new DefaultStyledDocument.ElementSpec(brkSet, 3, "\r".toCharArray(), 0, 1);
                elSpecList.add(nlTg);
            }
            if (text != null) {
                Color c;
                String de = text.getDecoration();
                if (Text.UNDERLINE.equals(de)) {
                    StyleConstants.setUnderline(saSet, true);
                } else if (Text.LINE_THROUGH.equals(de)) {
                    StyleConstants.setStrikeThrough(saSet, true);
                } else if (Text.NONE.equals(de)) {
                    StyleConstants.setUnderline(saSet, false);
                }
                String co = text.getColor();
                if (co != null && (c = ColorUtils.stringToColor((String)co)) != null) {
                    StyleConstants.setForeground(saSet, c);
                }
            }
            if (f != null) {
                String st;
                Style defStyle;
                Object defFontSize;
                String si = f.getSize();
                if (si != null && (defFontSize = (defStyle = this.getStyle("default")).getAttribute(StyleConstants.FontSize)) instanceof Number) {
                    Number defFontSizeNumber = (Number)defFontSize;
                    Font.FontSize fs = f.fontSize();
                    if (fs != null) {
                        saSet.addAttribute(STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE, fs);
                    }
                    double absSize = f.toRealFontSize(defFontSizeNumber.doubleValue());
                    StyleConstants.setFontSize(saSet, (int)absSize);
                }
                if (Font.ITALIC.equals(st = f.getStyle())) {
                    StyleConstants.setItalic(saSet, true);
                } else if (Font.NORMAL.equals(st)) {
                    StyleConstants.setBold(saSet, false);
                }
                String we = f.getWeight();
                if (Font.BOLD.equals(we)) {
                    StyleConstants.setBold(saSet, true);
                } else if (Font.NORMAL.equals(we)) {
                    StyleConstants.setBold(saSet, false);
                }
            }
            if (t == null) continue;
            int tlen = t.length();
            DefaultStyledDocument.ElementSpec txtTg = new DefaultStyledDocument.ElementSpec(saSet, 3, t.toCharArray(), 0, tlen);
            elSpecList.add(txtTg);
        }
        SimpleAttributeSet saSet = new SimpleAttributeSet(this.getStyle("default"));
        DefaultStyledDocument.ElementSpec nlTg = new DefaultStyledDocument.ElementSpec(saSet, 3, "\n".toCharArray(), 0, 1);
        elSpecList.add(nlTg);
    }

    public PromptStyledDocument(StyleContext styleCtx, PromptDoc promptDoc) throws ParserException {
        super(styleCtx);
        this.promptDoc = promptDoc;
        this.build();
    }

    private void build() throws ParserException {
        Body body = this.promptDoc.getBody();
        if (body != null) {
            ArrayList<DefaultStyledDocument.ElementSpec> elspecs = new ArrayList<DefaultStyledDocument.ElementSpec>();
            SimpleAttributeSet sAttrSet = new SimpleAttributeSet(this.getStyle("default"));
            sAttrSet.addAttribute("$ename", "section");
            DefaultStyledDocument.ElementSpec s = new DefaultStyledDocument.ElementSpec(sAttrSet, 1);
            elspecs.add(s);
            List blocks = body.getBlocks();
            int pCnt = blocks.size();
            if (pCnt > 0) {
                for (int pi = 0; pi < pCnt; ++pi) {
                    Block b = (Block)blocks.get(pi);
                    SimpleAttributeSet ppAttrSet = new SimpleAttributeSet(this.getStyle("default"));
                    ppAttrSet.addAttribute(VIEW_ELEMENT_NAME, true);
                    DefaultStyledDocument.ElementSpec spTg = new DefaultStyledDocument.ElementSpec(ppAttrSet, 1);
                    elspecs.add(spTg);
                    if (b instanceof P) {
                        P p = (P)b;
                        SimpleAttributeSet pAttrSet = new SimpleAttributeSet(this.getStyle("default"));
                        this.toContentElems(elspecs, p.getTexts(), pAttrSet);
                    }
                    DefaultStyledDocument.ElementSpec epTg = new DefaultStyledDocument.ElementSpec(ppAttrSet, 2);
                    elspecs.add(epTg);
                }
            } else {
                SimpleAttributeSet ppAttrSet = new SimpleAttributeSet(this.getStyle("default"));
                DefaultStyledDocument.ElementSpec spTg = new DefaultStyledDocument.ElementSpec(ppAttrSet, 1);
                elspecs.add(spTg);
                DefaultStyledDocument.ElementSpec stTg = new DefaultStyledDocument.ElementSpec(null, 1);
                elspecs.add(stTg);
                DefaultStyledDocument.ElementSpec pETg = new DefaultStyledDocument.ElementSpec(null, 2);
                elspecs.add(pETg);
                DefaultStyledDocument.ElementSpec speTg = new DefaultStyledDocument.ElementSpec(ppAttrSet.copyAttributes(), 2);
                elspecs.add(speTg);
            }
            DefaultStyledDocument.ElementSpec seTg = new DefaultStyledDocument.ElementSpec(sAttrSet, 2);
            elspecs.add(seTg);
            this.create(elspecs.toArray(new DefaultStyledDocument.ElementSpec[elspecs.size()]));
        }
    }

    public void insertLineBreak(int offset) throws BadLocationException {
        SimpleAttributeSet brkSet = new SimpleAttributeSet();
        brkSet.addAttribute("$ename", LINE_BREAK_ELEMENT_NAME);
        this.insertString(offset, "\r", brkSet);
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        if (attr != null) {
            Object elName = attr.getAttribute("$ename");
            if (elName != null && LINE_BREAK_ELEMENT_NAME.equals(elName)) {
                int offset = chng.getOffset();
                int length = chng.getLength();
                Element paragraph = this.getParagraphElement(offset + length);
                AttributeSet pattr = paragraph.getAttributes();
                Element pParagraph = this.getParagraphElement(offset);
                Element run = pParagraph.getElement(pParagraph.getElementIndex(offset));
                int endOffset = offset + length;
                boolean insertingAtBoundry = run.getEndOffset() == endOffset;
                AttributeSet cattr = run.getAttributes();
                try {
                    Element nextRun;
                    DefaultStyledDocument.ElementSpec last;
                    Segment s = new Segment();
                    Vector<DefaultStyledDocument.ElementSpec> parseBuffer = new Vector<DefaultStyledDocument.ElementSpec>();
                    boolean insertingAfterNewline = false;
                    if (!insertingAfterNewline) {
                        pattr = pParagraph.getAttributes();
                    }
                    this.getText(offset, length, s);
                    char[] txt = s.array;
                    int n = s.offset + s.count;
                    int lastOffset = s.offset;
                    for (int i = s.offset; i < n; ++i) {
                        if (txt[i] != '\n') continue;
                        int breakOffset = i + 1;
                        parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(attr, 3, breakOffset - lastOffset));
                        lastOffset = breakOffset;
                    }
                    if (lastOffset < n) {
                        parseBuffer.addElement(new DefaultStyledDocument.ElementSpec(attr, 3, n - lastOffset));
                    }
                    DefaultStyledDocument.ElementSpec first = (DefaultStyledDocument.ElementSpec)parseBuffer.firstElement();
                    int docLength = this.getLength();
                    if (first.getType() == 3 && cattr.isEqual(attr)) {
                        first.setDirection((short)4);
                    }
                    if (insertingAtBoundry && endOffset < docLength && (last = (DefaultStyledDocument.ElementSpec)parseBuffer.lastElement()).getType() == 3 && last.getDirection() != 4 && (paragraph == pParagraph || insertingAfterNewline) && (nextRun = paragraph.getElement(paragraph.getElementIndex(endOffset))).isLeaf() && attr.isEqual(nextRun.getAttributes())) {
                        last.setDirection((short)5);
                    }
                    Object[] spec = new DefaultStyledDocument.ElementSpec[parseBuffer.size()];
                    parseBuffer.copyInto(spec);
                    this.buffer.insert(offset, length, (DefaultStyledDocument.ElementSpec[])spec, chng);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                super.insertUpdate(chng, attr);
            }
        } else {
            super.insertUpdate(chng, attr);
        }
    }

    private void updateFontSizes() throws BadLocationException, ParserException {
        this.remove(0, this.getLength());
        this.build();
    }

    public void setUseVirtualScaleBox(boolean useVirtualScaleBox) {
        Style defStyle = this.getStyle("default");
        defStyle.addAttribute(STYLE_ATTR_USE_VIRTUAL_SCALE_BOX, useVirtualScaleBox);
        try {
            this.updateFontSizes();
        }
        catch (ParserException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean getUseVirtualScaleBox() {
        boolean uvsb = true;
        Style defStyle = this.getStyle("default");
        Object useVsb = defStyle.getAttribute(STYLE_ATTR_USE_VIRTUAL_SCALE_BOX);
        if (Boolean.FALSE.equals(useVsb)) {
            uvsb = false;
        }
        return uvsb;
    }

    public PromptDoc toPromptFormat() {
        this.readLock();
        PromptDoc pr = new PromptDoc();
        ArrayList<P> prParagraphs = new ArrayList<P>();
        Element rootElem = this.getDefaultRootElement();
        int pCnt = rootElem.getElementCount();
        for (int i = 0; i < pCnt; ++i) {
            Element pe = rootElem.getElement(i);
            P p = new P();
            prParagraphs.add(p);
            int pChCnt = pe.getElementCount();
            for (int pci = 0; pci < pChCnt; ++pci) {
                Object cAttr;
                Object ulAttr;
                Object stAttr;
                Font.FontSize fs;
                Element pChE = pe.getElement(pci);
                if (!pChE.isLeaf()) continue;
                AttributeSet attrSet = pChE.getAttributes();
                Object nmAttr = attrSet.getAttribute("$ename");
                if (LINE_BREAK_ELEMENT_NAME.equals(nmAttr)) {
                    Linebreak nl = new Linebreak();
                    p.getTexts().add(nl);
                    continue;
                }
                Font fe = null;
                Text te = new Text();
                if (attrSet.isDefined(StyleConstants.Italic)) {
                    fe = new Font();
                    Object italicAttr = attrSet.getAttribute(StyleConstants.Italic);
                    if (Boolean.TRUE.equals(italicAttr)) {
                        fe.setStyle(Font.ITALIC);
                    } else {
                        fe.setStyle(Font.NORMAL);
                    }
                }
                if (attrSet.isDefined(StyleConstants.Bold)) {
                    Object boldAttr;
                    if (fe == null) {
                        fe = new Font();
                    }
                    if (Boolean.TRUE.equals(boldAttr = attrSet.getAttribute(StyleConstants.Bold))) {
                        fe.setWeight(Font.BOLD);
                    } else {
                        fe.setWeight(Font.NORMAL);
                    }
                }
                if ((fs = (Font.FontSize)attrSet.getAttribute(STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE)) != null) {
                    if (fe == null) {
                        fe = new Font();
                    }
                    fe.setSize(fs.toString());
                }
                String decoration = null;
                if (attrSet.isDefined(StyleConstants.StrikeThrough) && Boolean.TRUE.equals(stAttr = attrSet.getAttribute(StyleConstants.StrikeThrough))) {
                    decoration = Text.LINE_THROUGH;
                }
                if (decoration == null && attrSet.isDefined(StyleConstants.Underline) && Boolean.TRUE.equals(ulAttr = attrSet.getAttribute(StyleConstants.Underline))) {
                    decoration = Text.UNDERLINE;
                }
                te.setDecoration(decoration);
                if (attrSet.isDefined(StyleConstants.Foreground) && (cAttr = attrSet.getAttribute(StyleConstants.Foreground)) instanceof Color) {
                    Color c = (Color)cAttr;
                    te.setColor(ColorUtils.colorToString((Color)c));
                }
                if (fe != null) {
                    fe.setText(te);
                }
                if (!(pChE instanceof AbstractDocument.LeafElement)) continue;
                AbstractDocument.LeafElement le = (AbstractDocument.LeafElement)pChE;
                int st = le.getStartOffset();
                int en = le.getEndOffset();
                try {
                    String str = this.getText(st, en - st);
                    str = str.replaceFirst("\n$", "");
                    if (str.length() <= 0) continue;
                    te.setText(str);
                    if (fe != null) {
                        p.getTexts().add(fe);
                        continue;
                    }
                    p.getTexts().add(te);
                    continue;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        int prSize = prParagraphs.size();
        Block lastPr = (Block)prParagraphs.get(prSize - 1);
        if (lastPr.getTexts().size() == 0) {
            prParagraphs.remove(prSize - 1);
        }
        Body body = new Body();
        pr.setBody(body);
        body.setBlocks(prParagraphs);
        this.readUnlock();
        return pr;
    }

    public class LineBreakElement
    extends AbstractDocument.LeafElement {
        public LineBreakElement(Element parent, int offs1, int offs2) {
            super(PromptStyledDocument.this, parent, new SimpleAttributeSet(), offs1, offs2);
            this.addAttribute(NameAttribute, LINE_BREAK_ELEMENT_NAME);
            this.addAttribute("$ename", LINE_BREAK_ELEMENT_NAME);
        }
    }

    public class TextFragmentElement
    extends AbstractDocument.LeafElement {
        public TextFragmentElement(Element parent, AttributeSet attrSet, int offs1, int offs2) {
            super(PromptStyledDocument.this, parent, attrSet, offs1, offs2);
        }
    }

    public class ParagraphElement
    extends AbstractDocument.BranchElement {
        public ParagraphElement(Element parent, AttributeSet attrSet) {
            super(PromptStyledDocument.this, parent, attrSet);
        }
    }

    public class PromptDocElement
    extends DefaultStyledDocument.SectionElement {
        public PromptDocElement() {
            super(PromptStyledDocument.this);
        }
    }
}

