/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import ipsk.apps.speechrecorder.script.ui.prompt.styled.PromptStyledDocument;
import ipsk.swing.CopyAction;
import ipsk.swing.CutAction;
import ipsk.swing.PasteAction;
import ipsk.swing.RedoAction;
import ipsk.swing.SelectAllAction;
import ipsk.swing.UndoAction;
import ipsk.swing.action.EditActions;
import ipsk.swing.action.EditActionsListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class StyledEditorKitMenu
implements CaretListener,
MouseListener,
FlavorListener,
FocusListener,
UndoableEditListener,
PropertyChangeListener {
    private JEditorPane textComponent;
    private ArrayList<JMenuItem> menuItems = new ArrayList();
    private Action[] actions;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private JPopupMenu popupMenu;
    private boolean popupMenuActiv = true;
    private Clipboard clipboard;
    private Vector<EditActionsListener> editActionsListenerList;
    private EditActions editActions;
    private Document document = null;
    private UndoManager undoManager = new UndoManager();

    public StyledEditorKitMenu(JEditorPane textComponent, EditActionsListener editActionsListener) {
        this(textComponent);
        this.addEditActionListener(editActionsListener);
    }

    public StyledEditorKitMenu(JEditorPane textComponent) {
        this(textComponent, true);
    }

    public StyledEditorKitMenu(JEditorPane textComponent, boolean editable) {
        this.textComponent = textComponent;
        try {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (SecurityException se) {
            this.clipboard = null;
        }
        if (this.clipboard != null) {
            this.clipboard.addFlavorListener(this);
        }
        this.actions = textComponent.getActions();
        InputMap iMap = textComponent.getInputMap();
        ActionMap aMap = textComponent.getActionMap();
        textComponent.addCaretListener(this);
        final UndoManager um = this.undoManager;
        this.undoAction = new UndoAction(){

            public void actionPerformed(ActionEvent e) {
                um.undo();
                StyledEditorKitMenu.this.updateActions();
            }
        };
        iMap.put(UndoAction.ACCELERATOR_VAL, UndoAction.NAME);
        aMap.put(UndoAction.NAME, (Action)this.undoAction);
        this.redoAction = new RedoAction(){

            public void actionPerformed(ActionEvent e) {
                um.redo();
                StyledEditorKitMenu.this.updateActions();
            }
        };
        iMap.put(RedoAction.ACCELERATOR_VAL, RedoAction.NAME);
        aMap.put(RedoAction.NAME, (Action)this.redoAction);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        this.document = textComponent.getDocument();
        if (this.document != null) {
            this.document.addUndoableEditListener(this);
        }
        textComponent.addPropertyChangeListener("document", this);
        for (Action a : this.actions) {
            if (a.getValue("Name").equals("cut-to-clipboard")) {
                final Action aCut = a;
                this.cutAction = new CutAction(){

                    public void actionPerformed(ActionEvent e) {
                        aCut.actionPerformed(e);
                    }
                };
                if (!editable) continue;
                this.menuItems.add(new JMenuItem(this.cutAction));
                continue;
            }
            if (a.getValue("Name").equals("copy-to-clipboard")) {
                final Action aCopy = a;
                this.copyAction = new CopyAction(){

                    public void actionPerformed(ActionEvent e) {
                        aCopy.actionPerformed(e);
                    }
                };
                this.menuItems.add(new JMenuItem(this.copyAction));
                continue;
            }
            if (a.getValue("Name").equals("paste-from-clipboard")) {
                final Action aPaste = a;
                this.pasteAction = new PasteAction(){

                    public void actionPerformed(ActionEvent e) {
                        aPaste.actionPerformed(e);
                    }
                };
                this.pasteAction.setEnabled(false);
                if (!editable) continue;
                this.menuItems.add(new JMenuItem(this.pasteAction));
                continue;
            }
            if (!a.getValue("Name").equals("select-all")) continue;
            final Action aSelectAll = a;
            SelectAllAction selectAllAction = new SelectAllAction(){

                public void actionPerformed(ActionEvent e) {
                    aSelectAll.actionPerformed(e);
                }
            };
            this.menuItems.add(new JMenuItem((Action)selectAllAction));
        }
        if (editable) {
            this.menuItems.add(new JMenuItem((Action)this.undoAction));
            this.menuItems.add(new JMenuItem((Action)this.redoAction));
        }
        this.popupMenu = this.createJPopupMenu();
        this.editActionsListenerList = new Vector();
        this.editActions = new EditActions("Editor kit menu of " + textComponent.getClass().getName(), this.cutAction, this.copyAction, this.pasteAction, this.undoAction, this.redoAction);
        textComponent.addFocusListener(this);
        this.updateActions();
        this.setPopupMenuActiv(true);
    }

    public JPopupMenu createJPopupMenu() {
        JPopupMenu popMenu = new JPopupMenu();
        for (JMenuItem mi : this.menuItems) {
            popMenu.add(mi);
        }
        return popMenu;
    }

    public boolean isPopupMenuActiv() {
        return this.popupMenuActiv;
    }

    public void setPopupMenuActiv(boolean popupMenuActiv) {
        this.popupMenuActiv = popupMenuActiv;
        if (this.popupMenuActiv) {
            this.textComponent.addMouseListener(this);
        } else {
            this.textComponent.removeMouseListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("document".equals(evt.getPropertyName())) {
            if (this.document != null) {
                this.document.removeUndoableEditListener(this);
            }
            this.document = this.textComponent.getDocument();
            if (this.document != null) {
                this.document.addUndoableEditListener(this);
            }
        }
    }

    private void updateActions() {
        if (this.clipboard != null) {
            boolean clipBoardAvail = false;
            try {
                clipBoardAvail = this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            String selText = this.textComponent.getSelectedText();
            Document doc = this.textComponent.getDocument();
            if (doc instanceof PromptStyledDocument) {
                PromptStyledDocument promptStyledDocument = (PromptStyledDocument)doc;
            }
            if (selText != null) {
                if (this.cutAction != null) {
                    this.cutAction.setEnabled(true);
                }
                if (this.copyAction != null) {
                    this.copyAction.setEnabled(true);
                }
            } else {
                if (this.cutAction != null) {
                    this.cutAction.setEnabled(false);
                }
                if (this.copyAction != null) {
                    this.copyAction.setEnabled(false);
                }
            }
            if (clipBoardAvail) {
                if (this.pasteAction != null) {
                    this.pasteAction.setEnabled(true);
                }
            } else if (this.pasteAction != null) {
                this.pasteAction.setEnabled(false);
            }
        }
        this.undoAction.setEnabled(this.undoManager.canUndo());
        this.undoAction.putValue("Name", (Object)this.undoManager.getUndoPresentationName());
        this.redoAction.setEnabled(this.undoManager.canRedo());
        this.redoAction.putValue("Name", (Object)this.undoManager.getRedoPresentationName());
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        this.updateActions();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        if (c.isEnabled() && e.isPopupTrigger()) {
            this.popupMenu.show(c, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Component c = e.getComponent();
        if (c.isEnabled() && e.isPopupTrigger()) {
            this.popupMenu.show(c, e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoManager.undoableEditHappened(e);
        this.updateActions();
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEditActionListener(EditActionsListener editActionsListener) {
        Vector<EditActionsListener> vector = this.editActionsListenerList;
        synchronized (vector) {
            if (!this.editActionsListenerList.contains(editActionsListener)) {
                this.editActionsListenerList.add(editActionsListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEditActionListener(EditActionsListener editActionsListener) {
        Vector<EditActionsListener> vector = this.editActionsListenerList;
        synchronized (vector) {
            this.editActionsListenerList.remove(editActionsListener);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (EditActionsListener eal : this.editActionsListenerList) {
            eal.providesEditActions((Object)this, this.editActions);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void discardAllEdits() {
        this.undoManager.discardAllEdits();
        this.updateActions();
    }

    public void release() {
        this.setPopupMenuActiv(false);
        this.clipboard.removeFlavorListener(this);
        this.textComponent.removeCaretListener(this);
        this.textComponent.getDocument().removeUndoableEditListener(this);
        this.textComponent.removeFocusListener(this);
        this.editActionsListenerList.clear();
        this.undoManager.discardAllEdits();
        this.undoManager = null;
        this.textComponent = null;
    }
}

