/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.storage.net.ui;

import ipsk.apps.speechrecorder.PluginLoadingException;
import ipsk.apps.speechrecorder.config.ProjectConfiguration;
import ipsk.apps.speechrecorder.config.RecordingConfiguration;
import ipsk.apps.speechrecorder.storage.ActiveSessionStorageManager;
import ipsk.apps.speechrecorder.storage.StorageManagerException;
import ipsk.beans.DOMCodec;
import ipsk.net.UploadCache;
import ipsk.net.UploadCacheListener;
import ipsk.net.UploadCacheUI;
import ipsk.net.cookie.SessionCookieHandler;
import ipsk.net.event.UploadEvent;
import ipsk.net.event.UploadFinishedEvent;
import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParser;
import ipsk.util.optionparser.OptionParserException;
import ipsk.xml.DOMConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.net.CookieHandler;
import java.net.URL;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;

public class StorageManagerUploadUI
extends JFrame
implements UploadCacheListener,
WindowListener {
    private UploadCache uploadCache;
    private UploadCacheUI uploadCacheUI;
    private ActiveSessionStorageManager storageManager;
    private boolean finished = false;
    private String projectFileURL;

    public StorageManagerUploadUI(String projectFileURL) {
        super("Speech recorder cache upload");
        this.projectFileURL = projectFileURL;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.storageManager = new ActiveSessionStorageManager();
        this.getContentPane().setLayout(new BorderLayout());
    }

    public void open() throws StorageManagerException {
        if (this.projectFileURL != null) {
            try {
                URL projectURL = new URL(this.projectFileURL);
                DOMConverter domConverter = new DOMConverter();
                Package configBasePack = Class.forName("ipsk.apps.speechrecorder.config.ProjectConfiguration").getPackage();
                DOMCodec domCodec = new DOMCodec(configBasePack);
                Document d = domConverter.readXML(projectURL.openStream());
                ProjectConfiguration project = (ProjectConfiguration)domCodec.readDocument(d);
                RecordingConfiguration recCfg = project.getRecordingConfiguration();
                boolean overwrite = recCfg.getOverwrite();
                String recDirName = recCfg.getUrl();
                URL recBaseURL = new URL(recDirName);
                boolean useUploadCache = true;
                this.storageManager.setUseAsCache(useUploadCache);
                if (useUploadCache) {
                    this.storageManager.setSessionIDFormat(new DecimalFormat("0"));
                }
                String uploadCacheClassname = project.getCacheConfiguration().getUploadCacheClassname();
                try {
                    this.uploadCache = (UploadCache)Class.forName(uploadCacheClassname).newInstance();
                }
                catch (Exception e) {
                    throw new PluginLoadingException(uploadCacheClassname, e);
                }
                this.uploadCache.setOverwrite(project.getRecordingConfiguration().getOverwrite());
                int transferRateLimit = project.getCacheConfiguration().getTransferRateLimit();
                if (transferRateLimit != -1 && this.uploadCache.isTransferLimitSupported()) {
                    this.uploadCache.setTransferLimit(transferRateLimit);
                }
                this.storageManager.setUploadCache(this.uploadCache);
                this.storageManager.setUseAsCache(useUploadCache);
                this.storageManager.setOverwrite(overwrite);
                String audioCompression = project.getCacheConfiguration().getAudioStorageType();
                if (audioCompression != null && !audioCompression.equals("")) {
                    AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes();
                    AudioFileFormat.Type type = null;
                    for (int i = 0; i < types.length; ++i) {
                        if (!types[i].toString().equalsIgnoreCase(audioCompression)) continue;
                        type = types[i];
                    }
                    if (type != null) {
                        this.storageManager.setUploadType(type);
                    }
                }
                this.storageManager.setStorageURL(recBaseURL);
                this.storageManager.setCreateSessionDir(false);
                this.storageManager.setCreateSpeakerDir(false);
                this.storageManager.setUseScriptID(false);
                this.uploadCacheUI = new UploadCacheUI(this.uploadCache);
                this.getContentPane().add((Component)this.uploadCacheUI, "Center");
                this.storageManager.open();
                this.uploadCache.addUploadCacheListener((UploadCacheListener)this);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new StorageManagerException(e);
            }
        }
    }

    public void start() {
        this.uploadCache.start();
    }

    public void close() throws StorageManagerException {
        this.uploadCache.stop();
        this.uploadCache.clear();
        this.uploadCache.close();
        this.storageManager.close();
    }

    public void update(UploadEvent event) {
        if (event instanceof UploadFinishedEvent) {
            this.finished = true;
            JOptionPane.showMessageDialog(this, "Upload of pending recording files finished! Thank you!");
            try {
                this.close();
            }
            catch (StorageManagerException e) {
                JOptionPane.showMessageDialog(null, "Error: " + e.getLocalizedMessage(), "Storage manager close error", 0);
            }
            finally {
                this.dispose();
                System.exit(-1);
            }
        }
    }

    public static void main(String[] args) {
        String projectFileURL = null;
        String user = null;
        String password = "";
        OptionParser op = new OptionParser();
        op.addOption("u", "");
        op.addOption("p", "");
        op.addOption("s", "");
        try {
            op.parse(args);
        }
        catch (OptionParserException e) {
            System.err.println(e.getLocalizedMessage());
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "ERROR", 0);
            System.exit(-1);
        }
        Option[] options = op.getOptions();
        for (int i = 0; i < options.length; ++i) {
            if (options[i].getOptionName().equals("u")) {
                user = options[i].getParam();
                continue;
            }
            if (options[i].getOptionName().equals("p")) {
                password = options[i].getParam();
                continue;
            }
            if (!options[i].getOptionName().equals("s")) continue;
            String sessionCookie = options[i].getParam();
            CookieHandler.setDefault((CookieHandler)new SessionCookieHandler(sessionCookie));
        }
        String[] params = op.getParams();
        if (params.length != 1 && params.length != 0) {
            System.out.println("Usage\n\n\t" + StorageManagerUploadUI.class.getName() + " PROJECT_FILE_URL\n\n");
            System.exit(-1);
        }
        if (params.length == 1) {
            projectFileURL = params[0];
        }
        final String fprojectFileURL = projectFileURL;
        String fuser = user;
        String fpassword = password;
        Runnable buildAndShow = new Runnable(){

            @Override
            public void run() {
                StorageManagerUploadUI uploadUi = new StorageManagerUploadUI(fprojectFileURL);
                uploadUi.setLocationRelativeTo(null);
                try {
                    uploadUi.open();
                    uploadUi.pack();
                    uploadUi.setVisible(true);
                    uploadUi.start();
                }
                catch (StorageManagerException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(buildAndShow);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent e) {
        Window w = e.getWindow();
        if (this.finished) {
            try {
                this.close();
            }
            catch (StorageManagerException e1) {
                e1.printStackTrace();
            }
            finally {
                w.dispose();
                System.exit(0);
            }
        } else {
            int answer = JOptionPane.showConfirmDialog(null, "upload not finshied yet.\nDow you really want to exit?");
            if (answer == 0) {
                try {
                    this.close();
                }
                catch (StorageManagerException e1) {
                    e1.printStackTrace();
                }
                finally {
                    w.dispose();
                    System.exit(1);
                }
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

