/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.workspace.ui;

import ipsk.apps.speechrecorder.config.WorkspaceProject;
import ipsk.awt.ProgressListener;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressErrorEvent;
import ipsk.awt.event.ProgressEvent;
import ipsk.io.DeleteDirectoryWorker;
import ipsk.swing.JDialogPanel;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class ProjectDeleteDialog
extends JDialogPanel
implements ProgressListener {
    private WorkspaceProject project;
    private File projectDir;
    private JButton deleteButton;
    private JTextField messageLabel;
    private JProgressBar progressBar;
    private static final String DELETE_PROJECT_ACTION_CMD = "delete_project";

    public ProjectDeleteDialog(WorkspaceProject project, File projectDir) {
        super("Delete project");
        this.project = project;
        this.projectDir = projectDir;
        this.okButton.setText("Delete");
        this.okButton.setActionCommand(DELETE_PROJECT_ACTION_CMD);
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        cp.add((Component)new JLabel("Project: "), c);
        ++c.gridx;
        JTextField nameField = new JTextField(project.getConfiguration().getName());
        nameField.setEditable(false);
        cp.add((Component)nameField, c);
        c.gridx = 0;
        ++c.gridy;
        cp.add((Component)new JLabel("Status:"), c);
        ++c.gridx;
        this.messageLabel = new JTextField(20);
        this.messageLabel.setEditable(false);
        cp.add((Component)this.messageLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.progressBar = new JProgressBar();
        cp.add((Component)this.progressBar, c);
    }

    public void doReallyDelete() {
        DeleteDirectoryWorker deleteWorker = new DeleteDirectoryWorker();
        deleteWorker.setDirectory(this.projectDir);
        deleteWorker.addProgressListener((ProgressListener)this);
        try {
            deleteWorker.open();
            this.okButton.setEnabled(false);
            deleteWorker.start();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object aSrc = ae.getSource();
        if (aSrc == this.okButton) {
            if (DELETE_PROJECT_ACTION_CMD.equals(this.okButton.getActionCommand())) {
                int ans = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you really want to delete the project?\nAll recordings,speaker and session data will be deleted!\nThis action cannot be undone!", "Confirm project delete!", 0, 2);
                if (ans == 0) {
                    this.doReallyDelete();
                }
            } else {
                super.actionPerformed(ae);
            }
        } else {
            super.actionPerformed(ae);
        }
    }

    public void update(ProgressEvent progressEvent) {
        LocalizableMessage message;
        ProgressStatus ps = progressEvent.getProgressStatus();
        if (ps != null && (message = ps.getMessage()) != null) {
            this.messageLabel.setText(message.localize());
        }
        if (progressEvent instanceof ProgressErrorEvent) {
            this.messageLabel.setForeground(Color.RED);
        } else if (ps != null) {
            Short pProgr = ps.getPercentProgress();
            if (pProgr != null) {
                this.progressBar.setValue(ps.getPercentProgress().shortValue());
            }
            if (ps.isError()) {
                this.setValue(0);
                this.okButton.setText("OK");
                this.okButton.setEnabled(true);
            }
            if (ps.isDone()) {
                this.cancelButton.setEnabled(false);
                this.setValue(0);
                this.okButton.setText("OK");
                this.okButton.setActionCommand("ok");
                this.okButton.setEnabled(true);
            }
        }
    }
}

