/*
 * Decompiled with CFR 0.152.
 */
package ipsk.apps.speechrecorder.workspace.ui;

import ipsk.apps.speechrecorder.config.WorkspaceProject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Path;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ProjectEmuDBExportDialog
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private JTextField baseDirNameField;
    private JButton browseButton;
    private JFileChooser fileChooser;
    private static JButton okButton;
    private static JButton cancelButton;
    private static JOptionPane selPane;
    private Document baseDirNameDoc;
    private File exportBaseDir = null;
    private JTextField statusLabel;

    public ProjectEmuDBExportDialog(WorkspaceProject project, File projectDir) {
        super(new GridBagLayout());
        okButton = new JButton("OK");
        okButton.setEnabled(false);
        okButton.addActionListener(this);
        cancelButton = new JButton("Cancel");
        cancelButton.setEnabled(true);
        cancelButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.add((Component)new JLabel("Export base directory"), c);
        ++c.gridx;
        c.weightx = 3.0;
        this.baseDirNameField = new JTextField(20);
        this.baseDirNameDoc = this.baseDirNameField.getDocument();
        this.baseDirNameDoc.addDocumentListener(this);
        this.add((Component)this.baseDirNameField, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.anchor = 13;
        c.fill = 0;
        this.browseButton = new JButton("Browse...");
        this.browseButton.addActionListener(this);
        this.add((Component)this.browseButton, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 2.0;
        c.fill = 2;
        this.statusLabel = new JTextField(30);
        this.statusLabel.setEditable(false);
        this.add((Component)this.statusLabel, c);
        this.baseDirNameField.setText("");
    }

    public Object showDialog(Component parent) {
        selPane = new JOptionPane(this, -1, 2, null, new Object[]{okButton, cancelButton});
        JDialog dialog = selPane.createDialog(parent, "Export to EmuDB");
        dialog.setVisible(true);
        return selPane.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == okButton) {
            selPane.setValue(new Integer(0));
        } else if (src == cancelButton) {
            selPane.setValue(new Integer(2));
        } else if (src == this.browseButton) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setFileSelectionMode(1);
            String baseDirName = this.baseDirNameField.getText();
            if (!"".equals(baseDirName)) {
                File currentBaseDir = new File(baseDirName);
                this.fileChooser.setCurrentDirectory(currentBaseDir);
            }
            this.fileChooser.setApproveButtonText("Select");
            int res = this.fileChooser.showOpenDialog(this);
            if (res == 0) {
                this.exportBaseDir = this.fileChooser.getSelectedFile();
                this.baseDirNameField.setText(this.exportBaseDir.getPath());
                this.setDependencies();
            }
        }
    }

    private void setDependencies() {
        String baseDirName = this.baseDirNameField.getText();
        if (!"".equals(baseDirName)) {
            okButton.setEnabled(true);
        }
    }

    public Path getBaseDir() {
        String baseDirName = this.baseDirNameField.getText();
        Path baseDir = new File(baseDirName).toPath();
        return baseDir;
    }

    private void documentChanged(Document d) {
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0.getDocument());
    }
}

