//    IPS Java Utils
//    (c) Copyright 2009-2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

import ipsk.db.speech.script.prompt.doc.Block;
import ipsk.db.speech.script.prompt.doc.Body;
import ipsk.db.speech.script.prompt.doc.Font;
import ipsk.db.speech.script.prompt.doc.Linebreak;
import ipsk.db.speech.script.prompt.doc.P;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.db.speech.script.prompt.doc.Text;
import ipsk.swing.text.EditorKitMenu;
import ipsk.text.ParserException;


/**
 * 
 * Styled document editor.
 * Experimental source and WYSIWYG editor for HTML (and RTF docs).
 * @version alpha
 * @author klausj
 *
 */
public class JPromptDocumentEditor extends JPanel implements ActionListener,
		DocumentListener, CaretListener {

	final private JEditorPane editorPane;

	private JTextPane srcEditorPane;

	private JPanel buttonPanel;

	private EditorKit editorKit;

	private Document srcDoc;

	private Document doc;

	private Color editorForeGroundColor = Color.BLACK;

	private JToggleButton boldButton;
	
	private JToggleButton italicButton;

	private JToggleButton defaultStyleButton;
	
	public JPromptDocumentEditor() {
		super(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		c.weightx = 2.0;
		c.weighty = 2.0;
		c.fill = GridBagConstraints.BOTH;
		editorPane = new JEditorPane();
		editorPane.setEditorKitForContentType("text/x-prompt",new PromptDocEditorKit());
		editorPane.setPreferredSize(new Dimension(300, 100));
		editorPane.setContentType("text/x-prompt");
		EditorKitMenu epEkm=new EditorKitMenu(editorPane);
		epEkm.setPopupMenuActiv(true);
		doc = editorPane.getDocument();
	
		editorPane.addCaretListener(this);
		
		editorKit = editorPane.getEditorKit();

		InputMap inMap=editorPane.getInputMap();
		
		
		
		KeyStroke shiftEnterKeyStroke=KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, ActionEvent.SHIFT_MASK);
		inMap.put(shiftEnterKeyStroke, PromptDocEditorKit.LineBreakAction.ACTION_COMMAND);
		
		KeyStroke[] kstrks=inMap.allKeys();
		for(KeyStroke kstrk:kstrks) {
			Object val=inMap.get(kstrk);
			System.out.println(kstrk+" -> "+val);
		}
		
		 ActionMap actions = editorPane.getActionMap();
		 actions.put(PromptDocEditorKit.LineBreakAction.ACTION_COMMAND, new PromptDocEditorKit.LineBreakAction());		
		    
		    
		srcEditorPane = new JTextPane();
		srcEditorPane.setPreferredSize(new Dimension(300, 100));
		srcEditorPane.setContentType("text/plain");
		EditorKitMenu sepEkm=new EditorKitMenu(srcEditorPane);
		sepEkm.setPopupMenuActiv(true);
		srcDoc = srcEditorPane.getDocument();
		add(new JScrollPane(editorPane), c);
		c.gridx++;
		add(new JScrollPane(srcEditorPane), c);
		c.gridx = 0;
		c.gridy++;
		buttonPanel = new JPanel();

		JToolBar toolBar = new JToolBar();

		boldButton = new JToggleButton("<html><b>B</b></html>");
	
		italicButton = new JToggleButton("<html><i>i</i></html>");
		defaultStyleButton=new JToggleButton("Default style");
		
		for (Action a : editorKit.getActions()) {
			String name = (String) a.getValue(Action.NAME);
			if (name.equals("font-bold")) {
				boldButton.addActionListener(a);
			} else if (name.equals("font-italic")) {
				italicButton.addActionListener(a);
			}
			// buttonPanel.add(new JButton(a),c2);
			// c2.gridy++;
			// if(c2.gridy % 15==0){
			// c2.gridy=0;
			// c2.gridx++;
			// }
		}
		// c2.gridy++;
		JButton wButt = new JButton("Write");
		wButt.addActionListener(this);
		toolBar.add(defaultStyleButton);
		toolBar.add(boldButton);
		toolBar.add(italicButton);

		JButton colorButton = new JButton("Color");

		final Component parent = this;

		toolBar.add(colorButton);

		SpinnerNumberModel model = new SpinnerNumberModel(12, 8, 1000, 10);
		final JSpinner fontSizeSpinner = new JSpinner(model);
		fontSizeSpinner.addChangeListener(new ChangeListener() {

			public void stateChanged(ChangeEvent e) {
				Integer value = (Integer) fontSizeSpinner.getValue();
				Action fsAction = new StyledEditorKit.FontSizeAction(
						"font-size-" + value.toString(), value);
				fsAction.actionPerformed(new ActionEvent(editorPane,
						ActionEvent.ACTION_PERFORMED, value.toString()));
				// fsAction.actionPerformed(null);
			}

		});

		colorButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {

				if (editorKit instanceof StyledEditorKit
						&& doc instanceof StyledDocument) {
					StyledEditorKit sek = (StyledEditorKit) editorKit;
					StyledDocument sd = (StyledDocument) doc;
					editorForeGroundColor = sd.getForeground(sek
							.getInputAttributes());

				}
				Color c = JColorChooser.showDialog(parent, "Text color",
						editorForeGroundColor);
				if (c == null)
					return;
				Action fgAction = new StyledEditorKit.ForegroundAction("color",
						c);
				fgAction.actionPerformed(e);
				editorForeGroundColor = c;

			}
		});

		toolBar.add(colorButton);
		toolBar.add(fontSizeSpinner);

		buttonPanel.add(toolBar);
		buttonPanel.add(wButt);
		add(buttonPanel, c);

		doc.addDocumentListener(this);
		srcDoc.addDocumentListener(this);
		
		
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		
		Runnable guiRunnable=new Runnable() {
            
            @Override
            public void run() {
                JFrame f = new JFrame("Test");
                f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                JPromptDocumentEditor e = new JPromptDocumentEditor();
                f.add(e);
                f.pack();
                f.setVisible(true);
                
                List<Block> ps=new ArrayList<>();
                P p=new P();
                Text ft1=new Text();
                ft1.setText("How ");
                p.getTexts().add(ft1);
                
                Text ft2=new Text();
                ft2.setText("did ");
                Font b1=new Font();
                b1.setWeight(Font.BOLD);
                b1.setText(ft2);
                p.getTexts().add(b1);
                
                Text ft3=new Text();
                ft3.setText("you");
                p.getTexts().add(ft3);
                
                ps.add(p);
                
               
                
                P p2=new P();
                Text ft4=new Text();
                ft4.setText("Line1");
                p2.getTexts().add(ft4);
                
              
                ps.add(p2); 
                
               
                P p3=new P();
                Text ft5=new Text();
                ft5.setText("Line3");
                p3.getTexts().add(ft5);
                Linebreak nl=new Linebreak();
                p3.getTexts().add(nl);
                Text ft6=new Text();
                ft6.setText("Line4");
                p3.getTexts().add(ft6);
                
              
                ps.add(p3);
                
                PromptDoc pd=new PromptDoc();
                Body body=new Body();
                pd.setBody(body);
                body.setBlocks(ps);
               
                PromptStyleContext sc=new PromptStyleContext();
               
                PromptStyledDocument psd;
                try {
                    psd = new PromptStyledDocument(sc,pd);
                    psd.addDocumentListener(e);
                    e.setDocument(psd);
                } catch (ParserException e1) {
                    // TODO Auto-generated catch block
                    e1.printStackTrace();
                }
            }
        };
        
        SwingUtilities.invokeLater(guiRunnable);
	
	}

	/**
	 * @param psd
	 */
	protected void setDocument(PromptStyledDocument psd) {
		editorPane.setDocument(psd);
	}

	public void actionPerformed(ActionEvent e) {
		Document doc = editorPane.getDocument();
		try {
			editorKit.write(System.out, doc, 0, doc.getLength());
			Document d=editorPane.getDocument();
			if (d instanceof PromptStyledDocument){
	            PromptStyledDocument pd=(PromptStyledDocument)d;
	            pd.dump(System.out);
//	            List<P> pList=pd.toPromptFormat();
//	            for(P p:pList){
//	                System.out.println(p);
//	            }
//	            System.out.println();
				
	        }
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (BadLocationException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

	}

	private void updateSourcePane(DocumentEvent e) {
		Document d = e.getDocument();
		if (d == doc) {
			StringWriter sw = new StringWriter();
			try {

				// editorPane.write(sw);
				editorKit.write(sw, d, 0, d.getLength());
			} catch (IOException ioe) {
				// TODO Auto-generated catch block
				ioe.printStackTrace();
			} catch (BadLocationException ble) {
				// TODO Auto-generated catch block
				ble.printStackTrace();
			}
			String srcText = sw.toString();
			srcDoc.removeDocumentListener(this);
			srcEditorPane.setText(srcText);
			srcDoc.addDocumentListener(this);
		} else if (d == srcDoc) {
			StringReader in;
			try {
				in = new StringReader(srcDoc.getText(0, srcDoc.getLength()));
				doc.removeDocumentListener(this);
				doc.remove(0, doc.getLength());
				editorKit.read(in, doc, 0);
				doc.addDocumentListener(this);
			} catch (BadLocationException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (IOException ioe) {
				// TODO Auto-generated catch block
				ioe.printStackTrace();
			}
		}
	}

	private void printDoc(DocumentEvent e){
		Document d=e.getDocument();
		if (d instanceof PromptStyledDocument){
		    PromptStyledDocument pd=(PromptStyledDocument)d;
		    PromptDoc pr=pd.toPromptFormat();
		    Body pdBody=pr.getBody();
		    if(pdBody!=null) {
		    List<Block> pList=pdBody.getBlocks();
		    for(Block p:pList){
		        System.out.println(p);
		    }
		    }
		    System.out.println();
		}
	}
	
	public void changedUpdate(DocumentEvent e) {
		updateSourcePane(e);
		//printDoc(e);
	}

	private String elementToDescr(Element e){
	    StringBuffer sb=new StringBuffer();
	    sb.append(e.getName()+"\n");
	    sb.append(e.getClass().getName()+"\n");
	    int eCnt=e.getElementCount();
	    for(int i=0;i<eCnt;i++){
	        sb.append("Child: "+elementToDescr(e.getElement(i))+"\n");
	    }
	    return sb.toString();
	}
	
	public void insertUpdate(DocumentEvent e) {
		updateSourcePane(e);
		//printDoc(e);	
	}

	public void removeUpdate(DocumentEvent e) {
		updateSourcePane(e);
		//printDoc(e);
	}

	/* (non-Javadoc)
	 * @see javax.swing.event.CaretListener#caretUpdate(javax.swing.event.CaretEvent)
	 */
	@Override
	public void caretUpdate(CaretEvent e) {
		
		int start=editorPane.getSelectionStart();
		int end=editorPane.getSelectionEnd();
		//System.out.println("Select: "+start+" "+end);
		Document d=editorPane.getDocument();
		if(d instanceof StyledDocument){
			StyledDocument sd=(StyledDocument)d;
//			Style defStyle=sd.getStyle(StyleContext.DEFAULT_STYLE);
			boolean allDefault=true;
			boolean allBold=false;
			boolean allItalic=false;
			if(end>start){
				allBold=true;
				allItalic=true;
				for(int pos=start;pos<end;pos++){
					Element el=sd.getCharacterElement(pos);
					AttributeSet as=el.getAttributes();
					allDefault=allDefault && !as.isDefined(StyleConstants.Bold) && !as.isDefined(StyleConstants.Italic) && !as.isDefined(StyleConstants.Underline);
					allBold=allBold && StyleConstants.isBold(as);
					allItalic=allItalic && StyleConstants.isItalic(as);
				}
			}
			//System.out.println("Bold: "+allBold+" italic: "+allItalic);
			defaultStyleButton.setSelected(allDefault);
			boldButton.setSelected(allBold);
			italicButton.setSelected(allItalic);
			
		}

	}



}
